/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.InspectorPanelController;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import javafx.application.Platform;

public class CssPanelDelegate
extends CssPanelController.Delegate {
    private final InspectorPanelController inspectorController;
    private final DocumentWindowController documentWindowController;

    public CssPanelDelegate(InspectorPanelController inspectorController, DocumentWindowController documentWindowController) {
        this.inspectorController = inspectorController;
        this.documentWindowController = documentWindowController;
    }

    @Override
    public void revealInspectorEditor(ValuePropertyMetadata propMeta) {
        String inspectorSection;
        if (this.inspectorController == null || this.documentWindowController == null || propMeta == null) {
            return;
        }
        if (!this.documentWindowController.isRightPanelVisible()) {
            this.documentWindowController.performControlAction(DocumentWindowController.DocumentControlAction.TOGGLE_RIGHT_PANEL);
        }
        if ((inspectorSection = propMeta.getInspectorPath().getSectionTag()).equalsIgnoreCase("properties")) {
            this.inspectorController.setExpandedSection(InspectorPanelController.SectionId.PROPERTIES);
        } else if (inspectorSection.equalsIgnoreCase("layout")) {
            this.inspectorController.setExpandedSection(InspectorPanelController.SectionId.LAYOUT);
        } else if (inspectorSection.equalsIgnoreCase("code")) {
            this.inspectorController.setExpandedSection(InspectorPanelController.SectionId.CODE);
        }
        Platform.runLater(() -> Platform.runLater(() -> this.inspectorController.setFocusToEditor(propMeta.getName())));
    }
}

