/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.ResourceController;
import com.oracle.javafx.scenebuilder.app.SceneStyleSheetMenuController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.util.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;

public class DocumentWatchingController
implements FileWatcher.Delegate {
    private final DocumentWindowController documentWindowController;
    private final EditorController editorController;
    private final ResourceController resourceController;
    private final SceneStyleSheetMenuController sceneStyleSheetMenuController;
    private final FileWatcher fileWatcher = new FileWatcher(2000L, this, DocumentWindowController.class.getSimpleName());

    public DocumentWatchingController(DocumentWindowController documentWindowController) {
        this.documentWindowController = documentWindowController;
        this.editorController = documentWindowController.getEditorController();
        this.resourceController = documentWindowController.getResourceController();
        this.sceneStyleSheetMenuController = documentWindowController.getSceneStyleSheetMenuController();
        this.editorController.sceneStyleSheetProperty().addListener((ov, t, t1) -> this.update());
    }

    public void start() {
        this.fileWatcher.start();
    }

    public void stop() {
        this.fileWatcher.stop();
    }

    public void update() {
        ArrayList<Path> targets = new ArrayList<Path>();
        this.editorController.fxomDocument().flatMap(FXOMDocument::locationPath).ifPresent(targets::add);
        if (this.resourceController.getResourceFile() != null) {
            targets.add(this.resourceController.getResourceFile().toPath());
        }
        if (this.editorController.getSceneStyleSheets() != null) {
            for (File sceneStyleSheet : this.editorController.getSceneStyleSheets()) {
                targets.add(sceneStyleSheet.toPath());
            }
        }
        this.fileWatcher.setTargets(targets);
    }

    public void removeDocumentTarget() {
        this.editorController.fxomDocument().flatMap(FXOMDocument::locationPath).ifPresent(this.fileWatcher::removeTarget);
    }

    @Override
    public void fileWatcherDidWatchTargetCreation(Path target) {
    }

    @Override
    public void fileWatcherDidWatchTargetDeletion(Path target) {
        if (this.isPathMatchingResourceLocation(target)) {
            this.resourceController.performRemoveResource();
            this.log("log.info.file.deleted", target);
        } else if (this.isPathMatchingSceneStyleSheet(target)) {
            this.sceneStyleSheetMenuController.performRemoveSceneStyleSheet(target.toFile());
            this.log("log.info.file.deleted", target);
        }
    }

    @Override
    public void fileWatcherDidWatchTargetModification(Path target) {
        if (this.isPathMatchingResourceLocation(target)) {
            this.resourceController.performReloadResource();
            this.log("log.info.reload", target);
        } else if (this.isPathMatchingDocumentLocation(target)) {
            if (!this.documentWindowController.isDocumentDirty()) {
                try {
                    this.documentWindowController.reload();
                    this.log("log.info.reload", target);
                }
                catch (IOException iOException) {}
            }
        } else if (this.isPathMatchingSceneStyleSheet(target)) {
            this.editorController.fxomDocument().ifPresent(doc -> {
                doc.reapplyCSS(target);
                this.log("log.info.reload", target);
            });
        }
    }

    private void log(String infoKey, Path target) {
        this.editorController.getMessageLog().logInfoMessage(infoKey, I18N.getBundle(), target.getFileName());
    }

    private boolean isPathMatchingDocumentLocation(Path p) {
        return this.editorController.fxomDocument().flatMap(FXOMDocument::locationPath).map(p::equals).orElse(false);
    }

    private boolean isPathMatchingResourceLocation(Path p) {
        if (this.resourceController.getResourceFile() != null) {
            return p.equals(this.resourceController.getResourceFile().toPath());
        }
        return false;
    }

    private boolean isPathMatchingSceneStyleSheet(Path p) {
        if (this.editorController.getSceneStyleSheets() != null) {
            return this.editorController.getSceneStyleSheets().contains((Object)p.toFile());
        }
        return false;
    }
}

