/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.gluonhq.scenebuilder.plugins.alert.WarnThemeAlert;
import com.gluonhq.scenebuilder.plugins.editor.GluonEditorController;
import com.oracle.javafx.scenebuilder.app.CssPanelDelegate;
import com.oracle.javafx.scenebuilder.app.CssPanelMenuController;
import com.oracle.javafx.scenebuilder.app.DocumentWatchingController;
import com.oracle.javafx.scenebuilder.app.ResourceController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.SceneStyleSheetMenuController;
import com.oracle.javafx.scenebuilder.app.SplitController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.menubar.MenuBarController;
import com.oracle.javafx.scenebuilder.app.message.MessageBarController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordDocument;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.app.report.JarAnalysisReportController;
import com.oracle.javafx.scenebuilder.app.util.AppSettings;
import com.oracle.javafx.scenebuilder.kit.ResourceUtils;
import com.oracle.javafx.scenebuilder.kit.ToolTheme;
import com.oracle.javafx.scenebuilder.kit.editor.DocumentationUrls;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.FileBrowserRevealException;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.css.CssPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.info.InfoPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.InspectorPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.manager.LibraryDialogController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.editor.search.SearchController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.preview.PreviewWindowController;
import com.oracle.javafx.scenebuilder.kit.selectionbar.SelectionBarController;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonWindowController;
import com.oracle.javafx.scenebuilder.kit.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.TitledPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class DocumentWindowController
extends AbstractFxmlWindowController {
    private static final Logger LOGGER = Logger.getLogger(DocumentWindowController.class.getName());
    private final EditorController editorController = new EditorController();
    private final MenuBarController menuBarController = new MenuBarController(this);
    private final ContentPanelController contentPanelController = new ContentPanelController(this.editorController);
    private final AbstractHierarchyPanelController hierarchyPanelController = new HierarchyPanelController(this.editorController);
    private final InfoPanelController infoPanelController = new InfoPanelController(this.editorController);
    private final InspectorPanelController inspectorPanelController = new InspectorPanelController(this.editorController);
    private final CssPanelDelegate cssPanelDelegate = new CssPanelDelegate(this.inspectorPanelController, this);
    private final CssPanelController cssPanelController = new CssPanelController(this.editorController, this.cssPanelDelegate);
    private final LibraryPanelController libraryPanelController = new LibraryPanelController(this.editorController, PreferencesController.getSingleton().getMavenPreferences());
    private final SelectionBarController selectionBarController = new SelectionBarController(this.editorController);
    private final MessageBarController messageBarController = new MessageBarController(this.editorController);
    private final SearchController librarySearchController = new SearchController(this.editorController);
    private final SearchController inspectorSearchController = new SearchController(this.editorController);
    private final SearchController cssPanelSearchController = new SearchController(this.editorController);
    private final SceneStyleSheetMenuController sceneStyleSheetMenuController = new SceneStyleSheetMenuController(this);
    private final CssPanelMenuController cssPanelMenuController = new CssPanelMenuController(this.cssPanelController);
    private final ResourceController resourceController = new ResourceController(this);
    private final DocumentWatchingController watchingController = new DocumentWatchingController(this);
    private PreviewWindowController previewWindowController = null;
    private SkeletonWindowController skeletonWindowController = null;
    private JarAnalysisReportController jarAnalysisReportController = null;
    private LibraryDialogController libraryDialogController = null;
    @FXML
    private StackPane libraryPanelHost;
    @FXML
    private StackPane librarySearchPanelHost;
    @FXML
    private StackPane hierarchyPanelHost;
    @FXML
    private StackPane infoPanelHost;
    @FXML
    private StackPane contentPanelHost;
    @FXML
    private StackPane inspectorPanelHost;
    @FXML
    private StackPane inspectorSearchPanelHost;
    @FXML
    private StackPane cssPanelHost;
    @FXML
    private StackPane cssPanelSearchPanelHost;
    @FXML
    private StackPane messageBarHost;
    @FXML
    private Accordion documentAccordion;
    @FXML
    private SplitPane mainSplitPane;
    @FXML
    private SplitPane leftRightSplitPane;
    @FXML
    private SplitPane libraryDocumentSplitPane;
    @FXML
    private Label libraryLabel;
    @FXML
    private MenuButton libraryMenuButton;
    @FXML
    private MenuItem libraryImportSelection;
    @FXML
    private RadioMenuItem libraryViewAsList;
    @FXML
    private RadioMenuItem libraryViewAsSections;
    @FXML
    private MenuItem libraryReveal;
    @FXML
    private Menu customLibraryMenu;
    @FXML
    private MenuItem cssPanelShowStyledOnlyMi;
    @FXML
    private MenuItem cssPanelSplitDefaultsMi;
    @FXML
    private RadioMenuItem showInfoMenuItem;
    @FXML
    private RadioMenuItem showFxIdMenuItem;
    @FXML
    private RadioMenuItem showNodeIdMenuItem;
    private SplitController bottomSplitController;
    private SplitController leftSplitController;
    private SplitController rightSplitController;
    private SplitController librarySplitController;
    private SplitController documentSplitController;
    private FileTime loadFileTime;
    private Job saveJob;
    private PreferencesRecordGlobal recordGlobal;
    private final EventHandler<KeyEvent> mainKeyEventFilter = event -> {
        boolean isSelectAll;
        Node focusOwner = this.getScene().getFocusOwner();
        KeyCombination accelerator = this.getAccelerator((KeyEvent)event);
        if (!this.isTextInputControlEditing(focusOwner) || accelerator != null) {
            // empty if block
        }
        boolean modifierDown = EditorPlatform.IS_MAC ? event.isMetaDown() : event.isControlDown();
        boolean bl = isSelectAll = KeyCode.A.equals((Object)event.getCode()) && modifierDown;
        if (this.getHierarchyPanelController().getPanelControl().isFocused() && isSelectAll) {
            event.consume();
            if (!this.menuBarController.getMenuBar().isUseSystemMenuBar() && this.canPerformControlAction(DocumentControlAction.SELECT_ALL)) {
                this.performControlAction(DocumentControlAction.SELECT_ALL);
            }
        }
        boolean isBackspace = KeyCode.BACK_SPACE.equals((Object)event.getCode());
        if (!this.isTextInputControlEditing(focusOwner) && isBackspace) {
            if (this.canPerformEditAction(DocumentEditAction.DELETE)) {
                this.performEditAction(DocumentEditAction.DELETE);
            }
            event.consume();
        }
        if (KeyCode.P.equals((Object)event.getCode()) && modifierDown) {
            this.menuBarController.showPreview();
            event.consume();
        }
    };

    public DocumentWindowController() {
        super(DocumentWindowController.class.getResource("DocumentWindow.fxml"), I18N.getBundle(), false);
        this.editorController.setLibrary(SceneBuilderApp.getSingleton().getUserLibrary());
    }

    public EditorController getEditorController() {
        return this.editorController;
    }

    public MenuBarController getMenuBarController() {
        return this.menuBarController;
    }

    public ContentPanelController getContentPanelController() {
        return this.contentPanelController;
    }

    public InspectorPanelController getInspectorPanelController() {
        return this.inspectorPanelController;
    }

    public CssPanelController getCssPanelController() {
        return this.cssPanelController;
    }

    public AbstractHierarchyPanelController getHierarchyPanelController() {
        return this.hierarchyPanelController;
    }

    public InfoPanelController getInfoPanelController() {
        return this.infoPanelController;
    }

    public PreviewWindowController getPreviewWindowController() {
        return this.previewWindowController;
    }

    public SceneStyleSheetMenuController getSceneStyleSheetMenuController() {
        return this.sceneStyleSheetMenuController;
    }

    public ResourceController getResourceController() {
        return this.resourceController;
    }

    public DocumentWatchingController getWatchingController() {
        return this.watchingController;
    }

    public SplitController getBottomSplitController() {
        return this.bottomSplitController;
    }

    public SplitController getLeftSplitController() {
        return this.leftSplitController;
    }

    public SplitController getRightSplitController() {
        return this.rightSplitController;
    }

    public SplitController getLibrarySplitController() {
        return this.librarySplitController;
    }

    public SplitController getDocumentSplitController() {
        return this.documentSplitController;
    }

    public void loadFromFile(File fxmlFile) throws IOException {
        URL fxmlURL = fxmlFile.toURI().toURL();
        String fxmlText = FXOMDocument.readContentFromURL(fxmlURL);
        this.editorController.setFxmlTextAndLocation(fxmlText, fxmlURL, false);
        this.updateLoadFileTime();
        this.updateStageTitle();
        this.updateFromDocumentPreferences(true);
        this.watchingController.update();
        if (this.editorController.getFxomDocument().hasControlsFromExternalPlugin()) {
            WarnThemeAlert.showAlertIfRequired(this.getStage(), this.editorController.getTheme(), this.editorController::setTheme);
        }
    }

    public void loadFromURL(URL fxmlURL, boolean refreshThemeFromDocumentPreferences) {
        assert (fxmlURL != null);
        try {
            String fxmlText = FXOMDocument.readContentFromURL(fxmlURL);
            this.editorController.setFxmlTextAndLocation(fxmlText, null, false);
            this.updateLoadFileTime();
            this.updateStageTitle();
            this.updateFromDocumentPreferences(refreshThemeFromDocumentPreferences);
            this.watchingController.update();
        }
        catch (IOException x) {
            throw new IllegalStateException(x);
        }
    }

    public void updateWithDefaultContent() {
        try {
            this.editorController.setFxmlTextAndLocation("", null, true);
            this.updateLoadFileTime();
            this.updateStageTitle();
            this.watchingController.update();
        }
        catch (IOException x) {
            throw new IllegalStateException(x);
        }
    }

    public void reload() throws IOException {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        assert (fxomDocument != null && fxomDocument.getLocation() != null);
        URL fxmlURL = fxomDocument.getLocation();
        String fxmlText = FXOMDocument.readContentFromURL(fxmlURL);
        this.editorController.setFxmlTextAndLocation(fxmlText, fxmlURL, true);
        this.updateLoadFileTime();
    }

    public String getFxmlText() {
        PreferencesRecordGlobal recordGlobal = this.getPreferencesRecordGlobal();
        return this.editorController.getFxmlText(recordGlobal.isWildcardImports());
    }

    public void refreshLibraryDisplayOption(LibraryPanelController.DISPLAY_MODE option) {
        switch (option) {
            case LIST: {
                this.libraryViewAsList.setSelected(true);
                break;
            }
            case SECTIONS: {
                this.libraryViewAsSections.setSelected(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.libraryPanelController.setDisplayMode(option);
    }

    public void refreshHierarchyDisplayOption(AbstractHierarchyPanelController.DisplayOption option) {
        switch (option) {
            case INFO: {
                this.showInfoMenuItem.setSelected(true);
                break;
            }
            case FXID: {
                this.showFxIdMenuItem.setSelected(true);
                break;
            }
            case NODEID: {
                this.showNodeIdMenuItem.setSelected(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.hierarchyPanelController.setDisplayOption(option);
    }

    public void refreshCssTableColumnsOrderingReversed(boolean cssTableColumnsOrderingReversed) {
        this.cssPanelController.setTableColumnsOrderingReversed(cssTableColumnsOrderingReversed);
    }

    public void refreshCssTableColumnsOrderingReversed(PreferencesRecordGlobal preferences) {
        this.refreshCssTableColumnsOrderingReversed(preferences.isCssTableColumnsOrderingReversed());
    }

    public void refreshAlignmentGuidesColor(PreferencesRecordGlobal preferences) {
        ContentPanelController cpc = this.getContentPanelController();
        cpc.setGuidesColor((Paint)preferences.getAlignmentGuidesColor());
    }

    public void animateAccordion(boolean animate) {
        this.libraryPanelController.animateAccordion(animate);
        this.inspectorPanelController.animateAccordion(animate);
        this.documentAccordion.getPanes().forEach(tp -> tp.setAnimated(animate));
    }

    public void refreshBackgroundImage(PreferencesRecordGlobal preferences) {
        this.getContentPanelController().setWorkspaceBackground(preferences.getBackgroundImageImage());
    }

    public void refreshToolTheme(PreferencesRecordGlobal preferences) {
        SceneBuilderApp app = SceneBuilderApp.getSingleton();
        app.performControlAction(switch (preferences.getToolTheme()) {
            case ToolTheme.DEFAULT -> SceneBuilderApp.ApplicationControlAction.USE_DEFAULT_THEME;
            case ToolTheme.DARK -> SceneBuilderApp.ApplicationControlAction.USE_DARK_THEME;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield null;
            }
        }, this);
    }

    public void refreshLibraryDisplayOption(PreferencesRecordGlobal preferences) {
        this.refreshLibraryDisplayOption(preferences.getLibraryDisplayOption());
    }

    public void refreshHierarchyDisplayOption(PreferencesRecordGlobal preferences) {
        this.refreshHierarchyDisplayOption(preferences.getHierarchyDisplayOption());
    }

    public void refreshParentRingColor(PreferencesRecordGlobal preferences) {
        Color parentRingColor = preferences.getParentRingColor();
        ContentPanelController cpc = this.getContentPanelController();
        cpc.setPringColor((Paint)parentRingColor);
        AbstractHierarchyPanelController hpc = this.getHierarchyPanelController();
        hpc.setParentRingColor((Paint)parentRingColor);
    }

    public void refreshRootContainerHeight(PreferencesRecordGlobal preferencesRecordGlobal) {
        EditorController ec = this.getEditorController();
        ec.setDefaultRootContainerHeight(preferencesRecordGlobal.getRootContainerHeight());
    }

    public void refreshRootContainerWidth(PreferencesRecordGlobal preferencesRecordGlobal) {
        EditorController ec = this.getEditorController();
        ec.setDefaultRootContainerWidth(preferencesRecordGlobal.getRootContainerWidth());
    }

    public void refreshTheme(PreferencesRecordGlobal preferencesRecordGlobal) {
        EditorController ec = this.getEditorController();
        ec.setTheme(preferencesRecordGlobal.getTheme());
    }

    public void refreshSwatch(PreferencesRecordGlobal preferencesRecordGlobal) {
        GluonEditorController.getInstance().setGluonSwatch(preferencesRecordGlobal.getSwatch());
    }

    public void refreshGluonTheme(PreferencesRecordGlobal preferencesRecordGlobal) {
        GluonEditorController.getInstance().setGluonTheme(preferencesRecordGlobal.getGluonTheme());
    }

    public void refreshAccordionAnimation(PreferencesRecordGlobal preferencesRecordGlobal) {
        this.animateAccordion(preferencesRecordGlobal.isAccordionAnimation());
    }

    public boolean canPerformControlAction(DocumentControlAction controlAction) {
        boolean result;
        switch (controlAction.ordinal()) {
            case 0: {
                result = this.canPerformCopy();
                break;
            }
            case 1: {
                result = this.canPerformSelectAll();
                break;
            }
            case 2: {
                result = this.canPerformSelectNone();
                break;
            }
            case 26: {
                result = this.editorController.getFxomDocument() != null;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                result = true;
                break;
            }
            case 20: {
                FXOMDocument fxomDocument = this.editorController.getFxomDocument();
                if (fxomDocument != null) {
                    Object sceneGraphRoot = fxomDocument.getSceneGraphRoot();
                    return sceneGraphRoot instanceof DialogPane;
                }
                result = false;
                break;
            }
            case 3: {
                result = this.isDocumentDirty() || this.editorController.getFxomDocument().getLocation() == null;
                break;
            }
            case 4: 
            case 6: {
                result = true;
                break;
            }
            case 5: {
                result = this.isDocumentDirty() && this.editorController.getFxomDocument().getLocation() != null;
                break;
            }
            case 7: {
                result = this.editorController.getFxomDocument() != null && this.editorController.getFxomDocument().getLocation() != null;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                result = true;
                break;
            }
            case 21: {
                result = true;
                break;
            }
            case 22: {
                result = true;
                break;
            }
            case 23: 
            case 24: {
                result = this.resourceController.getResourceFile() != null;
                break;
            }
            case 25: {
                result = true;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                result = true;
                break;
            }
            default: {
                result = false;
                assert (false);
                break;
            }
        }
        return result;
    }

    public void performControlAction(DocumentControlAction controlAction) {
        assert (this.canPerformControlAction(controlAction));
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
        switch (controlAction.ordinal()) {
            case 0: {
                this.performCopy();
                break;
            }
            case 1: {
                this.performSelectAll();
                break;
            }
            case 2: {
                this.performSelectNone();
                break;
            }
            case 19: {
                if (this.previewWindowController == null) {
                    this.previewWindowController = new PreviewWindowController(this.editorController, this.getStage());
                    this.previewWindowController.setToolStylesheet(this.getToolStylesheet());
                }
                this.previewWindowController.getStage().centerOnScreen();
                this.previewWindowController.openWindow();
                break;
            }
            case 20: {
                if (this.previewWindowController == null) {
                    this.previewWindowController = new PreviewWindowController(this.editorController, this.getStage());
                    this.previewWindowController.setToolStylesheet(this.getToolStylesheet());
                }
                this.previewWindowController.openDialog();
                break;
            }
            case 3: {
                this.performSaveOrSaveAsAction();
                break;
            }
            case 4: {
                this.performSaveAsAction();
                break;
            }
            case 5: {
                this.performRevertAction();
                break;
            }
            case 6: {
                this.performCloseAction();
                break;
            }
            case 7: {
                this.performRevealAction();
                break;
            }
            case 8: {
                this.contentPanelController.getGlassLayer().requestFocus();
                break;
            }
            case 9: {
                this.performGoToSection(InspectorPanelController.SectionId.PROPERTIES);
                break;
            }
            case 10: {
                this.performGoToSection(InspectorPanelController.SectionId.LAYOUT);
                break;
            }
            case 11: {
                this.performGoToSection(InspectorPanelController.SectionId.CODE);
                break;
            }
            case 15: {
                if (this.leftSplitController.isTargetVisible()) {
                    assert (this.librarySplitController.isTargetVisible() || this.documentSplitController.isTargetVisible());
                    this.librarySplitController.hideTarget();
                    this.documentSplitController.hideTarget();
                    this.leftSplitController.hideTarget();
                } else {
                    assert (!this.librarySplitController.isTargetVisible() && !this.documentSplitController.isTargetVisible());
                    this.librarySplitController.showTarget();
                    this.documentSplitController.showTarget();
                    this.leftSplitController.showTarget();
                    this.libraryDocumentSplitPane.layout();
                    this.libraryDocumentSplitPane.setDividerPositions(new double[]{0.5});
                }
                recordDocument.setLibraryVisible(this.librarySplitController.isTargetVisible());
                recordDocument.setDocumentVisible(this.documentSplitController.isTargetVisible());
                recordDocument.setLeftVisible(this.leftSplitController.isTargetVisible());
                break;
            }
            case 16: {
                this.rightSplitController.toggleTarget();
                recordDocument.setRightVisible(this.rightSplitController.isTargetVisible());
                break;
            }
            case 14: {
                this.initializeCssPanel();
                this.bottomSplitController.toggleTarget();
                if (this.bottomSplitController.isTargetVisible()) {
                    PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
                    this.refreshCssTableColumnsOrderingReversed(recordGlobal.isCssTableColumnsOrderingReversed());
                    this.editorController.setPickModeEnabled(true);
                } else {
                    this.editorController.setPickModeEnabled(false);
                }
                recordDocument.setBottomVisible(this.bottomSplitController.isTargetVisible());
                break;
            }
            case 12: {
                if (this.librarySplitController.isTargetVisible()) {
                    assert (this.leftSplitController.isTargetVisible());
                    this.librarySplitController.hideTarget();
                    if (!this.documentSplitController.isTargetVisible()) {
                        this.leftSplitController.hideTarget();
                    }
                } else {
                    if (!this.leftSplitController.isTargetVisible()) {
                        this.leftSplitController.showTarget();
                    }
                    this.librarySplitController.showTarget();
                }
                recordDocument.setLibraryVisible(this.librarySplitController.isTargetVisible());
                recordDocument.setLeftVisible(this.leftSplitController.isTargetVisible());
                break;
            }
            case 13: {
                if (this.documentSplitController.isTargetVisible()) {
                    assert (this.leftSplitController.isTargetVisible());
                    this.documentSplitController.hideTarget();
                    if (!this.librarySplitController.isTargetVisible()) {
                        this.leftSplitController.hideTarget();
                    }
                } else {
                    if (!this.leftSplitController.isTargetVisible()) {
                        this.leftSplitController.showTarget();
                    }
                    this.documentSplitController.showTarget();
                }
                recordDocument.setDocumentVisible(this.documentSplitController.isTargetVisible());
                recordDocument.setLeftVisible(this.leftSplitController.isTargetVisible());
                break;
            }
            case 17: {
                this.contentPanelController.setOutlinesVisible(!this.contentPanelController.isOutlinesVisible());
                break;
            }
            case 18: {
                this.contentPanelController.setGuidesVisible(!this.contentPanelController.isGuidesVisible());
                break;
            }
            case 21: {
                this.sceneStyleSheetMenuController.performAddSceneStyleSheet();
                break;
            }
            case 22: {
                this.resourceController.performSetResource();
                recordDocument.setI18NResourceFile(this.getResourceFile());
                break;
            }
            case 23: {
                this.resourceController.performRemoveResource();
                recordDocument.setI18NResourceFile(this.getResourceFile());
                break;
            }
            case 24: {
                this.resourceController.performRevealResource();
                break;
            }
            case 25: {
                this.performHelp();
                break;
            }
            case 27: {
                this.openURL(DocumentationUrls.OPENJFX_GETTING_STARTED.toString());
                break;
            }
            case 29: {
                this.openURL(DocumentationUrls.OPENJFX_JAVADOC_HOME.toString());
                break;
            }
            case 30: {
                this.openURL(DocumentationUrls.OPENJFX_CSS_REFERENCE.toString());
                break;
            }
            case 31: {
                this.openURL(DocumentationUrls.OPENJFX_FXML_REFERENCE.toString());
                break;
            }
            case 32: {
                this.openURL(DocumentationUrls.GLUON_SCENEBUILDER_HOME.toString());
                break;
            }
            case 33: {
                this.openURL(DocumentationUrls.GLUON_SCENEBUILDER_CONTRIBUTE.toString());
                break;
            }
            case 34: {
                this.openURL(DocumentationUrls.JFXCENTRAL_HOMEPAGE.toString());
                break;
            }
            case 26: {
                if (this.skeletonWindowController == null) {
                    this.skeletonWindowController = new SkeletonWindowController(this.editorController, Utils.makeTitle(this.editorController.getFxomDocument()), this.getStage());
                    this.skeletonWindowController.setToolStylesheet(this.getToolStylesheet());
                }
                this.skeletonWindowController.openWindow();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean canPerformEditAction(DocumentEditAction editAction) {
        boolean result;
        switch (editAction.ordinal()) {
            case 0: {
                result = this.canPerformDelete();
                break;
            }
            case 1: {
                result = this.canPerformCut();
                break;
            }
            case 3: 
            case 4: {
                result = true;
                break;
            }
            case 5: {
                FXOMDocument fxomDocument = this.editorController.getFxomDocument();
                result = fxomDocument != null && fxomDocument.getFxomRoot() != null && fxomDocument.getLocation() != null;
                break;
            }
            case 2: {
                result = this.canPerformPaste();
                break;
            }
            default: {
                result = false;
                assert (false);
                break;
            }
        }
        return result;
    }

    public void performEditAction(DocumentEditAction editAction) {
        assert (this.canPerformEditAction(editAction));
        switch (editAction.ordinal()) {
            case 0: {
                this.performDelete();
                break;
            }
            case 1: {
                this.performCut();
                break;
            }
            case 3: {
                this.performImportFxml();
                break;
            }
            case 4: {
                this.performImportMedia();
                break;
            }
            case 5: {
                this.performIncludeFxml();
                break;
            }
            case 2: {
                this.performPaste();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean isLeftPanelVisible() {
        return this.leftSplitController.isTargetVisible();
    }

    public boolean isRightPanelVisible() {
        return this.rightSplitController.isTargetVisible();
    }

    public boolean isBottomPanelVisible() {
        return this.bottomSplitController.isTargetVisible();
    }

    public boolean isHierarchyPanelVisible() {
        return this.documentSplitController.isTargetVisible();
    }

    public boolean isLibraryPanelVisible() {
        return this.librarySplitController.isTargetVisible();
    }

    public File getResourceFile() {
        return this.resourceController.getResourceFile();
    }

    public void setResourceFile(File file) {
        this.resourceController.setResourceFile(file);
    }

    public boolean isDocumentDirty() {
        return this.getEditorController().getJobManager().getCurrentJob() != this.saveJob;
    }

    public boolean isUnused() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        boolean noFxmlText = fxomDocument == null || fxomDocument.getFxomRoot() == null;
        boolean clean = !this.isDocumentDirty();
        boolean noName = fxomDocument != null && fxomDocument.getLocation() == null;
        return noFxmlText && clean && noName;
    }

    public void initializeCssPanel() {
        assert (this.cssPanelHost != null);
        assert (this.cssPanelSearchPanelHost != null);
        if (this.cssPanelHost.getChildren().isEmpty()) {
            this.cssPanelHost.getChildren().add((Object)this.cssPanelController.getPanelRoot());
        }
        if (this.cssPanelSearchPanelHost.getChildren().isEmpty()) {
            this.cssPanelSearchPanelHost.getChildren().add((Object)this.cssPanelSearchController.getPanelRoot());
            this.addCssPanelSearchListener();
        }
    }

    public void updatePreferences() {
        PreferencesController pc = PreferencesController.getSingleton();
        URL fxmlLocation = this.getEditorController().getFxmlLocation();
        if (fxmlLocation == null) {
            return;
        }
        PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
        recordDocument.writeToJavaPreferences();
        PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
        if (!recordGlobal.containsRecentItem(fxmlLocation)) {
            recordGlobal.addRecentItem(fxmlLocation);
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        String revealMenuKey;
        assert (this.libraryPanelHost != null);
        assert (this.librarySearchPanelHost != null);
        assert (this.hierarchyPanelHost != null);
        assert (this.infoPanelHost != null);
        assert (this.contentPanelHost != null);
        assert (this.inspectorPanelHost != null);
        assert (this.inspectorSearchPanelHost != null);
        assert (this.messageBarHost != null);
        assert (this.mainSplitPane != null);
        assert (this.mainSplitPane.getItems().size() == 2);
        assert (this.leftRightSplitPane != null);
        assert (this.leftRightSplitPane.getItems().size() == 3);
        assert (this.libraryDocumentSplitPane != null);
        assert (this.libraryDocumentSplitPane.getItems().size() == 2);
        assert (this.documentAccordion != null);
        assert (!this.documentAccordion.getPanes().isEmpty());
        assert (this.libraryViewAsList != null);
        assert (this.libraryViewAsSections != null);
        assert (this.libraryReveal != null);
        assert (this.libraryMenuButton != null);
        assert (this.libraryImportSelection != null);
        assert (this.customLibraryMenu != null);
        if (EditorPlatform.IS_WINDOWS) {
            this.getRoot().getStyleClass().add((Object)"windows-document-decoration");
        }
        this.mainSplitPane.addEventFilter(KeyEvent.KEY_PRESSED, this.mainKeyEventFilter);
        assert (this.getRoot() instanceof VBox);
        VBox rootVBox = (VBox)this.getRoot();
        rootVBox.getChildren().add(0, (Object)this.menuBarController.getMenuBar());
        this.libraryPanelHost.getChildren().add((Object)this.libraryPanelController.getPanelRoot());
        this.librarySearchPanelHost.getChildren().add((Object)this.librarySearchController.getPanelRoot());
        this.hierarchyPanelHost.getChildren().add((Object)this.hierarchyPanelController.getPanelRoot());
        this.infoPanelHost.getChildren().add((Object)this.infoPanelController.getPanelRoot());
        this.contentPanelHost.getChildren().add((Object)this.contentPanelController.getPanelRoot());
        this.inspectorPanelHost.getChildren().add((Object)this.inspectorPanelController.getPanelRoot());
        this.inspectorSearchPanelHost.getChildren().add((Object)this.inspectorSearchController.getPanelRoot());
        this.messageBarHost.getChildren().add((Object)this.messageBarController.getPanelRoot());
        this.messageBarController.getSelectionBarHost().getChildren().add((Object)this.selectionBarController.getPanelRoot());
        this.inspectorSearchController.textProperty().addListener((ov, oldStr, newStr) -> this.inspectorPanelController.setSearchPattern((String)newStr));
        this.librarySearchController.textProperty().addListener((ov, oldStr, newStr) -> this.libraryPanelController.setSearchPattern((String)newStr));
        this.bottomSplitController = new SplitController(this.mainSplitPane, SplitController.Target.LAST);
        this.leftSplitController = new SplitController(this.leftRightSplitPane, SplitController.Target.FIRST);
        this.rightSplitController = new SplitController(this.leftRightSplitPane, SplitController.Target.LAST);
        this.librarySplitController = new SplitController(this.libraryDocumentSplitPane, SplitController.Target.FIRST);
        this.documentSplitController = new SplitController(this.libraryDocumentSplitPane, SplitController.Target.LAST);
        this.messageBarHost.heightProperty().addListener(o -> {
            double h = this.messageBarHost.getHeight();
            this.contentPanelHost.setPadding(new Insets(h, 0.0, 0.0, 0.0));
        });
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
        this.getEditorController().getJobManager().revisionProperty().addListener((ov, t, t1) -> this.messageBarController.setDocumentDirty(this.isDocumentDirty()));
        if (EditorPlatform.IS_MAC) {
            revealMenuKey = "menu.title.reveal.mac";
        } else if (EditorPlatform.IS_WINDOWS) {
            revealMenuKey = "menu.title.reveal.win";
        } else {
            assert (EditorPlatform.IS_LINUX);
            revealMenuKey = "menu.title.reveal.linux";
        }
        this.libraryReveal.setText(I18N.getString(revealMenuKey));
        this.libraryMenuButton.showingProperty().addListener((ov, t, t1) -> {
            if (t1.booleanValue()) {
                Library lib;
                AbstractSelectionGroup asg = this.getEditorController().getSelection().getGroup();
                this.libraryImportSelection.setDisable(true);
                if (asg instanceof ObjectSelectionGroup && ((ObjectSelectionGroup)asg).getItems().size() >= 1) {
                    this.libraryImportSelection.setDisable(false);
                }
                if ((lib = this.getEditorController().getLibrary()) instanceof UserLibrary) {
                    File userLibDir = new File(((UserLibrary)lib).getPath());
                    if (userLibDir.canRead()) {
                        this.customLibraryMenu.setDisable(false);
                    } else {
                        this.customLibraryMenu.setDisable(true);
                    }
                }
            }
        });
        this.libraryLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> SceneBuilderApp.getSingleton().getUserLibrary().isExploring() ? I18N.getString("library.exploring") : I18N.getString("library"), (Observable[])new Observable[]{SceneBuilderApp.getSingleton().getUserLibrary().exploringProperty()}));
    }

    @Override
    protected void controllerDidCreateStage() {
        this.updateStageTitle();
        this.updateFromDocumentPreferences(true);
        this.editorController.setOwnerWindow(this.getStage());
    }

    @Override
    public void openWindow() {
        if (!this.getStage().isShowing()) {
            assert (!this.editorController.isFileWatchingStarted());
            this.editorController.startFileWatching();
            this.watchingController.start();
        }
        super.openWindow();
        if (!EditorPlatform.IS_MAC) {
            this.getStage().setMaximized(true);
        }
        assert (this.librarySearchController != null);
        this.librarySearchController.requestFocus();
    }

    @Override
    public void closeWindow() {
        super.closeWindow();
        this.editorController.stopFileWatching();
        this.watchingController.stop();
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.performCloseAction();
    }

    public boolean isFrontDocumentWindow() {
        return this.getStage().isFocused() || this.previewWindowController != null && this.previewWindowController.getStage().isFocused() || this.skeletonWindowController != null && this.skeletonWindowController.getStage().isFocused() || this.jarAnalysisReportController != null && this.jarAnalysisReportController.getStage().isFocused();
    }

    public void performCloseFrontDocumentWindow() {
        if (this.getStage().isFocused()) {
            this.performCloseAction();
        } else if (this.previewWindowController != null && this.previewWindowController.getStage().isFocused()) {
            this.previewWindowController.closeWindow();
        } else if (this.skeletonWindowController != null && this.skeletonWindowController.getStage().isFocused()) {
            this.skeletonWindowController.closeWindow();
        } else if (this.jarAnalysisReportController != null && this.jarAnalysisReportController.getStage().isFocused()) {
            this.jarAnalysisReportController.closeWindow();
        }
    }

    @Override
    protected void toolStylesheetDidChange(String oldStylesheet) {
        super.toolStylesheetDidChange(oldStylesheet);
        this.editorController.setToolStylesheet(this.getToolStylesheet());
        if (this.skeletonWindowController != null) {
            this.skeletonWindowController.setToolStylesheet(this.getToolStylesheet());
        }
        if (this.jarAnalysisReportController != null) {
            this.jarAnalysisReportController.setToolStylesheet(this.getToolStylesheet());
        }
    }

    @FXML
    void onInspectorShowAllAction(ActionEvent event) {
        this.inspectorPanelController.setShowMode(InspectorPanelController.ShowMode.ALL);
    }

    @FXML
    void onInspectorShowEditedAction(ActionEvent event) {
        this.inspectorPanelController.setShowMode(InspectorPanelController.ShowMode.EDITED);
    }

    @FXML
    void onInspectorViewSectionsAction(ActionEvent event) {
        this.inspectorPanelController.setViewMode(InspectorPanelController.ViewMode.SECTION);
    }

    @FXML
    void onInspectorViewByPropertyNameAction(ActionEvent event) {
        this.inspectorPanelController.setViewMode(InspectorPanelController.ViewMode.PROPERTY_NAME);
    }

    @FXML
    void onInspectorViewByPropertyTypeAction(ActionEvent event) {
        this.inspectorPanelController.setViewMode(InspectorPanelController.ViewMode.PROPERTY_TYPE);
    }

    @FXML
    void onCssPanelViewRulesAction(ActionEvent event) {
        this.cssPanelMenuController.viewRules();
        this.cssPanelSplitDefaultsMi.setDisable(true);
        this.cssPanelShowStyledOnlyMi.setDisable(true);
    }

    @FXML
    void onCssPanelViewTableAction(ActionEvent event) {
        this.cssPanelMenuController.viewTable();
        this.cssPanelSplitDefaultsMi.setDisable(false);
        this.cssPanelShowStyledOnlyMi.setDisable(false);
    }

    @FXML
    void onCssPanelViewTextAction(ActionEvent event) {
        this.cssPanelMenuController.viewText();
        this.cssPanelSplitDefaultsMi.setDisable(true);
        this.cssPanelShowStyledOnlyMi.setDisable(true);
    }

    @FXML
    void onCssPanelCopyStyleablePathAction(ActionEvent event) {
        this.cssPanelMenuController.copyStyleablePath();
    }

    @FXML
    void onCssPanelSplitDefaultsAction(ActionEvent event) {
        this.cssPanelMenuController.splitDefaultsAction(this.cssPanelSplitDefaultsMi);
    }

    @FXML
    void onCssPanelShowStyledOnlyAction(ActionEvent event) {
        this.cssPanelMenuController.showStyledOnly(this.cssPanelShowStyledOnlyMi);
    }

    @FXML
    void onHierarchyShowInfo(ActionEvent event) {
        this.hierarchyPanelController.setDisplayOption(AbstractHierarchyPanelController.DisplayOption.INFO);
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
        this.updateHierarchyDisplayOption();
    }

    @FXML
    void onHierarchyShowFxId(ActionEvent event) {
        this.hierarchyPanelController.setDisplayOption(AbstractHierarchyPanelController.DisplayOption.FXID);
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
        this.updateHierarchyDisplayOption();
    }

    @FXML
    void onHierarchyShowNodeId(ActionEvent event) {
        this.hierarchyPanelController.setDisplayOption(AbstractHierarchyPanelController.DisplayOption.NODEID);
        this.documentAccordion.setExpandedPane((TitledPane)this.documentAccordion.getPanes().get(0));
        this.updateHierarchyDisplayOption();
    }

    private void updateHierarchyDisplayOption() {
        PreferencesRecordGlobal recordGlobal = this.getPreferencesRecordGlobal();
        recordGlobal.updateHierarchyDisplayOption(this.hierarchyPanelController.getDisplayOption());
    }

    @FXML
    public void onManageJarFxml(ActionEvent event) {
        if (this.libraryDialogController == null) {
            this.libraryDialogController = new LibraryDialogController(this.editorController, AppSettings.getUserM2Repository(), PreferencesController.getSingleton(), this.getStage());
            this.libraryDialogController.setOnAddJar(() -> this.onImportJarFxml((Window)this.libraryDialogController.getStage()));
            this.libraryDialogController.setOnEditFXML(fxmlPath -> {
                if (SceneBuilderApp.getSingleton().findFirstUnusedDocumentWindowController().isPresent()) {
                    this.libraryDialogController.closeWindow();
                }
                SceneBuilderApp.getSingleton().performOpenRecent(this, fxmlPath.toFile());
            });
            this.libraryDialogController.setOnAddFolder(() -> this.onImportFromFolder((Window)this.libraryDialogController.getStage()));
        }
        this.libraryDialogController.openWindow();
    }

    public void onImportJarFxml(Window owner) {
        this.libraryPanelController.performImportJarFxml(owner);
    }

    public void onImportFromFolder(Window owner) {
        this.libraryPanelController.performImportFromFolder(owner);
    }

    @FXML
    void onLibraryViewAsList(ActionEvent event) {
        if (this.libraryPanelController.getDisplayMode() != LibraryPanelController.DISPLAY_MODE.SEARCH) {
            this.libraryPanelController.setDisplayMode(LibraryPanelController.DISPLAY_MODE.LIST);
        } else {
            this.libraryPanelController.setPreviousDisplayMode(LibraryPanelController.DISPLAY_MODE.LIST);
        }
        this.updateLibraryDisplayOption();
    }

    @FXML
    void onLibraryViewAsSections(ActionEvent event) {
        if (this.libraryPanelController.getDisplayMode() != LibraryPanelController.DISPLAY_MODE.SEARCH) {
            this.libraryPanelController.setDisplayMode(LibraryPanelController.DISPLAY_MODE.SECTIONS);
        } else {
            this.libraryPanelController.setPreviousDisplayMode(LibraryPanelController.DISPLAY_MODE.SECTIONS);
        }
        this.updateLibraryDisplayOption();
    }

    private void updateLibraryDisplayOption() {
        PreferencesRecordGlobal recordGlobal = this.getPreferencesRecordGlobal();
        recordGlobal.updateLibraryDisplayOption(this.libraryPanelController.getDisplayMode());
    }

    @FXML
    void onLibraryImportSelection(ActionEvent event) {
        AbstractSelectionGroup asg = this.getEditorController().getSelection().getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            assert (!osg.getItems().isEmpty());
            ArrayList<FXOMObject> selection = new ArrayList<FXOMObject>(osg.getItems());
            this.libraryPanelController.performImportSelection(selection);
        }
    }

    @FXML
    void onLibraryRevealCustomFolder(ActionEvent event) {
        String userLibraryPath = ((UserLibrary)this.getEditorController().getLibrary()).getPath();
        File libraryPath = Paths.get(userLibraryPath, new String[0]).normalize().toFile();
        try {
            EditorPlatform.revealInFileBrowser(libraryPath);
        }
        catch (Exception revealError) {
            this.handleRevealFolderException(revealError, String.valueOf(libraryPath));
        }
    }

    @FXML
    void onLibraryShowJarAnalysisReport(ActionEvent event) {
        if (this.jarAnalysisReportController == null) {
            this.jarAnalysisReportController = new JarAnalysisReportController(this.getEditorController(), this.getStage());
            this.jarAnalysisReportController.setToolStylesheet(this.getToolStylesheet());
        }
        this.jarAnalysisReportController.openWindow();
    }

    private boolean canPerformSelectAll() {
        boolean result;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            String text = tic.getText();
            String selectedText = tic.getSelectedText();
            result = text == null || text.isEmpty() ? false : selectedText == null || selectedText.length() < tic.getText().length();
        } else {
            result = this.getEditorController().canPerformControlAction(EditorController.ControlAction.SELECT_ALL);
        }
        return result;
    }

    private void performSelectAll() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.selectAll();
        } else {
            this.getEditorController().performControlAction(EditorController.ControlAction.SELECT_ALL);
        }
    }

    private boolean canPerformSelectNone() {
        TextInputControl tic;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        boolean result = this.isTextInputControlEditing(focusOwner) ? (tic = this.getTextInputControl(focusOwner)).getSelectedText() != null && !tic.getSelectedText().isEmpty() : this.getEditorController().canPerformControlAction(EditorController.ControlAction.SELECT_NONE);
        return result;
    }

    private void performSelectNone() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.deselect();
        } else {
            this.getEditorController().performControlAction(EditorController.ControlAction.SELECT_NONE);
        }
    }

    private boolean canPerformCopy() {
        TextInputControl tic;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        boolean result = this.isTextInputControlEditing(focusOwner) ? (tic = this.getTextInputControl(focusOwner)).getSelectedText() != null && !tic.getSelectedText().isEmpty() : (this.isCssRulesEditing(focusOwner) || this.isCssTextEditing(focusOwner) ? true : this.getEditorController().canPerformControlAction(EditorController.ControlAction.COPY));
        return result;
    }

    private void performCopy() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.copy();
        } else if (this.isCssRulesEditing(focusOwner)) {
            this.cssPanelController.copyRules();
        } else if (!this.isCssTextEditing(focusOwner)) {
            this.getEditorController().performControlAction(EditorController.ControlAction.COPY);
        }
    }

    private boolean canPerformCut() {
        TextInputControl tic;
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isPopupEditing(focusOwner)) {
            return false;
        }
        boolean result = this.isTextInputControlEditing(focusOwner) ? (tic = this.getTextInputControl(focusOwner)).getSelectedText() != null && !tic.getSelectedText().isEmpty() : this.getEditorController().canPerformEditAction(EditorController.EditAction.CUT);
        return result;
    }

    private void performCut() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.cut();
        } else {
            this.getEditorController().performEditAction(EditorController.EditAction.CUT);
        }
    }

    private boolean canPerformPaste() {
        Node focusOwner = this.getScene().getFocusOwner();
        boolean result = this.getEditorController().canPerformEditAction(EditorController.EditAction.PASTE) ? true : (this.isTextInputControlEditing(focusOwner) ? Clipboard.getSystemClipboard().hasString() : false);
        return result;
    }

    private void performPaste() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.getEditorController().canPerformEditAction(EditorController.EditAction.PASTE)) {
            this.getEditorController().performEditAction(EditorController.EditAction.PASTE);
            this.contentPanelController.getGlassLayer().requestFocus();
        } else {
            assert (this.isTextInputControlEditing(focusOwner));
            TextInputControl tic = this.getTextInputControl(focusOwner);
            boolean alternatePaste = PreferencesController.getSingleton().getRecordGlobal().isAlternateTextInputControlPaste();
            if (!alternatePaste) {
                tic.paste();
            }
        }
    }

    private boolean canPerformDelete() {
        TextInputControl tic;
        Node focusOwner = this.getScene().getFocusOwner();
        boolean result = this.isTextInputControlEditing(focusOwner) ? (tic = this.getTextInputControl(focusOwner)).getCaretPosition() < tic.getLength() : this.getEditorController().canPerformEditAction(EditorController.EditAction.DELETE);
        return result;
    }

    private void performDelete() {
        Node focusOwner = this.getScene().getFocusOwner();
        if (this.isTextInputControlEditing(focusOwner)) {
            TextInputControl tic = this.getTextInputControl(focusOwner);
            tic.deleteNextChar();
        } else {
            boolean deleteConfirmed;
            List<FXOMObject> selectedObjects = this.editorController.getSelectedObjects();
            HashMap<String, FXOMObject> fxIdMap = new HashMap<String, FXOMObject>();
            for (FXOMObject selectedObject : selectedObjects) {
                fxIdMap.putAll(selectedObject.collectFxIds());
            }
            FXOMNodes.removeToggleGroups(fxIdMap);
            if (fxIdMap.isEmpty()) {
                deleteConfirmed = true;
            } else {
                String message = fxIdMap.size() == 1 ? (selectedObjects.size() == 1 ? I18N.getString("alert.delete.fxid1of1.message") : I18N.getString("alert.delete.fxid1ofN.message")) : (selectedObjects.size() == fxIdMap.size() ? I18N.getString("alert.delete.fxidNofN.message") : I18N.getString("alert.delete.fxidKofN.message"));
                AlertDialog d = new AlertDialog((Window)this.getStage());
                d.setMessage(message);
                d.setDetails(I18N.getString("alert.delete.fxid.details"));
                d.setOKButtonTitle(I18N.getString("label.delete"));
                boolean bl = deleteConfirmed = d.showAndWait() == AbstractModalDialog.ButtonID.OK;
            }
            if (deleteConfirmed) {
                this.editorController.performEditAction(EditorController.EditAction.DELETE);
            }
        }
    }

    private void performImportFxml() {
        this.fetchFXMLFile().ifPresent(fxmlFile -> this.getEditorController().performImportFxml((File)fxmlFile));
    }

    private void performIncludeFxml() {
        this.fetchFXMLFile().ifPresent(fxmlFile -> this.getEditorController().performIncludeFxml((File)fxmlFile));
    }

    private Optional<File> fetchFXMLFile() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter f = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"});
        fileChooser.getExtensionFilters().add((Object)f);
        fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        File fxmlFile = fileChooser.showOpenDialog((Window)this.getStage());
        if (fxmlFile != null) {
            String path = fxmlFile.getPath();
            if (!path.endsWith(".fxml")) {
                fxmlFile = new File(path + ".fxml");
            }
            EditorController.updateNextInitialDirectory(fxmlFile);
        }
        return Optional.ofNullable(fxmlFile);
    }

    private void performImportMedia() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter imageFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.image"), ResourceUtils.getSupportedImageExtensions());
        FileChooser.ExtensionFilter audioFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.audio"), ResourceUtils.getSupportedAudioExtensions());
        FileChooser.ExtensionFilter videoFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.video"), ResourceUtils.getSupportedVideoExtensions());
        FileChooser.ExtensionFilter mediaFilter = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.media"), ResourceUtils.getSupportedMediaExtensions());
        fileChooser.getExtensionFilters().add((Object)mediaFilter);
        fileChooser.getExtensionFilters().add((Object)imageFilter);
        fileChooser.getExtensionFilters().add((Object)audioFilter);
        fileChooser.getExtensionFilters().add((Object)videoFilter);
        fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        File mediaFile = fileChooser.showOpenDialog((Window)this.getStage());
        if (mediaFile != null) {
            EditorController.updateNextInitialDirectory(mediaFile);
            this.getEditorController().performImportMedia(mediaFile);
        }
    }

    private boolean isTextInputControlEditing(Node node) {
        return node instanceof TextInputControl || node instanceof ComboBox;
    }

    private TextInputControl getTextInputControl(Node node) {
        TextInputControl tic;
        assert (this.isTextInputControlEditing(node));
        if (node instanceof TextInputControl) {
            tic = (TextInputControl)node;
        } else {
            assert (node instanceof ComboBox);
            ComboBox cb = (ComboBox)node;
            tic = cb.getEditor();
        }
        return tic;
    }

    private boolean isPopupEditing(Node node) {
        return node instanceof MenuButton && ((MenuButton)node).isShowing() || this.editorController.getInlineEditController().isWindowOpened();
    }

    private boolean isCssRulesEditing(Node node) {
        Node cssRules = this.cssPanelController.getRulesPane();
        if (cssRules != null) {
            return this.isDescendantOf(cssRules, node);
        }
        return false;
    }

    private boolean isCssTextEditing(Node node) {
        Node cssText = this.cssPanelController.getTextPane();
        if (cssText != null) {
            return this.isDescendantOf(cssText, node);
        }
        return false;
    }

    private boolean isDescendantOf(Node container, Node node) {
        for (Node child = node; child != null; child = child.getParent()) {
            if (child != container) continue;
            return true;
        }
        return false;
    }

    private KeyCombination getAccelerator(KeyEvent event) {
        KeyCombination result = null;
        for (KeyCombination kc : this.menuBarController.getAccelerators()) {
            if (!kc.match(event)) continue;
            result = kc;
            break;
        }
        return result;
    }

    private void updateStageTitle() {
        if (this.libraryPanelHost != null) {
            this.getStage().setTitle(Utils.makeTitle(this.editorController.getFxomDocument()));
        }
    }

    private void updateFromDocumentPreferences(boolean refreshTheme) {
        if (this.libraryPanelHost != null) {
            PreferencesController pc = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
            this.refreshFromPreferencesRecordGlobal(recordGlobal, refreshTheme);
            PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
            recordDocument.readFromJavaPreferences();
            recordDocument.refresh();
        }
    }

    public void refreshFromPreferencesRecordGlobal(PreferencesRecordGlobal recordGlobal, boolean refreshTheme) {
        this.refreshAlignmentGuidesColor(recordGlobal);
        this.refreshBackgroundImage(recordGlobal);
        this.refreshCssTableColumnsOrderingReversed(recordGlobal);
        this.refreshToolTheme(recordGlobal);
        this.refreshLibraryDisplayOption(recordGlobal);
        this.refreshHierarchyDisplayOption(recordGlobal);
        this.refreshParentRingColor(recordGlobal);
        this.refreshRootContainerHeight(recordGlobal);
        this.refreshRootContainerWidth(recordGlobal);
        if (refreshTheme) {
            this.refreshTheme(recordGlobal);
            this.refreshSwatch(recordGlobal);
            this.refreshGluonTheme(recordGlobal);
        }
        this.refreshAccordionAnimation(recordGlobal);
    }

    private void resetDocumentPreferences() {
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordDocument recordDocument = pc.getRecordDocument(this);
        recordDocument.resetDocumentPreferences();
    }

    ActionStatus performSaveOrSaveAsAction() {
        ActionStatus result = this.editorController.getFxomDocument().getLocation() == null ? this.performSaveAsAction() : this.performSaveAction();
        if (result.equals((Object)ActionStatus.DONE)) {
            this.messageBarController.setDocumentDirty(false);
            this.saveJob = this.getEditorController().getJobManager().getCurrentJob();
        }
        return result;
    }

    private void addCssPanelSearchListener() {
        this.cssPanelSearchController.textProperty().addListener((ov, oldStr, newStr) -> this.cssPanelController.setSearchPattern((String)newStr));
    }

    private void performGoToSection(InspectorPanelController.SectionId sectionId) {
        if (!this.isRightPanelVisible()) {
            this.performControlAction(DocumentControlAction.TOGGLE_RIGHT_PANEL);
        }
        this.inspectorPanelController.setExpandedSection(sectionId);
    }

    private ActionStatus performSaveAction() {
        ActionStatus result;
        block13: {
            FXOMDocument fxomDocument = this.editorController.getFxomDocument();
            assert (fxomDocument != null);
            assert (fxomDocument.getLocation() != null);
            if (this.editorController.canGetFxmlText()) {
                Path fxmlPath;
                try {
                    fxmlPath = Paths.get(fxomDocument.getLocation().toURI());
                }
                catch (URISyntaxException x) {
                    throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
                }
                String fileName = fxmlPath.getFileName().toString();
                try {
                    boolean saveConfirmed;
                    if (this.checkLoadFileTime()) {
                        saveConfirmed = true;
                    } else {
                        AlertDialog d = new AlertDialog((Window)this.getStage());
                        d.setMessage(I18N.getString("alert.overwrite.message", fileName));
                        d.setDetails(I18N.getString("alert.overwrite.details"));
                        d.setOKButtonVisible(true);
                        d.setOKButtonTitle(I18N.getString("label.overwrite"));
                        d.setDefaultButtonID(AbstractModalDialog.ButtonID.CANCEL);
                        d.setShowDefaultButton(true);
                        boolean bl = saveConfirmed = d.showAndWait() == AbstractModalDialog.ButtonID.OK;
                    }
                    if (saveConfirmed) {
                        try {
                            this.watchingController.removeDocumentTarget();
                            PreferencesRecordGlobal recordGlobal = this.getPreferencesRecordGlobal();
                            byte[] fxmlBytes = this.editorController.getFxmlText(recordGlobal.isWildcardImports()).getBytes(StandardCharsets.UTF_8);
                            Files.write(fxmlPath, fxmlBytes, new OpenOption[0]);
                            this.updateLoadFileTime();
                            this.watchingController.update();
                            this.editorController.getMessageLog().logInfoMessage("log.info.save.confirmation", I18N.getBundle(), fileName);
                            result = ActionStatus.DONE;
                            break block13;
                        }
                        catch (UnsupportedEncodingException x) {
                            throw new RuntimeException("Bug", x);
                        }
                    }
                    result = ActionStatus.CANCELLED;
                }
                catch (IOException x) {
                    ErrorDialog d = new ErrorDialog((Window)this.getStage());
                    d.setMessage(I18N.getString("alert.save.failure.message", fileName));
                    d.setDetails(I18N.getString("alert.save.failure.details"));
                    d.setDebugInfoWithThrowable(x);
                    d.showAndWait();
                    result = ActionStatus.CANCELLED;
                }
            } else {
                result = ActionStatus.CANCELLED;
            }
        }
        return result;
    }

    private ActionStatus performSaveAsAction() {
        ActionStatus result;
        if (this.editorController.canGetFxmlText()) {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter f = new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"});
            fileChooser.getExtensionFilters().add((Object)f);
            fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
            File fxmlFile = fileChooser.showSaveDialog((Window)this.getStage());
            if (fxmlFile == null) {
                result = ActionStatus.CANCELLED;
            } else {
                URL newLocation;
                boolean forgetSave = false;
                String path = fxmlFile.getPath();
                if (!path.endsWith(".fxml")) {
                    try {
                        URL alternateURL = new URL(fxmlFile.toURI().toURL().toExternalForm() + ".fxml");
                        File alternateFxmlFile = new File(alternateURL.toURI());
                        AlertDialog d = new AlertDialog((Window)this.getStage());
                        d.setMessage(I18N.getString("alert.save.noextension.message", fxmlFile.getName()));
                        Object details = I18N.getString("alert.save.noextension.details");
                        if (alternateFxmlFile.exists()) {
                            details = (String)details + "\n" + I18N.getString("alert.save.noextension.details.overwrite", alternateFxmlFile.getName());
                        }
                        d.setDetails((String)details);
                        d.setOKButtonVisible(true);
                        d.setOKButtonTitle(I18N.getString("alert.save.noextension.savewith"));
                        d.setDefaultButtonID(AbstractModalDialog.ButtonID.OK);
                        d.setShowDefaultButton(true);
                        d.setActionButtonDisable(false);
                        d.setActionButtonVisible(true);
                        d.setActionButtonTitle(I18N.getString("alert.save.noextension.savewithout"));
                        switch (d.showAndWait()) {
                            case ACTION: {
                                break;
                            }
                            case CANCEL: {
                                forgetSave = true;
                                break;
                            }
                            case OK: {
                                fxmlFile = alternateFxmlFile;
                            }
                        }
                    }
                    catch (MalformedURLException | URISyntaxException ex) {
                        forgetSave = true;
                    }
                }
                try {
                    newLocation = fxmlFile.toURI().toURL();
                }
                catch (MalformedURLException x) {
                    throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
                }
                DocumentWindowController dwc = SceneBuilderApp.getSingleton().lookupDocumentWindowControllers(newLocation);
                if (dwc != null && dwc != this) {
                    Path fxmlPath = Paths.get(fxmlFile.toString(), new String[0]);
                    String fileName = fxmlPath.getFileName().toString();
                    ErrorDialog d = new ErrorDialog((Window)this.getStage());
                    d.setMessage(I18N.getString("alert.save.conflict.message", fileName));
                    d.setDetails(I18N.getString("alert.save.conflict.details"));
                    d.showAndWait();
                    result = ActionStatus.CANCELLED;
                } else if (forgetSave) {
                    result = ActionStatus.CANCELLED;
                } else {
                    this.editorController.setFxmlLocation(newLocation);
                    this.updateLoadFileTime();
                    this.updateStageTitle();
                    this.resetDocumentPreferences();
                    this.watchingController.update();
                    result = this.performSaveAction();
                    if (result.equals((Object)ActionStatus.DONE)) {
                        this.messageBarController.setDocumentDirty(false);
                        this.saveJob = this.getEditorController().getJobManager().getCurrentJob();
                    }
                    EditorController.updateNextInitialDirectory(fxmlFile);
                    PreferencesRecordGlobal recordGlobal = this.getPreferencesRecordGlobal();
                    recordGlobal.addRecentItem(fxmlFile);
                }
            }
        } else {
            result = ActionStatus.CANCELLED;
        }
        return result;
    }

    private void performRevertAction() {
        assert (this.editorController.getFxomDocument() != null);
        assert (this.editorController.getFxomDocument().getLocation() != null);
        AlertDialog d = new AlertDialog((Window)this.getStage());
        d.setMessage(I18N.getString("alert.revert.question.message", this.getStage().getTitle()));
        d.setDetails(I18N.getString("alert.revert.question.details"));
        d.setOKButtonTitle(I18N.getString("label.revert"));
        if (d.showAndWait() == AbstractModalDialog.ButtonID.OK) {
            try {
                this.reload();
            }
            catch (IOException x) {
                ErrorDialog errorDialog = new ErrorDialog(null);
                errorDialog.setMessage(I18N.getString("alert.open.failure1.message", this.getStage().getTitle()));
                errorDialog.setDetails(I18N.getString("alert.open.failure1.details"));
                errorDialog.setDebugInfoWithThrowable(x);
                errorDialog.setTitle(I18N.getString("alert.title.open"));
                errorDialog.showAndWait();
                SceneBuilderApp.getSingleton().documentWindowRequestClose(this);
            }
        }
    }

    ActionStatus performCloseAction() {
        boolean closeConfirmed;
        this.getStage().toFront();
        if (this.getEditorController().isTextEditingSessionOnGoing() && !this.getEditorController().canGetFxmlText()) {
            return ActionStatus.CANCELLED;
        }
        if (this.isDocumentDirty()) {
            AlertDialog d = new AlertDialog((Window)this.getStage());
            d.setTitle(I18N.getString("alert.save.question.title"));
            d.setMessage(I18N.getString("alert.save.question.message", this.getStage().getTitle()));
            d.setDetails(I18N.getString("alert.save.question.details"));
            d.setOKButtonTitle(I18N.getString("label.save"));
            d.setActionButtonTitle(I18N.getString("label.do.not.save"));
            d.setActionButtonVisible(true);
            switch (d.showAndWait()) {
                default: {
                    if (this.editorController.getFxomDocument().getLocation() == null) {
                        closeConfirmed = this.performSaveAsAction() == ActionStatus.DONE;
                        break;
                    }
                    closeConfirmed = this.performSaveAction() == ActionStatus.DONE;
                    break;
                }
                case CANCEL: {
                    closeConfirmed = false;
                    break;
                }
                case ACTION: {
                    closeConfirmed = true;
                    break;
                }
            }
        } else {
            closeConfirmed = true;
        }
        if (closeConfirmed) {
            SceneBuilderApp.getSingleton().documentWindowRequestClose(this);
            this.updatePreferences();
        }
        return closeConfirmed ? ActionStatus.DONE : ActionStatus.CANCELLED;
    }

    private void performRevealAction() {
        assert (this.editorController.getFxomDocument() != null);
        assert (this.editorController.getFxomDocument().getLocation() != null);
        URL location = this.editorController.getFxomDocument().getLocation();
        File fxmlFile = null;
        try {
            fxmlFile = Path.of(location.toURI()).normalize().toAbsolutePath().toFile();
        }
        catch (URISyntaxException e) {
            this.handleRevealResourceException(e, String.valueOf(location));
        }
        try {
            EditorPlatform.revealInFileBrowser(fxmlFile);
        }
        catch (FileBrowserRevealException re) {
            this.handleRevealFileException(re, String.valueOf(fxmlFile));
        }
        catch (IOException x) {
            this.handleRevealResourceException(x, String.valueOf(fxmlFile));
        }
    }

    private void updateLoadFileTime() {
        URL fxmlURL = this.editorController.getFxmlLocation();
        if (fxmlURL == null) {
            this.loadFileTime = null;
        } else {
            try {
                Path fxmlPath = Paths.get(fxmlURL.toURI());
                this.loadFileTime = Files.exists(fxmlPath, new LinkOption[0]) ? Files.getLastModifiedTime(fxmlPath, new LinkOption[0]) : null;
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Bug", x);
            }
            catch (IOException x) {
                this.loadFileTime = null;
            }
        }
    }

    private boolean checkLoadFileTime() throws IOException {
        boolean result;
        assert (this.editorController.getFxmlLocation() != null);
        if (this.loadFileTime == null) {
            result = true;
        } else {
            try {
                Path fxmlPath = Paths.get(this.editorController.getFxmlLocation().toURI());
                FileTime currentFileTime = Files.getLastModifiedTime(fxmlPath, new LinkOption[0]);
                result = this.loadFileTime.compareTo(currentFileTime) == 0;
            }
            catch (NoSuchFileException x) {
                result = true;
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Bug", x);
            }
        }
        return result;
    }

    private void performHelp() {
        this.openURL(DocumentationUrls.ORACLE_DOCUMENTATION.toString());
    }

    private void openURL(String url) {
        try {
            LOGGER.log(Level.FINE, "Attempting to open URL: {0}", url);
            EditorPlatform.open(url);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error during attempt to open URL!", ioe);
            this.handleRevealResourceException(ioe, url);
        }
    }

    private void handleRevealFileException(FileBrowserRevealException fileRevealException, String locationToBeRevealed) {
        ErrorDialog errorDialog = new ErrorDialog((Window)this.getStage());
        errorDialog.setTitle(I18N.getString("alert.error.file.reveal.title"));
        errorDialog.setMessage(I18N.getString("alert.error.file.reveal.message"));
        errorDialog.setDetails(I18N.getString("alert.error.file.reveal.details", locationToBeRevealed));
        errorDialog.setDetailsTitle(I18N.getString("alert.error.file.reveal.details.title"));
        errorDialog.setDebugInfoWithThrowable(fileRevealException);
        errorDialog.showAndWait();
    }

    private void handleRevealResourceException(Exception revealException, String locationToBeRevealed) {
        ErrorDialog errorDialog = new ErrorDialog((Window)this.getStage());
        errorDialog.setTitle(I18N.getString("alert.error.resource.reveal.title"));
        errorDialog.setMessage(I18N.getString("alert.error.resource.reveal.message"));
        errorDialog.setDetails(I18N.getString("alert.error.resource.reveal.details", locationToBeRevealed));
        errorDialog.setDetailsTitle(I18N.getString("alert.error.resource.reveal.details.title"));
        errorDialog.setDebugInfoWithThrowable(revealException);
        errorDialog.showAndWait();
    }

    private void handleRevealFolderException(Exception revealException, String directoryToBeRevealed) {
        ErrorDialog errorDialog = new ErrorDialog((Window)this.getStage());
        errorDialog.setTitle(I18N.getString("alert.error.directory.reveal.title"));
        errorDialog.setMessage(I18N.getString("alert.error.directory.reveal.message"));
        errorDialog.setDetails(I18N.getString("alert.error.directory.reveal.details", directoryToBeRevealed));
        errorDialog.setDetailsTitle(I18N.getString("alert.error.directory.reveal.details.title"));
        errorDialog.setDebugInfoWithThrowable(revealException);
        errorDialog.showAndWait();
    }

    private PreferencesRecordGlobal getPreferencesRecordGlobal() {
        if (this.recordGlobal == null) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            this.recordGlobal = preferencesController.getRecordGlobal();
        }
        return this.recordGlobal;
    }

    public static enum DocumentControlAction {
        COPY,
        SELECT_ALL,
        SELECT_NONE,
        SAVE_FILE,
        SAVE_AS_FILE,
        REVERT_FILE,
        CLOSE_FILE,
        REVEAL_FILE,
        GOTO_CONTENT,
        GOTO_PROPERTIES,
        GOTO_LAYOUT,
        GOTO_CODE,
        TOGGLE_LIBRARY_PANEL,
        TOGGLE_DOCUMENT_PANEL,
        TOGGLE_CSS_PANEL,
        TOGGLE_LEFT_PANEL,
        TOGGLE_RIGHT_PANEL,
        TOGGLE_OUTLINES_VISIBILITY,
        TOGGLE_GUIDES_VISIBILITY,
        SHOW_PREVIEW_WINDOW,
        SHOW_PREVIEW_DIALOG,
        ADD_SCENE_STYLE_SHEET,
        SET_RESOURCE,
        REMOVE_RESOURCE,
        REVEAL_RESOURCE,
        HELP,
        SHOW_SAMPLE_CONTROLLER,
        HELP_OPEN_GETTING_STARTED_GUIDE,
        HELP_OPEN_GETTING_STARTED_WITH_KOTLIN,
        HELP_OPEN_OPENJFX_APIDOC,
        HELP_OPEN_OPENJFX_CSS_REFERENCE,
        HELP_OPEN_OPENJFX_FXML_REFERENCE,
        HELP_OPEN_GLUON_SCENEBUILDER_HOME,
        HELP_COMMUNITY_CONTRIBUTE_SCENEBUILDER,
        HELP_OPEN_JFXCENTRAL_HOMEPAGE;

    }

    public static enum ActionStatus {
        CANCELLED,
        DONE;

    }

    public static enum DocumentEditAction {
        DELETE,
        CUT,
        PASTE,
        IMPORT_FXML,
        IMPORT_MEDIA,
        INCLUDE_FXML;

    }

    public static class TitleComparator
    implements Comparator<DocumentWindowController> {
        @Override
        public int compare(DocumentWindowController d1, DocumentWindowController d2) {
            int result;
            assert (d1 != null);
            assert (d2 != null);
            if (d1 == d2) {
                result = 0;
            } else {
                String t1 = d1.getStage().getTitle();
                String t2 = d2.getStage().getTitle();
                assert (t1 != null);
                assert (t2 != null);
                result = t1.compareTo(t2);
            }
            return result;
        }
    }
}

