/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.PropertyResourceBundle;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class ResourceController {
    private final DocumentWindowController documentWindowController;
    private File resourceFile;

    public ResourceController(DocumentWindowController dwc) {
        this.documentWindowController = dwc;
    }

    public File getResourceFile() {
        return this.resourceFile;
    }

    public void setResourceFile(File file) {
        if (file != null && ResourceController.readPropertyResourceBundle(file) != null) {
            this.resourceFile = file;
            this.resourceFileDidChange();
        }
    }

    public void performSetResource() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("resource.filechooser.filter.msg"), new String[]{"*.properties"}));
        fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        File newResourceFile = fileChooser.showOpenDialog((Window)this.documentWindowController.getStage());
        if (newResourceFile != null) {
            EditorController.updateNextInitialDirectory(newResourceFile);
        }
        this.setResourceFile(newResourceFile);
    }

    public void performRemoveResource() {
        assert (this.resourceFile != null);
        this.resourceFile = null;
        this.resourceFileDidChange();
    }

    public void performRevealResource() {
        assert (this.resourceFile != null);
        try {
            EditorPlatform.revealInFileBrowser(this.resourceFile);
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog((Window)this.documentWindowController.getStage());
            errorDialog.setTitle(I18N.getString("alert.error.file.reveal.title"));
            errorDialog.setMessage(I18N.getString("alert.error.file.reveal.message"));
            errorDialog.setDetails(I18N.getString("alert.error.file.reveal.details", this.resourceFile));
            errorDialog.setDetailsTitle(I18N.getString("alert.error.file.reveal.details.title"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }

    public void performReloadResource() {
        assert (this.resourceFile != null);
        this.resourceFileDidChange();
    }

    private void resourceFileDidChange() {
        PropertyResourceBundle resources;
        if (this.resourceFile != null) {
            resources = ResourceController.readPropertyResourceBundle(this.resourceFile);
            assert (resources != null);
        } else {
            resources = null;
        }
        this.documentWindowController.getEditorController().setResources(resources);
        this.documentWindowController.getWatchingController().update();
    }

    private static PropertyResourceBundle readPropertyResourceBundle(File f) {
        PropertyResourceBundle result;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("UTF-8"));){
            result = new PropertyResourceBundle(reader);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }
}

