/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.gluonhq.scenebuilder.plugins.editor.GluonEditorPlatform;
import com.oracle.javafx.scenebuilder.app.AppPlatform;
import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.UpdateSceneBuilderDialog;
import com.oracle.javafx.scenebuilder.app.about.AboutWindowController;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.menubar.MenuBarController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesWindowController;
import com.oracle.javafx.scenebuilder.app.registration.RegistrationWindowController;
import com.oracle.javafx.scenebuilder.app.tracking.Tracking;
import com.oracle.javafx.scenebuilder.app.util.AppSettings;
import com.oracle.javafx.scenebuilder.app.welcomedialog.WelcomeDialogWindowController;
import com.oracle.javafx.scenebuilder.kit.ResourceUtils;
import com.oracle.javafx.scenebuilder.kit.ToolTheme;
import com.oracle.javafx.scenebuilder.kit.alert.SBAlert;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractWindowController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.preferences.MavenPreferences;
import com.oracle.javafx.scenebuilder.kit.template.Template;
import com.oracle.javafx.scenebuilder.kit.template.TemplatesWindowController;
import com.oracle.javafx.scenebuilder.kit.template.Type;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPicker;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class SceneBuilderApp
extends Application
implements AppPlatform.AppNotificationHandler {
    private static final Logger LOGGER = Logger.getLogger(SceneBuilderApp.class.getName());
    private static SceneBuilderApp singleton;
    private final ObservableList<DocumentWindowController> windowList = FXCollections.observableArrayList();
    private UserLibrary userLibrary;
    private ToolTheme toolTheme = ToolTheme.DEFAULT;
    private final ObservableList<Runnable> startupTasks = FXCollections.observableArrayList();
    private final BooleanBinding startupTasksFinished = Bindings.isEmpty(this.startupTasks);

    public static SceneBuilderApp getSingleton() {
        return singleton;
    }

    public SceneBuilderApp() {
        assert (singleton == null);
        singleton = this;
        Beans.setDesignTime(true);
        this.windowList.addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                String toolStylesheet = this.getToolStylesheet();
                for (DocumentWindowController dwc : c.getAddedSubList()) {
                    dwc.setToolStylesheet(toolStylesheet);
                }
            }
        });
    }

    public BooleanBinding startupTasksFinishedBinding() {
        return this.startupTasksFinished;
    }

    public void performControlAction(ApplicationControlAction a, DocumentWindowController source) {
        switch (a.ordinal()) {
            case 0: {
                AboutWindowController aboutWindowController = new AboutWindowController();
                aboutWindowController.setToolStylesheet(this.getToolStylesheet());
                aboutWindowController.openWindow();
                AppSettings.setWindowIcon(aboutWindowController.getStage());
                break;
            }
            case 2: {
                RegistrationWindowController registrationWindowController = new RegistrationWindowController(source.getStage());
                registrationWindowController.openWindow();
                break;
            }
            case 1: {
                this.checkUpdates(source);
                break;
            }
            case 3: {
                DocumentWindowController newWindow = this.makeNewWindow();
                newWindow.updateWithDefaultContent();
                newWindow.openWindow();
                break;
            }
            case 4: {
                TemplatesWindowController templatesWindowController = new TemplatesWindowController(source.getStage());
                templatesWindowController.setOnTemplateChosen(template -> {
                    templatesWindowController.getStage().hide();
                    this.performNewTemplateInNewWindow((Template)((Object)template));
                });
                templatesWindowController.openWindow();
                break;
            }
            case 5: {
                this.performOpenFile();
                break;
            }
            case 6: {
                this.performCloseFrontWindow();
                break;
            }
            case 7: {
                this.performUseToolTheme(ToolTheme.DEFAULT);
                break;
            }
            case 8: {
                this.performUseToolTheme(ToolTheme.DARK);
                break;
            }
            case 9: {
                PreferencesWindowController preferencesWindowController = new PreferencesWindowController(source.getStage());
                preferencesWindowController.setToolStylesheet(this.getToolStylesheet());
                preferencesWindowController.openWindow();
                break;
            }
            case 10: {
                this.performExit();
                break;
            }
            case 11: {
                WelcomeDialogWindowController.getInstance().getStage().show();
            }
        }
    }

    public boolean canPerformControlAction(ApplicationControlAction a, DocumentWindowController source) {
        boolean result;
        switch (a.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                result = true;
                break;
            }
            case 6: {
                result = !this.windowList.isEmpty();
                break;
            }
            case 7: {
                result = this.toolTheme != ToolTheme.DEFAULT;
                break;
            }
            case 8: {
                result = this.toolTheme != ToolTheme.DARK;
                break;
            }
            default: {
                result = false;
                assert (false);
                break;
            }
        }
        return result;
    }

    public void performOpenRecent(DocumentWindowController source, File fxmlFile) {
        assert (fxmlFile != null && fxmlFile.exists());
        ArrayList<File> fxmlFiles = new ArrayList<File>();
        fxmlFiles.add(fxmlFile);
        this.performOpenFiles(fxmlFiles);
    }

    public void documentWindowRequestClose(DocumentWindowController fromWindow) {
        this.closeWindow(fromWindow);
    }

    public UserLibrary getUserLibrary() {
        return this.userLibrary;
    }

    public List<DocumentWindowController> getDocumentWindowControllers() {
        return Collections.unmodifiableList(this.windowList);
    }

    public DocumentWindowController lookupDocumentWindowControllers(URL fxmlLocation) {
        assert (fxmlLocation != null);
        DocumentWindowController result = null;
        try {
            URI fxmlURI = fxmlLocation.toURI();
            for (DocumentWindowController dwc : this.windowList) {
                URL docLocation = dwc.getEditorController().getFxmlLocation();
                if (docLocation == null || !fxmlURI.equals(docLocation.toURI())) continue;
                result = dwc;
                break;
            }
        }
        catch (URISyntaxException x) {
            throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
        }
        return result;
    }

    public Optional<DocumentWindowController> findFirstUnusedDocumentWindowController() {
        return this.windowList.stream().filter(DocumentWindowController::isUnused).findFirst();
    }

    public void toggleDebugMenu() {
        boolean visible;
        if (this.windowList.isEmpty()) {
            visible = false;
        } else {
            DocumentWindowController dwc = (DocumentWindowController)this.windowList.get(0);
            visible = dwc.getMenuBarController().isDebugMenuVisible();
        }
        for (DocumentWindowController dwc : this.windowList) {
            dwc.getMenuBarController().setDebugMenuVisible(!visible);
        }
        if (EditorPlatform.IS_MAC) {
            MenuBarController.getSystemMenuBarController().setDebugMenuVisible(!visible);
        }
    }

    public void start(Stage stage) throws Exception {
        this.setApplicationUncaughtExceptionHandler();
        try {
            if (!AppPlatform.requestStart(this, this.getParameters())) {
                Platform.exit();
            }
        }
        catch (IOException x) {
            ErrorDialog errorDialog = new ErrorDialog(null);
            errorDialog.setTitle(I18N.getString("alert.title.start"));
            errorDialog.setMessage(I18N.getString("alert.start.failure.message"));
            errorDialog.setDetails(I18N.getString("alert.start.failure.details"));
            errorDialog.setDebugInfoWithThrowable(x);
            errorDialog.showAndWait();
            Platform.exit();
        }
        this.logTimestamp(ACTION.START);
    }

    @Override
    public void handleLaunch(List<String> files) {
        CountDownLatch latch = new CountDownLatch(1);
        this.startupTasksFinished.addListener((observableValue, aBoolean, isFinished) -> {
            if (isFinished.booleanValue()) {
                latch.countDown();
            }
        });
        boolean showWelcomeDialog = files.isEmpty();
        this.setApplicationUncaughtExceptionHandler();
        this.startInBackground("Set up Scene Builder", () -> {
            this.backgroundStart();
            this.setUpUserLibrary(showWelcomeDialog);
            this.createEmptyDocumentWindow();
        });
        if (showWelcomeDialog) {
            WelcomeDialogWindowController.getInstance().getStage().show();
        } else {
            new Thread(() -> {
                if (!this.startupTasksFinished.get()) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "An exception was thrown:", e);
                    }
                }
                Platform.runLater(() -> this.handleOpenFilesAction(files));
            }).start();
        }
    }

    private void startInBackground(String taskName, Runnable task) {
        Thread t = new Thread(() -> {
            task.run();
            this.startupTasks.remove((Object)task);
        }, taskName + " Thread");
        t.setDaemon(true);
        t.start();
        this.startupTasks.add((Object)task);
    }

    private void setUpUserLibrary(boolean showWelcomeDialog) {
        MavenPreferences mavenPreferences = PreferencesController.getSingleton().getMavenPreferences();
        this.userLibrary = new UserLibrary(AppPlatform.getUserLibraryFolder(), () -> mavenPreferences.getArtifactsPathsWithDependencies(), () -> mavenPreferences.getArtifactsFilter());
        this.userLibrary.setOnUpdatedJarReports(jarReports -> {
            boolean shouldShowImportGluonJarAlert = false;
            for (JarReport jarReport : jarReports) {
                if (!jarReport.hasControlsFromExternalPlugin() || SceneBuilderApp.hasGluonJarBeenImported(jarReport.getJar().getFileName().toString())) continue;
                shouldShowImportGluonJarAlert = true;
                break;
            }
            if (shouldShowImportGluonJarAlert) {
                Platform.runLater(() -> {
                    DocumentWindowController dwc = this.findFirstUnusedDocumentWindowController().orElse(this.makeNewWindow());
                    EditorPlatform.showImportAlert(showWelcomeDialog ? WelcomeDialogWindowController.getInstance().getStage() : dwc.getStage());
                });
            }
            SceneBuilderApp.updateImportedGluonJars(jarReports);
        });
        this.userLibrary.explorationCountProperty().addListener((ov, t, t1) -> this.userLibraryExplorationCountDidChange());
        this.userLibrary.startWatching();
        this.sendTrackingStartupInfo();
    }

    private void sendTrackingStartupInfo() {
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
        boolean sendTrackingInfo = this.shouldSendTrackingInfo(recordGlobal);
        if (sendTrackingInfo) {
            boolean update = false;
            String hash = recordGlobal.getRegistrationHash();
            String email = recordGlobal.getRegistrationEmail();
            boolean optIn = recordGlobal.isRegistrationOptIn();
            Tracking.sendTrackingInfo("scenebuilder-usage", hash, email, optIn, update);
        }
    }

    private boolean shouldSendTrackingInfo(PreferencesRecordGlobal recordGlobal) {
        LocalDate date = recordGlobal.getLastSentTrackingInfoDate();
        boolean sendTrackingInfo = true;
        LocalDate now = LocalDate.now();
        if (date != null) {
            sendTrackingInfo = date.plusWeeks(1L).isBefore(now);
            if (sendTrackingInfo) {
                recordGlobal.setLastSentTrackingInfoDate(now);
            }
        } else {
            recordGlobal.setLastSentTrackingInfoDate(now);
        }
        return sendTrackingInfo;
    }

    private void createEmptyDocumentWindow() {
        DocumentWindowController newWindow = this.makeNewWindow();
        newWindow.updateWithDefaultContent();
    }

    @Override
    public void handleOpenFilesAction(List<String> files) {
        this.handleOpenFilesAction(files, () -> {});
    }

    public void handleOpenFilesAction(List<String> files, final Runnable onSuccess) {
        assert (files != null);
        assert (!files.isEmpty());
        final ArrayList<File> fileObjs = new ArrayList<File>();
        for (String file : files) {
            fileObjs.add(new File(file));
        }
        EditorController.updateNextInitialDirectory((File)fileObjs.get(0));
        final Consumer<Map<File, Exception>> onError = errors -> this.showFileOpenErrors((Map<File, Exception>)errors, () -> WelcomeDialogWindowController.getInstance().getStage());
        if (this.userLibrary.isFirstExplorationCompleted()) {
            this.performOpenFiles(fileObjs, onError, onSuccess);
        } else {
            this.userLibrary.firstExplorationCompletedProperty().addListener(new InvalidationListener(){
                final /* synthetic */ SceneBuilderApp this$0;
                {
                    this.this$0 = this$0;
                }

                public void invalidated(Observable observable) {
                    if (this.this$0.userLibrary.isFirstExplorationCompleted()) {
                        this.this$0.userLibrary.firstExplorationCompletedProperty().removeListener((InvalidationListener)this);
                        this.this$0.performOpenFiles(fileObjs, onError, onSuccess);
                    }
                }
            });
        }
    }

    private void showFileOpenErrors(Map<File, Exception> errors, Supplier<Stage> owner) {
        if (errors.isEmpty()) {
            return;
        }
        for (Map.Entry<File, Exception> error : errors.entrySet()) {
            File fxmlFile = error.getKey();
            Exception x = error.getValue();
            ErrorDialog errorDialog = new ErrorDialog((Window)owner.get());
            errorDialog.setMessage(I18N.getString("alert.open.failure1.message", SceneBuilderApp.displayName(fxmlFile.getPath())));
            errorDialog.setDetails(I18N.getString("alert.open.failure1.details"));
            errorDialog.setDebugInfoWithThrowable(x);
            errorDialog.setTitle(I18N.getString("alert.open.failure.title"));
            errorDialog.setDetailsTitle(I18N.getString("alert.open.failure.title") + ": " + fxmlFile.getName());
            errorDialog.showAndWait();
        }
    }

    private Supplier<Stage> getOwnerWindow() {
        return () -> this.findFirstUnusedDocumentWindowController().map(AbstractWindowController::getStage).orElse(WelcomeDialogWindowController.getInstance().getStage());
    }

    @Override
    public void handleMessageBoxFailure(Exception x) {
        ErrorDialog errorDialog = new ErrorDialog(null);
        errorDialog.setTitle(I18N.getString("alert.title.messagebox"));
        errorDialog.setMessage(I18N.getString("alert.messagebox.failure.message"));
        errorDialog.setDetails(I18N.getString("alert.messagebox.failure.details"));
        errorDialog.setDebugInfoWithThrowable(x);
        errorDialog.showAndWait();
    }

    @Override
    public void handleQuitAction() {
        if (this.windowList.isEmpty()) {
            this.logTimestamp(ACTION.STOP);
            Platform.exit();
        }
    }

    public static void main(String[] args) {
        SceneBuilderApp.launch((String[])args);
    }

    public DocumentWindowController makeNewWindow() {
        DocumentWindowController result = new DocumentWindowController();
        if (Platform.isFxApplicationThread()) {
            AppSettings.setWindowIcon(result.getStage());
            this.windowList.add((Object)result);
        } else {
            Platform.runLater(() -> {
                AppSettings.setWindowIcon(result.getStage());
                this.windowList.add((Object)result);
            });
        }
        return result;
    }

    private void closeWindow(DocumentWindowController w) {
        assert (this.windowList.contains((Object)w));
        this.windowList.remove((Object)w);
        w.closeWindow();
    }

    private static String displayName(String pathString) {
        return Paths.get(pathString, new String[0]).getFileName().toString();
    }

    private void performOpenFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"}));
        fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        List fxmlFiles = fileChooser.showOpenMultipleDialog(null);
        if (fxmlFiles != null) {
            assert (!fxmlFiles.isEmpty());
            EditorController.updateNextInitialDirectory((File)fxmlFiles.get(0));
            this.performOpenFiles(fxmlFiles);
        }
    }

    public void performNewTemplate(Template template) {
        DocumentWindowController documentWC = this.findFirstUnusedDocumentWindowController().orElseGet(() -> {
            DocumentWindowController w = this.makeNewWindow();
            w.updateWithDefaultContent();
            return w;
        });
        this.loadTemplateInWindow(template, documentWC);
    }

    private void performNewTemplateInNewWindow(Template template) {
        DocumentWindowController newTemplateWindow = this.makeNewWindow();
        this.loadTemplateInWindow(template, newTemplateWindow);
    }

    private void loadTemplateInWindow(Template template, DocumentWindowController documentWindowController) {
        documentWindowController.loadFromURL(template.getFXMLURL(), template.getType() != Type.PHONE);
        if (template.getType() == Type.PHONE) {
            documentWindowController.getEditorController().performEditAction(EditorController.EditAction.SET_SIZE_335x600);
            documentWindowController.getEditorController().setTheme(GluonEditorPlatform.GLUON_MOBILE_LIGHT);
        }
        documentWindowController.openWindow();
    }

    private void performCloseFrontWindow() {
        for (DocumentWindowController dwc : this.windowList) {
            if (!dwc.isFrontDocumentWindow()) continue;
            dwc.performCloseFrontDocumentWindow();
            break;
        }
    }

    public DocumentWindowController getFrontDocumentWindow() {
        for (DocumentWindowController dwc : this.windowList) {
            if (!dwc.isFrontDocumentWindow()) continue;
            return dwc;
        }
        return null;
    }

    private void performOpenFiles(List<File> fxmlFiles) {
        this.performOpenFiles(fxmlFiles, r -> this.showFileOpenErrors((Map<File, Exception>)r, this.getOwnerWindow()), () -> {});
    }

    private void performOpenFiles(List<File> fxmlFiles, Consumer<Map<File, Exception>> onError, Runnable onSuccess) {
        assert (fxmlFiles != null);
        assert (!fxmlFiles.isEmpty());
        LOGGER.log(Level.FINE, "Opening {0} files...", fxmlFiles.size());
        HashMap<File, Exception> exceptionsPerFile = new HashMap<File, Exception>();
        ArrayList<File> openedFiles = new ArrayList<File>();
        for (File fxmlFile : fxmlFiles) {
            LOGGER.log(Level.FINE, "Attempting to open file {0}", fxmlFile);
            try {
                DocumentWindowController dwc = this.lookupDocumentWindowControllers(fxmlFile.toURI().toURL());
                if (dwc != null) {
                    dwc.getStage().toFront();
                    continue;
                }
                DocumentWindowController hostWindow = this.findFirstUnusedDocumentWindowController().orElse(this.makeNewWindow());
                hostWindow.loadFromFile(fxmlFile);
                hostWindow.openWindow();
                openedFiles.add(fxmlFile);
                LOGGER.log(Level.INFO, "Successfully opened file {0}", fxmlFile);
            }
            catch (Exception xx) {
                LOGGER.log(Level.WARNING, "Failed to open file: %s".formatted(fxmlFile), xx);
                exceptionsPerFile.put(fxmlFile, xx);
            }
        }
        if (!openedFiles.isEmpty()) {
            PreferencesController pc = PreferencesController.getSingleton();
            pc.getRecordGlobal().addRecentItems(openedFiles);
        }
        if (exceptionsPerFile.isEmpty()) {
            LOGGER.log(Level.FINE, "Successfully opened all files.");
            onSuccess.run();
        } else {
            LOGGER.log(Level.WARNING, "Failed to open {0} of {1} files!", new Object[]{exceptionsPerFile.size(), fxmlFiles.size()});
            onError.accept(exceptionsPerFile);
        }
    }

    private void performExit() {
        for (Object dwc : this.windowList) {
            if (!((DocumentWindowController)dwc).getEditorController().isTextEditingSessionOnGoing() || ((DocumentWindowController)dwc).getEditorController().canGetFxmlText()) continue;
            return;
        }
        ArrayList<DocumentWindowController> pendingDocs = new ArrayList<DocumentWindowController>();
        for (DocumentWindowController dwc : this.windowList) {
            if (!dwc.isDocumentDirty()) continue;
            pendingDocs.add(dwc);
        }
        if (switch (pendingDocs.size()) {
            case 0 -> true;
            case 1 -> {
                DocumentWindowController dwc0 = (DocumentWindowController)pendingDocs.get(0);
                yield dwc0.performCloseAction() == DocumentWindowController.ActionStatus.DONE;
            }
            default -> {
                if (!$assertionsDisabled && pendingDocs.size() < 2) {
                    throw new AssertionError();
                }
                AlertDialog d = new AlertDialog(null);
                d.setMessage(I18N.getString("alert.review.question.message", pendingDocs.size()));
                d.setDetails(I18N.getString("alert.review.question.details"));
                d.setOKButtonTitle(I18N.getString("label.review.changes"));
                d.setActionButtonTitle(I18N.getString("label.discard.changes"));
                d.setActionButtonVisible(true);
                switch (d.showAndWait()) {
                    default: {
                        DocumentWindowController.ActionStatus status;
                        int i = 0;
                        while ((status = ((DocumentWindowController)pendingDocs.get(i++)).performCloseAction()) == DocumentWindowController.ActionStatus.DONE && i < pendingDocs.size()) {
                        }
                        yield status == DocumentWindowController.ActionStatus.DONE;
                    }
                    case CANCEL: {
                        yield false;
                    }
                    case ACTION: 
                }
                yield true;
            }
        }) {
            for (DocumentWindowController dwc : new ArrayList<DocumentWindowController>((Collection<DocumentWindowController>)this.windowList)) {
                dwc.updatePreferences();
                this.documentWindowRequestClose(dwc);
            }
            this.logTimestamp(ACTION.STOP);
            Platform.exit();
        }
    }

    private void logTimestamp(ACTION type) {
        Logger.getLogger(this.getClass().getName()).info(I18N.getString(type.logKey));
    }

    private void setApplicationUncaughtExceptionHandler() {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler(new SceneBuilderUncaughtExceptionHandler());
        }
    }

    private void performUseToolTheme(ToolTheme toolTheme) {
        this.toolTheme = toolTheme;
        String toolStylesheet = this.getToolStylesheet();
        for (DocumentWindowController dwc : this.windowList) {
            dwc.setToolStylesheet(toolStylesheet);
        }
    }

    private String getToolStylesheet() {
        return ResourceUtils.getToolStylesheet(this.toolTheme);
    }

    private void backgroundStart() {
        PreferencesController.getSingleton();
        Metadata.getMetadata();
        BuiltinLibrary.getLibrary();
        if (EditorPlatform.IS_MAC) {
            MenuBarController.getSystemMenuBarController();
        }
        EffectPicker.getEffectClasses();
    }

    private void userLibraryExplorationCountDidChange() {
        int numOfFxmlFiles = this.userLibrary.getFxmlFileReports().size();
        int numOfJarFiles = this.userLibrary.getJarReports().size();
        int jarCount = this.userLibrary.getJarReports().size();
        int fxmlCount = this.userLibrary.getFxmlFileReports().size();
        block0 : switch (numOfFxmlFiles + numOfJarFiles) {
            case 0: {
                int previousNumOfJarFiles = this.userLibrary.getPreviousJarReports().size();
                int previousNumOfFxmlFiles = this.userLibrary.getPreviousFxmlFileReports().size();
                if (previousNumOfFxmlFiles <= 0 && previousNumOfJarFiles <= 0) break;
                this.logInfoMessage("log.user.exploration.0");
                break;
            }
            case 1: {
                Path path = numOfFxmlFiles == 1 ? (Path)this.userLibrary.getFxmlFileReports().get(0) : ((JarReport)this.userLibrary.getJarReports().get(0)).getJar();
                this.logInfoMessage("log.user.exploration.1", path.getFileName());
                break;
            }
            default: {
                switch (numOfFxmlFiles) {
                    case 0: {
                        this.logInfoMessage("log.user.jar.exploration.n", jarCount);
                        break block0;
                    }
                    case 1: {
                        Path fxmlName = ((Path)this.userLibrary.getFxmlFileReports().get(0)).getFileName();
                        if (numOfFxmlFiles == numOfJarFiles) {
                            Path jarName = ((JarReport)this.userLibrary.getJarReports().get(0)).getJar().getFileName();
                            this.logInfoMessage("log.user.fxml.jar.exploration.1.1", fxmlName, jarName);
                            break block0;
                        }
                        this.logInfoMessage("log.user.fxml.jar.exploration.1.n", fxmlName, jarCount);
                        break block0;
                    }
                }
                switch (numOfJarFiles) {
                    case 0: {
                        this.logInfoMessage("log.user.fxml.exploration.n", fxmlCount);
                        break block0;
                    }
                    case 1: {
                        Path jarName = ((JarReport)this.userLibrary.getJarReports().get(0)).getJar().getFileName();
                        this.logInfoMessage("log.user.fxml.jar.exploration.n.1", fxmlCount, jarName);
                        break block0;
                    }
                }
                this.logInfoMessage("log.user.fxml.jar.exploration.n.n", fxmlCount, jarCount);
            }
        }
    }

    private void showUpdateDialogIfRequired(DocumentWindowController dwc) {
        AppSettings.getLatestVersion(latestVersion -> {
            if (latestVersion == null) {
                return;
            }
            try {
                boolean showUpdateDialog = true;
                if (AppSettings.getSceneBuilderVersion().contains("SNAPSHOT")) {
                    showUpdateDialog = false;
                } else if (AppSettings.isCurrentVersionLowerThan(latestVersion)) {
                    PreferencesController pc = PreferencesController.getSingleton();
                    PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
                    if (this.isVersionToBeIgnored(recordGlobal, (String)latestVersion)) {
                        showUpdateDialog = false;
                    }
                    if (!this.isUpdateDialogDateReached(recordGlobal)) {
                        showUpdateDialog = false;
                    }
                } else {
                    showUpdateDialog = false;
                }
                if (showUpdateDialog) {
                    String latestVersionText = AppSettings.getLatestVersionText();
                    String latestVersionAnnouncementURL = AppSettings.getLatestVersionAnnouncementURL();
                    Platform.runLater(() -> {
                        UpdateSceneBuilderDialog dialog = new UpdateSceneBuilderDialog((String)latestVersion, latestVersionText, latestVersionAnnouncementURL, (Window)dwc.getStage());
                        dialog.showAndWait();
                    });
                }
            }
            catch (NumberFormatException ex) {
                Platform.runLater(() -> this.showVersionNumberFormatError(dwc));
            }
        });
    }

    private void checkUpdates(DocumentWindowController source) {
        AppSettings.getLatestVersion(latestVersion -> {
            if (latestVersion == null) {
                Platform.runLater(() -> {
                    SBAlert alert = new SBAlert(Alert.AlertType.ERROR, this.getFrontDocumentWindow().getStage());
                    alert.setTitle(I18N.getString("check_for_updates.alert.error.title"));
                    alert.setHeaderText(I18N.getString("check_for_updates.alert.headertext"));
                    alert.setContentText(I18N.getString("check_for_updates.alert.error.message"));
                    alert.showAndWait();
                });
            } else {
                try {
                    if (AppSettings.isCurrentVersionLowerThan(latestVersion)) {
                        String latestVersionText = AppSettings.getLatestVersionText();
                        String latestVersionAnnouncementURL = AppSettings.getLatestVersionAnnouncementURL();
                        Platform.runLater(() -> {
                            UpdateSceneBuilderDialog dialog = new UpdateSceneBuilderDialog((String)latestVersion, latestVersionText, latestVersionAnnouncementURL, (Window)source.getStage());
                            dialog.showAndWait();
                        });
                    } else {
                        SBAlert alert = new SBAlert(Alert.AlertType.INFORMATION, this.getFrontDocumentWindow().getStage());
                        alert.setTitle(I18N.getString("check_for_updates.alert.up_to_date.title"));
                        alert.setHeaderText(I18N.getString("check_for_updates.alert.headertext"));
                        alert.setContentText(I18N.getString("check_for_updates.alert.up_to_date.message"));
                        alert.showAndWait();
                    }
                }
                catch (NumberFormatException ex) {
                    Platform.runLater(() -> this.showVersionNumberFormatError(source));
                }
            }
        });
    }

    private void showVersionNumberFormatError(DocumentWindowController dwc) {
        SBAlert alert = new SBAlert(Alert.AlertType.ERROR, dwc.getStage());
        alert.setTitle("Error");
        alert.setHeaderText(I18N.getString("check_for_updates.alert.headertext"));
        alert.setContentText("Update check is disabled in development environment.");
        alert.showAndWait();
    }

    private boolean isVersionToBeIgnored(PreferencesRecordGlobal recordGlobal, String latestVersion) {
        String ignoreVersion = recordGlobal.getIgnoreVersion();
        return latestVersion.equals(ignoreVersion);
    }

    private boolean isUpdateDialogDateReached(PreferencesRecordGlobal recordGlobal) {
        LocalDate dialogDate = recordGlobal.getShowUpdateDialogDate();
        if (dialogDate == null) {
            return true;
        }
        return dialogDate.isBefore(LocalDate.now());
    }

    private void logInfoMessage(String key) {
        for (DocumentWindowController dwc : this.windowList) {
            dwc.getEditorController().getMessageLog().logInfoMessage(key, I18N.getBundle(), new Object[0]);
        }
    }

    private void logInfoMessage(String key, Object ... args) {
        for (DocumentWindowController dwc : this.windowList) {
            dwc.getEditorController().getMessageLog().logInfoMessage(key, I18N.getBundle(), args);
        }
    }

    private static void updateImportedGluonJars(List<JarReport> jars) {
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
        ArrayList<String> jarReportCollection = new ArrayList<String>();
        for (JarReport jarReport : jars) {
            if (!jarReport.hasControlsFromExternalPlugin()) continue;
            jarReportCollection.add(jarReport.getJar().getFileName().toString());
        }
        if (jarReportCollection.isEmpty()) {
            recordGlobal.setImportedGluonJars(new String[0]);
        } else {
            recordGlobal.setImportedGluonJars(jarReportCollection.toArray(new String[0]));
        }
    }

    private static boolean hasGluonJarBeenImported(String jar) {
        PreferencesController pc = PreferencesController.getSingleton();
        String[] importedJars = pc.getRecordGlobal().getImportedGluonJars();
        if (importedJars == null) {
            return false;
        }
        for (String importedJar : importedJars) {
            if (!jar.equals(importedJar)) continue;
            return true;
        }
        return false;
    }

    public static void applyToAllDocumentWindows(Consumer<DocumentWindowController> consumer) {
        for (DocumentWindowController dwc : SceneBuilderApp.getSingleton().getDocumentWindowControllers()) {
            consumer.accept(dwc);
        }
    }

    static {
        try {
            LogManager.getLogManager().readConfiguration(SceneBuilderApp.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialise log manager", e);
        }
    }

    public static enum ApplicationControlAction {
        ABOUT,
        CHECK_UPDATES,
        REGISTER,
        NEW_FILE,
        NEW_TEMPLATE,
        OPEN_FILE,
        CLOSE_FRONT_WINDOW,
        USE_DEFAULT_THEME,
        USE_DARK_THEME,
        SHOW_PREFERENCES,
        EXIT,
        SHOW_WELCOME;

    }

    private static enum ACTION {
        START("log.start"),
        STOP("log.stop");

        private final String logKey;

        private ACTION(String logKey) {
            this.logKey = logKey;
        }
    }

    private static class SceneBuilderUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private SceneBuilderUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "An exception was thrown:", e);
        }
    }
}

