/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;

public class SplitController {
    private final SplitPane splitPane;
    private final Target target;
    private final Node targetNode;
    private double dividerPosition = -1.0;

    public SplitController(SplitPane splitPane, Target target) {
        assert (splitPane != null);
        assert (splitPane.getItems().size() >= 1);
        this.splitPane = splitPane;
        this.target = target;
        ObservableList children = splitPane.getItems();
        int targetIndex = target == Target.FIRST ? 0 : children.size() - 1;
        this.targetNode = (Node)children.get(targetIndex);
    }

    public DoubleProperty position() {
        SplitPane.Divider divider = this.getTargetDivider();
        return divider == null ? null : divider.positionProperty();
    }

    public double getPosition() {
        SplitPane.Divider divider = this.getTargetDivider();
        return divider == null ? -1.0 : divider.getPosition();
    }

    public void setPosition(double value) {
        SplitPane.Divider divider = this.getTargetDivider();
        if (divider != null) {
            divider.setPosition(value);
        }
        this.dividerPosition = value;
    }

    public void showTarget() {
        if (!this.isTargetVisible()) {
            if (this.target == Target.FIRST) {
                this.splitPane.getItems().add(0, (Object)this.targetNode);
            } else {
                this.splitPane.getItems().add((Object)this.targetNode);
            }
            ObservableList dividers = this.splitPane.getDividers();
            if (!dividers.isEmpty() && this.dividerPosition != -1.0) {
                SplitPane.Divider divider = this.getTargetDivider();
                assert (divider != null);
                divider.setPosition(this.dividerPosition);
            }
        }
    }

    public void hideTarget() {
        if (this.isTargetVisible()) {
            ObservableList dividers = this.splitPane.getDividers();
            List<Double> positionsList = SplitController.asList(this.splitPane.getDividerPositions());
            SplitPane.Divider targetDivider = this.getTargetDivider();
            if (targetDivider != null) {
                this.dividerPosition = targetDivider.getPosition();
                int targetDividerIndex = this.target == Target.FIRST ? 0 : dividers.size() - 1;
                positionsList.remove(targetDividerIndex);
            }
            this.splitPane.getItems().remove((Object)this.targetNode);
            if (!positionsList.isEmpty()) {
                double[] positionsArray = SplitController.toArray(positionsList);
                this.splitPane.setDividerPositions(positionsArray);
            }
        }
    }

    public void toggleTarget() {
        if (this.isTargetVisible()) {
            this.hideTarget();
        } else {
            this.showTarget();
        }
    }

    public void setTargetVisible(boolean visible) {
        if (visible) {
            this.showTarget();
        } else {
            this.hideTarget();
        }
    }

    public boolean isTargetVisible() {
        return this.splitPane.getItems().contains((Object)this.targetNode);
    }

    private SplitPane.Divider getTargetDivider() {
        ObservableList dividers = this.splitPane.getDividers();
        SplitPane.Divider divider = !dividers.isEmpty() ? (this.target == Target.FIRST ? (SplitPane.Divider)dividers.get(0) : (SplitPane.Divider)dividers.get(dividers.size() - 1)) : null;
        return divider;
    }

    private static List<Double> asList(double[] array) {
        ArrayList<Double> list = new ArrayList<Double>(array.length);
        for (double d : array) {
            list.add(d);
        }
        return list;
    }

    private static double[] toArray(List<Double> list) {
        double[] array = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static enum Target {
        FIRST,
        LAST;

    }
}

