/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.app.util.AppSettings;
import java.time.LocalDate;
import javafx.application.HostServices;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class UpdateSceneBuilderDialog
extends Dialog {
    public UpdateSceneBuilderDialog(String latestVersion, String latestVersionTextString, String announcementURL, Window owner) {
        this.initOwner(owner);
        this.setTitle(I18N.getString("download.scene.builder.title"));
        Label header = new Label(I18N.getString("download.scene.builder.header.label"));
        Label currentVersionTextLabel = new Label(I18N.getString("download.scene.builder.current.version.label"));
        Label latestVersionTextLabel = new Label(I18N.getString("download.scene.builder.last.version.number.label"));
        Label currentVersionLabel = new Label(AppSettings.getSceneBuilderVersion());
        Label latestVersionLabel = new Label(latestVersion);
        GridPane gridPane = new GridPane();
        gridPane.add((Node)currentVersionTextLabel, 0, 0);
        gridPane.add((Node)currentVersionLabel, 1, 0);
        gridPane.add((Node)latestVersionTextLabel, 0, 1);
        gridPane.add((Node)latestVersionLabel, 1, 1);
        Label latestVersionText = new Label(latestVersionTextString);
        VBox contentContainer = new VBox();
        contentContainer.getChildren().addAll((Object[])new Node[]{header, gridPane});
        BorderPane mainContainer = new BorderPane();
        mainContainer.setCenter((Node)contentContainer);
        ImageView imageView = new ImageView(UpdateSceneBuilderDialog.class.getResource("computerDownload.png").toExternalForm());
        mainContainer.setRight((Node)imageView);
        mainContainer.setBottom((Node)latestVersionText);
        this.getDialogPane().setContent((Node)mainContainer);
        mainContainer.getStyleClass().add((Object)"main-container");
        contentContainer.getStyleClass().add((Object)"content-container");
        this.getDialogPane().getStyleClass().add((Object)"download_scenebuilder-dialog");
        header.getStyleClass().add((Object)"header");
        latestVersionText.getStyleClass().add((Object)"latest-version-text");
        ButtonType downloadButton = new ButtonType(I18N.getString("download.scene.builder.download.label"), ButtonBar.ButtonData.OK_DONE);
        ButtonType ignoreThisUpdate = new ButtonType(I18N.getString("download.scene.builder.ignore.label"));
        ButtonType remindLater = new ButtonType(I18N.getString("download.scene.builder.remind.later.label"), ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType learnMore = new ButtonType(I18N.getString("download.scene.builder.learn.mode.label"));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{learnMore, downloadButton, ignoreThisUpdate, remindLater});
        this.getDialogPane().getStylesheets().add((Object)SceneBuilderApp.class.getResource("css/UpdateSceneBuilderDialog.css").toString());
        this.resultProperty().addListener((observable, oldValue, newValue) -> {
            HostServices hostServices = SceneBuilderApp.getSingleton().getHostServices();
            if (newValue == downloadButton) {
                hostServices.showDocument("https://gluonhq.com/products/scene-builder/");
            } else if (newValue == remindLater) {
                LocalDate now = LocalDate.now();
                LocalDate futureDate = now.plusWeeks(1L);
                PreferencesController pc = PreferencesController.getSingleton();
                PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
                recordGlobal.setShowUpdateDialogAfter(futureDate);
            } else if (newValue == ignoreThisUpdate) {
                PreferencesController pc = PreferencesController.getSingleton();
                PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
                recordGlobal.setIgnoreVersion(latestVersion);
            } else if (newValue == learnMore) {
                hostServices.showDocument(announcementURL);
            }
        });
        AppSettings.setWindowIcon((Stage)this.getDialogPane().getScene().getWindow());
    }
}

