/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.about;

import com.oracle.javafx.scenebuilder.app.AppPlatform;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.util.AppSettings;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Properties;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.WindowEvent;

public final class AboutWindowController
extends AbstractFxmlWindowController {
    @FXML
    private GridPane vbox;
    @FXML
    private TextArea textArea;
    private String sbBuildInfo;
    private String sbBuildVersion;
    private String sbBuildDate;
    private String sbBuildDateFormat;
    private String sbBuildJavaVersion;
    private String sbBuildJavaFXVersion;
    private String sbAboutCopyrightKeyName;
    private final String LOG_FILE_NAME = "scenebuilder-" + AppSettings.getSceneBuilderVersion() + ".log";

    public AboutWindowController() {
        super(AboutWindowController.class.getResource("About.fxml"), I18N.getBundle());
        try (InputStream in = this.getClass().getResourceAsStream("about.properties");){
            if (in != null) {
                Properties sbProps = new Properties();
                sbProps.load(in);
                this.sbBuildInfo = sbProps.getProperty("build.info", "UNSET");
                this.sbBuildVersion = sbProps.getProperty("build.version", "UNSET");
                this.sbBuildDate = sbProps.getProperty("build.date", "UNSET");
                this.sbBuildDateFormat = sbProps.getProperty("build.date.format", "UNSET");
                this.sbBuildJavaVersion = sbProps.getProperty("build.java.version", "UNSET");
                this.sbBuildJavaFXVersion = sbProps.getProperty("build.javafx.version", "UNSET");
                this.sbAboutCopyrightKeyName = sbProps.getProperty("copyright.key.name", "UNSET");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @FXML
    public void onMousePressed(MouseEvent event) {
        if (event.getClickCount() == 2 && event.isAltDown()) {
            SceneBuilderApp.getSingleton().toggleDebugMenu();
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.closeWindow();
    }

    @Override
    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
        this.getStage().setTitle(I18N.getString("about.title"));
        this.getStage().initModality(Modality.APPLICATION_MODAL);
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        assert (this.vbox != null);
        assert (this.textArea != null);
        this.textArea.setText(this.getAboutText());
    }

    private String getAboutText() {
        LocalDateTime buildDate = LocalDateTime.parse(this.sbBuildDate, DateTimeFormatter.ofPattern(this.sbBuildDateFormat));
        StringBuilder text = this.getVersionParagraph().append((CharSequence)this.getBuildInfoParagraph()).append((CharSequence)this.getLoggingParagraph()).append((CharSequence)this.getJavaFXParagraph()).append((CharSequence)this.getJavaParagraph()).append((CharSequence)this.getJavaLibraryPathParagraph()).append((CharSequence)this.getOsParagraph()).append((CharSequence)this.getApplicationDirectoriesParagraph()).append(I18N.getString(this.sbAboutCopyrightKeyName, String.valueOf(buildDate.getYear())));
        return text.toString();
    }

    private StringBuilder getApplicationDirectoriesParagraph() {
        return new StringBuilder(I18N.getString("about.app.data.directory")).append("\n\t").append(Paths.get(AppPlatform.getApplicationDataFolder(), new String[0]).normalize()).append("\n\n").append(I18N.getString("about.app.user.library")).append("\n\t").append(Paths.get(AppPlatform.getUserLibraryFolder(), new String[0]).normalize()).append("\n\n").append(I18N.getString("about.app.program.directory")).append("\n\t").append(Paths.get(".", new String[0]).toAbsolutePath().normalize()).append("\n\n");
    }

    public String getBuildJavaVersion() {
        return this.sbBuildJavaVersion;
    }

    public String getBuildInfo() {
        return this.sbBuildInfo;
    }

    private StringBuilder getVersionParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.product.version"));
        sb.append("\nJavaFX Scene Builder ").append(this.sbBuildVersion).append("\n\n");
        return sb;
    }

    private String getLogFilePath() {
        StringBuilder sb = new StringBuilder(AppPlatform.getLogFolder());
        if (sb.charAt(sb.length() - 1) != File.separatorChar) {
            sb.append(File.separatorChar);
        }
        sb.append(this.LOG_FILE_NAME);
        return sb.toString();
    }

    private StringBuilder getBuildInfoParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.build.information"));
        sb.append("\n").append(this.sbBuildInfo).append("\n").append(I18N.getString("about.build.date", this.sbBuildDate)).append("\n").append(I18N.getString("about.build.javafx.version", this.sbBuildJavaFXVersion)).append("\n").append(I18N.getString("about.build.java.version", this.sbBuildJavaVersion)).append("\n\n");
        return sb;
    }

    private StringBuilder getLoggingParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.logging.title"));
        sb.append("\n").append(I18N.getString("about.logging.body.first", this.LOG_FILE_NAME)).append("\n").append(I18N.getString("about.logging.body.second", this.getLogFilePath())).append("\n\n");
        return sb;
    }

    private StringBuilder getJavaFXParagraph() {
        StringBuilder sb = new StringBuilder("JavaFX\n");
        sb.append(System.getProperty("javafx.version")).append("\n\n");
        return sb;
    }

    private StringBuilder getJavaParagraph() {
        StringBuilder sb = new StringBuilder("Java\n");
        sb.append(System.getProperty("java.version")).append(", ").append(System.getProperty("java.runtime.name")).append("\n\n");
        return sb;
    }

    private StringBuilder getJavaLibraryPathParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.java.library.paths")).append("\n");
        String libPaths = System.getProperty("java.library.path");
        ArrayList<String> invalidPaths = new ArrayList<String>();
        String separator = this.getPathSeparator();
        for (String libPath : libPaths.split(separator)) {
            try {
                Path absolutePath = Paths.get(libPath, new String[0]).normalize().toAbsolutePath();
                if (Files.exists(absolutePath, new LinkOption[0])) {
                    String path = absolutePath.toString();
                    sb.append("\t").append(path).append("\n");
                    continue;
                }
                invalidPaths.add(libPath);
            }
            catch (InvalidPathException error) {
                invalidPaths.add(libPath);
            }
        }
        sb.append("\n");
        if (!invalidPaths.isEmpty()) {
            sb.append(I18N.getString("about.java.library.paths.invalids"));
            sb.append("\n");
            invalidPaths.forEach(invalidPath -> sb.append("\t").append((String)invalidPath).append("\n"));
            sb.append("\n");
        }
        return sb;
    }

    private String getPathSeparator() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return ";";
        }
        return ":";
    }

    private StringBuilder getOsParagraph() {
        StringBuilder sb = new StringBuilder(I18N.getString("about.operating.system"));
        sb.append("\n").append(System.getProperty("os.name")).append(", ").append(System.getProperty("os.arch")).append(", ").append(System.getProperty("os.version")).append("\n\n");
        return sb;
    }
}

