/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.menubar;

import com.gluonhq.scenebuilder.plugins.editor.GluonEditorController;
import com.gluonhq.scenebuilder.plugins.editor.GluonEditorPlatform;
import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.menubar.DebugMenuController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinSectionComparator;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItemNameComparator;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPicker;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;

public class MenuBarController {
    private static MenuBarController systemMenuBarController;
    private Menu insertCustomMenu;
    private final DocumentWindowController documentWindowController;
    private DebugMenuController debugMenuController;
    @FXML
    private MenuBar menuBar;
    @FXML
    private Menu insertMenu;
    @FXML
    private Menu addEffectMenu;
    @FXML
    private Menu fileMenu;
    @FXML
    private Menu previewMenu;
    @FXML
    private Menu windowMenu;
    @FXML
    private MenuItem newMenuItem;
    @FXML
    private MenuItem newTemplateMenuItem;
    @FXML
    private MenuItem openMenuItem;
    @FXML
    private Menu openRecentMenu;
    @FXML
    private MenuItem saveMenuItem;
    @FXML
    private MenuItem saveAsMenuItem;
    @FXML
    private MenuItem revertMenuItem;
    @FXML
    private MenuItem closeMenuItem;
    @FXML
    private MenuItem revealMenuItem;
    @FXML
    private MenuItem importFxmlMenuItem;
    @FXML
    private MenuItem importMediaMenuItem;
    @FXML
    private MenuItem includeFileMenuItem;
    @FXML
    private MenuItem editIncludedFileMenuItem;
    @FXML
    private MenuItem revealIncludedFileMenuItem;
    @FXML
    private MenuItem showPreferencesMenuItem;
    @FXML
    private MenuItem exitMenuItem;
    @FXML
    private MenuItem undoMenuItem;
    @FXML
    private MenuItem redoMenuItem;
    @FXML
    private MenuItem copyMenuItem;
    @FXML
    private MenuItem cutMenuItem;
    @FXML
    private MenuItem pasteMenuItem;
    @FXML
    private MenuItem pasteIntoMenuItem;
    @FXML
    private MenuItem duplicateMenuItem;
    @FXML
    private MenuItem deleteMenuItem;
    @FXML
    private MenuItem selectAllMenuItem;
    @FXML
    private MenuItem selectNoneMenuItem;
    @FXML
    private MenuItem selectParentMenuItem;
    @FXML
    private MenuItem selectNextMenuItem;
    @FXML
    private MenuItem selectPreviousMenuItem;
    @FXML
    private MenuItem trimMenuItem;
    @FXML
    private MenuItem gotoContentMenuItem;
    @FXML
    private MenuItem gotoPropertiesMenuItem;
    @FXML
    private MenuItem gotoLayoutMenuItem;
    @FXML
    private MenuItem gotoCodeMenuItem;
    @FXML
    private MenuItem toggleLibraryPanelMenuItem;
    @FXML
    private MenuItem toggleHierarchyPanelMenuItem;
    @FXML
    private MenuItem toggleCSSPanelMenuItem;
    @FXML
    private MenuItem toggleLeftPanelMenuItem;
    @FXML
    private MenuItem toggleRightPanelMenuItem;
    @FXML
    private MenuItem toggleOutlinesMenuItem;
    @FXML
    private MenuItem toggleSampleDataMenuItem;
    @FXML
    private MenuItem toggleAlignmentGuidesMenuItem;
    @FXML
    private MenuItem showSampleControllerMenuItem;
    @FXML
    private Menu zoomMenu;
    @FXML
    private MenuItem fitToParentMenuItem;
    @FXML
    private MenuItem useComputedSizesMenuItem;
    @FXML
    private MenuItem addContextMenuMenuItem;
    @FXML
    private MenuItem addTooltipMenuItem;
    @FXML
    private MenuItem moveRowAboveMenuItem;
    @FXML
    private MenuItem moveRowBelowMenuItem;
    @FXML
    private MenuItem moveColumnBeforeMenuItem;
    @FXML
    private MenuItem moveColumnAfterMenuItem;
    @FXML
    private MenuItem addRowAboveMenuItem;
    @FXML
    private MenuItem addRowBelowMenuItem;
    @FXML
    private MenuItem addColumnBeforeMenuItem;
    @FXML
    private MenuItem addColumnAfterMenuItem;
    @FXML
    private MenuItem increaseRowSpanMenuItem;
    @FXML
    private MenuItem decreaseRowSpanMenuItem;
    @FXML
    private MenuItem increaseColumnSpanMenuItem;
    @FXML
    private MenuItem decreaseColumnSpanMenuItem;
    @FXML
    private MenuItem phoneSetSizeMenuItem;
    @FXML
    private MenuItem tabletSetSizeMenuItem;
    @FXML
    private RadioMenuItem qvgaSetSizeMenuItem;
    @FXML
    private RadioMenuItem vgaSetSizeMenuItem;
    @FXML
    private RadioMenuItem touchSetSizeMenuItem;
    @FXML
    private RadioMenuItem hdSetSizeMenuItem;
    @FXML
    private MenuItem bringToFrontMenuItem;
    @FXML
    private MenuItem sendToBackMenuItem;
    @FXML
    private MenuItem bringForwardMenuItem;
    @FXML
    private MenuItem sendBackwardMenuItem;
    @FXML
    private MenuItem wrapInAnchorPaneMenuItem;
    @FXML
    private MenuItem wrapInBorderPaneMenuItem;
    @FXML
    private MenuItem wrapInButtonBarMenuItem;
    @FXML
    private MenuItem wrapInDialogPaneMenuItem;
    @FXML
    private MenuItem wrapInFlowPaneMenuItem;
    @FXML
    private MenuItem wrapInGridPaneMenuItem;
    @FXML
    private MenuItem wrapInHBoxMenuItem;
    @FXML
    private MenuItem wrapInPaneMenuItem;
    @FXML
    private MenuItem wrapInScrollPaneMenuItem;
    @FXML
    private MenuItem wrapInSplitPaneMenuItem;
    @FXML
    private MenuItem wrapInStackPaneMenuItem;
    @FXML
    private MenuItem wrapInTabPaneMenuItem;
    @FXML
    private MenuItem wrapInTextFlowMenuItem;
    @FXML
    private MenuItem wrapInTilePaneMenuItem;
    @FXML
    private MenuItem wrapInTitledPaneMenuItem;
    @FXML
    private MenuItem wrapInToolBarMenuItem;
    @FXML
    private MenuItem wrapInVBoxMenuItem;
    @FXML
    private MenuItem wrapInGroupMenuItem;
    @FXML
    private MenuItem wrapInSceneMenuItem;
    @FXML
    private MenuItem wrapInStageMenuItem;
    @FXML
    private MenuItem unwrapMenuItem;
    @FXML
    private MenuItem showPreviewInWindowMenuItem;
    @FXML
    private MenuItem showPreviewInDialogMenuItem;
    @FXML
    private RadioMenuItem gluonMobileLightThemeMenuItem;
    @FXML
    private RadioMenuItem gluonMobileDarkThemeMenuItem;
    @FXML
    private RadioMenuItem modenaThemeMenuItem;
    @FXML
    private RadioMenuItem modenaTouchThemeMenuItem;
    @FXML
    private RadioMenuItem modenaHighContrastBlackonwhiteThemeMenuItem;
    @FXML
    private RadioMenuItem modenaHighContrastWhiteonblackThemeMenuItem;
    @FXML
    private RadioMenuItem modenaHighContrastYellowonblackThemeMenuItem;
    @FXML
    private RadioMenuItem caspianThemeMenuItem;
    @FXML
    private CheckMenuItem caspianHighContrastThemeMenuItem;
    @FXML
    private RadioMenuItem caspianEmbeddedThemeMenuItem;
    @FXML
    private RadioMenuItem caspianEmbeddedQVGAThemeMenuItem;
    @FXML
    private MenuItem addSceneStyleSheetMenuItem;
    @FXML
    private Menu removeSceneStyleSheetMenu;
    @FXML
    private Menu openSceneStyleSheetMenu;
    @FXML
    private MenuItem setResourceMenuItem;
    @FXML
    private MenuItem removeResourceMenuItem;
    @FXML
    private MenuItem revealResourceMenuItem;
    @FXML
    private RadioMenuItem phonePreviewSizeMenuItem;
    @FXML
    private RadioMenuItem tabletPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem qvgaPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem vgaPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem touchPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem hdPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem preferredPreviewSizeMenuItem;
    @FXML
    private RadioMenuItem blueSwatch;
    @FXML
    private RadioMenuItem cyanSwatch;
    @FXML
    private RadioMenuItem deepOrangeSwatch;
    @FXML
    private RadioMenuItem deepPurpleSwatch;
    @FXML
    private RadioMenuItem greenSwatch;
    @FXML
    private RadioMenuItem indigoSwatch;
    @FXML
    private RadioMenuItem lightBlueSwatch;
    @FXML
    private RadioMenuItem pinkSwatch;
    @FXML
    private RadioMenuItem purpleSwatch;
    @FXML
    private RadioMenuItem redSwatch;
    @FXML
    private RadioMenuItem tealSwatch;
    @FXML
    private RadioMenuItem lightGreenSwatch;
    @FXML
    private RadioMenuItem limeSwatch;
    @FXML
    private RadioMenuItem yellowSwatch;
    @FXML
    private RadioMenuItem amberSwatch;
    @FXML
    private RadioMenuItem orangeSwatch;
    @FXML
    private RadioMenuItem brownSwatch;
    @FXML
    private RadioMenuItem greySwatch;
    @FXML
    private RadioMenuItem blueGreySwatch;
    @FXML
    private MenuItem helpMenuItem;
    @FXML
    private MenuItem showWelcomeItem;
    @FXML
    private MenuItem aboutMenuItem;
    @FXML
    private MenuItem checkUpdatesMenuItem;
    @FXML
    private MenuItem registerMenuItem;
    @FXML
    private MenuItem sceneBuilderHomeMenuItem;
    @FXML
    private MenuItem gettingStartedMenuItem;
    @FXML
    private MenuItem apiDocMenuItem;
    @FXML
    private MenuItem cssReferenceGuideMenuItem;
    @FXML
    private MenuItem fxmlIntroductionMenuItem;
    @FXML
    private MenuItem communityContributeMenuItem;
    @FXML
    private MenuItem jfxCentralMenuItem;
    private static final KeyCombination.Modifier modifier;
    private final Map<KeyCombination, MenuItem> keyToMenu = new HashMap<KeyCombination, MenuItem>();
    private DocumentControlActionController previewController;
    private final EventHandler<Event> onMenuValidationEventHandler = t -> {
        assert (t.getSource() instanceof Menu);
        this.handleOnMenuValidation((Menu)t.getSource());
    };
    private final EventHandler<ActionEvent> onActionEventHandler = t -> {
        assert (t.getSource() instanceof MenuItem);
        this.handleOnActionMenu((MenuItem)t.getSource());
    };
    static final double[] scalingTable;
    private final EventHandler<Event> onCustomPartOfInsertMenuValidationHandler = t -> {
        assert (t.getSource() == this.insertMenu);
        this.updateCustomPartOfInsertMenu();
    };
    private final EventHandler<Event> onWindowMenuValidationHandler = t -> {
        assert (t.getSource() == this.windowMenu);
        this.handleOnWindowMenuValidation();
    };

    public MenuBarController(DocumentWindowController documentWindowController) {
        this.documentWindowController = documentWindowController;
    }

    public void showPreview() {
        if (this.previewController != null && this.previewController.canPerform()) {
            this.previewController.perform();
        }
    }

    public MenuBar getMenuBar() {
        if (this.menuBar == null) {
            URL fxmlURL = MenuBarController.class.getResource("MenuBar.fxml");
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setLocation(fxmlURL);
            loader.setResources(I18N.getBundle());
            try {
                loader.load();
                this.controllerDidLoadFxml();
            }
            catch (IOException | RuntimeException x) {
                String logMessage = "Failed to load MenuBar.fxml:\nloader.getController()=" + String.valueOf(loader.getController()) + "\nloader.getLocation()=" + String.valueOf(loader.getLocation()) + ":";
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, logMessage, x);
                throw new RuntimeException("Failed to load " + fxmlURL.getFile(), x);
            }
        }
        return this.menuBar;
    }

    public void setDebugMenuVisible(boolean visible) {
        if (this.isDebugMenuVisible() != visible) {
            if (visible) {
                if (this.debugMenuController == null) {
                    this.debugMenuController = new DebugMenuController(this.documentWindowController);
                }
                this.menuBar.getMenus().add((Object)this.debugMenuController.getMenu());
            } else {
                this.menuBar.getMenus().remove((Object)this.debugMenuController.getMenu());
            }
        }
    }

    public boolean isDebugMenuVisible() {
        boolean result = this.debugMenuController == null ? false : this.menuBar.getMenus().contains((Object)this.debugMenuController.getMenu());
        return result;
    }

    public static synchronized MenuBarController getSystemMenuBarController() {
        if (systemMenuBarController == null) {
            systemMenuBarController = new MenuBarController(null);
        }
        return systemMenuBarController;
    }

    private void controllerDidLoadFxml() {
        String revealMenuKey;
        assert (this.menuBar != null);
        assert (this.menuBar.getParent() instanceof StackPane);
        assert (this.insertMenu != null);
        assert (this.addEffectMenu != null);
        assert (this.fileMenu != null);
        assert (this.windowMenu != null);
        assert (this.newMenuItem != null);
        assert (this.newTemplateMenuItem != null);
        assert (this.openMenuItem != null);
        assert (this.openRecentMenu != null);
        assert (this.saveMenuItem != null);
        assert (this.saveAsMenuItem != null);
        assert (this.revertMenuItem != null);
        assert (this.closeMenuItem != null);
        assert (this.revealMenuItem != null);
        assert (this.importFxmlMenuItem != null);
        assert (this.importMediaMenuItem != null);
        assert (this.includeFileMenuItem != null);
        assert (this.editIncludedFileMenuItem != null);
        assert (this.revealIncludedFileMenuItem != null);
        assert (this.showPreferencesMenuItem != null);
        assert (this.exitMenuItem != null);
        assert (this.undoMenuItem != null);
        assert (this.redoMenuItem != null);
        assert (this.copyMenuItem != null);
        assert (this.cutMenuItem != null);
        assert (this.pasteMenuItem != null);
        assert (this.pasteIntoMenuItem != null);
        assert (this.duplicateMenuItem != null);
        assert (this.deleteMenuItem != null);
        assert (this.selectAllMenuItem != null);
        assert (this.selectNoneMenuItem != null);
        assert (this.selectParentMenuItem != null);
        assert (this.selectNextMenuItem != null);
        assert (this.selectPreviousMenuItem != null);
        assert (this.trimMenuItem != null);
        assert (this.gotoContentMenuItem != null);
        assert (this.gotoPropertiesMenuItem != null);
        assert (this.gotoLayoutMenuItem != null);
        assert (this.gotoCodeMenuItem != null);
        assert (this.toggleLibraryPanelMenuItem != null);
        assert (this.toggleHierarchyPanelMenuItem != null);
        assert (this.toggleCSSPanelMenuItem != null);
        assert (this.toggleLeftPanelMenuItem != null);
        assert (this.toggleRightPanelMenuItem != null);
        assert (this.toggleOutlinesMenuItem != null);
        assert (this.toggleSampleDataMenuItem != null);
        assert (this.toggleAlignmentGuidesMenuItem != null);
        assert (this.showSampleControllerMenuItem != null);
        assert (this.zoomMenu != null);
        assert (this.zoomMenu.getItems().isEmpty());
        assert (this.fitToParentMenuItem != null);
        assert (this.useComputedSizesMenuItem != null);
        assert (this.addContextMenuMenuItem != null);
        assert (this.addTooltipMenuItem != null);
        assert (this.moveRowAboveMenuItem != null);
        assert (this.moveRowBelowMenuItem != null);
        assert (this.moveColumnBeforeMenuItem != null);
        assert (this.moveColumnAfterMenuItem != null);
        assert (this.addRowAboveMenuItem != null);
        assert (this.addRowBelowMenuItem != null);
        assert (this.addColumnBeforeMenuItem != null);
        assert (this.addColumnAfterMenuItem != null);
        assert (this.increaseRowSpanMenuItem != null);
        assert (this.decreaseRowSpanMenuItem != null);
        assert (this.increaseColumnSpanMenuItem != null);
        assert (this.decreaseColumnSpanMenuItem != null);
        assert (this.phoneSetSizeMenuItem != null);
        assert (this.tabletSetSizeMenuItem != null);
        assert (this.qvgaSetSizeMenuItem != null);
        assert (this.vgaSetSizeMenuItem != null);
        assert (this.touchSetSizeMenuItem != null);
        assert (this.hdSetSizeMenuItem != null);
        assert (this.bringToFrontMenuItem != null);
        assert (this.sendToBackMenuItem != null);
        assert (this.bringForwardMenuItem != null);
        assert (this.sendBackwardMenuItem != null);
        assert (this.wrapInAnchorPaneMenuItem != null);
        assert (this.wrapInBorderPaneMenuItem != null);
        assert (this.wrapInButtonBarMenuItem != null);
        assert (this.wrapInDialogPaneMenuItem != null);
        assert (this.wrapInFlowPaneMenuItem != null);
        assert (this.wrapInGridPaneMenuItem != null);
        assert (this.wrapInHBoxMenuItem != null);
        assert (this.wrapInPaneMenuItem != null);
        assert (this.wrapInScrollPaneMenuItem != null);
        assert (this.wrapInSplitPaneMenuItem != null);
        assert (this.wrapInStackPaneMenuItem != null);
        assert (this.wrapInTabPaneMenuItem != null);
        assert (this.wrapInTextFlowMenuItem != null);
        assert (this.wrapInTilePaneMenuItem != null);
        assert (this.wrapInTitledPaneMenuItem != null);
        assert (this.wrapInToolBarMenuItem != null);
        assert (this.wrapInVBoxMenuItem != null);
        assert (this.wrapInGroupMenuItem != null);
        assert (this.wrapInSceneMenuItem != null);
        assert (this.wrapInStageMenuItem != null);
        assert (this.unwrapMenuItem != null);
        assert (this.showPreviewInWindowMenuItem != null);
        assert (this.showPreviewInDialogMenuItem != null);
        assert (this.gluonMobileLightThemeMenuItem != null);
        assert (this.gluonMobileDarkThemeMenuItem != null);
        assert (this.modenaThemeMenuItem != null);
        assert (this.modenaTouchThemeMenuItem != null);
        assert (this.modenaHighContrastBlackonwhiteThemeMenuItem != null);
        assert (this.modenaHighContrastWhiteonblackThemeMenuItem != null);
        assert (this.modenaHighContrastYellowonblackThemeMenuItem != null);
        assert (this.caspianThemeMenuItem != null);
        assert (this.caspianHighContrastThemeMenuItem != null);
        assert (this.caspianEmbeddedThemeMenuItem != null);
        assert (this.caspianEmbeddedQVGAThemeMenuItem != null);
        assert (this.addSceneStyleSheetMenuItem != null);
        assert (this.removeSceneStyleSheetMenu != null);
        assert (this.openSceneStyleSheetMenu != null);
        assert (this.setResourceMenuItem != null);
        assert (this.removeResourceMenuItem != null);
        assert (this.revealResourceMenuItem != null);
        assert (this.phonePreviewSizeMenuItem != null);
        assert (this.tabletPreviewSizeMenuItem != null);
        assert (this.qvgaPreviewSizeMenuItem != null);
        assert (this.vgaPreviewSizeMenuItem != null);
        assert (this.touchPreviewSizeMenuItem != null);
        assert (this.hdPreviewSizeMenuItem != null);
        assert (this.preferredPreviewSizeMenuItem != null);
        assert (this.helpMenuItem != null);
        assert (this.showWelcomeItem != null);
        assert (this.aboutMenuItem != null);
        assert (this.checkUpdatesMenuItem != null);
        assert (this.registerMenuItem != null);
        assert (this.gettingStartedMenuItem != null);
        assert (this.apiDocMenuItem != null);
        assert (this.cssReferenceGuideMenuItem != null);
        assert (this.fxmlIntroductionMenuItem != null);
        assert (this.sceneBuilderHomeMenuItem != null);
        assert (this.communityContributeMenuItem != null);
        assert (this.jfxCentralMenuItem != null);
        StackPane rootStackPane = (StackPane)this.menuBar.getParent();
        rootStackPane.getChildren().remove((Object)this.menuBar);
        if (EditorPlatform.IS_MAC) {
            this.menuBar.setUseSystemMenuBar(true);
            this.menuBar.useSystemMenuBarProperty().addListener((obs, ov, nv) -> {
                if (!nv.booleanValue()) {
                    this.menuBar.setUseSystemMenuBar(true);
                }
            });
            this.exitMenuItem.getParentMenu().getItems().remove((Object)this.exitMenuItem);
        }
        if (EditorPlatform.IS_MAC) {
            revealMenuKey = "menu.title.reveal.mac";
        } else if (EditorPlatform.IS_WINDOWS) {
            revealMenuKey = "menu.title.reveal.win.mnemonic";
        } else {
            assert (EditorPlatform.IS_LINUX);
            revealMenuKey = "menu.title.reveal.linux";
        }
        this.revealMenuItem.setText(I18N.getString(revealMenuKey));
        this.newMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_FILE));
        this.newMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{modifier}));
        this.newTemplateMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.NEW_TEMPLATE));
        this.openMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.OPEN_FILE));
        this.openMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{modifier}));
        this.openRecentMenu.setOnShowing(t -> this.updateOpenRecentMenuItems());
        this.saveMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SAVE_FILE));
        this.saveMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{modifier}));
        this.saveAsMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SAVE_AS_FILE));
        this.saveAsMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.revertMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REVERT_FILE));
        this.revealMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REVEAL_FILE));
        this.importFxmlMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.IMPORT_FXML));
        this.importMediaMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.IMPORT_MEDIA));
        this.includeFileMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.INCLUDE_FXML));
        this.editIncludedFileMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.EDIT_INCLUDED_FILE){

            @Override
            public String getTitle() {
                File file;
                String title = I18N.getString("menu.title.edit.included.default");
                if (MenuBarController.this.documentWindowController != null && (file = MenuBarController.this.documentWindowController.getEditorController().getIncludedFile()) != null) {
                    title = I18N.getString("menu.title.edit.included", file.getName());
                }
                return title;
            }
        });
        this.revealIncludedFileMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.REVEAL_INCLUDED_FILE){

            @Override
            public String getTitle() {
                File file;
                String title = I18N.getString("menu.title.reveal.included.default");
                if (MenuBarController.this.documentWindowController != null && (file = MenuBarController.this.documentWindowController.getEditorController().getIncludedFile()) != null) {
                    title = EditorPlatform.IS_MAC ? I18N.getString("menu.title.reveal.included.finder", file.getName()) : I18N.getString("menu.title.reveal.included.explorer", file.getName());
                }
                return title;
            }
        });
        this.closeMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.CLOSE_FRONT_WINDOW));
        this.closeMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{modifier}));
        this.showPreferencesMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.SHOW_PREFERENCES));
        this.showPreferencesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{modifier}));
        this.exitMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.EXIT));
        this.undoMenuItem.setUserData((Object)new UndoActionController());
        this.undoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{modifier}));
        this.redoMenuItem.setUserData((Object)new RedoActionController());
        if (EditorPlatform.IS_MAC) {
            this.redoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        } else {
            this.redoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{modifier}));
        }
        this.copyMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.COPY));
        this.copyMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{modifier}));
        this.cutMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.CUT));
        this.cutMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{modifier}));
        this.pasteMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.PASTE));
        this.pasteMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{modifier}));
        this.pasteIntoMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.PASTE_INTO));
        this.pasteIntoMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.duplicateMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DUPLICATE));
        this.duplicateMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{modifier}));
        this.deleteMenuItem.setUserData((Object)new DocumentEditActionController(DocumentWindowController.DocumentEditAction.DELETE));
        this.deleteMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
        this.selectAllMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SELECT_ALL));
        this.selectAllMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{modifier}));
        this.selectNoneMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SELECT_NONE));
        this.selectNoneMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.selectParentMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.SELECT_PARENT));
        this.selectParentMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{modifier}));
        this.selectNextMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.SELECT_NEXT));
        this.selectNextMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{modifier}));
        this.selectPreviousMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.SELECT_PREVIOUS));
        this.selectPreviousMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{modifier}));
        this.trimMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.TRIM));
        this.gotoContentMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_CONTENT));
        this.gotoContentMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{modifier}));
        this.gotoPropertiesMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_PROPERTIES));
        this.gotoPropertiesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT1, new KeyCombination.Modifier[]{modifier}));
        this.gotoLayoutMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_LAYOUT));
        this.gotoLayoutMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{modifier}));
        this.gotoCodeMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.GOTO_CODE));
        this.gotoCodeMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT3, new KeyCombination.Modifier[]{modifier}));
        this.toggleLibraryPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_LIBRARY_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.library.panel" : (MenuBarController.this.documentWindowController.isLibraryPanelVisible() ? "menu.title.hide.library.panel" : "menu.title.show.library.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleLibraryPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT4, new KeyCombination.Modifier[]{modifier}));
        this.toggleHierarchyPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_DOCUMENT_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.document.panel" : (MenuBarController.this.documentWindowController.isHierarchyPanelVisible() ? "menu.title.hide.document.panel" : "menu.title.show.document.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleHierarchyPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT5, new KeyCombination.Modifier[]{modifier}));
        this.toggleCSSPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_CSS_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.bottom.panel" : (MenuBarController.this.documentWindowController.isBottomPanelVisible() ? "menu.title.hide.bottom.panel" : "menu.title.show.bottom.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleCSSPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT6, new KeyCombination.Modifier[]{modifier}));
        this.toggleLeftPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_LEFT_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.left.panel" : (MenuBarController.this.documentWindowController.isLeftPanelVisible() ? "menu.title.hide.left.panel" : "menu.title.show.left.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleLeftPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT7, new KeyCombination.Modifier[]{modifier}));
        this.toggleRightPanelMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_RIGHT_PANEL){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.right.panel" : (MenuBarController.this.documentWindowController.isRightPanelVisible() ? "menu.title.hide.right.panel" : "menu.title.show.right.panel");
                return I18N.getString(titleKey);
            }
        });
        this.toggleRightPanelMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT8, new KeyCombination.Modifier[]{modifier}));
        this.toggleOutlinesMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_OUTLINES_VISIBILITY){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.outlines" : (MenuBarController.this.documentWindowController.getContentPanelController().isOutlinesVisible() ? "menu.title.hide.outlines" : "menu.title.show.outlines");
                return I18N.getString(titleKey);
            }
        });
        this.toggleOutlinesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{modifier}));
        this.toggleSampleDataMenuItem.setUserData((Object)new ControlActionController(EditorController.ControlAction.TOGGLE_SAMPLE_DATA){

            @Override
            public String getTitle() {
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.hide.sample.data" : (MenuBarController.this.documentWindowController.getEditorController().isSampleDataEnabled() ? "menu.title.hide.sample.data" : "menu.title.show.sample.data");
                return I18N.getString(titleKey);
            }
        });
        this.toggleAlignmentGuidesMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.TOGGLE_GUIDES_VISIBILITY){

            @Override
            public String getTitle() {
                ContentPanelController contentPanelController;
                String titleKey = MenuBarController.this.documentWindowController == null ? "menu.title.disable.guides" : ((contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController()).isGuidesVisible() ? "menu.title.disable.guides" : "menu.title.enable.guides");
                return I18N.getString(titleKey);
            }
        });
        this.showSampleControllerMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SHOW_SAMPLE_CONTROLLER));
        this.updateZoomMenu();
        this.fitToParentMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.FIT_TO_PARENT));
        this.fitToParentMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{modifier}));
        this.useComputedSizesMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.USE_COMPUTED_SIZES));
        this.useComputedSizesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.addContextMenuMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_CONTEXT_MENU));
        this.addTooltipMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_TOOLTIP));
        this.moveRowAboveMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_ROW_ABOVE));
        this.moveRowBelowMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_ROW_BELOW));
        this.moveColumnBeforeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_COLUMN_BEFORE));
        this.moveColumnAfterMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.MOVE_COLUMN_AFTER));
        this.addRowAboveMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_ROW_ABOVE));
        this.addRowBelowMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_ROW_BELOW));
        this.addColumnBeforeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_COLUMN_BEFORE));
        this.addColumnAfterMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.ADD_COLUMN_AFTER));
        this.increaseRowSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.INCREASE_ROW_SPAN));
        this.decreaseRowSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DECREASE_ROW_SPAN));
        this.increaseColumnSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.INCREASE_COLUMN_SPAN));
        this.decreaseColumnSpanMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.DECREASE_COLUMN_SPAN));
        this.phoneSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_335x600){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_335x600);
            }
        });
        this.tabletSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_900x600){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_900x600);
            }
        });
        this.qvgaSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_320x240){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_320x240);
            }
        });
        this.vgaSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_640x480){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_640x480);
            }
        });
        this.touchSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_1280x800){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_1280x800);
            }
        });
        this.hdSetSizeMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SET_SIZE_1920x1080){

            @Override
            public void perform() {
                super.perform();
                MenuBarController.this.updatePreviewWindowSize(EditorController.Size.SIZE_1920x1080);
            }
        });
        this.updateAddEffectMenu();
        this.bringToFrontMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.BRING_TO_FRONT));
        this.bringToFrontMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("]", new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.sendToBackMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SEND_TO_BACK));
        this.sendToBackMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("[", new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, modifier}));
        this.bringForwardMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.BRING_FORWARD));
        this.bringForwardMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("]", new KeyCombination.Modifier[]{modifier}));
        this.sendBackwardMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.SEND_BACKWARD));
        this.sendBackwardMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("[", new KeyCombination.Modifier[]{modifier}));
        this.wrapInAnchorPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_ANCHOR_PANE));
        this.wrapInBorderPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_BORDER_PANE));
        this.wrapInButtonBarMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_BUTTON_BAR));
        this.wrapInDialogPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_DIALOG_PANE));
        this.wrapInFlowPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_FLOW_PANE));
        this.wrapInGroupMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GROUP));
        this.wrapInGridPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GRID_PANE));
        this.wrapInHBoxMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_HBOX));
        this.wrapInPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_PANE));
        this.wrapInScrollPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_SCROLL_PANE));
        this.wrapInSplitPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_SPLIT_PANE));
        this.wrapInStackPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_STACK_PANE));
        this.wrapInTabPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TAB_PANE));
        this.wrapInTextFlowMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TEXT_FLOW));
        this.wrapInTilePaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TILE_PANE));
        this.wrapInTitledPaneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TITLED_PANE));
        this.wrapInToolBarMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_TOOL_BAR));
        this.wrapInVBoxMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_VBOX));
        this.wrapInGroupMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_GROUP));
        this.wrapInSceneMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_SCENE));
        this.wrapInStageMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.WRAP_IN_STAGE));
        this.unwrapMenuItem.setUserData((Object)new EditActionController(EditorController.EditAction.UNWRAP));
        this.unwrapMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{modifier}));
        if (null == this.previewController) {
            this.previewController = new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SHOW_PREVIEW_WINDOW);
        }
        this.showPreviewInWindowMenuItem.setUserData((Object)this.previewController);
        this.showPreviewInWindowMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{modifier}));
        this.showPreviewInDialogMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SHOW_PREVIEW_DIALOG));
        this.caspianHighContrastThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST));
        this.caspianThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN));
        this.caspianEmbeddedThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN_EMBEDDED));
        this.caspianEmbeddedQVGAThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA));
        this.gluonMobileLightThemeMenuItem.setUserData((Object)new SetThemeActionController(GluonEditorPlatform.GLUON_MOBILE_LIGHT));
        this.gluonMobileDarkThemeMenuItem.setUserData((Object)new SetThemeActionController(GluonEditorPlatform.GLUON_MOBILE_DARK));
        this.modenaThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA));
        this.modenaTouchThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_TOUCH));
        this.modenaHighContrastBlackonwhiteThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE));
        this.modenaHighContrastWhiteonblackThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK));
        this.modenaHighContrastYellowonblackThemeMenuItem.setUserData((Object)new SetThemeActionController(EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK));
        this.blueSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_BLUE));
        this.addSwatchGraphic(this.blueSwatch);
        this.cyanSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_CYAN));
        this.addSwatchGraphic(this.cyanSwatch);
        this.deepOrangeSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_DEEP_ORANGE));
        this.addSwatchGraphic(this.deepOrangeSwatch);
        this.deepPurpleSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_DEEP_PURPLE));
        this.addSwatchGraphic(this.deepPurpleSwatch);
        this.greenSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_GREEN));
        this.addSwatchGraphic(this.greenSwatch);
        this.indigoSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_INDIGO));
        this.addSwatchGraphic(this.indigoSwatch);
        this.lightBlueSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_LIGHT_BLUE));
        this.addSwatchGraphic(this.lightBlueSwatch);
        this.pinkSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_PINK));
        this.addSwatchGraphic(this.pinkSwatch);
        this.purpleSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_PURPLE));
        this.addSwatchGraphic(this.purpleSwatch);
        this.redSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_RED));
        this.addSwatchGraphic(this.redSwatch);
        this.tealSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_TEAL));
        this.addSwatchGraphic(this.tealSwatch);
        this.lightGreenSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_LIGHT_GREEN));
        this.addSwatchGraphic(this.lightGreenSwatch);
        this.limeSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_LIME));
        this.addSwatchGraphic(this.limeSwatch);
        this.yellowSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_YELLOW));
        this.addSwatchGraphic(this.yellowSwatch);
        this.amberSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_AMBER));
        this.addSwatchGraphic(this.amberSwatch);
        this.orangeSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_ORANGE));
        this.addSwatchGraphic(this.orangeSwatch);
        this.brownSwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_BROWN));
        this.addSwatchGraphic(this.brownSwatch);
        this.greySwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_GREY));
        this.addSwatchGraphic(this.greySwatch);
        this.blueGreySwatch.setUserData((Object)new GluonActionController(GluonEditorPlatform.GLUON_SWATCH_BLUE_GREY));
        this.addSwatchGraphic(this.blueGreySwatch);
        this.addSceneStyleSheetMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.ADD_SCENE_STYLE_SHEET));
        this.updateOpenAndRemoveSceneStyleSheetMenus();
        if (this.documentWindowController != null) {
            this.documentWindowController.getEditorController().sceneStyleSheetProperty().addListener((ov, t, t1) -> {
                if (t1 != null) {
                    this.updateOpenAndRemoveSceneStyleSheetMenus();
                    this.setupMenuItemHandlers((MenuItem)this.removeSceneStyleSheetMenu);
                    this.setupMenuItemHandlers((MenuItem)this.openSceneStyleSheetMenu);
                }
            });
        }
        this.setResourceMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.SET_RESOURCE));
        this.removeResourceMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REMOVE_RESOURCE){

            @Override
            public String getTitle() {
                String title = I18N.getString("menu.title.remove.resource");
                if (MenuBarController.this.documentWindowController != null && MenuBarController.this.documentWindowController.getResourceFile() != null) {
                    title = I18N.getString("menu.title.remove.resource.with.file", MenuBarController.this.documentWindowController.getResourceFile().getName());
                }
                return title;
            }
        });
        this.revealResourceMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.REVEAL_RESOURCE){

            @Override
            public String getTitle() {
                String title = I18N.getString("menu.title.reveal.resource");
                if (MenuBarController.this.documentWindowController != null && MenuBarController.this.documentWindowController.getResourceFile() != null) {
                    title = I18N.getString("menu.title.reveal.resource.with.file", MenuBarController.this.documentWindowController.getResourceFile().getName());
                }
                return title;
            }
        });
        this.phonePreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_335x600));
        this.tabletPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_900x600));
        this.qvgaPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_320x240));
        this.vgaPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_640x480));
        this.touchPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_1280x800));
        this.hdPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_1920x1080));
        this.preferredPreviewSizeMenuItem.setUserData((Object)new SetSizeActionController(EditorController.Size.SIZE_PREFERRED));
        this.aboutMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.ABOUT));
        this.helpMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP));
        this.helpMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F1, new KeyCombination.Modifier[0]));
        this.showWelcomeItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.SHOW_WELCOME));
        this.checkUpdatesMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.CHECK_UPDATES));
        this.registerMenuItem.setUserData((Object)new ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction.REGISTER));
        this.gettingStartedMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP_OPEN_GETTING_STARTED_GUIDE));
        this.gettingStartedMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]));
        this.apiDocMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP_OPEN_OPENJFX_APIDOC));
        this.apiDocMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]));
        this.cssReferenceGuideMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP_OPEN_OPENJFX_CSS_REFERENCE));
        this.cssReferenceGuideMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F4, new KeyCombination.Modifier[0]));
        this.fxmlIntroductionMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP_OPEN_OPENJFX_FXML_REFERENCE));
        this.fxmlIntroductionMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]));
        this.jfxCentralMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP_OPEN_JFXCENTRAL_HOMEPAGE));
        this.jfxCentralMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F6, new KeyCombination.Modifier[0]));
        this.sceneBuilderHomeMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP_OPEN_GLUON_SCENEBUILDER_HOME));
        this.communityContributeMenuItem.setUserData((Object)new DocumentControlActionController(DocumentWindowController.DocumentControlAction.HELP_COMMUNITY_CONTRIBUTE_SCENEBUILDER));
        for (Menu m : this.menuBar.getMenus()) {
            this.setupMenuItemHandlers((MenuItem)m);
        }
        this.constructBuiltinPartOfInsertMenu();
        this.constructCustomPartOfInsertMenu();
        this.insertMenu.setOnMenuValidation(this.onCustomPartOfInsertMenuValidationHandler);
        this.windowMenu.setOnMenuValidation(this.onWindowMenuValidationHandler);
    }

    private void addSwatchGraphic(RadioMenuItem swatchMenuItem) {
        EditorPlatform.Theme swatch = ((GluonActionController)swatchMenuItem.getUserData()).getSwatch();
        swatchMenuItem.setGraphic(GluonEditorPlatform.createGraphicForSwatch(swatch));
    }

    private void setupMenuItemHandlers(MenuItem i) {
        if (i instanceof Menu) {
            Menu m = (Menu)i;
            m.setOnMenuValidation(this.onMenuValidationEventHandler);
            for (MenuItem child : m.getItems()) {
                this.setupMenuItemHandlers(child);
            }
        } else {
            i.setOnAction(this.onActionEventHandler);
            if (i.getAccelerator() != null) {
                this.keyToMenu.put(i.getAccelerator(), i);
            }
        }
    }

    private void handleOnMenuValidation(Menu menu) {
        for (MenuItem i : menu.getItems()) {
            boolean selected;
            String title;
            boolean disable;
            if (i.getUserData() instanceof MenuItemController) {
                boolean canPerform;
                MenuItemController c = (MenuItemController)i.getUserData();
                try {
                    canPerform = c.canPerform();
                }
                catch (RuntimeException x) {
                    canPerform = false;
                    Exception xx = new Exception(c.getClass().getSimpleName() + ".canPerform() did break for menu item " + String.valueOf(i), x);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xx.getMessage(), xx);
                }
                disable = !canPerform;
                title = c.getTitle();
                selected = c.isSelected();
            } else if (i instanceof Menu) {
                disable = false;
                selected = false;
                title = null;
            } else {
                disable = true;
                selected = false;
                title = null;
            }
            i.setDisable(disable);
            if (title != null) {
                i.setText(title);
            }
            if (!(i instanceof RadioMenuItem)) continue;
            RadioMenuItem ri = (RadioMenuItem)i;
            ri.setSelected(selected);
        }
    }

    private void handleOnActionMenu(MenuItem i) {
        assert (i.getUserData() instanceof MenuItemController);
        MenuItemController c = (MenuItemController)i.getUserData();
        c.perform();
    }

    private void updateZoomMenu() {
        double[] scalingTable = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 4.0};
        MenuItem zoomInMenuItem = new MenuItem(I18N.getString("menu.title.zoom.in"));
        zoomInMenuItem.setUserData((Object)new ZoomInActionController());
        zoomInMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("+", new KeyCombination.Modifier[]{modifier}));
        this.zoomMenu.getItems().add((Object)zoomInMenuItem);
        MenuItem zoomOutMenuItem = new MenuItem(I18N.getString("menu.title.zoom.out"));
        zoomOutMenuItem.setUserData((Object)new ZoomOutActionController());
        zoomOutMenuItem.setAccelerator((KeyCombination)new KeyCharacterCombination("/", new KeyCombination.Modifier[]{modifier}));
        this.zoomMenu.getItems().add((Object)zoomOutMenuItem);
        this.zoomMenu.getItems().add((Object)new SeparatorMenuItem());
        for (int i = 0; i < scalingTable.length; ++i) {
            double scaling = scalingTable[i];
            String title = String.format("%.0f%%", scaling * 100.0);
            RadioMenuItem mi = new RadioMenuItem(title);
            mi.setUserData((Object)new SetZoomActionController(scaling));
            this.zoomMenu.getItems().add((Object)mi);
        }
    }

    private static int findZoomScaleIndex(double zoomScale) {
        int result = -1;
        for (int i = 0; i < scalingTable.length; ++i) {
            if (!MathUtils.equals(zoomScale, scalingTable[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    private void updateOpenRecentMenuItems() {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
        List<String> recentItems = recordGlobal.getRecentItems();
        MenuItem clearMenuItem = new MenuItem(I18N.getString("menu.title.open.recent.clear"));
        clearMenuItem.setOnAction((EventHandler)new ClearOpenRecentHandler());
        if (recentItems.isEmpty()) {
            clearMenuItem.setDisable(true);
            menuItems.add(clearMenuItem);
        } else {
            String name;
            File recentItemFile;
            clearMenuItem.setDisable(false);
            HashMap<String, Integer> recentItemsNames = new HashMap<String, Integer>();
            ArrayList<String> recentItemsToRemove = new ArrayList<String>();
            for (String recentItem : recentItems) {
                recentItemFile = new File(recentItem);
                if (recentItemFile.exists()) {
                    name = recentItemFile.getName();
                    if (recentItemsNames.containsKey(name)) {
                        recentItemsNames.replace(name, (Integer)recentItemsNames.get(name) + 1);
                        continue;
                    }
                    recentItemsNames.put(name, 1);
                    continue;
                }
                recentItemsToRemove.add(recentItem);
            }
            for (String recentItem : recentItems) {
                MenuItem mi;
                recentItemFile = new File(recentItem);
                if (!recentItemFile.exists()) continue;
                name = recentItemFile.getName();
                assert (recentItemsNames.keySet().contains(name));
                if ((Integer)recentItemsNames.get(name) > 1) {
                    mi = new MenuItem(recentItem);
                } else {
                    assert ((Integer)recentItemsNames.get(name) == 1);
                    mi = new MenuItem(name);
                }
                mi.setOnAction(t -> {
                    File file = new File(recentItem);
                    SceneBuilderApp.getSingleton().performOpenRecent(this.documentWindowController, file);
                });
                mi.setMnemonicParsing(false);
                menuItems.add(mi);
            }
            if (!recentItemsToRemove.isEmpty()) {
                recordGlobal.removeRecentItems(recentItemsToRemove);
            }
            menuItems.add(new SeparatorMenuItem());
            menuItems.add(clearMenuItem);
        }
        this.openRecentMenu.getItems().setAll(menuItems);
    }

    private void updateOpenAndRemoveSceneStyleSheetMenus() {
        ObservableList<File> sceneStyleSheets;
        assert (this.removeSceneStyleSheetMenu != null);
        if (this.documentWindowController != null && (sceneStyleSheets = this.documentWindowController.getEditorController().getSceneStyleSheets()) != null) {
            this.removeSceneStyleSheetMenu.getItems().clear();
            this.openSceneStyleSheetMenu.getItems().clear();
            if (sceneStyleSheets.size() == 0) {
                MenuItem mi = new MenuItem(I18N.getString("scenestylesheet.none"));
                mi.setDisable(true);
                this.removeSceneStyleSheetMenu.getItems().add((Object)mi);
                MenuItem mi2 = new MenuItem(I18N.getString("scenestylesheet.none"));
                mi2.setDisable(true);
                this.openSceneStyleSheetMenu.getItems().add((Object)mi2);
            } else {
                for (File f : sceneStyleSheets) {
                    MenuItem mi = new MenuItem(f.getName());
                    mi.setUserData((Object)new RemoveSceneStyleSheetActionController(f));
                    this.removeSceneStyleSheetMenu.getItems().add((Object)mi);
                    MenuItem mi2 = new MenuItem(f.getName());
                    mi2.setUserData((Object)new OpenSceneStyleSheetActionController(f));
                    this.openSceneStyleSheetMenu.getItems().add((Object)mi2);
                }
            }
        }
    }

    private void updateCustomPartOfInsertMenu() {
        assert (this.insertMenu != null);
        assert (this.insertCustomMenu != null);
        if (this.documentWindowController != null) {
            EditorController editorController = this.documentWindowController.getEditorController();
            assert (editorController.getLibrary() != null);
            TreeSet<LibraryItem> sectionItems = new TreeSet<LibraryItem>(new LibraryItemNameComparator());
            for (LibraryItem li : editorController.getLibrary().getItems()) {
                if (!li.getSection().equals("Custom")) continue;
                sectionItems.add(li);
            }
            if (sectionItems.size() > 0) {
                this.insertCustomMenu.getItems().clear();
                for (LibraryItem li : sectionItems) {
                    this.insertCustomMenu.getItems().add((Object)this.makeMenuItemForLibraryItem(li));
                }
                this.insertCustomMenu.setVisible(true);
            } else {
                this.insertCustomMenu.setVisible(false);
            }
        }
    }

    private void constructCustomPartOfInsertMenu() {
        assert (this.insertMenu != null);
        this.insertCustomMenu = this.makeMenuForLibrarySection("Custom");
        this.insertMenu.getItems().add(0, (Object)this.insertCustomMenu);
        this.insertCustomMenu.setVisible(false);
    }

    private void constructBuiltinPartOfInsertMenu() {
        assert (this.insertMenu != null);
        this.insertMenu.getItems().clear();
        TreeMap<String, TreeSet<LibraryItem>> sectionMap = new TreeMap<String, TreeSet<LibraryItem>>(new BuiltinSectionComparator());
        for (LibraryItem li : BuiltinLibrary.getLibrary().getItems()) {
            TreeSet<LibraryItem> sectionItems = (TreeSet<LibraryItem>)sectionMap.get(li.getSection());
            if (sectionItems == null) {
                sectionItems = new TreeSet<LibraryItem>(new LibraryItemNameComparator());
                sectionMap.put(li.getSection(), sectionItems);
            }
            if (ContextMenu.class.getSimpleName().equals(li.getName())) continue;
            sectionItems.add(li);
        }
        for (Map.Entry e : sectionMap.entrySet()) {
            Menu sectionMenu = this.makeMenuForLibrarySection((String)e.getKey());
            this.insertMenu.getItems().add((Object)sectionMenu);
            for (LibraryItem li : (Set)e.getValue()) {
                sectionMenu.getItems().add((Object)this.makeMenuItemForLibraryItem(li));
            }
        }
    }

    private Menu makeMenuForLibrarySection(String section) {
        Menu result = new Menu();
        result.setText(section);
        result.setOnShowing(t -> this.updateInsertMenuState(result));
        return result;
    }

    private MenuItem makeMenuItemForLibraryItem(LibraryItem li) {
        MenuItem result = new MenuItem();
        result.setText(li.getName());
        result.setUserData((Object)li);
        result.setOnAction(t -> this.handleInsertMenuAction(li));
        return result;
    }

    private void updateInsertMenuState(Menu sectionMenu) {
        if (this.documentWindowController != null && this.documentWindowController.getStage().isFocused()) {
            EditorController editorController = this.documentWindowController.getEditorController();
            for (MenuItem menuItem : sectionMenu.getItems()) {
                assert (menuItem.getUserData() instanceof LibraryItem);
                LibraryItem li = (LibraryItem)menuItem.getUserData();
                boolean enabled = editorController.canPerformInsert(li);
                menuItem.setDisable(!enabled);
            }
        } else {
            for (MenuItem menuItem : sectionMenu.getItems()) {
                assert (menuItem.getUserData() instanceof LibraryItem);
                menuItem.setDisable(true);
            }
        }
    }

    private void handleInsertMenuAction(LibraryItem li) {
        if (this.documentWindowController != null) {
            EditorController editorController = this.documentWindowController.getEditorController();
            editorController.performInsert(li);
        }
    }

    private void updateAddEffectMenu() {
        this.addEffectMenu.getItems().clear();
        for (Class<? extends Effect> c : EffectPicker.getEffectClasses()) {
            this.addEffectMenu.getItems().add((Object)this.makeMenuItemForEffect(c));
        }
    }

    private MenuItem makeMenuItemForEffect(Class<? extends Effect> effectClass) {
        MenuItem result = new MenuItem();
        result.setText(effectClass.getSimpleName());
        result.setUserData((Object)new AddEffectActionController(effectClass));
        return result;
    }

    private void handleOnWindowMenuValidation() {
        this.windowMenu.getItems().clear();
        List<DocumentWindowController> documentWindowControllers = SceneBuilderApp.getSingleton().getDocumentWindowControllers();
        if (documentWindowControllers.isEmpty()) {
            this.windowMenu.getItems().add((Object)this.makeWindowMenuItem(null));
        } else {
            ArrayList<DocumentWindowController> sortedControllers = new ArrayList<DocumentWindowController>(documentWindowControllers);
            Collections.sort(sortedControllers, new DocumentWindowController.TitleComparator());
            for (DocumentWindowController dwc : sortedControllers) {
                this.windowMenu.getItems().add((Object)this.makeWindowMenuItem(dwc));
            }
        }
    }

    private MenuItem makeWindowMenuItem(DocumentWindowController dwc) {
        RadioMenuItem result = new RadioMenuItem();
        if (dwc != null) {
            result.setText(dwc.getStage().getTitle());
            result.setDisable(false);
            result.setSelected(dwc.getStage().isFocused());
            result.setOnAction((EventHandler)new WindowMenuEventHandler(dwc));
        } else {
            result.setText(I18N.getString("menu.title.no.window"));
            result.setDisable(true);
            result.setSelected(false);
        }
        return result;
    }

    private void updatePreviewWindowSize(EditorController.Size size) {
        if (this.documentWindowController != null && this.documentWindowController.getPreviewWindowController() != null && this.documentWindowController.getPreviewWindowController().getStage().isShowing()) {
            this.documentWindowController.getPreviewWindowController().setSize(size);
        }
    }

    public MenuItem getMenuItem(KeyCombination key) {
        return this.keyToMenu.get(key);
    }

    public Set<KeyCombination> getAccelerators() {
        return this.keyToMenu.keySet();
    }

    private String getStringFromDouble(double value) {
        String res = Double.toString(value);
        if (res.endsWith(".0")) {
            res = Integer.toString((int)value);
        }
        return res;
    }

    static {
        modifier = EditorPlatform.IS_MAC ? KeyCombination.META_DOWN : KeyCombination.CONTROL_DOWN;
        scalingTable = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 4.0};
    }

    class DocumentControlActionController
    extends MenuItemController {
        private final DocumentWindowController.DocumentControlAction controlAction;

        public DocumentControlActionController(DocumentWindowController.DocumentControlAction controlAction) {
            super(MenuBarController.this);
            this.controlAction = controlAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null ? false : MenuBarController.this.documentWindowController.canPerformControlAction(this.controlAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "controlAction=" + String.valueOf((Object)this.controlAction);
            MenuBarController.this.documentWindowController.performControlAction(this.controlAction);
        }
    }

    class ApplicationControlActionController
    extends MenuItemController {
        private final SceneBuilderApp.ApplicationControlAction controlAction;

        public ApplicationControlActionController(SceneBuilderApp.ApplicationControlAction controlAction) {
            super(MenuBarController.this);
            this.controlAction = controlAction;
        }

        @Override
        public boolean canPerform() {
            return SceneBuilderApp.getSingleton().canPerformControlAction(this.controlAction, MenuBarController.this.documentWindowController);
        }

        @Override
        public void perform() {
            SceneBuilderApp.getSingleton().performControlAction(this.controlAction, MenuBarController.this.documentWindowController);
        }
    }

    class DocumentEditActionController
    extends MenuItemController {
        private final DocumentWindowController.DocumentEditAction editAction;

        public DocumentEditActionController(DocumentWindowController.DocumentEditAction editAction) {
            super(MenuBarController.this);
            this.editAction = editAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.canPerformEditAction(this.editAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "editAction=" + String.valueOf((Object)this.editAction);
            MenuBarController.this.documentWindowController.performEditAction(this.editAction);
        }
    }

    class UndoActionController
    extends MenuItemController {
        UndoActionController() {
            super(MenuBarController.this);
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canUndo();
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform());
            MenuBarController.this.documentWindowController.getEditorController().undo();
        }

        @Override
        public String getTitle() {
            StringBuilder result = new StringBuilder();
            result.append(I18N.getString("menu.title.undo"));
            if (this.canPerform()) {
                result.append(" ");
                result.append(MenuBarController.this.documentWindowController.getEditorController().getUndoDescription());
            }
            return result.toString();
        }
    }

    class RedoActionController
    extends MenuItemController {
        RedoActionController() {
            super(MenuBarController.this);
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canRedo();
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform());
            MenuBarController.this.documentWindowController.getEditorController().redo();
        }

        @Override
        public String getTitle() {
            StringBuilder result = new StringBuilder();
            result.append(I18N.getString("menu.title.redo"));
            if (this.canPerform()) {
                result.append(" ");
                result.append(MenuBarController.this.documentWindowController.getEditorController().getRedoDescription());
            }
            return result.toString();
        }
    }

    class EditActionController
    extends MenuItemController {
        private final EditorController.EditAction editAction;

        public EditActionController(EditorController.EditAction editAction) {
            super(MenuBarController.this);
            this.editAction = editAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canPerformEditAction(this.editAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "editAction=" + String.valueOf((Object)this.editAction);
            MenuBarController.this.documentWindowController.getEditorController().performEditAction(this.editAction);
        }
    }

    class ControlActionController
    extends MenuItemController {
        private final EditorController.ControlAction controlAction;

        public ControlActionController(EditorController.ControlAction controlAction) {
            super(MenuBarController.this);
            this.controlAction = controlAction;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null ? false : MenuBarController.this.documentWindowController.getEditorController().canPerformControlAction(this.controlAction);
            return result;
        }

        @Override
        public void perform() {
            assert (this.canPerform()) : "controlAction=" + String.valueOf((Object)this.controlAction);
            MenuBarController.this.documentWindowController.getEditorController().performControlAction(this.controlAction);
        }
    }

    class SetThemeActionController
    extends MenuItemController {
        private final EditorPlatform.Theme theme;

        public SetThemeActionController(EditorPlatform.Theme theme) {
            super(MenuBarController.this);
            this.theme = theme;
        }

        @Override
        public boolean canPerform() {
            boolean res;
            boolean bl = res = MenuBarController.this.documentWindowController != null;
            if (res) {
                EditorPlatform.Theme currentTheme = MenuBarController.this.documentWindowController.getEditorController().getTheme();
                if (this.theme == EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST && EditorPlatform.isModena(currentTheme)) {
                    res = false;
                    MenuBarController.this.caspianHighContrastThemeMenuItem.setSelected(false);
                } else if (this.theme == EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE && EditorPlatform.isCaspian(currentTheme)) {
                    res = false;
                    MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.setSelected(false);
                } else if (this.theme == EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK && EditorPlatform.isCaspian(currentTheme)) {
                    res = false;
                    MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.setSelected(false);
                } else if (this.theme == EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK && EditorPlatform.isCaspian(currentTheme)) {
                    res = false;
                    MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.setSelected(false);
                }
            }
            return res;
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            EditorPlatform.Theme currentTheme = MenuBarController.this.documentWindowController.getEditorController().getTheme();
            EditorPlatform.Theme overridingTheme = this.theme;
            block11 : switch (this.theme.name()) {
                case "CASPIAN": {
                    if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break;
                    overridingTheme = EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST;
                    break;
                }
                case "CASPIAN_EMBEDDED": {
                    if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break;
                    overridingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_HIGH_CONTRAST;
                    break;
                }
                case "CASPIAN_EMBEDDED_QVGA": {
                    if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break;
                    overridingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST;
                    break;
                }
                case "CASPIAN_HIGH_CONTRAST": {
                    switch (currentTheme.name()) {
                        case "CASPIAN": {
                            if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block11;
                            overridingTheme = EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST;
                            break;
                        }
                        case "CASPIAN_EMBEDDED": {
                            if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block11;
                            overridingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_HIGH_CONTRAST;
                            break;
                        }
                        case "CASPIAN_EMBEDDED_QVGA": {
                            if (!MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block11;
                            overridingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST;
                            break;
                        }
                        case "CASPIAN_HIGH_CONTRAST": {
                            if (MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block11;
                            overridingTheme = EditorPlatform.Theme.CASPIAN;
                            break;
                        }
                        case "CASPIAN_EMBEDDED_HIGH_CONTRAST": {
                            if (MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block11;
                            overridingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED;
                            break;
                        }
                        case "CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST": {
                            if (MenuBarController.this.caspianHighContrastThemeMenuItem.isSelected()) break block11;
                            overridingTheme = EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA;
                            break;
                        }
                        default: {
                            assert (false);
                            break block11;
                        }
                    }
                    break;
                }
                case "MODENA": {
                    if (MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) {
                        overridingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE;
                        break;
                    }
                    if (MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) {
                        overridingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK;
                        break;
                    }
                    if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                    overridingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK;
                    break;
                }
                case "MODENA_TOUCH": {
                    if (MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) {
                        overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE;
                        break;
                    }
                    if (MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) {
                        overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                        break;
                    }
                    if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                    overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK;
                    break;
                }
                case "MODENA_HIGH_CONTRAST_BLACK_ON_WHITE": {
                    switch (currentTheme.name()) {
                        case "MODENA": {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_BLACK_ON_WHITE;
                            break;
                        }
                        case "MODENA_TOUCH": {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE;
                            break;
                        }
                        case "MODENA_HIGH_CONTRAST_BLACK_ON_WHITE": {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA;
                            break;
                        }
                        case "MODENA_HIGH_CONTRAST_WHITE_ON_BLACK": 
                        case "MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK": {
                            break;
                        }
                        case "MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE": {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH;
                            break;
                        }
                        case "MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK": 
                        case "MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK": {
                            if (!MenuBarController.this.modenaHighContrastBlackonwhiteThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE;
                            break;
                        }
                    }
                    break;
                }
                case "MODENA_HIGH_CONTRAST_WHITE_ON_BLACK": {
                    switch (currentTheme.name()) {
                        case "MODENA": {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                        case "MODENA_TOUCH": {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                        case "MODENA_HIGH_CONTRAST_BLACK_ON_WHITE": {
                            break;
                        }
                        case "MODENA_HIGH_CONTRAST_WHITE_ON_BLACK": {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA;
                            break;
                        }
                        case "MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK": {
                            break;
                        }
                        case "MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE": {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                        case "MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK": {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH;
                            break;
                        }
                        case "MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK": {
                            if (!MenuBarController.this.modenaHighContrastWhiteonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK;
                            break;
                        }
                    }
                    break;
                }
                case "MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK": {
                    switch (currentTheme.name()) {
                        case "MODENA": {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK;
                            break;
                        }
                        case "MODENA_TOUCH": {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK;
                            break;
                        }
                        case "MODENA_HIGH_CONTRAST_BLACK_ON_WHITE": 
                        case "MODENA_HIGH_CONTRAST_WHITE_ON_BLACK": {
                            break;
                        }
                        case "MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK": {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA;
                            break;
                        }
                        case "MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE": 
                        case "MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK": {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK;
                            break;
                        }
                        case "MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK": {
                            if (!MenuBarController.this.modenaHighContrastYellowonblackThemeMenuItem.isSelected()) break;
                            overridingTheme = EditorPlatform.Theme.MODENA_TOUCH;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            MenuBarController.this.documentWindowController.getEditorController().setTheme(overridingTheme);
            if (GluonEditorPlatform.isGluonMobileLight(overridingTheme)) {
                GluonEditorController.getInstance().setGluonTheme(GluonEditorPlatform.GLUON_MOBILE_LIGHT);
            } else if (GluonEditorPlatform.isGluonMobileDark(overridingTheme)) {
                GluonEditorController.getInstance().setGluonTheme(GluonEditorPlatform.GLUON_MOBILE_DARK);
            }
        }

        @Override
        public boolean isSelected() {
            boolean res;
            if (MenuBarController.this.documentWindowController == null) {
                res = false;
            } else {
                EditorPlatform.Theme currentTheme = MenuBarController.this.documentWindowController.getEditorController().getTheme();
                res = switch (this.theme.name()) {
                    case "GLUON_MOBILE_LIGHT" -> {
                        if (GluonEditorPlatform.GLUON_MOBILE_LIGHT == currentTheme) {
                            yield true;
                        }
                        yield false;
                    }
                    case "GLUON_MOBILE_DARK" -> {
                        if (GluonEditorPlatform.GLUON_MOBILE_DARK == currentTheme) {
                            yield true;
                        }
                        yield false;
                    }
                    case "CASPIAN_HIGH_CONTRAST" -> EditorPlatform.isCaspian(currentTheme);
                    case "CASPIAN" -> {
                        if (currentTheme == this.theme || currentTheme == EditorPlatform.Theme.CASPIAN_HIGH_CONTRAST) {
                            yield true;
                        }
                        yield false;
                    }
                    case "CASPIAN_EMBEDDED" -> {
                        if (currentTheme == this.theme || currentTheme == EditorPlatform.Theme.CASPIAN_EMBEDDED_HIGH_CONTRAST) {
                            yield true;
                        }
                        yield false;
                    }
                    case "CASPIAN_EMBEDDED_QVGA" -> {
                        if (currentTheme == this.theme || currentTheme == EditorPlatform.Theme.CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST) {
                            yield true;
                        }
                        yield false;
                    }
                    case "MODENA_HIGH_CONTRAST_BLACK_ON_WHITE" -> {
                        if (EditorPlatform.isModenaBlackOnWhite(currentTheme) && EditorPlatform.isModenaHighContrast(currentTheme)) {
                            yield true;
                        }
                        yield false;
                    }
                    case "MODENA_HIGH_CONTRAST_WHITE_ON_BLACK" -> {
                        if (EditorPlatform.isModenaWhiteOnBlack(currentTheme) && EditorPlatform.isModenaHighContrast(currentTheme)) {
                            yield true;
                        }
                        yield false;
                    }
                    case "MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK" -> {
                        if (EditorPlatform.isModenaYellowOnBlack(currentTheme) && EditorPlatform.isModenaHighContrast(currentTheme)) {
                            yield true;
                        }
                        yield false;
                    }
                    case "MODENA" -> {
                        if (currentTheme == this.theme || EditorPlatform.isModenaHighContrast(currentTheme) && !EditorPlatform.isModenaTouch(currentTheme)) {
                            yield true;
                        }
                        yield false;
                    }
                    case "MODENA_TOUCH" -> {
                        if (currentTheme == this.theme || EditorPlatform.isModenaTouchHighContrast(currentTheme)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        yield false;
                    }
                };
            }
            return res;
        }
    }

    class GluonActionController
    extends MenuItemController {
        private final EditorPlatform.Theme gluonSwatch;

        public GluonActionController(EditorPlatform.Theme gluonSwatch) {
            super(MenuBarController.this);
            this.gluonSwatch = gluonSwatch;
        }

        public EditorPlatform.Theme getSwatch() {
            return this.gluonSwatch;
        }

        @Override
        public boolean canPerform() {
            EditorPlatform.Theme currentTheme = MenuBarController.this.documentWindowController.getEditorController().getTheme();
            return GluonEditorPlatform.isGluonMobileLight(currentTheme) || GluonEditorPlatform.isGluonMobileDark(currentTheme);
        }

        @Override
        public void perform() {
            GluonEditorController.getInstance().setGluonSwatch(this.gluonSwatch);
            MenuBarController.this.documentWindowController.getEditorController().refreshTheme();
        }

        @Override
        public boolean isSelected() {
            boolean res = false;
            if (MenuBarController.this.documentWindowController == null) {
                res = false;
            } else if (this.gluonSwatch != null) {
                res = this.gluonSwatch == GluonEditorController.getInstance().getGluonSwatch();
            }
            return res;
        }
    }

    class SetSizeActionController
    extends MenuItemController {
        private final EditorController.Size size;

        public SetSizeActionController(EditorController.Size size) {
            super(MenuBarController.this);
            this.size = size;
        }

        @Override
        public boolean canPerform() {
            boolean res = MenuBarController.this.documentWindowController != null && MenuBarController.this.documentWindowController.getPreviewWindowController() != null && MenuBarController.this.documentWindowController.getPreviewWindowController().getStage().isShowing() && !MenuBarController.this.documentWindowController.getEditorController().is3D() && MenuBarController.this.documentWindowController.getEditorController().isNode() && MenuBarController.this.documentWindowController.getPreviewWindowController().sizeDoesFit(this.size);
            return res;
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            assert (MenuBarController.this.documentWindowController.getPreviewWindowController() != null);
            MenuBarController.this.documentWindowController.getPreviewWindowController().setSize(this.size);
        }

        @Override
        public boolean isSelected() {
            EditorController.Size currentSize;
            boolean res = MenuBarController.this.documentWindowController == null || MenuBarController.this.documentWindowController.getPreviewWindowController() == null ? false : this.size == (currentSize = MenuBarController.this.documentWindowController.getPreviewWindowController().getSize()) && MenuBarController.this.documentWindowController.getPreviewWindowController().getStage().isShowing() && !MenuBarController.this.documentWindowController.getPreviewWindowController().userResizedPreviewWindow() && !MenuBarController.this.documentWindowController.getEditorController().is3D() && MenuBarController.this.documentWindowController.getEditorController().isNode();
            return res;
        }

        @Override
        public String getTitle() {
            if (MenuBarController.this.documentWindowController == null) {
                return null;
            }
            if (this.size == EditorController.Size.SIZE_PREFERRED) {
                String title = I18N.getString("menu.title.size.preferred");
                if (MenuBarController.this.documentWindowController.getPreviewWindowController() != null && MenuBarController.this.documentWindowController.getPreviewWindowController().getStage().isShowing() && !MenuBarController.this.documentWindowController.getEditorController().is3D() && MenuBarController.this.documentWindowController.getEditorController().isNode()) {
                    title = I18N.getString("menu.title.size.preferred.with.value", MenuBarController.this.getStringFromDouble(MenuBarController.this.documentWindowController.getPreviewWindowController().getRoot().prefWidth(-1.0)), MenuBarController.this.getStringFromDouble(MenuBarController.this.documentWindowController.getPreviewWindowController().getRoot().prefHeight(-1.0)));
                }
                return title;
            }
            return null;
        }
    }

    abstract class MenuItemController {
        MenuItemController(MenuBarController this$0) {
        }

        public abstract boolean canPerform();

        public abstract void perform();

        public String getTitle() {
            return null;
        }

        public boolean isSelected() {
            return false;
        }
    }

    class ZoomInActionController
    extends MenuItemController {
        ZoomInActionController() {
            super(MenuBarController.this);
        }

        @Override
        public boolean canPerform() {
            ContentPanelController contentPanelController;
            int currentScalingIndex;
            boolean result = MenuBarController.this.documentWindowController == null ? false : (currentScalingIndex = MenuBarController.findZoomScaleIndex((contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController()).getScaling())) + 1 < scalingTable.length;
            return result;
        }

        @Override
        public void perform() {
            ContentPanelController contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController();
            int currentScalingIndex = MenuBarController.findZoomScaleIndex(contentPanelController.getScaling());
            double newScaling = scalingTable[currentScalingIndex + 1];
            contentPanelController.setScaling(newScaling);
        }
    }

    class ZoomOutActionController
    extends MenuItemController {
        ZoomOutActionController() {
            super(MenuBarController.this);
        }

        @Override
        public boolean canPerform() {
            ContentPanelController contentPanelController;
            int currentScalingIndex;
            boolean result = MenuBarController.this.documentWindowController == null ? false : 0 <= (currentScalingIndex = MenuBarController.findZoomScaleIndex((contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController()).getScaling())) - 1;
            return result;
        }

        @Override
        public void perform() {
            ContentPanelController contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController();
            int currentScalingIndex = MenuBarController.findZoomScaleIndex(contentPanelController.getScaling());
            double newScaling = scalingTable[currentScalingIndex - 1];
            contentPanelController.setScaling(newScaling);
        }
    }

    class SetZoomActionController
    extends MenuItemController {
        private final double scaling;

        public SetZoomActionController(double scaling) {
            super(MenuBarController.this);
            this.scaling = scaling;
        }

        @Override
        public boolean canPerform() {
            return MenuBarController.this.documentWindowController != null;
        }

        @Override
        public void perform() {
            ContentPanelController contentPanelController = MenuBarController.this.documentWindowController.getContentPanelController();
            double currentScaling = contentPanelController.getScaling();
            if (!MathUtils.equals(currentScaling, this.scaling)) {
                contentPanelController.setScaling(this.scaling);
            }
        }

        @Override
        public boolean isSelected() {
            boolean result;
            if (MenuBarController.this.documentWindowController == null) {
                result = false;
            } else {
                double currentScaling = MenuBarController.this.documentWindowController.getContentPanelController().getScaling();
                result = MathUtils.equals(currentScaling, this.scaling);
            }
            return result;
        }
    }

    private static class ClearOpenRecentHandler
    implements EventHandler<ActionEvent> {
        private ClearOpenRecentHandler() {
        }

        public void handle(ActionEvent t) {
            PreferencesController pc = PreferencesController.getSingleton();
            pc.clearRecentItems();
        }
    }

    class RemoveSceneStyleSheetActionController
    extends MenuItemController {
        private final File styleSheet;

        public RemoveSceneStyleSheetActionController(File file) {
            super(MenuBarController.this);
            this.styleSheet = file;
        }

        @Override
        public boolean canPerform() {
            return MenuBarController.this.documentWindowController != null && this.styleSheet.exists();
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            MenuBarController.this.documentWindowController.getSceneStyleSheetMenuController().performRemoveSceneStyleSheet(this.styleSheet);
        }

        @Override
        public String getTitle() {
            return this.styleSheet.getName();
        }
    }

    class OpenSceneStyleSheetActionController
    extends MenuItemController {
        private final File styleSheet;

        public OpenSceneStyleSheetActionController(File file) {
            super(MenuBarController.this);
            this.styleSheet = file;
        }

        @Override
        public boolean canPerform() {
            return MenuBarController.this.documentWindowController != null && this.styleSheet.exists();
        }

        @Override
        public void perform() {
            assert (MenuBarController.this.documentWindowController != null);
            MenuBarController.this.documentWindowController.getSceneStyleSheetMenuController().performOpenSceneStyleSheet(this.styleSheet);
        }

        @Override
        public String getTitle() {
            return this.styleSheet.getName();
        }
    }

    class AddEffectActionController
    extends MenuItemController {
        private final Class<? extends Effect> effectClass;

        public AddEffectActionController(Class<? extends Effect> effectClass) {
            super(MenuBarController.this);
            this.effectClass = effectClass;
        }

        @Override
        public boolean canPerform() {
            boolean result = MenuBarController.this.documentWindowController == null || !MenuBarController.this.documentWindowController.getStage().isFocused() ? false : MenuBarController.this.documentWindowController.getEditorController().canPerformSetEffect();
            return result;
        }

        @Override
        public void perform() {
            MenuBarController.this.documentWindowController.getEditorController().performSetEffect(this.effectClass);
        }
    }

    private static class WindowMenuEventHandler
    implements EventHandler<ActionEvent> {
        private final DocumentWindowController dwc;

        public WindowMenuEventHandler(DocumentWindowController dwc) {
            this.dwc = dwc;
        }

        public void handle(ActionEvent t) {
            this.dwc.getStage().toFront();
        }
    }
}

