/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.message;

import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.messagelog.MessageLogEntry;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlPanelController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class MessagePanelController
extends AbstractFxmlPanelController {
    private double panelWidth;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button clearButton;

    @FXML
    public void onClear(ActionEvent event) {
        this.getEditorController().getMessageLog().clear();
    }

    public MessagePanelController(EditorController editorController) {
        super(MessagePanelController.class.getResource("MessagePanel.fxml"), I18N.getBundle(), editorController);
    }

    public void setPanelWidth(double panelWidth) {
        this.panelWidth = panelWidth;
        if (this.scrollPane != null) {
            this.updateScrollPaneWidth();
        }
    }

    @Override
    protected void fxomDocumentDidChange(FXOMDocument oldDocument) {
    }

    @Override
    protected void sceneGraphRevisionDidChange() {
    }

    @Override
    protected void cssRevisionDidChange() {
    }

    @Override
    protected void jobManagerRevisionDidChange() {
    }

    @Override
    protected void editorSelectionDidChange() {
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.scrollPane != null);
        assert (this.gridPane != null);
        assert (this.clearButton != null);
        this.getEditorController().getMessageLog().revisionProperty().addListener((ov, t, t1) -> this.messageLogDidChange());
        this.updateScrollPaneWidth();
        this.messageLogDidChange();
    }

    private void messageLogDidChange() {
        assert (this.gridPane != null);
        this.gridPane.getChildren().clear();
        int rowIndex = 0;
        int columnIndex = 0;
        for (MessageLogEntry mle : this.getEditorController().getMessageLog().getEntries()) {
            if (mle.getType() != MessageLogEntry.Type.WARNING) continue;
            Button dismissButton = new Button("x");
            dismissButton.addEventHandler(MouseEvent.MOUSE_RELEASED, t -> this.getEditorController().getMessageLog().clearEntry(mle));
            StackPane paneForButton = new StackPane();
            paneForButton.getChildren().add((Object)dismissButton);
            paneForButton.setAlignment(Pos.CENTER_RIGHT);
            Label msgLabel = new Label(mle.getText());
            msgLabel.setTooltip(new Tooltip(mle.getText()));
            Label timestampLabel = new Label(mle.getTimestamp());
            timestampLabel.getStyleClass().add((Object)"timestamp");
            VBox labelBox = new VBox();
            labelBox.getChildren().addAll((Object[])new Node[]{timestampLabel, msgLabel});
            StackPane paneForLabel = new StackPane();
            paneForLabel.getChildren().add((Object)labelBox);
            paneForLabel.setAlignment(Pos.CENTER_LEFT);
            this.gridPane.add((Node)paneForLabel, columnIndex, rowIndex);
            this.gridPane.add((Node)paneForButton, ++columnIndex, rowIndex);
            --columnIndex;
            ++rowIndex;
        }
    }

    private void updateScrollPaneWidth() {
        assert (this.scrollPane != null);
        this.scrollPane.setPrefWidth(this.panelWidth);
    }
}

