/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.message;

import com.oracle.javafx.scenebuilder.app.message.MessagePanelController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractPopupController;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.stage.WindowEvent;

public class MessagePopupController
extends AbstractPopupController {
    private final MessagePanelController messagePanelController;

    public MessagePopupController(EditorController editorController) {
        this.messagePanelController = new MessagePanelController(editorController);
    }

    @Override
    protected void makeRoot() {
        this.setRoot(this.messagePanelController.getPanelRoot());
    }

    @Override
    protected void onHidden(WindowEvent event) {
    }

    @Override
    protected void anchorBoundsDidChange() {
        Bounds lb = this.getAnchor().getLayoutBounds();
        this.messagePanelController.setPanelWidth(lb.getWidth());
        this.updatePopupLocation();
    }

    @Override
    protected void anchorTransformDidChange() {
        this.updatePopupLocation();
    }

    @Override
    protected void anchorXYDidChange() {
        this.updatePopupLocation();
    }

    @Override
    protected void controllerDidCreatePopup() {
        this.getPopup().setAutoFix(false);
        this.getPopup().setAutoHide(true);
    }

    @Override
    protected void updatePopupLocation() {
        Bounds anchorBounds = this.getAnchor().getLayoutBounds();
        assert (anchorBounds != null);
        if (this.getAnchor().getScene() != null) {
            Point2D popupLocation = this.getAnchor().localToScreen(anchorBounds.getMinX(), anchorBounds.getMaxY());
            this.getPopup().setX(popupLocation.getX());
            this.getPopup().setY(popupLocation.getY());
        }
    }
}

