/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preferences;

import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordDocument;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesControllerBase;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesController
extends PreferencesControllerBase {
    static final String SB_RELEASE_NODE = "SB_2.0";
    static final String TOOL_THEME = "TOOL_THEME";
    static final String CSS_TABLE_COLUMNS_ORDERING_REVERSED = "CSS_TABLE_COLUMNS_ORDERING_REVERSED";
    static final String RECENT_ITEMS = "RECENT_ITEMS";
    static final String RECENT_ITEMS_SIZE = "RECENT_ITEMS_SIZE";
    static final String REGISTRATION_HASH = "REGISTRATION_HASH";
    static final String REGISTRATION_EMAIL = "REGISTRATION_EMAIL";
    static final String REGISTRATION_OPT_IN = "REGISTRATION_OPT_IN";
    static final String UPDATE_DIALOG_DATE = "UPDATE_DIALOG_DATE";
    static final String IGNORE_VERSION = "IGNORE_VERSION";
    static final String IMPORTED_GLUON_JARS = "IMPORTED_GLUON_JARS";
    static final String LAST_SENT_TRACKING_INFO_DATE = "LAST_SENT_TRACKING_INFO_DATE";
    static final String BOTTOM_VISIBLE = "bottomVisible";
    static final String LEFT_VISIBLE = "leftVisible";
    static final String RIGHT_VISIBLE = "rightVisible";
    static final String LIBRARY_VISIBLE = "libraryVisible";
    static final String DOCUMENT_VISIBLE = "documentVisible";
    static final String INSPECTOR_SECTION_ID = "inspectorSectionId";
    static final String LEFT_DIVIDER_HPOS = "leftDividerHPos";
    static final String RIGHT_DIVIDER_HPOS = "rightDividerHPos";
    static final String BOTTOM_DIVIDER_VPOS = "bottomDividerVPos";
    static final String LEFT_DIVIDER_VPOS = "leftDividerVPos";
    static final String GLUON_SWATCH = "gluonSwatch";
    static final String GLUON_THEME = "gluonTheme";
    private static PreferencesController singleton;
    private final Map<DocumentWindowController, PreferencesRecordDocument> recordDocuments = new HashMap<DocumentWindowController, PreferencesRecordDocument>();

    private PreferencesController() {
        super(SB_RELEASE_NODE, new PreferencesRecordGlobal());
        String items = this.applicationRootPreferences.get(RECENT_ITEMS, null);
        if (items != null && !items.isEmpty()) {
            try {
                String[] childrenNames;
                for (String child : childrenNames = this.documentsRootPreferences.childrenNames()) {
                    Preferences documentPreferences = this.documentsRootPreferences.node(child);
                    String nodePath = documentPreferences.get("path", null);
                    if (nodePath != null && !nodePath.isEmpty()) continue;
                    documentPreferences.removeNode();
                }
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PreferencesController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static synchronized PreferencesController getSingleton() {
        if (singleton == null) {
            singleton = new PreferencesController();
            singleton.getRecordGlobal().readFromJavaPreferences();
        }
        return singleton;
    }

    public PreferencesRecordDocument getRecordDocument(DocumentWindowController dwc) {
        PreferencesRecordDocument recordDocument;
        if (this.recordDocuments.containsKey(dwc)) {
            recordDocument = this.recordDocuments.get(dwc);
        } else {
            recordDocument = new PreferencesRecordDocument(this.documentsRootPreferences, dwc);
            this.recordDocuments.put(dwc, recordDocument);
        }
        return recordDocument;
    }

    public void clearRecentItems() {
        this.getRecordGlobal().clearRecentItems();
        try {
            for (String child : this.documentsRootPreferences.childrenNames()) {
                Preferences documentPreferences = this.documentsRootPreferences.node(child);
                documentPreferences.removeNode();
            }
            for (PreferencesRecordDocument prd : this.recordDocuments.values()) {
                prd.resetDocumentPreferences();
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public PreferencesRecordGlobal getRecordGlobal() {
        return (PreferencesRecordGlobal)this.recordGlobal;
    }
}

