/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preferences;

import com.gluonhq.scenebuilder.plugins.editor.GluonEditorController;
import com.gluonhq.scenebuilder.plugins.editor.GluonEditorPlatform;
import com.oracle.javafx.scenebuilder.app.DocumentWindowController;
import com.oracle.javafx.scenebuilder.app.SplitController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.InspectorPanelController;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Accordion;
import javafx.stage.Stage;

public class PreferencesRecordDocument {
    private static final double UNDEFINED_POS = -1.0;
    private static final double DEFAULT_X_POS = -1.0;
    private static final double DEFAULT_Y_POS = -1.0;
    private static final double DEFAULT_STAGE_HEIGHT = 800.0;
    private static final double DEFAULT_STAGE_WIDTH = 1240.0;
    private static final boolean DEFAULT_BOTTOM_VISIBLE = false;
    private static final boolean DEFAULT_LEFT_VISIBLE = true;
    private static final boolean DEFAULT_RIGHT_VISIBLE = true;
    private static final boolean DEFAULT_LIBRARY_VISIBLE = true;
    private static final boolean DEFAULT_DOCUMENT_VISIBLE = true;
    private static final InspectorPanelController.SectionId DEFAULT_INSPECTOR_SECTION_ID = InspectorPanelController.SectionId.PROPERTIES;
    private static final double DEFAULT_LEFT_DIVIDER_HPOS = -1.0;
    private static final double DEFAULT_RIGHT_DIVIDER_HPOS = -1.0;
    private static final double DEFAULT_BOTTOM_DIVIDER_VPOS = -1.0;
    private static final double DEFAULT_LEFT_DIVIDER_VPOS = -1.0;
    private double xPos = -1.0;
    private double yPos = -1.0;
    private double stageHeight = 800.0;
    private double stageWidth = 1240.0;
    private boolean bottomVisible = false;
    private boolean leftVisible = true;
    private boolean rightVisible = true;
    private boolean libraryVisible = true;
    private boolean documentVisible = true;
    private InspectorPanelController.SectionId inspectorSectionId = DEFAULT_INSPECTOR_SECTION_ID;
    private double leftDividerHPos = -1.0;
    private double rightDividerHPos = -1.0;
    private double bottomDividerVPos = -1.0;
    private double leftDividerVPos = -1.0;
    private final List<String> sceneStyleSheets = new ArrayList<String>();
    private String I18NResource = null;
    private EditorPlatform.Theme theme;
    private EditorPlatform.Theme gluonSwatch;
    private EditorPlatform.Theme gluonTheme;
    private Preferences documentPreferences;
    private final Preferences documentsRootPreferences;
    private final DocumentWindowController documentWindowController;
    private final ChangeListener<Number> leftDividerHListener = (ov, t, t1) -> this.setLeftDividerHPos(t1.doubleValue());
    private final ChangeListener<Number> rightDividerHListener = (ov, t, t1) -> this.setRightDividerHPos(t1.doubleValue());
    private final ChangeListener<Number> bottomDividerVListener = (ov, t, t1) -> this.setBottomDividerVPos(t1.doubleValue());
    private final ChangeListener<Number> leftDividerVListener = (ov, t, t1) -> this.setLeftDividerVPos(t1.doubleValue());
    private final ChangeListener<ObservableList<File>> sceneStyleSheetsListener = (ov, t, t1) -> this.setSceneStyleSheets((ObservableList<File>)t1);

    public PreferencesRecordDocument(Preferences documentsRootPreferences, DocumentWindowController dwc) {
        this.documentWindowController = dwc;
        this.documentsRootPreferences = documentsRootPreferences;
        Stage stage = this.documentWindowController.getStage();
        assert (stage != null);
        stage.xProperty().addListener((ov, t, t1) -> this.setXPos(t1.doubleValue()));
        stage.yProperty().addListener((ov, t, t1) -> this.setYPos(t1.doubleValue()));
        stage.heightProperty().addListener((ov, t, t1) -> this.setStageHeight(t1.doubleValue()));
        stage.widthProperty().addListener((ov, t, t1) -> this.setStageWidth(t1.doubleValue()));
        InspectorPanelController ipc = this.documentWindowController.getInspectorPanelController();
        assert (ipc != null);
        Accordion accordion = ipc.getAccordion();
        assert (accordion != null);
        accordion.expandedPaneProperty().addListener((ov, t, t1) -> this.setInspectorSectionId(ipc.getExpandedSectionId()));
        SplitController lhsc = this.documentWindowController.getLeftSplitController();
        lhsc.position().addListener(this.leftDividerHListener);
        SplitController rhsc = this.documentWindowController.getRightSplitController();
        rhsc.position().addListener(this.rightDividerHListener);
        SplitController bvsc = this.documentWindowController.getBottomSplitController();
        bvsc.position().addListener(this.bottomDividerVListener);
        SplitController lvsc = this.documentWindowController.getLibrarySplitController();
        lvsc.position().addListener(this.leftDividerVListener);
        EditorController ec = this.documentWindowController.getEditorController();
        ec.sceneStyleSheetProperty().addListener(this.sceneStyleSheetsListener);
        ec.themeProperty().addListener((observable, oldValue, newValue) -> this.setTheme((EditorPlatform.Theme)newValue));
        GluonEditorController.getInstance().gluonSwatchProperty().addListener((observable, oldValue, newValue) -> this.setGluonSwatch((EditorPlatform.Theme)newValue));
        GluonEditorController.getInstance().gluonThemeProperty().addListener((observable, oldValue, newValue) -> this.setGluonTheme((EditorPlatform.Theme)newValue));
    }

    public void resetDocumentPreferences() {
        this.documentPreferences = null;
    }

    public double getXPos() {
        return this.xPos;
    }

    public void setXPos(double value) {
        this.xPos = value;
    }

    public double getYPos() {
        return this.yPos;
    }

    public void setYPos(double value) {
        this.yPos = value;
    }

    public double getStageHeight() {
        return this.stageHeight;
    }

    public void setStageHeight(double value) {
        this.stageHeight = value;
    }

    public double getStageWidth() {
        return this.stageWidth;
    }

    public void setStageWidth(double value) {
        this.stageWidth = value;
    }

    public boolean getBottomVisible() {
        return this.bottomVisible;
    }

    public void setBottomVisible(boolean value) {
        this.bottomVisible = value;
    }

    public boolean getLeftVisible() {
        return this.leftVisible;
    }

    public void setLeftVisible(boolean value) {
        this.leftVisible = value;
    }

    public boolean getRightVisible() {
        return this.rightVisible;
    }

    public void setRightVisible(boolean value) {
        this.rightVisible = value;
    }

    public boolean getLibraryVisible() {
        return this.libraryVisible;
    }

    public void setLibraryVisible(boolean value) {
        this.libraryVisible = value;
    }

    public boolean getDocumentVisible() {
        return this.documentVisible;
    }

    public void setDocumentVisible(boolean value) {
        this.documentVisible = value;
    }

    public InspectorPanelController.SectionId getInspectorSectionId() {
        return this.inspectorSectionId;
    }

    public void setInspectorSectionId(InspectorPanelController.SectionId value) {
        this.inspectorSectionId = value;
    }

    public double getLeftDividerHPos() {
        return this.leftDividerHPos;
    }

    public void setLeftDividerHPos(double value) {
        this.leftDividerHPos = value;
    }

    public double getRightDividerHPos() {
        return this.rightDividerHPos;
    }

    public void setRightDividerHPos(double value) {
        this.rightDividerHPos = value;
    }

    public double getBottomDividerVPos() {
        return this.bottomDividerVPos;
    }

    public void setBottomDividerVPos(double value) {
        this.bottomDividerVPos = value;
    }

    public double getLeftividerVPos() {
        return this.leftDividerVPos;
    }

    public void setLeftDividerVPos(double value) {
        this.leftDividerVPos = value;
    }

    public List<String> getSceneStyleSheets() {
        return this.sceneStyleSheets;
    }

    public void setSceneStyleSheets(ObservableList<File> files) {
        this.sceneStyleSheets.clear();
        for (File file : files) {
            String filePath = file.getPath();
            this.sceneStyleSheets.add(filePath);
        }
    }

    public void removeSceneStyleSheet(String filePath) {
        this.sceneStyleSheets.remove(filePath);
    }

    public void removeSceneStyleSheet(List<String> filePaths) {
        for (String filePath : filePaths) {
            this.removeSceneStyleSheet(filePath);
        }
    }

    public String getI18NResource() {
        return this.I18NResource;
    }

    public void setI18NResource(String value) {
        this.I18NResource = value;
    }

    public void setI18NResourceFile(File file) {
        if (file != null) {
            this.I18NResource = file.getPath();
        }
    }

    private void setTheme(EditorPlatform.Theme theme) {
        this.theme = theme;
    }

    private EditorPlatform.Theme getTheme() {
        if (this.theme == null) {
            this.theme = this.documentWindowController.getEditorController().getTheme();
        }
        return this.theme;
    }

    public void setGluonSwatch(EditorPlatform.Theme gluonSwatch) {
        this.gluonSwatch = gluonSwatch;
    }

    public EditorPlatform.Theme getGluonSwatch() {
        if (this.gluonSwatch == null) {
            return GluonEditorController.getInstance().getGluonSwatch();
        }
        return this.gluonSwatch;
    }

    public void setGluonTheme(EditorPlatform.Theme gluonTheme) {
        this.gluonTheme = gluonTheme;
    }

    public EditorPlatform.Theme getGluonTheme() {
        if (this.gluonTheme == null) {
            return GluonEditorController.getInstance().getGluonTheme();
        }
        return this.gluonTheme;
    }

    public void refreshXPos() {
        if (this.xPos != -1.0) {
            this.documentWindowController.getStage().setX(this.xPos);
        }
    }

    public void refreshYPos() {
        if (this.yPos != -1.0) {
            this.documentWindowController.getStage().setY(this.yPos);
        }
    }

    public void refreshStageHeight() {
        this.documentWindowController.getStage().setHeight(this.stageHeight);
    }

    public void refreshStageWidth() {
        this.documentWindowController.getStage().setWidth(this.stageWidth);
    }

    public void refreshInspectorSectionId() {
        InspectorPanelController ipc = this.documentWindowController.getInspectorPanelController();
        ipc.setExpandedSection(this.inspectorSectionId);
    }

    public void refreshBottomVisible() {
        SplitController sc = this.documentWindowController.getBottomSplitController();
        if (this.bottomVisible) {
            this.documentWindowController.initializeCssPanel();
        }
        sc.setTargetVisible(this.bottomVisible);
    }

    public void refreshLeftVisible() {
        SplitController sc = this.documentWindowController.getLeftSplitController();
        sc.setTargetVisible(this.leftVisible);
    }

    public void refreshRightVisible() {
        SplitController sc = this.documentWindowController.getRightSplitController();
        sc.setTargetVisible(this.rightVisible);
    }

    public void refreshLibraryVisible() {
        SplitController sc = this.documentWindowController.getLibrarySplitController();
        sc.setTargetVisible(this.libraryVisible);
    }

    public void refreshDocumentVisible() {
        SplitController sc = this.documentWindowController.getDocumentSplitController();
        sc.setTargetVisible(this.documentVisible);
    }

    public void refreshLeftDividerHPos() {
        SplitController sc = this.documentWindowController.getLeftSplitController();
        if (this.leftDividerHPos != -1.0) {
            sc.setPosition(this.leftDividerHPos);
        }
    }

    public void refreshRightDividerHPos() {
        SplitController sc = this.documentWindowController.getRightSplitController();
        if (this.rightDividerHPos != -1.0) {
            sc.setPosition(this.rightDividerHPos);
        }
    }

    public void refreshBottomDividerVPos() {
        SplitController sc = this.documentWindowController.getBottomSplitController();
        if (this.bottomDividerVPos != -1.0) {
            sc.setPosition(this.bottomDividerVPos);
        }
    }

    public void refreshLeftDividerVPos() {
        SplitController sc = this.documentWindowController.getLibrarySplitController();
        if (this.leftDividerVPos != -1.0) {
            sc.setPosition(this.leftDividerVPos);
        }
    }

    public void refreshSceneStyleSheets() {
        if (!this.sceneStyleSheets.isEmpty()) {
            ObservableList files = FXCollections.observableArrayList();
            ArrayList<String> filePathsToRemove = new ArrayList<String>();
            for (String sceneStyleSheet : this.sceneStyleSheets) {
                File file = new File(sceneStyleSheet);
                if (file.exists()) {
                    files.add((Object)file);
                    continue;
                }
                filePathsToRemove.add(sceneStyleSheet);
            }
            EditorController ec = this.documentWindowController.getEditorController();
            ec.setSceneStyleSheets((ObservableList<File>)files);
            if (!filePathsToRemove.isEmpty()) {
                this.removeSceneStyleSheet(filePathsToRemove);
            }
        }
    }

    public void refreshI18NResource() {
        if (this.I18NResource != null) {
            File file = new File(this.I18NResource);
            if (file.exists()) {
                this.documentWindowController.setResourceFile(file);
            } else {
                this.setI18NResource(null);
            }
        }
    }

    public void refreshTheme() {
        if (this.theme == null) {
            return;
        }
        EditorController editorController = this.documentWindowController.getEditorController();
        editorController.setTheme(this.theme);
    }

    public void refreshGluonSwatch() {
        if (this.gluonSwatch == null) {
            return;
        }
        GluonEditorController.getInstance().setGluonSwatch(this.gluonSwatch);
    }

    public void refreshGluonTheme() {
        if (this.gluonTheme == null) {
            return;
        }
        GluonEditorController.getInstance().setGluonTheme(this.gluonTheme);
    }

    public void refresh() {
        this.refreshXPos();
        this.refreshYPos();
        this.refreshStageHeight();
        this.refreshStageWidth();
        this.refreshInspectorSectionId();
        this.refreshBottomVisible();
        this.refreshLeftVisible();
        this.refreshRightVisible();
        this.refreshLibraryVisible();
        this.refreshDocumentVisible();
        this.refreshLeftDividerHPos();
        this.refreshRightDividerHPos();
        this.refreshBottomDividerVPos();
        this.refreshLeftDividerVPos();
        this.refreshSceneStyleSheets();
        this.refreshI18NResource();
        this.refreshTheme();
        this.refreshGluonSwatch();
        this.refreshGluonTheme();
    }

    public void readFromJavaPreferences() {
        assert (this.documentPreferences == null);
        URL fxmlLocation = this.documentWindowController.getEditorController().getFxmlLocation();
        if (fxmlLocation == null) {
            return;
        }
        try {
            String[] childrenNames;
            File fxmlFile = new File(fxmlLocation.toURI());
            String filePath = fxmlFile.getPath();
            for (String child : childrenNames = this.documentsRootPreferences.childrenNames()) {
                Preferences pref = this.documentsRootPreferences.node(child);
                String nodePath = pref.get("path", null);
                assert (nodePath != null && !nodePath.isEmpty());
                if (!filePath.equals(nodePath)) continue;
                this.documentPreferences = pref;
                break;
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesRecordDocument.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PreferencesRecordDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.documentPreferences == null) {
            return;
        }
        double xpos = this.documentPreferences.getDouble("X", -1.0);
        if (xpos < 0.0) {
            xpos = -1.0;
        }
        this.setXPos(xpos);
        double ypos = this.documentPreferences.getDouble("Y", -1.0);
        if (ypos < 0.0) {
            ypos = -1.0;
        }
        this.setYPos(ypos);
        double h = this.documentPreferences.getDouble("height", 800.0);
        if (h < 0.0) {
            h = 800.0;
        }
        this.setStageHeight(h);
        double w = this.documentPreferences.getDouble("width", 1240.0);
        if (w < 0.0) {
            w = 1240.0;
        }
        this.setStageWidth(w);
        boolean bv = this.documentPreferences.getBoolean("bottomVisible", false);
        this.setBottomVisible(bv);
        boolean lv = this.documentPreferences.getBoolean("leftVisible", true);
        this.setLeftVisible(lv);
        boolean rv = this.documentPreferences.getBoolean("rightVisible", true);
        this.setRightVisible(rv);
        boolean libv = this.documentPreferences.getBoolean("libraryVisible", true);
        this.setLibraryVisible(lv && libv);
        boolean docv = this.documentPreferences.getBoolean("documentVisible", true);
        this.setDocumentVisible(lv && docv);
        String sectionId = this.documentPreferences.get("inspectorSectionId", DEFAULT_INSPECTOR_SECTION_ID.name());
        this.setInspectorSectionId(InspectorPanelController.SectionId.valueOf(sectionId));
        double ldhp = this.documentPreferences.getDouble("leftDividerHPos", -1.0);
        this.setLeftDividerHPos(ldhp);
        double rdhp = this.documentPreferences.getDouble("rightDividerHPos", -1.0);
        this.setRightDividerHPos(rdhp);
        double bdvp = this.documentPreferences.getDouble("bottomDividerVPos", -1.0);
        this.setBottomDividerVPos(bdvp);
        double ldvp = this.documentPreferences.getDouble("leftDividerVPos", -1.0);
        this.setLeftDividerVPos(ldvp);
        String items = this.documentPreferences.get("sceneStyleSheets", null);
        if (items != null) {
            String[] itemsArray = items.split(File.pathSeparator);
            this.sceneStyleSheets.addAll(Arrays.asList(itemsArray));
        }
        String resource = this.documentPreferences.get("I18NResource", null);
        this.setI18NResource(resource);
        String theme = this.documentPreferences.get("theme", null);
        if (theme != null) {
            this.setTheme(EditorPlatform.Theme.valueOf(theme));
        } else {
            this.setTheme(this.documentWindowController.getEditorController().getTheme());
        }
        String gluonSwatch = this.documentPreferences.get("gluonSwatch", null);
        if (gluonSwatch != null) {
            this.setGluonSwatch(EditorPlatform.Theme.valueOf(gluonSwatch));
        } else {
            this.setGluonSwatch(GluonEditorController.getInstance().getGluonSwatch());
        }
        String gluonTheme = this.documentPreferences.get("gluonTheme", null);
        if (gluonTheme != null) {
            this.setGluonTheme(EditorPlatform.Theme.valueOf(gluonTheme));
        } else {
            this.setGluonTheme(GluonEditorController.getInstance().getGluonTheme());
        }
    }

    public void writeToJavaPreferences() {
        URL fxmlLocation = this.documentWindowController.getEditorController().getFxmlLocation();
        if (fxmlLocation == null) {
            return;
        }
        if (this.documentPreferences == null) {
            try {
                File fxmlFile = new File(fxmlLocation.toURI());
                String filePath = fxmlFile.getPath();
                String key = this.generateKey(fxmlFile.getName());
                assert (!this.documentsRootPreferences.nodeExists(key));
                this.documentPreferences = this.documentsRootPreferences.node(key);
                this.documentPreferences.put("path", filePath);
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PreferencesRecordDocument.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(PreferencesRecordDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        assert (this.documentPreferences != null);
        this.documentPreferences.putDouble("X", this.getXPos());
        this.documentPreferences.putDouble("Y", this.getYPos());
        this.documentPreferences.putDouble("height", this.getStageHeight());
        this.documentPreferences.putDouble("width", this.getStageWidth());
        this.documentPreferences.putBoolean("bottomVisible", this.getBottomVisible());
        this.documentPreferences.putBoolean("leftVisible", this.getLeftVisible());
        this.documentPreferences.putBoolean("rightVisible", this.getRightVisible());
        this.documentPreferences.putBoolean("libraryVisible", this.getLibraryVisible());
        this.documentPreferences.putBoolean("documentVisible", this.getDocumentVisible());
        if (this.getInspectorSectionId() != null) {
            this.documentPreferences.put("inspectorSectionId", this.getInspectorSectionId().name());
        }
        this.documentPreferences.putDouble("leftDividerHPos", this.getLeftDividerHPos());
        this.documentPreferences.putDouble("rightDividerHPos", this.getRightDividerHPos());
        this.documentPreferences.putDouble("bottomDividerVPos", this.getBottomDividerVPos());
        this.documentPreferences.putDouble("leftDividerVPos", this.getLeftividerVPos());
        StringBuilder sb = new StringBuilder();
        for (String sceneStyleSheet : this.getSceneStyleSheets()) {
            sb.append(sceneStyleSheet);
            sb.append(File.pathSeparator);
        }
        this.documentPreferences.put("sceneStyleSheets", sb.toString());
        String resource = this.getI18NResource();
        if (resource != null) {
            this.documentPreferences.put("I18NResource", resource);
        } else {
            this.documentPreferences.remove("I18NResource");
        }
        EditorPlatform.Theme docTheme = this.getTheme();
        this.documentPreferences.put("theme", docTheme.name());
        if (GluonEditorPlatform.isGluonMobileLight(docTheme) || GluonEditorPlatform.isGluonMobileDark(docTheme)) {
            this.documentPreferences.put("gluonSwatch", this.getGluonSwatch().name());
            this.documentPreferences.put("gluonTheme", this.getGluonTheme().name());
        } else {
            this.documentPreferences.remove("gluonSwatch");
            this.documentPreferences.remove("gluonTheme");
        }
    }

    private String generateKey(String name) throws BackingStoreException {
        Object key = name;
        if (((String)key).length() > 80) {
            key = name.substring(0, 80);
        }
        int prefix = 1;
        int max = 20;
        while (this.documentsRootPreferences.nodeExists((String)key) && prefix < max) {
            if (((String)(key = prefix++ + "_" + name)).length() <= 80) continue;
            key = ((String)key).substring(0, 80);
        }
        return key;
    }
}

