/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preferences;

import com.gluonhq.scenebuilder.plugins.editor.GluonEditorPlatform;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.ToolTheme;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordGlobalBase;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreferencesRecordGlobal
extends PreferencesRecordGlobalBase {
    static final double DEFAULT_ROOT_CONTAINER_HEIGHT = 400.0;
    static final double DEFAULT_ROOT_CONTAINER_WIDTH = 600.0;
    static final ToolTheme DEFAULT_TOOL_THEME = ToolTheme.DEFAULT;
    static final LibraryPanelController.DISPLAY_MODE DEFAULT_LIBRARY_DISPLAY_OPTION = LibraryPanelController.DISPLAY_MODE.SECTIONS;
    static final AbstractHierarchyPanelController.DisplayOption DEFAULT_HIERARCHY_DISPLAY_OPTION = AbstractHierarchyPanelController.DisplayOption.INFO;
    static final boolean DEFAULT_CSS_TABLE_COLUMNS_ORDERING_REVERSED = false;
    static final int DEFAULT_RECENT_ITEMS_SIZE = 15;
    static final boolean DEFAULT_ACCORDION_ANIMATION = true;
    static final boolean DEFAULT_WILDCARD_IMPORTS = false;
    static final boolean DEFAULT_ALTERNATE_TEXT_INPUT_PASTE = EditorPlatform.IS_MAC;
    static final EditorPlatform.Theme DEFAULT_GLUON_SWATCH = GluonEditorPlatform.DEFAULT_GLUON_SWATCH;
    static final EditorPlatform.Theme DEFAULT_GLUON_THEME = GluonEditorPlatform.DEFAULT_GLUON_THEME;
    private EditorPlatform.Theme gluonSwatch = DEFAULT_GLUON_SWATCH;
    private EditorPlatform.Theme gluonTheme = DEFAULT_GLUON_THEME;
    private ToolTheme toolTheme = DEFAULT_TOOL_THEME;
    private LibraryPanelController.DISPLAY_MODE libraryDisplayOption = DEFAULT_LIBRARY_DISPLAY_OPTION;
    private AbstractHierarchyPanelController.DisplayOption hierarchyDisplayOption = DEFAULT_HIERARCHY_DISPLAY_OPTION;
    private boolean cssTableColumnsOrderingReversed = false;
    private int recentItemsSize = 15;
    private boolean accordionAnimation = true;
    private boolean wildcardImports = false;
    private final List<String> recentItems = new ArrayList<String>();
    private LocalDate showUpdateDialogDate = null;
    private String ignoreVersion = null;
    private String[] importedGluonJars = new String[0];
    private String registrationHash = null;
    private String registrationEmail = null;
    private boolean registrationOptIn = false;
    private LocalDate lastSentTrackingInfoDate = null;
    private boolean alternatePasteBehavior = true;
    static final Integer[] recentItemsSizes = new Integer[]{5, 10, 15, 20};

    public ToolTheme getToolTheme() {
        return this.toolTheme;
    }

    public void setToolTheme(ToolTheme value) {
        this.toolTheme = value;
    }

    public EditorPlatform.Theme getSwatch() {
        return this.gluonSwatch;
    }

    public void setSwatch(EditorPlatform.Theme swatch) {
        this.gluonSwatch = swatch;
    }

    public EditorPlatform.Theme getGluonTheme() {
        return this.gluonTheme;
    }

    public void setGluonTheme(EditorPlatform.Theme theme) {
        this.gluonTheme = theme;
    }

    public LibraryPanelController.DISPLAY_MODE getLibraryDisplayOption() {
        return this.libraryDisplayOption;
    }

    public void setLibraryDisplayOption(LibraryPanelController.DISPLAY_MODE value) {
        this.libraryDisplayOption = value;
    }

    public void updateLibraryDisplayOption(LibraryPanelController.DISPLAY_MODE value) {
        this.libraryDisplayOption = value;
        this.writeToJavaPreferences("LIBRARY_DISPLAY_OPTION");
    }

    public AbstractHierarchyPanelController.DisplayOption getHierarchyDisplayOption() {
        return this.hierarchyDisplayOption;
    }

    public void setHierarchyDisplayOption(AbstractHierarchyPanelController.DisplayOption value) {
        this.hierarchyDisplayOption = value;
    }

    public void updateHierarchyDisplayOption(AbstractHierarchyPanelController.DisplayOption value) {
        this.hierarchyDisplayOption = value;
        this.writeToJavaPreferences("HIERARCHY_DISPLAY_OPTION");
    }

    public CSSAnalyzerColumnsOrder getDefaultCSSAnalyzerColumnsOrder() {
        return CSSAnalyzerColumnsOrder.DEFAULTS_FIRST;
    }

    public CSSAnalyzerColumnsOrder getCSSAnalyzerColumnsOrder() {
        if (this.isCssTableColumnsOrderingReversed()) {
            return CSSAnalyzerColumnsOrder.DEFAULTS_LAST;
        }
        return CSSAnalyzerColumnsOrder.DEFAULTS_FIRST;
    }

    public void setCSSAnalyzerColumnsOrder(CSSAnalyzerColumnsOrder value) {
        switch (value.ordinal()) {
            case 0: {
                this.setCssTableColumnsOrderingReversed(false);
                break;
            }
            case 1: {
                this.setCssTableColumnsOrderingReversed(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean isCssTableColumnsOrderingReversed() {
        return this.cssTableColumnsOrderingReversed;
    }

    public void setCssTableColumnsOrderingReversed(boolean value) {
        this.cssTableColumnsOrderingReversed = value;
    }

    public int getRecentItemsSize() {
        return this.recentItemsSize;
    }

    public void setRecentItemsSize(int value) {
        this.recentItemsSize = value;
        while (this.recentItems.size() > this.recentItemsSize) {
            this.recentItems.remove(this.recentItems.size() - 1);
        }
    }

    public List<String> getRecentItems() {
        return this.recentItems;
    }

    public boolean containsRecentItem(File file) {
        String path = file.getPath();
        return this.recentItems.contains(path);
    }

    public boolean containsRecentItem(URL url) {
        try {
            File fxmlFile = new File(url.toURI());
            return this.containsRecentItem(fxmlFile);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PreferencesRecordGlobal.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public void addRecentItem(File file) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        this.addRecentItems(files);
    }

    public void addRecentItem(URL url) {
        try {
            File fxmlFile = new File(url.toURI());
            this.addRecentItem(fxmlFile);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PreferencesRecordGlobal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addRecentItems(List<File> files) {
        for (File file : files) {
            String path = file.getPath();
            if (this.recentItems.contains(path)) {
                this.recentItems.remove(path);
            }
            this.recentItems.add(0, path);
        }
        while (this.recentItems.size() > this.recentItemsSize) {
            this.recentItems.remove(this.recentItems.size() - 1);
        }
        this.writeToJavaPreferences("RECENT_ITEMS");
    }

    public void removeRecentItems(List<String> filePaths) {
        for (String filePath : filePaths) {
            this.recentItems.remove(filePath);
        }
        this.writeToJavaPreferences("RECENT_ITEMS");
    }

    public void clearRecentItems() {
        this.recentItems.clear();
        this.writeToJavaPreferences("RECENT_ITEMS");
    }

    public void updateRegistrationFields(String hash, String email, Boolean optIn) {
        this.registrationHash = hash;
        this.writeToJavaPreferences("REGISTRATION_HASH");
        if (email != null) {
            this.registrationEmail = email;
            this.writeToJavaPreferences("REGISTRATION_EMAIL");
        }
        if (optIn != null) {
            this.registrationOptIn = optIn;
            this.writeToJavaPreferences("REGISTRATION_OPT_IN");
        }
    }

    public String getRegistrationHash() {
        return this.registrationHash;
    }

    public void setRegistrationHash(String registrationHash) {
        this.registrationHash = registrationHash;
    }

    public String getRegistrationEmail() {
        return this.registrationEmail;
    }

    public void setRegistrationEmail(String registrationEmail) {
        this.registrationEmail = registrationEmail;
    }

    public boolean isRegistrationOptIn() {
        return this.registrationOptIn;
    }

    public void setRegistrationOptIn(boolean registrationOptIn) {
        this.registrationOptIn = registrationOptIn;
    }

    public void setShowUpdateDialogAfter(LocalDate showUpdateDialogDate) {
        this.showUpdateDialogDate = showUpdateDialogDate;
        this.writeToJavaPreferences("UPDATE_DIALOG_DATE");
    }

    public LocalDate getShowUpdateDialogDate() {
        return this.showUpdateDialogDate;
    }

    public void setIgnoreVersion(String ignoreVersion) {
        this.ignoreVersion = ignoreVersion;
        this.writeToJavaPreferences("IGNORE_VERSION");
    }

    public String getIgnoreVersion() {
        return this.ignoreVersion;
    }

    public void setImportedGluonJars(String[] importedJars) {
        this.importedGluonJars = importedJars;
        this.writeToJavaPreferences("IMPORTED_GLUON_JARS");
    }

    public String[] getImportedGluonJars() {
        return this.importedGluonJars;
    }

    public LocalDate getLastSentTrackingInfoDate() {
        return this.lastSentTrackingInfoDate;
    }

    public void setLastSentTrackingInfoDate(LocalDate date) {
        this.lastSentTrackingInfoDate = date;
        this.writeToJavaPreferences("LAST_SENT_TRACKING_INFO_DATE");
    }

    public boolean isAccordionAnimation() {
        return this.accordionAnimation;
    }

    public void setAccordionAnimation(boolean accordionAnimation) {
        this.accordionAnimation = accordionAnimation;
    }

    public boolean isWildcardImports() {
        return this.wildcardImports;
    }

    public void setWildcardImports(boolean wildcardImports) {
        this.wildcardImports = wildcardImports;
    }

    public boolean isAlternateTextInputControlPaste() {
        return this.alternatePasteBehavior;
    }

    public void setAlternateTextInputControlPaste(boolean alternatePasteBehavior) {
        this.alternatePasteBehavior = alternatePasteBehavior;
    }

    @Override
    public void readFromJavaPreferences() {
        super.readFromJavaPreferences();
        if (this.getRootContainerHeight() == -1.0) {
            this.setRootContainerHeight(400.0);
        }
        if (this.getRootContainerWidth() == -1.0) {
            this.setRootContainerWidth(600.0);
        }
        String swatchName = this.applicationRootPreferences.get("gluonSwatch", DEFAULT_GLUON_SWATCH.name());
        this.gluonSwatch = GluonEditorPlatform.swatchValueOf(swatchName);
        String gluonThemeName = this.applicationRootPreferences.get("gluonTheme", DEFAULT_GLUON_THEME.name());
        this.gluonTheme = EditorPlatform.Theme.valueOf(gluonThemeName);
        String tool_theme = this.applicationRootPreferences.get("TOOL_THEME", DEFAULT_TOOL_THEME.name());
        this.setToolTheme(ToolTheme.valueOf(tool_theme));
        String library_DisplayOption = this.applicationRootPreferences.get("LIBRARY_DISPLAY_OPTION", DEFAULT_LIBRARY_DISPLAY_OPTION.name());
        this.setLibraryDisplayOption(LibraryPanelController.DISPLAY_MODE.valueOf(library_DisplayOption));
        String hierarchy_DisplayOption = this.applicationRootPreferences.get("HIERARCHY_DISPLAY_OPTION", DEFAULT_HIERARCHY_DISPLAY_OPTION.name());
        this.setHierarchyDisplayOption(AbstractHierarchyPanelController.DisplayOption.valueOf(hierarchy_DisplayOption));
        boolean reversed = this.applicationRootPreferences.getBoolean("CSS_TABLE_COLUMNS_ORDERING_REVERSED", false);
        this.setCssTableColumnsOrderingReversed(reversed);
        int size = this.applicationRootPreferences.getInt("RECENT_ITEMS_SIZE", 15);
        this.setRecentItemsSize(size);
        String items = this.applicationRootPreferences.get("RECENT_ITEMS", null);
        assert (this.recentItems.isEmpty());
        if (items != null && !items.isEmpty()) {
            String[] itemsArray = items.split(File.pathSeparator);
            assert (itemsArray.length <= this.recentItemsSize);
            this.recentItems.addAll(Arrays.asList(itemsArray));
        }
        String registrationHash = this.applicationRootPreferences.get("REGISTRATION_HASH", null);
        this.setRegistrationHash(registrationHash);
        String registrationEmail = this.applicationRootPreferences.get("REGISTRATION_EMAIL", null);
        this.setRegistrationEmail(registrationEmail);
        boolean registrationOptIn = this.applicationRootPreferences.getBoolean("REGISTRATION_OPT_IN", false);
        this.setRegistrationOptIn(registrationOptIn);
        String updateDialogDate = this.applicationRootPreferences.get("UPDATE_DIALOG_DATE", null);
        this.showUpdateDialogDate = updateDialogDate == null ? null : LocalDate.parse(updateDialogDate);
        this.ignoreVersion = this.applicationRootPreferences.get("IGNORE_VERSION", null);
        String dateString = this.applicationRootPreferences.get("LAST_SENT_TRACKING_INFO_DATE", null);
        this.lastSentTrackingInfoDate = dateString == null ? null : LocalDate.parse(dateString);
        String importedGluonJarsString = this.applicationRootPreferences.get("IMPORTED_GLUON_JARS", null);
        this.importedGluonJars = importedGluonJarsString == null ? new String[0] : importedGluonJarsString.split(",");
        this.setAccordionAnimation(this.applicationRootPreferences.getBoolean("ACCORDION_ANIMATION", true));
        this.setWildcardImports(this.applicationRootPreferences.getBoolean("WILDCARD_IMPORT", false));
        this.setAlternateTextInputControlPaste(this.applicationRootPreferences.getBoolean("ALTERNATE_TEXT_INPUT_PASTE", DEFAULT_ALTERNATE_TEXT_INPUT_PASTE));
    }

    @Override
    public void writeToJavaPreferences(String key) {
        assert (this.applicationRootPreferences != null);
        assert (key != null);
        switch (key) {
            case "TOOL_THEME": {
                this.applicationRootPreferences.put("TOOL_THEME", this.getToolTheme().name());
                break;
            }
            case "gluonSwatch": {
                this.applicationRootPreferences.put("gluonSwatch", this.getSwatch().name());
                break;
            }
            case "gluonTheme": {
                this.applicationRootPreferences.put("gluonTheme", this.getGluonTheme().name());
                break;
            }
            case "LIBRARY_DISPLAY_OPTION": {
                this.applicationRootPreferences.put("LIBRARY_DISPLAY_OPTION", this.getLibraryDisplayOption().name());
                break;
            }
            case "HIERARCHY_DISPLAY_OPTION": {
                this.applicationRootPreferences.put("HIERARCHY_DISPLAY_OPTION", this.getHierarchyDisplayOption().name());
                break;
            }
            case "CSS_TABLE_COLUMNS_ORDERING_REVERSED": {
                this.applicationRootPreferences.putBoolean("CSS_TABLE_COLUMNS_ORDERING_REVERSED", this.isCssTableColumnsOrderingReversed());
                break;
            }
            case "RECENT_ITEMS_SIZE": {
                this.applicationRootPreferences.putInt("RECENT_ITEMS_SIZE", this.getRecentItemsSize());
                break;
            }
            case "RECENT_ITEMS": {
                StringBuilder sb = new StringBuilder();
                for (String recentItem : this.getRecentItems()) {
                    sb.append(recentItem);
                    sb.append(File.pathSeparator);
                }
                this.applicationRootPreferences.put("RECENT_ITEMS", sb.toString());
                break;
            }
            case "REGISTRATION_HASH": {
                this.applicationRootPreferences.put("REGISTRATION_HASH", this.getRegistrationHash());
                break;
            }
            case "REGISTRATION_EMAIL": {
                this.applicationRootPreferences.put("REGISTRATION_EMAIL", this.getRegistrationEmail());
                break;
            }
            case "REGISTRATION_OPT_IN": {
                this.applicationRootPreferences.putBoolean("REGISTRATION_OPT_IN", this.isRegistrationOptIn());
                break;
            }
            case "UPDATE_DIALOG_DATE": {
                this.applicationRootPreferences.put("UPDATE_DIALOG_DATE", this.getShowUpdateDialogDate().toString());
                break;
            }
            case "IGNORE_VERSION": {
                this.applicationRootPreferences.put("IGNORE_VERSION", this.getIgnoreVersion());
                break;
            }
            case "LAST_SENT_TRACKING_INFO_DATE": {
                this.applicationRootPreferences.put("LAST_SENT_TRACKING_INFO_DATE", this.getLastSentTrackingInfoDate().toString());
                break;
            }
            case "IMPORTED_GLUON_JARS": {
                if (this.importedGluonJars.length == 0) {
                    this.applicationRootPreferences.put("IMPORTED_GLUON_JARS", "");
                    break;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String s : this.importedGluonJars) {
                    stringBuilder.append(s);
                    stringBuilder.append(",");
                }
                this.applicationRootPreferences.put("IMPORTED_GLUON_JARS", stringBuilder.toString());
                break;
            }
            case "ACCORDION_ANIMATION": {
                this.applicationRootPreferences.putBoolean("ACCORDION_ANIMATION", this.isAccordionAnimation());
                break;
            }
            case "WILDCARD_IMPORT": {
                this.applicationRootPreferences.putBoolean("WILDCARD_IMPORT", this.isWildcardImports());
                break;
            }
            case "ALTERNATE_TEXT_INPUT_PASTE": {
                this.applicationRootPreferences.putBoolean("ALTERNATE_TEXT_INPUT_PASTE", this.isAlternateTextInputControlPaste());
                break;
            }
            default: {
                super.writeToJavaPreferences(key);
            }
        }
    }

    public static enum CSSAnalyzerColumnsOrder {
        DEFAULTS_FIRST{

            public String toString() {
                return I18N.getString("prefs.cssanalyzer.columns.defaults.first");
            }
        }
        ,
        DEFAULTS_LAST{

            public String toString() {
                return I18N.getString("prefs.cssanalyzer.columns.defaults.last");
            }
        };

    }
}

