/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.preferences;

import com.gluonhq.scenebuilder.plugins.editor.GluonEditorPlatform;
import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.kit.ToolTheme;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.AbstractHierarchyPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordGlobalBase;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import java.util.Arrays;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class PreferencesWindowController
extends AbstractFxmlWindowController {
    @FXML
    private DoubleField rootContainerHeight;
    @FXML
    private DoubleField rootContainerWidth;
    @FXML
    private ChoiceBox<PreferencesRecordGlobalBase.BackgroundImage> backgroundImage;
    @FXML
    private ChoiceBox<ToolTheme> scenebuilderTheme;
    @FXML
    private ChoiceBox<LibraryPanelController.DISPLAY_MODE> libraryDisplayOption;
    @FXML
    private ChoiceBox<AbstractHierarchyPanelController.DisplayOption> hierarchyDisplayOption;
    @FXML
    private ChoiceBox<PreferencesRecordGlobal.CSSAnalyzerColumnsOrder> cssAnalyzerColumnsOrder;
    @FXML
    private MenuButton alignmentGuidesButton;
    @FXML
    private MenuButton parentRingButton;
    @FXML
    private CustomMenuItem alignmentGuidesMenuItem;
    @FXML
    private CustomMenuItem parentRingMenuItem;
    @FXML
    private Rectangle alignmentGuidesGraphic;
    @FXML
    private Rectangle parentRingGraphic;
    @FXML
    private ChoiceBox<Integer> recentItemsSize;
    @FXML
    private ChoiceBox<EditorPlatform.Theme> themes;
    @FXML
    private ChoiceBox<EditorPlatform.Theme> gluonSwatch;
    @FXML
    private CheckBox animateAccordion;
    @FXML
    private CheckBox wildcardImports;
    @FXML
    private CheckBox alternatePasteBehavior;
    @FXML
    private Label alternatePasteBehaviorLabel;
    @FXML
    private Pane alternatePasteBehaviorPane;
    private PaintPicker alignmentColorPicker;
    private PaintPicker parentRingColorPicker;
    private Stage ownerWindow;

    public PreferencesWindowController(Stage ownerWindow) {
        super(PreferencesWindowController.class.getResource("Preferences.fxml"), I18N.getBundle(), ownerWindow);
        this.ownerWindow = ownerWindow;
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        PreferencesController preferencesController = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
        this.rootContainerHeight.setText(String.valueOf(recordGlobal.getRootContainerHeight()));
        this.rootContainerHeight.setOnAction(t -> {
            String value = this.rootContainerHeight.getText();
            recordGlobal.setRootContainerHeight(Double.valueOf(value));
            this.rootContainerHeight.selectAll();
            recordGlobal.writeToJavaPreferences("ROOT_CONTAINER_HEIGHT");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshRootContainerHeight(recordGlobal));
        });
        this.rootContainerWidth.setText(String.valueOf(recordGlobal.getRootContainerWidth()));
        this.rootContainerWidth.setOnAction(t -> {
            String value = this.rootContainerWidth.getText();
            recordGlobal.setRootContainerWidth(Double.valueOf(value));
            this.rootContainerWidth.selectAll();
            recordGlobal.writeToJavaPreferences("ROOT_CONTAINER_WIDTH");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshRootContainerWidth(recordGlobal));
        });
        this.backgroundImage.getItems().setAll(Arrays.asList((PreferencesRecordGlobalBase.BackgroundImage[])PreferencesRecordGlobalBase.BackgroundImage.class.getEnumConstants()));
        this.backgroundImage.setValue((Object)recordGlobal.getBackgroundImage());
        this.backgroundImage.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new BackgroundImageListener());
        PaintPickerDelegate delegate = new PaintPickerDelegate();
        Color alignmentColor = recordGlobal.getAlignmentGuidesColor();
        this.alignmentColorPicker = new PaintPicker(delegate, PaintPicker.Mode.COLOR);
        this.alignmentGuidesGraphic.setFill((Paint)alignmentColor);
        this.alignmentGuidesMenuItem.setContent((Node)this.alignmentColorPicker);
        this.alignmentColorPicker.setPaintProperty((Paint)alignmentColor);
        this.alignmentColorPicker.paintProperty().addListener((ChangeListener)new AlignmentGuidesColorListener(this.alignmentGuidesGraphic));
        Color parentRingColor = recordGlobal.getParentRingColor();
        this.parentRingColorPicker = new PaintPicker(delegate, PaintPicker.Mode.COLOR);
        this.parentRingGraphic.setFill((Paint)parentRingColor);
        this.parentRingMenuItem.setContent((Node)this.parentRingColorPicker);
        this.parentRingColorPicker.setPaintProperty((Paint)parentRingColor);
        this.parentRingColorPicker.paintProperty().addListener((ChangeListener)new ParentRingColorListener(this.parentRingGraphic));
        this.scenebuilderTheme.getItems().setAll(Arrays.asList((ToolTheme[])ToolTheme.class.getEnumConstants()));
        this.scenebuilderTheme.setValue((Object)recordGlobal.getToolTheme());
        this.scenebuilderTheme.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ToolThemeListener());
        LibraryPanelController.DISPLAY_MODE[] availableDisplayMode = new LibraryPanelController.DISPLAY_MODE[]{LibraryPanelController.DISPLAY_MODE.LIST, LibraryPanelController.DISPLAY_MODE.SECTIONS};
        this.libraryDisplayOption.getItems().setAll(Arrays.asList(availableDisplayMode));
        this.libraryDisplayOption.setValue((Object)recordGlobal.getLibraryDisplayOption());
        this.libraryDisplayOption.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new LibraryOptionListener());
        this.hierarchyDisplayOption.getItems().setAll(Arrays.asList((AbstractHierarchyPanelController.DisplayOption[])AbstractHierarchyPanelController.DisplayOption.class.getEnumConstants()));
        this.hierarchyDisplayOption.setValue((Object)recordGlobal.getHierarchyDisplayOption());
        this.hierarchyDisplayOption.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new DisplayOptionListener());
        this.cssAnalyzerColumnsOrder.getItems().setAll(Arrays.asList((PreferencesRecordGlobal.CSSAnalyzerColumnsOrder[])PreferencesRecordGlobal.CSSAnalyzerColumnsOrder.class.getEnumConstants()));
        this.cssAnalyzerColumnsOrder.setValue((Object)recordGlobal.getCSSAnalyzerColumnsOrder());
        this.cssAnalyzerColumnsOrder.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ColumnOrderListener());
        this.themes.getItems().setAll(EditorPlatform.Theme.getThemeList());
        this.themes.setValue((Object)recordGlobal.getTheme());
        this.themes.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ThemesListener());
        this.gluonSwatch.getItems().setAll(GluonEditorPlatform.getGluonSwatchList());
        this.gluonSwatch.setValue((Object)recordGlobal.getSwatch());
        this.gluonSwatch.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SwatchListener());
        this.recentItemsSize.getItems().setAll((Object[])PreferencesRecordGlobal.recentItemsSizes);
        this.recentItemsSize.setValue((Object)recordGlobal.getRecentItemsSize());
        this.recentItemsSize.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new RecentItemsSizeListener());
        this.animateAccordion.setSelected(recordGlobal.isAccordionAnimation());
        this.animateAccordion.selectedProperty().addListener((ChangeListener)new AnimationListener());
        this.wildcardImports.setSelected(recordGlobal.isWildcardImports());
        this.wildcardImports.selectedProperty().addListener((ChangeListener)new WildcardImportListener());
        if (EditorPlatform.IS_MAC) {
            this.alternatePasteBehavior.setSelected(recordGlobal.isAlternateTextInputControlPaste());
            this.alternatePasteBehavior.selectedProperty().addListener((ChangeListener)new AlternatePasteListener());
        } else {
            this.alternatePasteBehaviorPane.setDisable(true);
            this.alternatePasteBehaviorPane.setVisible(false);
            this.alternatePasteBehaviorPane.setManaged(false);
        }
    }

    @Override
    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
        this.getStage().setTitle(I18N.getString("prefs.title"));
        this.getStage().initModality(Modality.APPLICATION_MODAL);
        this.getStage().initOwner((Window)this.ownerWindow);
        this.getStage().setResizable(false);
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        super.closeWindow();
    }

    @FXML
    void resetToDefaultAction(ActionEvent event) {
        PreferencesController preferencesController = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
        this.rootContainerHeight.setText(String.valueOf(400.0));
        this.rootContainerHeight.getOnAction().handle((Event)new ActionEvent());
        this.rootContainerWidth.setText(String.valueOf(600.0));
        this.rootContainerWidth.getOnAction().handle((Event)new ActionEvent());
        this.backgroundImage.setValue((Object)PreferencesRecordGlobalBase.DEFAULT_BACKGROUND_IMAGE);
        this.alignmentColorPicker.setPaintProperty((Paint)PreferencesRecordGlobalBase.DEFAULT_ALIGNMENT_GUIDES_COLOR);
        this.parentRingColorPicker.setPaintProperty((Paint)PreferencesRecordGlobalBase.DEFAULT_PARENT_RING_COLOR);
        this.scenebuilderTheme.setValue((Object)PreferencesRecordGlobal.DEFAULT_TOOL_THEME);
        this.libraryDisplayOption.setValue((Object)PreferencesRecordGlobal.DEFAULT_LIBRARY_DISPLAY_OPTION);
        this.hierarchyDisplayOption.setValue((Object)PreferencesRecordGlobal.DEFAULT_HIERARCHY_DISPLAY_OPTION);
        this.cssAnalyzerColumnsOrder.setValue((Object)recordGlobal.getDefaultCSSAnalyzerColumnsOrder());
        this.recentItemsSize.setValue((Object)15);
        this.themes.setValue((Object)PreferencesRecordGlobalBase.DEFAULT_THEME);
        this.gluonSwatch.setValue((Object)PreferencesRecordGlobal.DEFAULT_GLUON_SWATCH);
        this.animateAccordion.setSelected(true);
        this.wildcardImports.setSelected(false);
    }

    private static class BackgroundImageListener
    implements ChangeListener<PreferencesRecordGlobalBase.BackgroundImage> {
        private BackgroundImageListener() {
        }

        public void changed(ObservableValue<? extends PreferencesRecordGlobalBase.BackgroundImage> observable, PreferencesRecordGlobalBase.BackgroundImage oldValue, PreferencesRecordGlobalBase.BackgroundImage newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setBackgroundImage(newValue);
            recordGlobal.writeToJavaPreferences("BACKGROUND_IMAGE");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshBackgroundImage(recordGlobal));
        }
    }

    private static class PaintPickerDelegate
    implements PaintPicker.Delegate {
        private PaintPickerDelegate() {
        }

        @Override
        public void handleError(String warningKey, Object ... arguments) {
        }
    }

    private static class AlignmentGuidesColorListener
    implements ChangeListener<Paint> {
        private final Rectangle graphic;

        public AlignmentGuidesColorListener(Rectangle graphic) {
            this.graphic = graphic;
        }

        public void changed(ObservableValue<? extends Paint> ov, Paint oldValue, Paint newValue) {
            assert (newValue instanceof Color);
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setAlignmentGuidesColor((Color)newValue);
            recordGlobal.writeToJavaPreferences("ALIGNMENT_GUIDES_COLOR");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshAlignmentGuidesColor(recordGlobal));
            this.graphic.setFill(newValue);
        }
    }

    private static class ParentRingColorListener
    implements ChangeListener<Paint> {
        private final Rectangle graphic;

        public ParentRingColorListener(Rectangle graphic) {
            this.graphic = graphic;
        }

        public void changed(ObservableValue<? extends Paint> ov, Paint oldValue, Paint newValue) {
            assert (newValue instanceof Color);
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setParentRingColor((Color)newValue);
            recordGlobal.writeToJavaPreferences("PARENT_RING_COLOR");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshParentRingColor(recordGlobal));
            this.graphic.setFill(newValue);
        }
    }

    private static class ToolThemeListener
    implements ChangeListener<ToolTheme> {
        private ToolThemeListener() {
        }

        public void changed(ObservableValue<? extends ToolTheme> observable, ToolTheme oldValue, ToolTheme newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setToolTheme(newValue);
            recordGlobal.writeToJavaPreferences("TOOL_THEME");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshToolTheme(recordGlobal));
        }
    }

    private static class LibraryOptionListener
    implements ChangeListener<LibraryPanelController.DISPLAY_MODE> {
        private LibraryOptionListener() {
        }

        public void changed(ObservableValue<? extends LibraryPanelController.DISPLAY_MODE> ov, LibraryPanelController.DISPLAY_MODE oldValue, LibraryPanelController.DISPLAY_MODE newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setLibraryDisplayOption(newValue);
            recordGlobal.writeToJavaPreferences("LIBRARY_DISPLAY_OPTION");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshLibraryDisplayOption(recordGlobal));
        }
    }

    private static class DisplayOptionListener
    implements ChangeListener<AbstractHierarchyPanelController.DisplayOption> {
        private DisplayOptionListener() {
        }

        public void changed(ObservableValue<? extends AbstractHierarchyPanelController.DisplayOption> observable, AbstractHierarchyPanelController.DisplayOption oldValue, AbstractHierarchyPanelController.DisplayOption newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setHierarchyDisplayOption(newValue);
            recordGlobal.writeToJavaPreferences("HIERARCHY_DISPLAY_OPTION");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshHierarchyDisplayOption(recordGlobal));
        }
    }

    private static class ColumnOrderListener
    implements ChangeListener<PreferencesRecordGlobal.CSSAnalyzerColumnsOrder> {
        private ColumnOrderListener() {
        }

        public void changed(ObservableValue<? extends PreferencesRecordGlobal.CSSAnalyzerColumnsOrder> observable, PreferencesRecordGlobal.CSSAnalyzerColumnsOrder oldValue, PreferencesRecordGlobal.CSSAnalyzerColumnsOrder newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setCSSAnalyzerColumnsOrder(newValue);
            recordGlobal.writeToJavaPreferences("CSS_TABLE_COLUMNS_ORDERING_REVERSED");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshCssTableColumnsOrderingReversed(recordGlobal));
        }
    }

    private static class ThemesListener
    implements ChangeListener<EditorPlatform.Theme> {
        private ThemesListener() {
        }

        public void changed(ObservableValue<? extends EditorPlatform.Theme> observable, EditorPlatform.Theme oldValue, EditorPlatform.Theme newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setTheme(newValue);
            recordGlobal.writeToJavaPreferences("theme");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshTheme(recordGlobal));
        }
    }

    private static class SwatchListener
    implements ChangeListener<EditorPlatform.Theme> {
        private SwatchListener() {
        }

        public void changed(ObservableValue<? extends EditorPlatform.Theme> observable, EditorPlatform.Theme oldValue, EditorPlatform.Theme newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setSwatch(newValue);
            recordGlobal.writeToJavaPreferences("gluonSwatch");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshSwatch(recordGlobal));
        }
    }

    private static class RecentItemsSizeListener
    implements ChangeListener<Integer> {
        private RecentItemsSizeListener() {
        }

        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setRecentItemsSize(newValue);
            recordGlobal.writeToJavaPreferences("RECENT_ITEMS_SIZE");
            recordGlobal.writeToJavaPreferences("RECENT_ITEMS");
        }
    }

    private static class AnimationListener
    implements ChangeListener<Boolean> {
        private AnimationListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setAccordionAnimation(newValue);
            recordGlobal.writeToJavaPreferences("ACCORDION_ANIMATION");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.animateAccordion(newValue));
        }
    }

    private static class WildcardImportListener
    implements ChangeListener<Boolean> {
        private WildcardImportListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setWildcardImports(newValue);
            recordGlobal.writeToJavaPreferences("WILDCARD_IMPORT");
        }
    }

    private static class AlternatePasteListener
    implements ChangeListener<Boolean> {
        private AlternatePasteListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setAlternateTextInputControlPaste(newValue);
            recordGlobal.writeToJavaPreferences("ALTERNATE_TEXT_INPUT_PASTE");
        }
    }

    private static class GluonThemeListener
    implements ChangeListener<EditorPlatform.Theme> {
        private GluonThemeListener() {
        }

        public void changed(ObservableValue<? extends EditorPlatform.Theme> observable, EditorPlatform.Theme oldValue, EditorPlatform.Theme newValue) {
            PreferencesController preferencesController = PreferencesController.getSingleton();
            PreferencesRecordGlobal recordGlobal = preferencesController.getRecordGlobal();
            recordGlobal.setGluonTheme(newValue);
            recordGlobal.writeToJavaPreferences("gluonTheme");
            SceneBuilderApp.applyToAllDocumentWindows(dwc -> dwc.refreshGluonTheme(recordGlobal));
        }
    }
}

