/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.registration;

import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.app.tracking.Tracking;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.regex.Pattern;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class RegistrationWindowController
extends AbstractFxmlWindowController {
    private static final Pattern emailPattern = Pattern.compile("[a-zA-Z0-9[!#$%&'()*+,/\\-_\\.\"]]+@[a-zA-Z0-9[!#$%&'()*+,/\\-_\"]]+\\.[a-zA-Z0-9[!#$%&'()*+,/\\-_\"\\.]]+");
    @FXML
    private Label lbAlert;
    @FXML
    private TextField tfEmail;
    @FXML
    private CheckBox cbOptIn;
    private final Window owner;

    public RegistrationWindowController(Stage owner) {
        super(RegistrationWindowController.class.getResource("Registration.fxml"), I18N.getBundle(), owner);
        this.owner = owner;
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.cancelUserRegistration();
        event.consume();
    }

    @Override
    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
        this.getStage().setTitle(I18N.getString("registration.title"));
        if (this.owner == null) {
            this.getStage().initModality(Modality.APPLICATION_MODAL);
        } else {
            this.getStage().initOwner(this.owner);
            this.getStage().initModality(Modality.WINDOW_MODAL);
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        assert (this.lbAlert != null);
        assert (this.tfEmail != null);
        assert (this.cbOptIn != null);
    }

    private boolean isEmailAddressValid() {
        String email = this.tfEmail.getText();
        return email != null && !email.isEmpty() && emailPattern.matcher(email).matches();
    }

    @FXML
    public void cancelUserRegistration() {
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
        if (recordGlobal.getRegistrationHash() == null) {
            String hash = this.getUniqueId();
            recordGlobal.updateRegistrationFields(hash, null, null);
            Tracking.sendTrackingInfo("scenebuilder", hash, "", false, false);
        }
        this.closeWindow();
    }

    @FXML
    public void trackUserRegistration() {
        if (!this.isEmailAddressValid()) {
            this.lbAlert.setVisible(true);
            return;
        }
        PreferencesController pc = PreferencesController.getSingleton();
        PreferencesRecordGlobal recordGlobal = pc.getRecordGlobal();
        boolean update = recordGlobal.getRegistrationHash() != null;
        String hash = update ? recordGlobal.getRegistrationHash() : this.getUniqueId();
        String email = this.tfEmail.getText();
        boolean optIn = this.cbOptIn.isSelected();
        recordGlobal.updateRegistrationFields(hash, email, optIn);
        Tracking.sendTrackingInfo("scenebuilder", hash, email, optIn, update);
        this.closeWindow();
    }

    private String getUniqueId() {
        String uniqueId = "";
        try {
            byte[] macAddress;
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            if (ni != null && (macAddress = ni.getHardwareAddress()) != null) {
                uniqueId = this.computeHash(macAddress);
            }
        }
        catch (SocketException | UnknownHostException iOException) {
            // empty catch block
        }
        if (uniqueId.isEmpty()) {
            uniqueId = UUID.randomUUID().toString();
        }
        return uniqueId;
    }

    private String computeHash(byte[] buffer) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.reset();
            messageDigest.update(buffer);
            byte[] digest = messageDigest.digest();
            Object hexStr = "";
            for (int i = 0; i < digest.length; ++i) {
                hexStr = (String)hexStr + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
            }
            return hexStr;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }
}

