/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.report;

import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class JarAnalysisReportController
extends AbstractFxmlWindowController {
    @FXML
    TextFlow textFlow;
    @FXML
    Label timestampLabel;
    private final EditorController editorController;
    private final String TIMESTAMP_PATTERN = "h:mm a EEEEEEEEE d MMM. yyyy";
    private final SimpleDateFormat TIMESTAMP_DATE_FORMAT = new SimpleDateFormat("h:mm a EEEEEEEEE d MMM. yyyy");
    private int prefixCounter = 0;
    private boolean dirty = false;

    @FXML
    void onCopyAction(ActionEvent event) {
        HashMap<DataFormat, String> content = new HashMap<DataFormat, String>();
        StringBuilder sb = new StringBuilder();
        for (Node item : this.textFlow.getChildrenUnmodifiable()) {
            if (!(item instanceof Text)) continue;
            sb.append(((Text)item).getText());
        }
        content.put(DataFormat.PLAIN_TEXT, sb.toString());
        Clipboard.getSystemClipboard().setContent(content);
    }

    public JarAnalysisReportController(EditorController editorController, Stage owner) {
        super(JarAnalysisReportController.class.getResource("JarAnalysisReport.fxml"), I18N.getBundle(), owner);
        this.editorController = editorController;
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.getStage().close();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        if (this.dirty) {
            this.update();
        }
    }

    @Override
    protected void controllerDidCreateStage() {
        this.getStage().setTitle(I18N.getString("jar.analysis.report.title"));
    }

    @Override
    protected void controllerDidLoadFxml() {
        assert (this.textFlow != null);
        assert (this.timestampLabel != null);
        UserLibrary lib = (UserLibrary)this.editorController.getLibrary();
        lib.getJarReports().addListener(change -> this.update());
        this.update();
    }

    private void update() {
        if (this.getStage().isShowing()) {
            this.textFlow.getChildren().clear();
            this.updateTimeStampLabel();
            UserLibrary lib = (UserLibrary)this.editorController.getLibrary();
            for (JarReport report : lib.getJarReports()) {
                for (JarReportEntry entry : report.getEntries()) {
                    Text text;
                    StringBuilder sb;
                    if (entry.getStatus() != JarReportEntry.Status.OK) {
                        if (entry.getKlass() == null || entry.getException() == null) continue;
                        sb = new StringBuilder();
                        sb.append(this.getSectionPrefix()).append(I18N.getString("jar.analysis.exception"));
                        sb.append(" ").append(entry.getName());
                        text = new Text();
                        text.setText(sb.toString());
                        text.getStyleClass().add((Object)"header");
                        this.textFlow.getChildren().add((Object)text);
                        StringBuilder sb2 = new StringBuilder();
                        sb2.append((CharSequence)this.getFullStack(entry.getException()));
                        Text text2 = new Text();
                        text2.setText(sb2.toString());
                        text2.getStyleClass().add((Object)"body");
                        this.textFlow.getChildren().add((Object)text2);
                        continue;
                    }
                    if (entry.isNode()) continue;
                    sb = new StringBuilder();
                    sb.append(this.getSectionPrefix()).append(I18N.getString("jar.analysis.not.node"));
                    sb.append(" ").append(entry.getName());
                    text = new Text();
                    text.setText(sb.toString());
                    text.getStyleClass().add((Object)"header");
                    this.textFlow.getChildren().add((Object)text);
                }
            }
            this.dirty = false;
        } else {
            this.dirty = true;
        }
    }

    private String getSectionPrefix() {
        if (this.prefixCounter == 0) {
            ++this.prefixCounter;
            return "";
        }
        return "\n\n";
    }

    private StringBuilder getFullStack(Throwable t) {
        StringBuilder res = new StringBuilder("\n");
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)writer, true));
        res.append(writer.getBuffer().toString());
        return res;
    }

    private void updateTimeStampLabel() {
        UserLibrary lib = (UserLibrary)this.editorController.getLibrary();
        Date date = (Date)lib.getExplorationDate();
        String timestampValue = this.TIMESTAMP_DATE_FORMAT.format(date);
        this.timestampLabel.setText(I18N.getString("jar.analysis.report.timestamp", timestampValue));
    }
}

