/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.util;

import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.about.AboutWindowController;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class AppSettings {
    private static final Logger LOGGER = Logger.getLogger(AppSettings.class.getName());
    public static final String APP_ICON_16 = SceneBuilderApp.class.getResource("SceneBuilderLogo_16.png").toString();
    public static final String APP_ICON_32 = SceneBuilderApp.class.getResource("SceneBuilderLogo_32.png").toString();
    public static final String LATEST_VERSION_CHECK_URL = "http://download.gluonhq.com/scenebuilder/settings.properties";
    public static final String LATEST_VERSION_NUMBER_PROPERTY = "latestversion";
    public static final String LATEST_VERSION_INFORMATION_URL = "http://download.gluonhq.com/scenebuilder/version.json";
    public static final String DOWNLOAD_URL = "https://gluonhq.com/products/scene-builder/";
    private static String sceneBuilderVersion;
    private static String latestVersion;
    private static String latestVersionText;
    private static String latestVersionAnnouncementURL;
    private static final JsonReaderFactory readerFactory;

    private static void initSceneBuilderVersion() {
        try (InputStream in = AboutWindowController.class.getResourceAsStream("about.properties");){
            if (in != null) {
                Properties sbProps = new Properties();
                sbProps.load(in);
                sceneBuilderVersion = sbProps.getProperty("build.version", "UNSET");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Cannot init SB version:", e);
        }
    }

    public static void setWindowIcon(Alert alert) {
        AppSettings.setWindowIcon((Stage)alert.getDialogPane().getScene().getWindow());
    }

    public static void setWindowIcon(Stage stage) {
        Image icon16 = new Image(APP_ICON_16);
        Image icon32 = new Image(APP_ICON_32);
        stage.getIcons().addAll((Object[])new Image[]{icon16, icon32});
    }

    public static String getSceneBuilderVersion() {
        return sceneBuilderVersion;
    }

    public static boolean isCurrentVersionLowerThan(String version) {
        String[] versionNumbers = version.split("\\.");
        String[] currentVersionNumbers = sceneBuilderVersion.split("\\.");
        for (int i = 0; i < versionNumbers.length; ++i) {
            int currentVersionNumber;
            int number = Integer.parseInt(versionNumbers[i]);
            if (number > (currentVersionNumber = Integer.parseInt(currentVersionNumbers[i]))) {
                return true;
            }
            if (number >= currentVersionNumber) continue;
            return false;
        }
        return false;
    }

    public static void getLatestVersion(Consumer<String> consumer) {
        if (latestVersion == null) {
            Task<String> fetchTask = AppSettings.createFetchTask(consumer);
            new Thread((Runnable)fetchTask, "GetLatestVersion").start();
        } else {
            consumer.accept(latestVersion);
        }
    }

    private static final Task<String> createFetchTask(final Consumer<String> consumer) {
        return new Task<String>(){

            protected String call() throws Exception {
                LOGGER.log(Level.FINE, "Fetching latest Scenebuilder version from: {0}", AppSettings.LATEST_VERSION_CHECK_URL);
                Properties prop = new Properties();
                String onlineVersionNumber = null;
                URL url = null;
                try {
                    url = new URL(AppSettings.LATEST_VERSION_CHECK_URL);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "Failed to construct version check URL: ", e);
                }
                try (InputStream inputStream = url.openStream();){
                    prop.load(inputStream);
                    onlineVersionNumber = prop.getProperty(AppSettings.LATEST_VERSION_NUMBER_PROPERTY);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to load latest version number property: ", e);
                }
                return onlineVersionNumber;
            }

            protected void succeeded() {
                String fetchedVersion = (String)this.getValue();
                LOGGER.log(Level.INFO, "Latest online available version is: {0}", fetchedVersion);
                consumer.accept(fetchedVersion);
                latestVersion = fetchedVersion;
            }
        };
    }

    public static String getLatestVersionText() {
        if (latestVersionText == null) {
            AppSettings.updateLatestVersionInfo();
        }
        return latestVersionText;
    }

    private static void updateLatestVersionInfo() {
        try {
            URL url = new URL(LATEST_VERSION_INFORMATION_URL);
            try (JsonReader reader = readerFactory.createReader(new InputStreamReader(url.openStream()));){
                JsonObject object = reader.readObject();
                JsonObject announcementObject = object.getJsonObject("announcement");
                latestVersionText = announcementObject.getString("text");
                latestVersionAnnouncementURL = announcementObject.getString("url");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to read latest version json: ", e);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Failed to construct latest version info URL: ", e);
        }
    }

    public static String getLatestVersionAnnouncementURL() {
        if (latestVersionAnnouncementURL == null) {
            AppSettings.updateLatestVersionInfo();
        }
        return latestVersionAnnouncementURL;
    }

    public static String getUserM2Repository() {
        String m2Path = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
        assert (m2Path != null);
        return m2Path;
    }

    static {
        readerFactory = Json.createReaderFactory(null);
        AppSettings.initSceneBuilderVersion();
    }
}

