/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Timer;
import java.util.TimerTask;

class FileMutex {
    private final Path lockFile;
    private RandomAccessFile lockRAF;
    private FileLock lock;

    public FileMutex(Path lockFile) {
        assert (lockFile != null);
        this.lockFile = lockFile;
    }

    public Path getLockFile() {
        return this.lockFile;
    }

    public void lock(long timeout) throws IOException {
        assert (this.lockRAF == null);
        assert (this.lock == null);
        this.createFileChannel();
        assert (this.lockRAF != null);
        Timer timer = new Timer();
        timer.schedule((TimerTask)new InterruptTask(), timeout);
        this.lock = this.lockRAF.getChannel().lock();
        timer.cancel();
        assert (this.lock != null);
    }

    public boolean tryLock() throws IOException {
        assert (this.lockRAF == null);
        assert (this.lock == null);
        this.createFileChannel();
        assert (this.lockRAF != null);
        this.lock = this.lockRAF.getChannel().tryLock();
        if (this.lock == null) {
            this.lockRAF.close();
            this.lockRAF = null;
        }
        return this.lock != null;
    }

    public void unlock() throws IOException {
        assert (this.lockRAF != null);
        assert (this.lock != null);
        assert (this.lock.channel() == this.lockRAF.getChannel());
        this.lock.release();
        this.lock = null;
        this.lockRAF.close();
        this.lockRAF = null;
    }

    public boolean isLocked() {
        return this.lock != null;
    }

    private void createFileChannel() throws IOException {
        try {
            Files.createFile(this.lockFile, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        this.lockRAF = new RandomAccessFile(this.lockFile.toFile(), "rw");
    }

    private static class InterruptTask
    extends TimerTask {
        private InterruptTask() {
        }

        @Override
        public void run() {
            Thread.currentThread().interrupt();
        }
    }
}

