/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.util;

import com.oracle.javafx.scenebuilder.app.util.FileMutex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageBox<T extends Serializable> {
    public static final long NAP_TIME = 100L;
    private final String folder;
    private final Class<T> messageClass;
    final int pollingTime;
    final Path messageFile;
    final FileMutex boxMutex;
    final FileMutex messageMutex;
    private PollingThread<T> pollingThread;
    private Delegate<T> delegate;

    public MessageBox(String folder, Class<T> messageClass, int pollingTime) {
        assert (folder != null);
        assert (messageClass != null);
        assert (pollingTime > 0);
        this.folder = folder;
        this.messageClass = messageClass;
        this.pollingTime = pollingTime;
        this.messageFile = Paths.get(folder, "message.dat");
        this.boxMutex = new FileMutex(Paths.get(folder, "box.mtx"));
        this.messageMutex = new FileMutex(Paths.get(folder, "message.mtx"));
        if (!Files.exists(Paths.get(folder, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException(folder + " does not exist");
        }
    }

    public String getFolder() {
        return this.folder;
    }

    public boolean grab(Delegate<T> delegate) throws IOException {
        assert (!this.boxMutex.isLocked());
        assert (this.pollingThread == null);
        assert (delegate != null);
        if (this.boxMutex.tryLock()) {
            this.delegate = delegate;
            this.pollingThread = new PollingThread(this);
            this.pollingThread.setDaemon(true);
            this.pollingThread.start();
        }
        return this.boxMutex.isLocked();
    }

    public void release() {
        assert (this.boxMutex.isLocked());
        assert (this.pollingThread != null);
        assert (this.pollingThread.isAlive());
        this.pollingThread.interrupt();
        this.pollingThread = null;
        try {
            this.boxMutex.unlock();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to unlock message box mutex: ", e);
        }
    }

    public void sendMessage(T message) throws IOException, InterruptedException {
        boolean retry;
        assert (!this.boxMutex.isLocked());
        assert (!this.messageMutex.isLocked());
        Path transientFile = Files.createTempFile(Paths.get(this.folder, new String[0]), null, null, new FileAttribute[0]);
        Files.write(transientFile, this.serializeMessage(message), new OpenOption[0]);
        this.messageMutex.lock(100L * (long)this.pollingTime);
        int accessDeniedCount = 0;
        do {
            if (!Files.exists(this.messageFile, new LinkOption[0])) {
                try {
                    Files.move(transientFile, this.messageFile, StandardCopyOption.ATOMIC_MOVE);
                    retry = false;
                }
                catch (AccessDeniedException x) {
                    if (accessDeniedCount++ <= 10) {
                        retry = true;
                    }
                    throw x;
                }
            } else {
                retry = true;
            }
            if (!retry) continue;
            Thread.sleep(100L);
        } while (retry);
        this.messageMutex.unlock();
    }

    public Path getMessagePath() {
        return this.messageFile;
    }

    public Path getBoxMutexPath() {
        return this.boxMutex.getLockFile();
    }

    public Path getMessageMutexPath() {
        return this.messageMutex.getLockFile();
    }

    private byte[] serializeMessage(T message) throws IOException {
        byte[] result;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(message);
            result = bos.toByteArray();
        }
        return result;
    }

    private T unserializeMessage(byte[] bytes) throws IOException {
        Serializable result;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
             ObjectInputStream ois = new ObjectInputStream(bis);){
            try {
                result = (Serializable)this.messageClass.cast(ois.readObject());
            }
            catch (ClassNotFoundException x) {
                throw new IOException(x);
            }
        }
        return (T)result;
    }

    private static class PollingThread<T extends Serializable>
    extends Thread {
        private final MessageBox<T> messageBox;

        public PollingThread(MessageBox<T> messageBox) {
            super("MessageBox[" + messageBox.getFolder() + "]");
            this.messageBox = messageBox;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (Files.exists(this.messageBox.messageFile, new LinkOption[0])) {
                        try {
                            byte[] messageBytes = Files.readAllBytes(this.messageBox.messageFile);
                            T message = this.messageBox.unserializeMessage(messageBytes);
                            this.messageBox.delegate.messageBoxDidGetMessage(message);
                        }
                        catch (IOException x) {
                            this.messageBox.delegate.messageBoxDidCatchException(x);
                        }
                        finally {
                            try {
                                Files.delete(this.messageBox.messageFile);
                            }
                            catch (IOException x) {
                                this.messageBox.delegate.messageBoxDidCatchException(x);
                            }
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    Thread.sleep(this.messageBox.pollingTime);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public static interface Delegate<T> {
        public void messageBoxDidGetMessage(T var1);

        public void messageBoxDidCatchException(Exception var1);
    }
}

