/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.welcomedialog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WelcomeDialogFilesDropHandler {
    private static final Logger LOGGER = Logger.getLogger(WelcomeDialogFilesDropHandler.class.getName());
    private final List<File> droppedFiles;
    private final List<String> toOpen;
    private final List<String> unsupportedItems;
    private Consumer<List<String>> openFiles;
    private Consumer<List<String>> handleUnsupported;

    WelcomeDialogFilesDropHandler(List<File> droppedFiles) {
        this.droppedFiles = Objects.requireNonNull(droppedFiles);
        this.toOpen = new ArrayList<String>(droppedFiles.size());
        this.unsupportedItems = new ArrayList<String>(droppedFiles.size());
    }

    final WelcomeDialogFilesDropHandler withSupportedFiles(Consumer<List<String>> handleOpen) {
        this.openFiles = handleOpen;
        return this;
    }

    final WelcomeDialogFilesDropHandler withUnsupportedFiles(Consumer<List<String>> unsupportedHandler) {
        this.handleUnsupported = unsupportedHandler;
        return this;
    }

    final void run() {
        this.analyzeDroppedItems();
        this.handleDropResult();
    }

    final void handleDropResult() {
        if (this.openFiles == null) {
            throw new IllegalStateException("Please configure a dropped file handling action using the withSupportedFiles(...) method.");
        }
        if (this.handleUnsupported == null) {
            throw new IllegalStateException("Please configure an action for handling of unsupported files using withUnsupportedFiles(...) method.");
        }
        if (!this.toOpen.isEmpty()) {
            LOGGER.log(Level.INFO, "Received drop event to open files...");
            this.openFiles.accept(this.toOpen);
        } else {
            LOGGER.log(Level.INFO, "Dropped object does not contain any loadable FXML files.");
            this.handleUnsupported.accept(this.unsupportedItems);
        }
        if (!this.unsupportedItems.isEmpty()) {
            LOGGER.log(Level.WARNING, "{0} unsupported items dropped.", this.unsupportedItems.size());
            for (String unsupportedItem : this.unsupportedItems) {
                LOGGER.log(Level.INFO, "Unsupported file or empty directory: {0}", unsupportedItem);
            }
        }
    }

    final void analyzeDroppedItems() {
        if (this.droppedFiles.isEmpty()) {
            return;
        }
        for (File file : this.droppedFiles) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                ArrayList<String> inDir = new ArrayList<String>(children.length);
                for (File child : children) {
                    if (!this.isFxml(child)) continue;
                    inDir.add(child.getAbsolutePath());
                }
                if (inDir.isEmpty()) {
                    this.unsupportedItems.add(file.getAbsolutePath());
                    continue;
                }
                this.toOpen.addAll(inDir);
                continue;
            }
            if (this.isFxml(file)) {
                this.toOpen.add(file.getAbsolutePath());
                continue;
            }
            this.unsupportedItems.add(file.getAbsolutePath());
        }
    }

    final boolean isFxml(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.toString().toLowerCase().endsWith(".fxml");
    }
}

