/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app.welcomedialog;

import com.oracle.javafx.scenebuilder.app.SceneBuilderApp;
import com.oracle.javafx.scenebuilder.app.i18n.I18N;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesController;
import com.oracle.javafx.scenebuilder.app.preferences.PreferencesRecordGlobal;
import com.oracle.javafx.scenebuilder.app.util.AppSettings;
import com.oracle.javafx.scenebuilder.app.welcomedialog.WelcomeDialogFilesDropHandler;
import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AlertDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.template.Template;
import com.oracle.javafx.scenebuilder.kit.template.TemplatesBaseWindowController;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class WelcomeDialogWindowController
extends TemplatesBaseWindowController {
    private static final Logger LOGGER = Logger.getLogger(WelcomeDialogWindowController.class.getName());
    @FXML
    private BorderPane contentPane;
    @FXML
    private VBox recentDocuments;
    @FXML
    private Button emptyApp;
    @FXML
    private VBox masker;
    @FXML
    private ProgressIndicator progress;
    private static WelcomeDialogWindowController instance;
    private final SceneBuilderApp sceneBuilderApp = SceneBuilderApp.getSingleton();

    WelcomeDialogWindowController() {
        super(WelcomeDialogWindowController.class.getResource("WelcomeWindow.fxml"), I18N.getBundle(), null);
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.getStage().hide();
    }

    @Override
    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
        this.getStage().setTitle(I18N.getString("welcome.title"));
        this.getStage().initModality(Modality.APPLICATION_MODAL);
    }

    @FXML
    void handleFileDraggedOver(DragEvent event) {
        if (event.getDragboard().hasFiles()) {
            event.acceptTransferModes(TransferMode.ANY);
        }
    }

    @FXML
    void handleDroppedFiles(DragEvent event) {
        if (event.getDragboard().hasFiles()) {
            new WelcomeDialogFilesDropHandler(event.getDragboard().getFiles()).withSupportedFiles(fileNames -> Platform.runLater(() -> this.handleOpen((List<String>)fileNames))).withUnsupportedFiles(unsupported -> this.notifyUserWhenDroppedUnsupportedFiles((List<String>)unsupported)).run();
        }
    }

    private void notifyUserWhenDroppedUnsupportedFiles(List<String> unsupported) {
        ErrorDialog dialog = new ErrorDialog((Window)this.getStage());
        dialog.setTitle(I18N.getString("welcome.loading.when.dropped.error.title"));
        dialog.setMessage(I18N.getString("welcome.loading.when.dropped.error.message"));
        dialog.setDetailsTitle(I18N.getString("welcome.loading.when.dropped.error.title"));
        dialog.setDetails(I18N.getString("welcome.loading.when.dropped.error.detail.explanation"));
        String debugInfo = unsupported.stream().collect(Collectors.joining(System.lineSeparator()));
        dialog.setDebugInfo(debugInfo);
        Platform.runLater(() -> dialog.showAndWait());
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        assert (this.recentDocuments != null);
        this.loadAndPopulateRecentItemsInBackground();
        this.setOnTemplateChosen(this::fireSelectTemplate);
    }

    private void loadAndPopulateRecentItemsInBackground() {
        Label loadingRecentItems = new Label(I18N.getString("welcome.recent.items.loading"));
        loadingRecentItems.getStyleClass().add((Object)"no-recent-items-label");
        this.recentDocuments.getChildren().add((Object)loadingRecentItems);
        Thread t = new Thread(() -> {
            PreferencesRecordGlobal preferencesRecordGlobal = PreferencesController.getSingleton().getRecordGlobal();
            List<String> recentItems = preferencesRecordGlobal.getRecentItems();
            Platform.runLater(() -> this.recentDocuments.getChildren().clear());
            if (recentItems.size() == 0) {
                Label noRecentItems = new Label(I18N.getString("welcome.recent.items.no.recent.items"));
                noRecentItems.getStyleClass().add((Object)"no-recent-items-label");
                Platform.runLater(() -> this.recentDocuments.getChildren().add((Object)noRecentItems));
            }
            ArrayList<Button> recentDocumentButtons = new ArrayList<Button>();
            for (int row = 0; row < preferencesRecordGlobal.getRecentItemsSize() && recentItems.size() >= row + 1; ++row) {
                String recentItem = recentItems.get(row);
                File recentItemFile = new File(recentItems.get(row));
                String recentItemTitle = recentItemFile.getName();
                Button recentDocument = new Button(recentItemTitle);
                recentDocument.getStyleClass().add((Object)"recent-document");
                recentDocument.setMaxWidth(Double.MAX_VALUE);
                recentDocument.setAlignment(Pos.BASELINE_LEFT);
                recentDocument.setOnAction(event -> this.fireOpenRecentProject((ActionEvent)event, recentItem));
                recentDocument.setTooltip(new Tooltip(recentItem));
                recentDocument.setMnemonicParsing(false);
                recentDocumentButtons.add(recentDocument);
            }
            Platform.runLater(() -> recentDocumentButtons.forEach(btn -> this.recentDocuments.getChildren().add(btn)));
        }, "Recent Items Loading Thread");
        t.setDaemon(true);
        t.start();
    }

    public static WelcomeDialogWindowController getInstance() {
        if (instance == null) {
            instance = new WelcomeDialogWindowController();
            Stage stage = instance.getStage();
            stage.setMinWidth(800.0);
            stage.setMinHeight(650.0);
            AppSettings.setWindowIcon(stage);
        }
        return instance;
    }

    private void fireSelectTemplate(Template template) {
        if (this.sceneBuilderApp.startupTasksFinishedBinding().get()) {
            this.sceneBuilderApp.performNewTemplate(template);
            this.getStage().hide();
        } else {
            this.showMasker(() -> {
                this.sceneBuilderApp.performNewTemplate(template);
                this.getStage().hide();
            });
        }
    }

    private void fireOpenRecentProject(ActionEvent event, String projectPath) {
        this.handleOpen(List.of(projectPath));
    }

    @FXML
    private void openDocument() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18N.getString("file.filter.label.fxml"), new String[]{"*.fxml"}));
        fileChooser.setInitialDirectory(EditorController.getNextInitialDirectory());
        List fxmlFiles = fileChooser.showOpenMultipleDialog((Window)this.getStage());
        if (fxmlFiles == null) {
            return;
        }
        List<String> paths = fxmlFiles.stream().map(File::toString).collect(Collectors.toList());
        this.handleOpen(paths);
    }

    protected static AlertDialog questionMissingFilesCleanup(Stage stage, List<String> missingFiles) {
        String withPath = missingFiles.stream().collect(Collectors.joining(System.lineSeparator()));
        AlertDialog question = new AlertDialog((Window)stage);
        question.setDefaultButtonID(AbstractModalDialog.ButtonID.CANCEL);
        question.setShowDefaultButton(true);
        question.setOKButtonTitle(I18N.getString("alert.welcome.file.not.found.okay"));
        question.setTitle(I18N.getString("alert.welcome.file.not.found.title"));
        question.setMessage(I18N.getString("alert.welcome.file.not.found.question"));
        question.setCancelButtonTitle(I18N.getString("alert.welcome.file.not.found.no"));
        question.setDetails(I18N.getString("alert.welcome.file.not.found.message") + withPath);
        return question;
    }

    boolean filePathExists(String filePath) {
        return Files.exists(Path.of(filePath, new String[0]), new LinkOption[0]);
    }

    private void handleOpen(List<String> filePaths) {
        this.handleOpen(filePaths, this::askUserToRemoveMissingRecentFiles, this::attemptOpenExistingFiles);
    }

    private void askUserToRemoveMissingRecentFiles(List<String> missingFiles) {
        AlertDialog questionDialog;
        if (!missingFiles.isEmpty() && (questionDialog = WelcomeDialogWindowController.questionMissingFilesCleanup(this.getStage(), missingFiles)).showAndWait() == AbstractModalDialog.ButtonID.OK) {
            this.removeMissingFilesFromPrefs(missingFiles);
            this.loadAndPopulateRecentItemsInBackground();
        }
    }

    private void attemptOpenExistingFiles(List<String> paths) {
        if (this.sceneBuilderApp.startupTasksFinishedBinding().get()) {
            this.openFilesAndHideStage(paths);
        } else {
            this.showMasker(() -> this.openFilesAndHideStage(paths));
        }
    }

    private void openFilesAndHideStage(List<String> files) {
        this.sceneBuilderApp.handleOpenFilesAction(files, () -> this.getStage().hide());
    }

    void handleOpen(List<String> filePaths, Consumer<List<String>> missingFilesHandler, Consumer<List<String>> fileLoader) {
        LOGGER.log(Level.INFO, "Attempting to open files: {0}", filePaths);
        if (filePaths.isEmpty()) {
            return;
        }
        ArrayList existingFiles = new ArrayList();
        ArrayList missingFiles = new ArrayList();
        filePaths.forEach(file -> {
            if (this.filePathExists((String)file)) {
                existingFiles.add(file);
            } else {
                missingFiles.add(file);
            }
        });
        missingFilesHandler.accept(missingFiles);
        if (existingFiles.isEmpty()) {
            return;
        }
        fileLoader.accept(existingFiles);
    }

    private void removeMissingFilesFromPrefs(List<String> missingFiles) {
        missingFiles.forEach(fxmlFileName -> LOGGER.log(Level.INFO, "Removing missing file from recent items: {0}", fxmlFileName));
        PreferencesRecordGlobal preferencesRecordGlobal = PreferencesController.getSingleton().getRecordGlobal();
        preferencesRecordGlobal.removeRecentItems(missingFiles);
    }

    private void showMasker(Runnable onEndAction) {
        this.contentPane.setDisable(true);
        this.masker.setVisible(true);
        this.progress.setProgress(-1.0);
        this.sceneBuilderApp.startupTasksFinishedBinding().addListener((o, old, isFinished) -> {
            if (isFinished.booleanValue()) {
                Platform.runLater(() -> {
                    onEndAction.run();
                    this.contentPane.setDisable(false);
                    this.masker.setVisible(false);
                });
            }
        });
    }
}

