/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit;

import com.oracle.javafx.scenebuilder.kit.ToolTheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class ResourceUtils {
    public static final String BASE = ResourceUtils.class.getResource("css/Base.css").toExternalForm();
    public static final String THEME_DARK_STYLESHEET = ResourceUtils.class.getResource("css/ThemeDark.css").toExternalForm();
    public static final String THEME_DEFAULT_STYLESHEET = ResourceUtils.class.getResource("css/ThemeDefault.css").toExternalForm();
    private static List<String> imageExtensions;
    private static List<String> audioExtensions;
    private static List<String> videoExtensions;
    private static List<String> mediaExtensions;

    ResourceUtils() {
    }

    public static String getToolStylesheet(ToolTheme theme) {
        switch (theme) {
            case DARK: {
                return THEME_DARK_STYLESHEET;
            }
            case DEFAULT: {
                return THEME_DEFAULT_STYLESHEET;
            }
        }
        return null;
    }

    public static void setToolTheme(ToolTheme theme, Scene scene) {
        ResourceUtils.setToolTheme(theme, (ObservableList<String>)scene.getStylesheets());
    }

    public static void setToolTheme(ToolTheme theme, Parent parent) {
        ResourceUtils.setToolTheme(theme, (ObservableList<String>)parent.getStylesheets());
    }

    private static void setToolTheme(ToolTheme theme, ObservableList<String> stylesheets) {
        String themeStylesheet;
        if (!stylesheets.contains((Object)BASE)) {
            stylesheets.add((Object)BASE);
        }
        if (!stylesheets.contains((Object)(themeStylesheet = ResourceUtils.getToolStylesheet(theme)))) {
            stylesheets.add((Object)themeStylesheet);
        }
    }

    public static List<String> getSupportedImageExtensions() {
        if (imageExtensions == null) {
            imageExtensions = new ArrayList<String>();
            imageExtensions.add("*.jpg");
            imageExtensions.add("*.jpeg");
            imageExtensions.add("*.png");
            imageExtensions.add("*.gif");
            imageExtensions = Collections.unmodifiableList(imageExtensions);
        }
        return imageExtensions;
    }

    public static List<String> getSupportedAudioExtensions() {
        if (audioExtensions == null) {
            audioExtensions = new ArrayList<String>();
            audioExtensions.add("*.aif");
            audioExtensions.add("*.aiff");
            audioExtensions.add("*.mp3");
            audioExtensions.add("*.m4a");
            audioExtensions.add("*.wav");
            audioExtensions.add("*.m3u");
            audioExtensions.add("*.m3u8");
            audioExtensions = Collections.unmodifiableList(audioExtensions);
        }
        return audioExtensions;
    }

    public static List<String> getSupportedVideoExtensions() {
        if (videoExtensions == null) {
            videoExtensions = new ArrayList<String>();
            videoExtensions.add("*.flv");
            videoExtensions.add("*.fxm");
            videoExtensions.add("*.mp4");
            videoExtensions.add("*.m4v");
            videoExtensions = Collections.unmodifiableList(videoExtensions);
        }
        return videoExtensions;
    }

    public static List<String> getSupportedMediaExtensions() {
        if (mediaExtensions == null) {
            mediaExtensions = new ArrayList<String>();
            mediaExtensions.addAll(ResourceUtils.getSupportedImageExtensions());
            mediaExtensions.addAll(ResourceUtils.getSupportedAudioExtensions());
            mediaExtensions.addAll(ResourceUtils.getSupportedVideoExtensions());
            mediaExtensions = Collections.unmodifiableList(mediaExtensions);
        }
        return mediaExtensions;
    }
}

