/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

public enum DocumentationUrls {
    JAVADOC_HOME("https://openjfx.io/javadoc/24/"),
    ORACLE_DOCUMENTATION("https://docs.oracle.com/javafx/index.html"),
    GLUON_SCENEBUILDER_HOME("https://gluonhq.com/products/scene-builder/"),
    OPENJFX_GETTING_STARTED("https://openjfx.io/openjfx-docs/"),
    OPENJFX_JAVADOC_HOME("https://openjfx.io/javadoc/{javafx.version.major}/"),
    OPENJFX_CSS_REFERENCE("https://openjfx.io/javadoc/{javafx.version.major}/javafx.graphics/javafx/scene/doc-files/cssref.html"),
    OPENJFX_FXML_REFERENCE("https://openjfx.io/javadoc/{javafx.version.major}/javafx.fxml/javafx/fxml/doc-files/introduction_to_fxml.html"),
    GLUON_SCENEBUILDER_CONTRIBUTE("https://github.com/gluonhq/scenebuilder"),
    JFXCENTRAL_HOMEPAGE("https://www.jfx-central.com");

    private static final String SAFE_DEFAULT_VERSION = "21";
    private static String javaFxMajorVersion;
    private final String url;

    private DocumentationUrls(String defaultValue) {
        this.url = defaultValue;
    }

    public String toString() {
        if (javaFxMajorVersion == null) {
            javaFxMajorVersion = DocumentationUrls.getMajorJavaFxVersion();
        }
        return DocumentationUrls.resolveJavaFxVersion(this.url, javaFxMajorVersion);
    }

    String getConfiguredValue() {
        return this.url;
    }

    private static String resolveJavaFxVersion(String url, String majorFxVersion) {
        String placeHolder = "{javafx.version.major}";
        if (url.contains(placeHolder)) {
            return url.replace(placeHolder, majorFxVersion);
        }
        return url;
    }

    static String getMajorJavaFxVersion() {
        return DocumentationUrls.getMajorJavaFxVersion(System.getProperty("javafx.version", SAFE_DEFAULT_VERSION));
    }

    static String getMajorJavaFxVersion(String version) {
        int firstDot = version.indexOf(46);
        if (firstDot > 1) {
            return version.substring(0, firstDot);
        }
        return version;
    }

    static {
        javaFxMajorVersion = null;
    }
}

