/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

import com.oracle.javafx.scenebuilder.kit.ResourceUtils;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.JobManager;
import com.oracle.javafx.scenebuilder.kit.editor.WatchingController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.DragController;
import com.oracle.javafx.scenebuilder.kit.editor.job.AddContextMenuToSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.AddTooltipToSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.BringForwardJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.BringToFrontJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.CutSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DuplicateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.FitToParentSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ImportFileJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.IncludeFileJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifySelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.PasteIntoJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.PasteJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SendBackwardJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SendToBackJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.TrimSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.UseComputedSizesSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.UsePredefinedSizeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.AddColumnJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.AddRowJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.MoveColumnJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.MoveRowJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.SpanJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.UnwrapJob;
import com.oracle.javafx.scenebuilder.kit.editor.messagelog.MessageLog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.editor.report.ErrorReport;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.editor.util.ContextMenuController;
import com.oracle.javafx.scenebuilder.kit.editor.util.InlineEditController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.glossary.BuiltinGlossary;
import com.oracle.javafx.scenebuilder.kit.glossary.Glossary;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.library.LibraryItem;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.PropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardEncoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableListValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Control;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.Effect;
import javafx.scene.input.Clipboard;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class EditorController {
    private final Selection selection = new Selection();
    private final JobManager jobManager = new JobManager(this, 50);
    private final MessageLog messageLog = new MessageLog();
    private final ErrorReport errorReport = new ErrorReport();
    private final DragController dragController = new DragController(this);
    private final InlineEditController inlineEditController = new InlineEditController(this);
    private final ContextMenuController contextMenuController = new ContextMenuController(this);
    private final WatchingController watchingController = new WatchingController(this);
    private double defaultRootContainerWidth = 600.0;
    private double defaultRootContainerHeight = 400.0;
    private final ObjectProperty<FXOMDocument> fxomDocumentProperty = new SimpleObjectProperty();
    private final ObjectProperty<URL> fxmlLocationProperty = new SimpleObjectProperty();
    private final ObjectProperty<Library> libraryProperty = new SimpleObjectProperty((Object)BuiltinLibrary.getLibrary());
    private final ObjectProperty<Glossary> glossaryProperty = new SimpleObjectProperty((Object)new BuiltinGlossary());
    private final ObjectProperty<ResourceBundle> resourcesProperty = new SimpleObjectProperty(null);
    private final ListProperty<File> sceneStyleSheetProperty = new SimpleListProperty();
    private final BooleanProperty pickModeEnabledProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty sampleDataEnabledProperty = new SimpleBooleanProperty(false);
    private final SimpleStringProperty toolStylesheetProperty = new SimpleStringProperty(EditorController.getBuiltinToolStylesheet());
    private Callback<Void, Boolean> requestTextEditingSessionEnd;
    private Stage ownerWindow;
    private static String builtinToolStylesheet;
    private static File nextInitialDirectory;
    private final ObjectProperty<EditorPlatform.Theme> themeProperty = new SimpleObjectProperty<EditorPlatform.Theme>(EditorPlatform.DEFAULT_THEME){

        protected void invalidated() {
            FXOMDocument fxomDocument = EditorController.this.getFxomDocument();
            if (fxomDocument != null) {
                fxomDocument.refreshSceneGraph();
            }
        }
    };
    private static List<Class<?>> classesSupportingWrapping;
    private static URL stylesheet;
    private final ChangeListener<ClassLoader> libraryClassLoaderListener = (ov, t, t1) -> this.libraryClassLoaderDidChange();

    public EditorController() {
        this.jobManager.revisionProperty().addListener((ov, t, t1) -> this.jobManagerRevisionDidChange());
    }

    public double getDefaultRootContainerWidth() {
        return this.defaultRootContainerWidth;
    }

    public void setDefaultRootContainerWidth(double defaultRootContainerWidth) {
        this.defaultRootContainerWidth = defaultRootContainerWidth;
    }

    public double getDefaultRootContainerHeight() {
        return this.defaultRootContainerHeight;
    }

    public void setDefaultRootContainerHeight(double defaultRootContainerHeight) {
        this.defaultRootContainerHeight = defaultRootContainerHeight;
    }

    public void setFxmlText(String fxmlText, boolean checkGluonControls) throws IOException {
        this.setFxmlTextAndLocation(fxmlText, this.getFxmlLocation(), checkGluonControls);
    }

    public String getFxmlText(boolean wildcardImports) {
        String result;
        FXOMDocument fxomDocument = this.getFxomDocument();
        if (fxomDocument == null) {
            result = null;
        } else {
            boolean sampleDataEnabled = fxomDocument.isSampleDataEnabled();
            if (sampleDataEnabled) {
                fxomDocument.setSampleDataEnabled(false);
            }
            result = fxomDocument.getFxmlText(wildcardImports);
            if (sampleDataEnabled) {
                fxomDocument.setSampleDataEnabled(true);
            }
        }
        return result;
    }

    public boolean canGetFxmlText() {
        boolean result;
        if (this.requestTextEditingSessionEnd == null) {
            result = true;
        } else {
            result = (Boolean)this.requestTextEditingSessionEnd.call(null);
            assert (this.requestTextEditingSessionEnd == null || !result);
        }
        return result;
    }

    public void textEditingSessionDidBegin(Callback<Void, Boolean> requestSessionEnd) {
        assert (this.requestTextEditingSessionEnd == null);
        this.requestTextEditingSessionEnd = requestSessionEnd;
    }

    public void textEditingSessionDidEnd() {
        assert (this.requestTextEditingSessionEnd != null);
        this.requestTextEditingSessionEnd = null;
    }

    public boolean isTextEditingSessionOnGoing() {
        return this.requestTextEditingSessionEnd != null;
    }

    public ObservableValue<URL> fxmlLocationProperty() {
        return this.fxmlLocationProperty;
    }

    public void setFxmlLocation(URL fxmlLocation) {
        this.fxmlLocationProperty.setValue((Object)fxmlLocation);
        if (this.getFxomDocument() != null) {
            this.getFxomDocument().setLocation(fxmlLocation);
            this.clearUndoRedo();
        }
        if (fxmlLocation != null) {
            File newInitialDirectory = new File(fxmlLocation.getPath());
            EditorController.updateNextInitialDirectory(newInitialDirectory);
        }
    }

    public Library getLibrary() {
        return (Library)this.libraryProperty.getValue();
    }

    public void setLibrary(Library library) {
        assert (library != null);
        ((Library)this.libraryProperty.getValue()).classLoaderProperty().removeListener(this.libraryClassLoaderListener);
        this.libraryProperty.setValue((Object)library);
        ((Library)this.libraryProperty.getValue()).classLoaderProperty().addListener(this.libraryClassLoaderListener);
        this.libraryClassLoaderDidChange();
    }

    public ObservableValue<Library> libraryProperty() {
        return this.libraryProperty;
    }

    public Glossary getGlossary() {
        return (Glossary)this.glossaryProperty.getValue();
    }

    public void setLibrary(Glossary glossary) {
        assert (glossary != null);
        this.glossaryProperty.setValue((Object)glossary);
    }

    public ObservableValue<Glossary> glossaryProperty() {
        return this.glossaryProperty;
    }

    public ResourceBundle getResources() {
        return (ResourceBundle)this.resourcesProperty.getValue();
    }

    public void setResources(ResourceBundle resources) {
        this.resourcesProperty.setValue((Object)resources);
        this.resourcesDidChange();
    }

    public ObservableValue<ResourceBundle> resourcesProperty() {
        return this.resourcesProperty;
    }

    public EditorPlatform.Theme getTheme() {
        return (EditorPlatform.Theme)this.themeProperty.getValue();
    }

    public void setTheme(EditorPlatform.Theme theme) {
        this.themeProperty.setValue((Object)theme);
    }

    public ObservableValue<EditorPlatform.Theme> themeProperty() {
        return this.themeProperty;
    }

    public void refreshTheme() {
        EditorPlatform.Theme currentTheme = this.getTheme();
        this.setTheme(null);
        this.setTheme(currentTheme);
    }

    public ObservableList<File> getSceneStyleSheets() {
        return this.sceneStyleSheetProperty.getValue();
    }

    public void setSceneStyleSheets(ObservableList<File> styleSheets) {
        this.sceneStyleSheetProperty.setValue(styleSheets);
    }

    public ObservableListValue<File> sceneStyleSheetProperty() {
        return this.sceneStyleSheetProperty;
    }

    public boolean isPickModeEnabled() {
        return this.pickModeEnabledProperty.getValue();
    }

    public void setPickModeEnabled(boolean pickModeEnabled) {
        this.pickModeEnabledProperty.setValue(Boolean.valueOf(pickModeEnabled));
    }

    public ObservableValue<Boolean> pickModeEnabledProperty() {
        return this.pickModeEnabledProperty;
    }

    public boolean isSampleDataEnabled() {
        return this.sampleDataEnabledProperty.getValue();
    }

    public void setSampleDataEnabled(boolean sampleDataEnabled) {
        this.setPickModeEnabled(false);
        this.sampleDataEnabledProperty.setValue(Boolean.valueOf(sampleDataEnabled));
        if (this.getFxomDocument() != null) {
            this.getFxomDocument().setSampleDataEnabled(this.isSampleDataEnabled());
        }
    }

    public ObservableValue<Boolean> sampleDataEnabledProperty() {
        return this.sampleDataEnabledProperty;
    }

    public URL getFxmlLocation() {
        return (URL)this.fxmlLocationProperty.getValue();
    }

    public void setFxmlTextAndLocation(String fxmlText, URL fxmlLocation) throws IOException {
        this.setFxmlTextAndLocation(fxmlText, fxmlLocation, false);
    }

    public void setFxmlTextAndLocation(String fxmlText, URL fxmlLocation, boolean checkTheme) throws IOException {
        this.updateFxomDocument(fxmlText, fxmlLocation, this.getResources(), checkTheme);
        this.fxmlLocationProperty.setValue((Object)fxmlLocation);
    }

    public void setFxmlTextLocationAndResources(String fxmlText, URL fxmlLocation, ResourceBundle resources) throws IOException {
        this.setFxmlTextLocationAndResources(fxmlText, fxmlLocation, resources, false);
    }

    public void setFxmlTextLocationAndResources(String fxmlText, URL fxmlLocation, ResourceBundle resources, boolean checkTheme) throws IOException {
        this.updateFxomDocument(fxmlText, fxmlLocation, resources, checkTheme);
        this.fxmlLocationProperty.setValue((Object)fxmlLocation);
    }

    public ObservableValue<FXOMDocument> fxomDocumentProperty() {
        return this.fxomDocumentProperty;
    }

    public FXOMDocument getFxomDocument() {
        return (FXOMDocument)this.fxomDocumentProperty.getValue();
    }

    public Optional<FXOMDocument> fxomDocument() {
        return Optional.ofNullable(this.getFxomDocument());
    }

    public String getToolStylesheet() {
        return this.toolStylesheetProperty.getValue();
    }

    public void setToolStylesheet(String stylesheet) {
        assert (stylesheet != null);
        this.toolStylesheetProperty.setValue(stylesheet);
    }

    public ObservableValue<String> toolStylesheetProperty() {
        return this.toolStylesheetProperty;
    }

    public static synchronized String getBuiltinToolStylesheet() {
        if (builtinToolStylesheet == null) {
            builtinToolStylesheet = ResourceUtils.THEME_DEFAULT_STYLESHEET;
        }
        return builtinToolStylesheet;
    }

    public void startFileWatching() {
        this.watchingController.start();
    }

    public void stopFileWatching() {
        this.watchingController.stop();
    }

    public boolean isFileWatchingStarted() {
        return this.watchingController.isStarted();
    }

    public Selection getSelection() {
        return this.selection;
    }

    public List<FXOMObject> getSelectedObjects() {
        ArrayList<FXOMObject> selectedObjects = new ArrayList<FXOMObject>();
        Selection selection = this.getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            selectedObjects.addAll(osg.getItems());
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
            selectedObjects.addAll(gsg.collectSelectedObjects());
        } else assert (false);
        return selectedObjects;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public MessageLog getMessageLog() {
        return this.messageLog;
    }

    public ErrorReport getErrorReport() {
        return this.errorReport;
    }

    public DragController getDragController() {
        return this.dragController;
    }

    public InlineEditController getInlineEditController() {
        return this.inlineEditController;
    }

    public ContextMenuController getContextMenuController() {
        return this.contextMenuController;
    }

    public boolean canUndo() {
        return this.jobManager.canUndo();
    }

    public String getUndoDescription() {
        return this.jobManager.getUndoDescription();
    }

    public void undo() {
        this.jobManager.undo();
        assert (!this.getFxomDocument().isUpdateOnGoing());
    }

    public boolean canRedo() {
        return this.jobManager.canRedo();
    }

    public String getRedoDescription() {
        return this.jobManager.getRedoDescription();
    }

    public void redo() {
        this.jobManager.redo();
        assert (!this.getFxomDocument().isUpdateOnGoing());
    }

    public void clearUndoRedo() {
        this.jobManager.clear();
    }

    public void performEditAction(EditAction editAction) {
        switch (editAction.ordinal()) {
            case 9: {
                this.performAddContextMenu();
                break;
            }
            case 10: {
                this.performAddTooltip();
                break;
            }
            case 23: {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                this.jobManager.push(job);
                break;
            }
            case 24: {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.AFTER);
                this.jobManager.push(job);
                break;
            }
            case 21: {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.ABOVE);
                this.jobManager.push(job);
                break;
            }
            case 22: {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.BELOW);
                this.jobManager.push(job);
                break;
            }
            case 31: {
                BringForwardJob job = new BringForwardJob(this);
                this.jobManager.push(job);
                break;
            }
            case 29: {
                BringToFrontJob job = new BringToFrontJob(this);
                this.jobManager.push(job);
                break;
            }
            case 0: {
                CutSelectionJob job = new CutSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case 28: {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_COLUMN_SPAN);
                this.jobManager.push(job);
                break;
            }
            case 26: {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_ROW_SPAN);
                this.jobManager.push(job);
                break;
            }
            case 4: {
                DeleteSelectionJob job = new DeleteSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case 3: {
                DuplicateSelectionJob job = new DuplicateSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case 7: {
                FitToParentSelectionJob job = new FitToParentSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case 27: {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_COLUMN_SPAN);
                this.jobManager.push(job);
                break;
            }
            case 25: {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_ROW_SPAN);
                this.jobManager.push(job);
                break;
            }
            case 19: {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                this.jobManager.push(job);
                break;
            }
            case 20: {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.AFTER);
                this.jobManager.push(job);
                break;
            }
            case 17: {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.ABOVE);
                this.jobManager.push(job);
                break;
            }
            case 18: {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.BELOW);
                this.jobManager.push(job);
                break;
            }
            case 1: {
                PasteJob job = new PasteJob(this);
                this.jobManager.push(job);
                break;
            }
            case 2: {
                PasteIntoJob job = new PasteIntoJob(this);
                this.jobManager.push(job);
                break;
            }
            case 32: {
                SendBackwardJob job = new SendBackwardJob(this);
                this.jobManager.push(job);
                break;
            }
            case 30: {
                SendToBackJob job = new SendToBackJob(this);
                this.jobManager.push(job);
                break;
            }
            case 11: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_335x600);
                this.jobManager.push(job);
                break;
            }
            case 12: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_900x600);
                this.jobManager.push(job);
                break;
            }
            case 13: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_320x240);
                this.jobManager.push(job);
                break;
            }
            case 14: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_640x480);
                this.jobManager.push(job);
                break;
            }
            case 15: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1280x800);
                this.jobManager.push(job);
                break;
            }
            case 16: {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1920x1080);
                this.jobManager.push(job);
                break;
            }
            case 5: {
                TrimSelectionJob job = new TrimSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case 33: {
                UnwrapJob job = new UnwrapJob(this);
                this.jobManager.push(job);
                break;
            }
            case 8: {
                UseComputedSizesSelectionJob job = new UseComputedSizesSelectionJob(this);
                this.jobManager.push(job);
                break;
            }
            case 34: {
                this.performWrap(AnchorPane.class);
                break;
            }
            case 35: {
                this.performWrap(BorderPane.class);
                break;
            }
            case 36: {
                this.performWrap(ButtonBar.class);
                break;
            }
            case 37: {
                this.performWrap(DialogPane.class);
                break;
            }
            case 38: {
                this.performWrap(FlowPane.class);
                break;
            }
            case 39: {
                this.performWrap(GridPane.class);
                break;
            }
            case 40: {
                this.performWrap(Group.class);
                break;
            }
            case 41: {
                this.performWrap(HBox.class);
                break;
            }
            case 42: {
                this.performWrap(Pane.class);
                break;
            }
            case 43: {
                this.performWrap(ScrollPane.class);
                break;
            }
            case 44: {
                this.performWrap(SplitPane.class);
                break;
            }
            case 45: {
                this.performWrap(StackPane.class);
                break;
            }
            case 46: {
                this.performWrap(TabPane.class);
                break;
            }
            case 47: {
                this.performWrap(TextFlow.class);
                break;
            }
            case 48: {
                this.performWrap(TilePane.class);
                break;
            }
            case 49: {
                this.performWrap(TitledPane.class);
                break;
            }
            case 50: {
                this.performWrap(ToolBar.class);
                break;
            }
            case 51: {
                this.performWrap(VBox.class);
                break;
            }
            case 52: {
                this.performWrap(Scene.class);
                break;
            }
            case 53: {
                this.performWrap(Stage.class);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
        assert (!this.getFxomDocument().isUpdateOnGoing());
    }

    public boolean canPerformEditAction(EditAction editAction) {
        return switch (editAction.ordinal()) {
            case 9 -> this.canPerformAddContextMenu();
            case 10 -> this.canPerformAddTooltip();
            case 23 -> {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                yield job.isExecutable();
            }
            case 24 -> {
                AddColumnJob job = new AddColumnJob(this, GridPaneJobUtils.Position.AFTER);
                yield job.isExecutable();
            }
            case 21 -> {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.ABOVE);
                yield job.isExecutable();
            }
            case 22 -> {
                AddRowJob job = new AddRowJob(this, GridPaneJobUtils.Position.BELOW);
                yield job.isExecutable();
            }
            case 31 -> {
                BringForwardJob job = new BringForwardJob(this);
                yield job.isExecutable();
            }
            case 29 -> {
                BringToFrontJob job = new BringToFrontJob(this);
                yield job.isExecutable();
            }
            case 0 -> {
                CutSelectionJob job = new CutSelectionJob(this);
                yield job.isExecutable();
            }
            case 28 -> {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_COLUMN_SPAN);
                yield job.isExecutable();
            }
            case 26 -> {
                SpanJob job = new SpanJob(this, EditAction.DECREASE_ROW_SPAN);
                yield job.isExecutable();
            }
            case 4 -> {
                DeleteSelectionJob job = new DeleteSelectionJob(this);
                yield job.isExecutable();
            }
            case 3 -> {
                DuplicateSelectionJob job = new DuplicateSelectionJob(this);
                yield job.isExecutable();
            }
            case 7 -> {
                FitToParentSelectionJob job = new FitToParentSelectionJob(this);
                yield job.isExecutable();
            }
            case 27 -> {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_COLUMN_SPAN);
                yield job.isExecutable();
            }
            case 25 -> {
                SpanJob job = new SpanJob(this, EditAction.INCREASE_ROW_SPAN);
                yield job.isExecutable();
            }
            case 19 -> {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.BEFORE);
                yield job.isExecutable();
            }
            case 20 -> {
                MoveColumnJob job = new MoveColumnJob(this, GridPaneJobUtils.Position.AFTER);
                yield job.isExecutable();
            }
            case 17 -> {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.ABOVE);
                yield job.isExecutable();
            }
            case 18 -> {
                MoveRowJob job = new MoveRowJob(this, GridPaneJobUtils.Position.BELOW);
                yield job.isExecutable();
            }
            case 1 -> {
                PasteJob job = new PasteJob(this);
                yield job.isExecutable();
            }
            case 2 -> {
                PasteIntoJob job = new PasteIntoJob(this);
                yield job.isExecutable();
            }
            case 32 -> {
                SendBackwardJob job = new SendBackwardJob(this);
                yield job.isExecutable();
            }
            case 30 -> {
                SendToBackJob job = new SendToBackJob(this);
                yield job.isExecutable();
            }
            case 11 -> {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_335x600);
                yield job.isExecutable();
            }
            case 12 -> {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_900x600);
                yield job.isExecutable();
            }
            case 13 -> {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_320x240);
                yield job.isExecutable();
            }
            case 14 -> {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_640x480);
                yield job.isExecutable();
            }
            case 15 -> {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1280x800);
                yield job.isExecutable();
            }
            case 16 -> {
                UsePredefinedSizeJob job = new UsePredefinedSizeJob(this, Size.SIZE_1920x1080);
                yield job.isExecutable();
            }
            case 5 -> {
                TrimSelectionJob job = new TrimSelectionJob(this);
                yield job.isExecutable();
            }
            case 33 -> {
                UnwrapJob job = new UnwrapJob(this);
                yield job.isExecutable();
            }
            case 8 -> {
                UseComputedSizesSelectionJob job = new UseComputedSizesSelectionJob(this);
                yield job.isExecutable();
            }
            case 34 -> this.canPerformWrap(AnchorPane.class);
            case 35 -> this.canPerformWrap(BorderPane.class);
            case 36 -> this.canPerformWrap(ButtonBar.class);
            case 37 -> this.canPerformWrap(DialogPane.class);
            case 38 -> this.canPerformWrap(FlowPane.class);
            case 39 -> this.canPerformWrap(GridPane.class);
            case 40 -> this.canPerformWrap(Group.class);
            case 41 -> this.canPerformWrap(HBox.class);
            case 42 -> this.canPerformWrap(Pane.class);
            case 43 -> this.canPerformWrap(ScrollPane.class);
            case 44 -> this.canPerformWrap(SplitPane.class);
            case 45 -> this.canPerformWrap(StackPane.class);
            case 46 -> this.canPerformWrap(TabPane.class);
            case 47 -> this.canPerformWrap(TextFlow.class);
            case 48 -> this.canPerformWrap(TilePane.class);
            case 49 -> this.canPerformWrap(TitledPane.class);
            case 50 -> this.canPerformWrap(ToolBar.class);
            case 51 -> this.canPerformWrap(VBox.class);
            case 52 -> this.canPerformWrap(Scene.class);
            case 53 -> this.canPerformWrap(Stage.class);
            default -> false;
        };
    }

    public void performControlAction(ControlAction controlAction) {
        switch (controlAction.ordinal()) {
            case 0: {
                this.performCopy();
                break;
            }
            case 6: {
                this.performEditIncludedFile();
                break;
            }
            case 7: {
                this.performRevealIncludedFile();
                break;
            }
            case 1: {
                this.performSelectAll();
                break;
            }
            case 2: {
                this.performSelectNone();
                break;
            }
            case 3: {
                this.performSelectParent();
                break;
            }
            case 4: {
                this.performSelectNext();
                break;
            }
            case 5: {
                this.performSelectPrevious();
                break;
            }
            case 9: {
                this.setSampleDataEnabled(!this.isSampleDataEnabled());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
    }

    public boolean canPerformControlAction(ControlAction controlAction) {
        if (this.getFxomDocument() == null || this.getFxomDocument().getFxomRoot() == null) {
            return false;
        }
        return switch (controlAction.ordinal()) {
            case 0 -> this.canPerformCopy();
            case 6, 7 -> this.canPerformIncludedFileAction();
            case 1 -> this.canPerformSelectAll();
            case 2 -> this.canPerformSelectNone();
            case 3 -> this.canPerformSelectParent();
            case 4 -> this.canPerformSelectNext();
            case 5 -> this.canPerformSelectPrevious();
            case 9 -> true;
            default -> false;
        };
    }

    public void performImportFxml(File fxmlFile) {
        this.performImport(fxmlFile);
    }

    public void performImportMedia(File mediaFile) {
        this.performImport(mediaFile);
    }

    private void performImport(File file) {
        ImportFileJob job = new ImportFileJob(file, this);
        if (job.isExecutable()) {
            this.jobManager.push(job);
        } else {
            Object sceneGraphTarget;
            String target = job.getTargetObject() == null ? null : ((sceneGraphTarget = job.getTargetObject().getSceneGraphObject()) == null ? null : sceneGraphTarget.getClass().getSimpleName());
            if (target != null) {
                this.getMessageLog().logWarningMessage("import.from.file.failed.target", file.getName(), target);
            } else {
                this.getMessageLog().logWarningMessage("import.from.file.failed", file.getName());
            }
        }
    }

    public void performIncludeFxml(File fxmlFile) {
        IncludeFileJob job = new IncludeFileJob(fxmlFile, this);
        if (job.isExecutable()) {
            this.jobManager.push(job);
        } else {
            Object sceneGraphTarget;
            String target = job.getTargetObject() == null ? null : ((sceneGraphTarget = job.getTargetObject().getSceneGraphObject()) == null ? null : sceneGraphTarget.getClass().getSimpleName());
            if (target != null) {
                this.getMessageLog().logWarningMessage("include.file.failed.target", fxmlFile.getName(), target);
            } else {
                this.getMessageLog().logWarningMessage("include.file.failed", fxmlFile.getName());
            }
        }
    }

    public void performInsert(LibraryItem libraryItem) {
        BatchSelectionJob job;
        assert (this.canPerformInsert(libraryItem));
        FXOMDocument newItemDocument = libraryItem.instantiate();
        assert (newItemDocument != null);
        FXOMObject newObject = newItemDocument.getFxomRoot();
        assert (newObject != null);
        newObject.moveToFxomDocument(this.getFxomDocument());
        FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
        if (rootObject == null) {
            String description = I18N.getString("drop.job.insert.library.item", libraryItem.getName());
            job = new SetDocumentRootJob(newObject, true, description, this);
        } else {
            FXOMObject target = this.selection.isEmpty() || this.selection.isSelected(rootObject) ? rootObject : this.selection.getAncestor();
            job = new InsertAsSubComponentJob(newObject, target, -1, this);
        }
        this.jobManager.push(job);
        if (newObject.isClassFromExternalPlugin()) {
            EditorPlatform.showThemeAlert(this.ownerWindow, this.getTheme(), this::setTheme);
        }
    }

    public boolean canPerformInsert(LibraryItem libraryItem) {
        boolean result;
        if (this.getFxomDocument() == null) {
            result = false;
        } else {
            assert (libraryItem.getLibrary().getClassLoader() == null || libraryItem.getLibrary().getClassLoader() == this.getFxomDocument().getClassLoader());
            FXOMDocument newItemDocument = libraryItem.instantiate();
            if (newItemDocument == null) {
                result = false;
            } else {
                FXOMObject newItemRoot = newItemDocument.getFxomRoot();
                newItemRoot.moveToFxomDocument(this.getFxomDocument());
                assert (newItemDocument.getFxomRoot() == null);
                FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
                if (rootObject == null) {
                    SetDocumentRootJob job = new SetDocumentRootJob(newItemRoot, true, "unused", this);
                    result = job.isExecutable();
                } else {
                    FXOMObject targetCandidate = this.selection.isEmpty() || this.selection.isSelected(rootObject) ? rootObject : this.selection.getAncestor();
                    InsertAsSubComponentJob job = new InsertAsSubComponentJob(newItemRoot, targetCandidate, -1, this);
                    result = job.isExecutable();
                }
            }
        }
        return result;
    }

    public void performWrap(Class<?> wrappingClass) {
        assert (this.canPerformWrap(wrappingClass));
        AbstractWrapInJob job = AbstractWrapInJob.getWrapInJob(this, wrappingClass);
        this.jobManager.push(job);
    }

    public boolean canPerformWrap(Class<?> wrappingClass) {
        if (!EditorController.getClassesSupportingWrapping().contains(wrappingClass)) {
            return false;
        }
        AbstractWrapInJob job = AbstractWrapInJob.getWrapInJob(this, wrappingClass);
        return job.isExecutable();
    }

    public static synchronized Collection<Class<?>> getClassesSupportingWrapping() {
        if (classesSupportingWrapping == null) {
            classesSupportingWrapping = new ArrayList();
            classesSupportingWrapping.add(AnchorPane.class);
            classesSupportingWrapping.add(BorderPane.class);
            classesSupportingWrapping.add(ButtonBar.class);
            classesSupportingWrapping.add(DialogPane.class);
            classesSupportingWrapping.add(FlowPane.class);
            classesSupportingWrapping.add(GridPane.class);
            classesSupportingWrapping.add(Group.class);
            classesSupportingWrapping.add(HBox.class);
            classesSupportingWrapping.add(Pane.class);
            classesSupportingWrapping.add(ScrollPane.class);
            classesSupportingWrapping.add(SplitPane.class);
            classesSupportingWrapping.add(StackPane.class);
            classesSupportingWrapping.add(TabPane.class);
            classesSupportingWrapping.add(TextFlow.class);
            classesSupportingWrapping.add(TilePane.class);
            classesSupportingWrapping.add(TitledPane.class);
            classesSupportingWrapping.add(ToolBar.class);
            classesSupportingWrapping.add(VBox.class);
            classesSupportingWrapping.add(Scene.class);
            classesSupportingWrapping.add(Stage.class);
            classesSupportingWrapping = Collections.unmodifiableList(classesSupportingWrapping);
        }
        return classesSupportingWrapping;
    }

    private void performCopy() {
        assert (this.canPerformCopy());
        assert (this.selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)this.selection.getGroup();
        ClipboardEncoder encoder = new ClipboardEncoder(osg.getSortedItems());
        assert (encoder.isEncodable());
        Clipboard.getSystemClipboard().setContent((Map)encoder.makeEncoding());
    }

    private boolean canPerformCopy() {
        return this.selection.getGroup() instanceof ObjectSelectionGroup;
    }

    private void performSelectAll() {
        assert (this.canPerformSelectAll());
        FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
        if (this.selection.isEmpty()) {
            this.selection.select(rootObject);
        } else if (this.selection.getGroup() instanceof ObjectSelectionGroup) {
            FXOMObject ancestor = this.selection.getAncestor();
            assert (ancestor != null);
            DesignHierarchyMask mask = new DesignHierarchyMask(ancestor);
            HashSet<FXOMObject> selectableObjects = new HashSet<FXOMObject>();
            if (mask.getFxomObject().getSceneGraphObject() instanceof BorderPane) {
                FXOMObject top = mask.getAccessory(DesignHierarchyMask.Accessory.TOP);
                FXOMObject left = mask.getAccessory(DesignHierarchyMask.Accessory.LEFT);
                FXOMObject center = mask.getAccessory(DesignHierarchyMask.Accessory.CENTER);
                FXOMObject right = mask.getAccessory(DesignHierarchyMask.Accessory.RIGHT);
                FXOMObject bottom = mask.getAccessory(DesignHierarchyMask.Accessory.BOTTOM);
                for (FXOMObject accessoryObject : new FXOMObject[]{top, left, center, right, bottom}) {
                    if (accessoryObject == null) continue;
                    selectableObjects.add(accessoryObject);
                }
            } else {
                assert (mask.isAcceptingSubComponent());
                selectableObjects.addAll(mask.getSubComponents());
            }
            this.selection.select(selectableObjects);
        } else if (this.selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)this.selection.getGroup();
            FXOMObject gridPane = gsg.getParentObject();
            assert (gridPane instanceof FXOMInstance);
            DesignHierarchyMask gridPaneMask = new DesignHierarchyMask(gridPane);
            int size = 0;
            switch (gsg.getType()) {
                case ROW: {
                    size = gridPaneMask.getRowsSize();
                    break;
                }
                case COLUMN: {
                    size = gridPaneMask.getColumnsSize();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.selection.select((FXOMInstance)gridPane, gsg.getType(), 0);
            for (int index = 1; index < size; ++index) {
                this.selection.toggleSelection((FXOMInstance)gridPane, gsg.getType(), index);
            }
        } else assert (this.selection.getGroup() == null) : "Add implementation for " + String.valueOf(this.selection.getGroup());
    }

    private boolean canPerformSelectAll() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        if (this.selection.isEmpty()) {
            return true;
        }
        if (this.selection.getGroup() instanceof ObjectSelectionGroup) {
            FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
            if (this.selection.isSelected(rootObject)) {
                return false;
            }
            FXOMObject ancestor = this.selection.getAncestor();
            assert (ancestor != null);
            DesignHierarchyMask mask = new DesignHierarchyMask(ancestor);
            if (mask.getFxomObject().getSceneGraphObject() instanceof BorderPane) {
                FXOMObject top = mask.getAccessory(DesignHierarchyMask.Accessory.TOP);
                FXOMObject left = mask.getAccessory(DesignHierarchyMask.Accessory.LEFT);
                FXOMObject center = mask.getAccessory(DesignHierarchyMask.Accessory.CENTER);
                FXOMObject right = mask.getAccessory(DesignHierarchyMask.Accessory.RIGHT);
                FXOMObject bottom = mask.getAccessory(DesignHierarchyMask.Accessory.BOTTOM);
                for (FXOMObject bpAccessoryObject : new FXOMObject[]{top, left, center, right, bottom}) {
                    if (bpAccessoryObject == null || this.selection.isSelected(bpAccessoryObject)) continue;
                    return true;
                }
            } else if (mask.isAcceptingSubComponent()) {
                for (FXOMObject subComponentObject : mask.getSubComponents()) {
                    if (this.selection.isSelected(subComponentObject)) continue;
                    return true;
                }
            }
        } else {
            if (this.selection.getGroup() instanceof GridSelectionGroup) {
                GridSelectionGroup gsg = (GridSelectionGroup)this.selection.getGroup();
                assert (!gsg.getIndexes().isEmpty());
                return true;
            }
            assert (this.selection.getGroup() == null) : "Add implementation for " + String.valueOf(this.selection.getGroup());
        }
        return false;
    }

    private void performSelectParent() {
        assert (this.canPerformSelectParent());
        FXOMObject ancestor = this.selection.getAncestor();
        assert (ancestor != null);
        this.selection.select(ancestor);
    }

    private boolean canPerformSelectParent() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        FXOMObject rootObject = this.getFxomDocument().getFxomRoot();
        return !this.selection.isEmpty() && !this.selection.isSelected(rootObject);
    }

    private void performSelectNext() {
        assert (this.canPerformSelectNext());
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            assert (items.size() == 1);
            FXOMObject selectedObject = items.iterator().next();
            FXOMObject nextSibling = selectedObject.getNextSlibing();
            assert (nextSibling != null);
            this.selection.select(nextSibling);
        } else {
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            FXOMObject gridPane = gsg.getParentObject();
            DesignHierarchyMask mask = new DesignHierarchyMask(gridPane);
            assert (gridPane instanceof FXOMInstance);
            Set<Integer> indexes = gsg.getIndexes();
            assert (indexes.size() == 1);
            int selectedIndex = indexes.iterator().next();
            int nextIndex = selectedIndex + 1;
            int size = 0;
            switch (gsg.getType()) {
                case ROW: {
                    size = mask.getRowsSize();
                    break;
                }
                case COLUMN: {
                    size = mask.getColumnsSize();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (nextIndex < size);
            this.selection.select((FXOMInstance)gridPane, gsg.getType(), nextIndex);
        }
    }

    private boolean canPerformSelectNext() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        if (this.selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            if (items.size() != 1) {
                return false;
            }
            FXOMObject selectedObject = items.iterator().next();
            return selectedObject.getNextSlibing() != null;
        }
        if (asg instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            Set<Integer> indexes = gsg.getIndexes();
            if (indexes.size() != 1) {
                return false;
            }
            FXOMObject gridPane = gsg.getParentObject();
            DesignHierarchyMask mask = new DesignHierarchyMask(gridPane);
            int size = 0;
            switch (gsg.getType()) {
                case ROW: {
                    size = mask.getRowsSize();
                    break;
                }
                case COLUMN: {
                    size = mask.getColumnsSize();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            int index = indexes.iterator().next();
            return index < size - 1;
        }
        assert (this.selection.getGroup() == null) : "Add implementation for " + String.valueOf(this.selection.getGroup());
        return false;
    }

    private void performSelectPrevious() {
        assert (this.canPerformSelectPrevious());
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            assert (items.size() == 1);
            FXOMObject selectedObject = items.iterator().next();
            FXOMObject previousSibling = selectedObject.getPreviousSlibing();
            assert (previousSibling != null);
            this.selection.select(previousSibling);
        } else {
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            FXOMObject gridPane = gsg.getParentObject();
            assert (gridPane instanceof FXOMInstance);
            Set<Integer> indexes = gsg.getIndexes();
            assert (indexes.size() == 1);
            int selectedIndex = indexes.iterator().next();
            int previousIndex = selectedIndex - 1;
            assert (previousIndex >= 0);
            this.selection.select((FXOMInstance)gridPane, gsg.getType(), previousIndex);
        }
    }

    private boolean canPerformSelectPrevious() {
        assert (this.getFxomDocument() != null && this.getFxomDocument().getFxomRoot() != null);
        if (this.selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            Set<FXOMObject> items = osg.getItems();
            if (items.size() != 1) {
                return false;
            }
            FXOMObject selectedObject = items.iterator().next();
            return selectedObject.getPreviousSlibing() != null;
        }
        if (asg instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            Set<Integer> indexes = gsg.getIndexes();
            if (indexes.size() != 1) {
                return false;
            }
            int index = indexes.iterator().next();
            return index > 0;
        }
        assert (this.selection.getGroup() == null) : "Add implementation for " + String.valueOf(this.selection.getGroup());
        return false;
    }

    private void performSelectNone() {
        assert (this.canPerformSelectNone());
        this.selection.clear();
    }

    private boolean canPerformSelectNone() {
        return !this.getSelection().isEmpty();
    }

    public File getIncludedFile() {
        AbstractSelectionGroup asg = this.getSelection().getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return null;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        if (osg.getItems().size() != 1) {
            return null;
        }
        FXOMObject fxomObject = osg.getItems().iterator().next();
        if (!(fxomObject instanceof FXOMIntrinsic)) {
            return null;
        }
        FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fxomObject;
        if (fxomIntrinsic.getType() != FXOMIntrinsic.Type.FX_INCLUDE) {
            return null;
        }
        String source = fxomIntrinsic.getSource();
        if (source == null) {
            return null;
        }
        if (source.startsWith("/")) {
            ClassLoader classLoader = this.getFxomDocument().getClassLoader();
            if (classLoader != null) {
                File file;
                PrefixedValue pv = new PrefixedValue(PrefixedValue.Type.CLASSLOADER_RELATIVE_PATH, source);
                URL url = pv.resolveClassLoaderRelativePath(classLoader);
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException(ex);
                }
                return file;
            }
        } else {
            URL location = this.getFxmlLocation();
            if (location != null) {
                File file;
                PrefixedValue pv = new PrefixedValue(PrefixedValue.Type.DOCUMENT_RELATIVE_PATH, source);
                URL url = pv.resolveDocumentRelativePath(location);
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException(ex);
                }
                return file;
            }
        }
        return null;
    }

    private boolean canPerformIncludedFileAction() {
        return this.getIncludedFile() != null;
    }

    private void performEditIncludedFile() {
        assert (this.canPerformIncludedFileAction());
        File includedFile = this.getIncludedFile();
        assert (includedFile != null);
        try {
            EditorPlatform.open(includedFile.getAbsolutePath());
        }
        catch (IOException re) {
            ErrorDialog errorDialog = new ErrorDialog((Window)this.ownerWindow);
            errorDialog.setTitle(I18N.getString("alert.error.file.open.title"));
            errorDialog.setMessage(I18N.getString("alert.error.file.open.edit.message"));
            errorDialog.setDetails(I18N.getString("alert.error.file.reveal.details", includedFile.getAbsolutePath()));
            errorDialog.setDetailsTitle(I18N.getString("alert.error.file.open.edit.details.title"));
            errorDialog.setDebugInfoWithThrowable(re);
            errorDialog.showAndWait();
        }
    }

    private void performRevealIncludedFile() {
        assert (this.canPerformIncludedFileAction());
        File includedFile = this.getIncludedFile();
        assert (includedFile != null);
        try {
            EditorPlatform.revealInFileBrowser(includedFile);
        }
        catch (IOException ioe) {
            ErrorDialog errorDialog = new ErrorDialog((Window)this.ownerWindow);
            errorDialog.setTitle(I18N.getString("alert.error.file.reveal.title"));
            errorDialog.setMessage(I18N.getString("alert.error.file.reveal.message"));
            errorDialog.setDetails(I18N.getString("alert.error.file.reveal.details", includedFile.getAbsolutePath()));
            errorDialog.setDetailsTitle(I18N.getString("alert.error.file.reveal.details.title"));
            errorDialog.setDebugInfoWithThrowable(ioe);
            errorDialog.showAndWait();
        }
    }

    public boolean canPerformSetEffect() {
        return this.isSelectionNode();
    }

    public void performSetEffect(Class<? extends Effect> effectClass) {
        assert (this.canPerformSetEffect());
        Effect effect = Utils.newInstance(effectClass);
        PropertyName pn = new PropertyName("effect");
        PropertyMetadata pm = Metadata.getMetadata().queryProperty(Node.class, pn);
        assert (pm instanceof ValuePropertyMetadata);
        ValuePropertyMetadata vpm = (ValuePropertyMetadata)pm;
        ModifySelectionJob job = new ModifySelectionJob(vpm, effect, this);
        this.getJobManager().push(job);
    }

    public boolean canPerformAddContextMenu() {
        return this.isSelectionControl();
    }

    public void performAddContextMenu() {
        assert (this.canPerformAddContextMenu());
        AddContextMenuToSelectionJob addContextMenuJob = new AddContextMenuToSelectionJob(this);
        this.getJobManager().push(addContextMenuJob);
    }

    public boolean canPerformAddTooltip() {
        return this.isSelectionControl();
    }

    public void performAddTooltip() {
        assert (this.canPerformAddTooltip());
        AddTooltipToSelectionJob addTooltipJob = new AddTooltipToSelectionJob(this);
        this.getJobManager().push(addTooltipJob);
    }

    public static synchronized URL getStylesheet() {
        if (stylesheet == null) {
            stylesheet = EditorController.class.getResource("EditorController.css");
            assert (stylesheet != null);
        }
        return stylesheet;
    }

    public static File getNextInitialDirectory() {
        return nextInitialDirectory;
    }

    public static void updateNextInitialDirectory(File chosenFile) {
        assert (chosenFile != null);
        Path chosenFolder = chosenFile.toPath().getParent();
        if (chosenFolder != null) {
            nextInitialDirectory = chosenFolder.toFile();
        }
    }

    public boolean is3D() {
        Object sgroot;
        boolean res = false;
        FXOMDocument doc = this.getFxomDocument();
        if (doc != null && (sgroot = doc.getSceneGraphRoot()) instanceof Node) {
            Bounds rootBounds = ((Node)sgroot).getLayoutBounds();
            res = rootBounds.getDepth() > 0.0;
        }
        return res;
    }

    public boolean isNode() {
        Object sgroot;
        boolean res = false;
        FXOMDocument doc = this.getFxomDocument();
        if (doc != null && (sgroot = doc.getSceneGraphRoot()) instanceof Node) {
            res = true;
        }
        return res;
    }

    public boolean isSelectionNode() {
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            for (FXOMObject fxomObject : osg.getItems()) {
                boolean isNode = fxomObject.getSceneGraphObject() instanceof Node;
                if (isNode) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isSelectionControl() {
        AbstractSelectionGroup asg = this.selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            for (FXOMObject fxomObject : osg.getItems()) {
                boolean isControl = fxomObject.getSceneGraphObject() instanceof Control;
                if (isControl) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void updateFxomDocument(String fxmlText, URL fxmlLocation, ResourceBundle resources, boolean checkTheme) throws IOException {
        FXOMDocument newFxomDocument = fxmlText != null ? new FXOMDocument(fxmlText, fxmlLocation, this.getLibrary().getClassLoader(), resources, FXOMDocument.FXOMDocumentSwitch.NORMALIZED) : null;
        this.jobManager.clear();
        this.selection.clear();
        this.messageLog.clear();
        this.errorReport.setFxomDocument(newFxomDocument);
        this.fxomDocumentProperty.setValue((Object)newFxomDocument);
        this.watchingController.fxomDocumentDidChange();
        if (checkTheme && newFxomDocument != null && newFxomDocument.hasControlsFromExternalPlugin()) {
            EditorPlatform.showThemeAlert(this.getOwnerWindow(), this.getTheme(), this::setTheme);
        }
    }

    private void libraryClassLoaderDidChange() {
        if (this.getFxomDocument() != null) {
            this.errorReport.forget();
            this.getFxomDocument().setClassLoader(((Library)this.libraryProperty.get()).getClassLoader());
        }
    }

    private void resourcesDidChange() {
        if (this.getFxomDocument() != null) {
            this.errorReport.forget();
            this.getFxomDocument().setResources(this.getResources());
        }
    }

    private void jobManagerRevisionDidChange() {
        this.errorReport.forget();
        this.watchingController.jobManagerRevisionDidChange();
    }

    public void setOwnerWindow(Stage ownerWindow) {
        this.ownerWindow = ownerWindow;
    }

    public Stage getOwnerWindow() {
        return this.ownerWindow;
    }

    static {
        nextInitialDirectory = new File(System.getProperty("user.home"));
        stylesheet = null;
    }

    public static enum EditAction {
        CUT,
        PASTE,
        PASTE_INTO,
        DUPLICATE,
        DELETE,
        TRIM,
        TOGGLE_FX_ROOT,
        FIT_TO_PARENT,
        USE_COMPUTED_SIZES,
        ADD_CONTEXT_MENU,
        ADD_TOOLTIP,
        SET_SIZE_335x600,
        SET_SIZE_900x600,
        SET_SIZE_320x240,
        SET_SIZE_640x480,
        SET_SIZE_1280x800,
        SET_SIZE_1920x1080,
        MOVE_ROW_ABOVE,
        MOVE_ROW_BELOW,
        MOVE_COLUMN_BEFORE,
        MOVE_COLUMN_AFTER,
        ADD_ROW_ABOVE,
        ADD_ROW_BELOW,
        ADD_COLUMN_BEFORE,
        ADD_COLUMN_AFTER,
        INCREASE_ROW_SPAN,
        DECREASE_ROW_SPAN,
        INCREASE_COLUMN_SPAN,
        DECREASE_COLUMN_SPAN,
        BRING_TO_FRONT,
        SEND_TO_BACK,
        BRING_FORWARD,
        SEND_BACKWARD,
        UNWRAP,
        WRAP_IN_ANCHOR_PANE,
        WRAP_IN_BORDER_PANE,
        WRAP_IN_BUTTON_BAR,
        WRAP_IN_DIALOG_PANE,
        WRAP_IN_FLOW_PANE,
        WRAP_IN_GRID_PANE,
        WRAP_IN_GROUP,
        WRAP_IN_HBOX,
        WRAP_IN_PANE,
        WRAP_IN_SCROLL_PANE,
        WRAP_IN_SPLIT_PANE,
        WRAP_IN_STACK_PANE,
        WRAP_IN_TAB_PANE,
        WRAP_IN_TEXT_FLOW,
        WRAP_IN_TILE_PANE,
        WRAP_IN_TITLED_PANE,
        WRAP_IN_TOOL_BAR,
        WRAP_IN_VBOX,
        WRAP_IN_SCENE,
        WRAP_IN_STAGE;

    }

    public static enum Size {
        SIZE_335x600,
        SIZE_900x600,
        SIZE_320x240,
        SIZE_640x480,
        SIZE_1280x800,
        SIZE_1920x1080,
        SIZE_PREFERRED,
        SIZE_DEFAULT;

    }

    public static enum ControlAction {
        COPY,
        SELECT_ALL,
        SELECT_NONE,
        SELECT_PARENT,
        SELECT_NEXT,
        SELECT_PREVIOUS,
        EDIT_INCLUDED_FILE,
        REVEAL_INCLUDED_FILE,
        TOGGLE_CSS_SELECTION,
        TOGGLE_SAMPLE_DATA;

    }
}

