/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

import com.oracle.javafx.scenebuilder.kit.editor.Cmd;
import com.oracle.javafx.scenebuilder.kit.editor.ExternalThemeProvider;
import com.oracle.javafx.scenebuilder.kit.editor.FileBrowserRevealException;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class EditorPlatform {
    private static final Logger LOGGER = Logger.getLogger(EditorPlatform.class.getName());
    private static final String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    public static final boolean IS_LINUX;
    public static final boolean IS_MAC;
    public static final boolean IS_WINDOWS;
    public static final Theme DEFAULT_THEME;
    private static final Collection<ExternalThemeProvider> externalThemeProviders;

    EditorPlatform() {
    }

    public static boolean isPlatformThemeStylesheetURL(String stylesheetURL) {
        return stylesheetURL != null && stylesheetURL.equals(Theme.MODENA.getStylesheetURLs().getFirst());
    }

    public static String getPlatformThemeStylesheetURL() {
        return Theme.MODENA.getStylesheetURLs().getFirst();
    }

    public static boolean isModena(Theme theme) {
        return theme.toString().startsWith("MODENA");
    }

    public static boolean isModenaBlackOnWhite(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("BLACK_ON_WHITE");
    }

    public static boolean isModenaWhiteOnBlack(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("WHITE_ON_BLACK");
    }

    public static boolean isModenaYellowOnBlack(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("YELLOW_ON_BLACK");
    }

    public static boolean isModenaHighContrast(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("HIGH_CONTRAST");
    }

    public static boolean isModenaTouch(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("TOUCH");
    }

    public static boolean isModenaTouchHighContrast(Theme theme) {
        return EditorPlatform.isModena(theme) && theme.toString().contains("HIGH_CONTRAST") && theme.toString().contains("TOUCH");
    }

    public static boolean isCaspian(Theme theme) {
        return theme.toString().startsWith("CASPIAN");
    }

    public static void open(String path) throws IOException, FileBrowserRevealException {
        ArrayList<String> args = new ArrayList<String>();
        if (IS_MAC) {
            args.add("open");
            args.add(path);
        } else if (IS_WINDOWS) {
            args.add("cmd");
            args.add("/c");
            args.add("start");
            if (path.contains(" ")) {
                args.add("\"html\"");
            }
            args.add(path);
        } else if (IS_LINUX) {
            args.add("xdg-open");
            args.add(path);
        }
        if (!args.isEmpty()) {
            EditorPlatform.executeDaemon(args, null, 0);
        }
    }

    public static void revealInFileBrowser(File filePath) throws IOException, FileBrowserRevealException {
        ArrayList<String> args = new ArrayList<String>();
        String path = Paths.get(filePath.toURI()).normalize().toAbsolutePath().toString();
        int exitCodeOk = 0;
        if (IS_MAC) {
            args.add("open");
            args.add("-R");
            args.add(path);
        } else if (IS_WINDOWS) {
            args.add("explorer");
            args.add("/select," + path);
            exitCodeOk = 1;
        } else if (IS_LINUX) {
            args.add("xdg-open");
            path = filePath.getAbsoluteFile().getParent();
            if (path == null) {
                path = ".";
            }
            args.add(path);
        } else {
            LOGGER.log(Level.SEVERE, "Unsupported operating system! Cannot reveal location {0} in file browser.", path);
        }
        if (!args.isEmpty()) {
            EditorPlatform.executeDaemon(args, null, exitCodeOk);
        }
    }

    public static boolean isContinuousSelectKeyDown(MouseEvent e) {
        return e.isShiftDown();
    }

    public static boolean isNonContinousSelectKeyDown(MouseEvent e) {
        return IS_MAC ? e.isMetaDown() : e.isControlDown();
    }

    public static boolean isAssertionEnabled() {
        return EditorPlatform.class.desiredAssertionStatus();
    }

    private static void executeDaemon(List<String> cmd, File wDir, int exitCodeOk) throws IOException, FileBrowserRevealException {
        String cmdLine = String.join((CharSequence)" ", cmd);
        long timeoutSec = 5L;
        try {
            int exitValue = new Cmd().exec(cmd, wDir, timeoutSec);
            if (exitCodeOk != exitValue) {
                LOGGER.log(Level.SEVERE, "Error during attempt to run: {0} in {1}", new Object[]{cmdLine, wDir});
                throw new FileBrowserRevealException("The command to reval the file exited with an error (exitValue=%s).\nCommand: %s\nWorking Dir: %s".formatted(Integer.toString(exitValue), cmdLine, wDir));
            }
            LOGGER.log(Level.FINE, "Successfully executed command: {0} in {1}", new Object[]{cmdLine, wDir});
        }
        catch (RuntimeException ex) {
            LOGGER.log(Level.SEVERE, "Unknown error during attempt to run: {0} in {1}", new Object[]{cmdLine, wDir});
            throw new IOException(ex);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Process timeout after {0}s: {1} in {2}", new Object[]{timeoutSec, cmdLine, wDir});
            Thread.currentThread().interrupt();
            String msg = "The command to reveal the file exited with an error after timeout.\nCommand: %s\nWorking Dir: %s\nTimeout (s):%s".formatted(cmdLine, wDir, timeoutSec);
            String detailMsg = msg + "\n" + e.getMessage();
            throw new IOException(detailMsg);
        }
    }

    private static List<Theme> getExternalThemes() {
        ArrayList<Theme> result = new ArrayList<Theme>();
        for (ExternalThemeProvider provider : externalThemeProviders) {
            result.addAll(provider.getExternalThemes());
        }
        return result;
    }

    public static List<String> getStylesheetsForTheme(Theme theme) {
        Iterator<ExternalThemeProvider> iterator;
        if (EditorPlatform.getExternalThemes().contains(theme) && (iterator = externalThemeProviders.iterator()).hasNext()) {
            ExternalThemeProvider provider = iterator.next();
            return provider.getExternalStylesheets();
        }
        return List.of();
    }

    public static void showThemeAlert(Stage owner, Theme currentTheme, Consumer<Theme> onSuccess) {
        for (ExternalThemeProvider provider : externalThemeProviders) {
            provider.showThemeAlert(owner, currentTheme, onSuccess);
        }
    }

    public static void showImportAlert(Stage owner) {
        for (ExternalThemeProvider provider : externalThemeProviders) {
            provider.showImportAlert(owner);
        }
    }

    public static boolean hasClassFromExternalPlugin(String text) {
        for (ExternalThemeProvider provider : externalThemeProviders) {
            if (!provider.hasClassFromExternalPlugin(text)) continue;
            return true;
        }
        return false;
    }

    public static Optional<String> getExternalJavadocURL(String classname) {
        for (ExternalThemeProvider provider : externalThemeProviders) {
            if (!provider.hasClassFromExternalPlugin(classname)) continue;
            return Optional.of(provider.getExternalJavadocURL());
        }
        return Optional.empty();
    }

    private static Collection<ExternalThemeProvider> getExternalThemeProviders() {
        ServiceLoader<ExternalThemeProvider> loader = ServiceLoader.load(ExternalThemeProvider.class);
        ArrayList<ExternalThemeProvider> providers = new ArrayList<ExternalThemeProvider>();
        loader.iterator().forEachRemaining(providers::add);
        return providers;
    }

    static {
        LOGGER.log(Level.FINE, "Detected Operating System: {0}", osName);
        IS_LINUX = osName.contains("linux");
        IS_MAC = osName.contains("mac");
        IS_WINDOWS = osName.contains("windows");
        DEFAULT_THEME = Theme.MODENA;
        externalThemeProviders = EditorPlatform.getExternalThemeProviders();
    }

    public record Theme(String name, String value, String[] stylesheetURLs) {
        private static final String MODENA_PATH = "com/sun/javafx/scene/control/skin/modena/";
        private static final String CASPIAN_PATH = "com/sun/javafx/scene/control/skin/caspian/";
        public static final Theme MODENA = new Theme("MODENA", I18N.getString("title.theme.modena"), "com/sun/javafx/scene/control/skin/modena/modena.css");
        public static final Theme MODENA_TOUCH = new Theme("MODENA_TOUCH", I18N.getString("title.theme.modena_touch"), "com/sun/javafx/scene/control/skin/modena/modena.css", "com/sun/javafx/scene/control/skin/modena/touch.css");
        public static final Theme MODENA_HIGH_CONTRAST_BLACK_ON_WHITE = new Theme("MODENA_HIGH_CONTRAST_BLACK_ON_WHITE", I18N.getString("title.theme.modena_high_contrast_black_on_white"), "com/sun/javafx/scene/control/skin/modena/modena.css", "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css");
        public static final Theme MODENA_HIGH_CONTRAST_WHITE_ON_BLACK = new Theme("MODENA_HIGH_CONTRAST_WHITE_ON_BLACK", I18N.getString("title.theme.modena_high_contrast_white_on_black"), "com/sun/javafx/scene/control/skin/modena/modena.css", "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css");
        public static final Theme MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK = new Theme("MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK", I18N.getString("title.theme.modena_high_contrast_yellow_on_black"), "com/sun/javafx/scene/control/skin/modena/modena.css", "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css");
        public static final Theme MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE = new Theme("MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE", I18N.getString("title.theme.modena_touch_high_contrast_black_on_white"), "com/sun/javafx/scene/control/skin/modena/modena.css", "com/sun/javafx/scene/control/skin/modena/touch.css", "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css");
        public static final Theme MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK = new Theme("MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK", I18N.getString("title.theme.modena_touch_high_contrast_white_on_black"), "com/sun/javafx/scene/control/skin/modena/modena.css", "com/sun/javafx/scene/control/skin/modena/touch.css", "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css");
        public static final Theme MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK = new Theme("MODENA_TOUCH_HIGH_CONTRAST_YELLOW_ON_BLACK", I18N.getString("title.theme.modena_touch_high_contrast_yellow_on_black"), "com/sun/javafx/scene/control/skin/modena/modena.css", "com/sun/javafx/scene/control/skin/modena/touch.css", "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css");
        public static final Theme CASPIAN = new Theme("CASPIAN", I18N.getString("title.theme.caspian"), "com/sun/javafx/scene/control/skin/caspian/caspian.css");
        public static final Theme CASPIAN_HIGH_CONTRAST = new Theme("CASPIAN_HIGH_CONTRAST", I18N.getString("title.theme.caspian_high_contrast"), "com/sun/javafx/scene/control/skin/caspian/caspian.css", "com/sun/javafx/scene/control/skin/caspian/highcontrast.css");
        public static final Theme CASPIAN_EMBEDDED = new Theme("CASPIAN_EMBEDDED", I18N.getString("title.theme.caspian_embedded"), "com/sun/javafx/scene/control/skin/caspian/caspian.css", "com/sun/javafx/scene/control/skin/caspian/embedded.css");
        public static final Theme CASPIAN_EMBEDDED_HIGH_CONTRAST = new Theme("CASPIAN_EMBEDDED_HIGH_CONTRAST", I18N.getString("title.theme.caspian_embedded_high_contrast"), "com/sun/javafx/scene/control/skin/caspian/caspian.css", "com/sun/javafx/scene/control/skin/caspian/embedded.css", "com/sun/javafx/scene/control/skin/caspian/highcontrast.css");
        public static final Theme CASPIAN_EMBEDDED_QVGA = new Theme("CASPIAN_EMBEDDED_QVGA", I18N.getString("title.theme.caspian_embedded_qvga"), "com/sun/javafx/scene/control/skin/caspian/caspian.css", "com/sun/javafx/scene/control/skin/caspian/embedded.css", "com/sun/javafx/scene/control/skin/caspian/embedded-qvga.css");
        public static final Theme CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST = new Theme("CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST", I18N.getString("title.theme.caspian_embedded_qvga_high_contrast"), "com/sun/javafx/scene/control/skin/caspian/caspian.css", "com/sun/javafx/scene/control/skin/caspian/embedded.css", "com/sun/javafx/scene/control/skin/caspian/embedded-qvga.css", "com/sun/javafx/scene/control/skin/caspian/highcontrast.css");

        @Override
        public String toString() {
            return this.value;
        }

        public List<String> getStylesheetURLs() {
            return List.of(this.stylesheetURLs);
        }

        public static List<Theme> getThemeList() {
            ArrayList<Theme> themeList = new ArrayList<Theme>(List.of(MODENA, MODENA_TOUCH, MODENA_HIGH_CONTRAST_BLACK_ON_WHITE, MODENA_HIGH_CONTRAST_WHITE_ON_BLACK, MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK, MODENA_TOUCH_HIGH_CONTRAST_BLACK_ON_WHITE, MODENA_TOUCH_HIGH_CONTRAST_WHITE_ON_BLACK, MODENA_HIGH_CONTRAST_YELLOW_ON_BLACK, CASPIAN, CASPIAN_EMBEDDED, CASPIAN_EMBEDDED_HIGH_CONTRAST, CASPIAN_EMBEDDED_QVGA, CASPIAN_EMBEDDED_QVGA_HIGH_CONTRAST));
            themeList.addAll(0, EditorPlatform.getExternalThemes());
            return themeList;
        }

        public static Theme valueOf(String themeName) {
            return Theme.getThemeList().stream().filter(t -> t.name().equals(themeName)).findFirst().orElse(DEFAULT_THEME);
        }
    }

    public static enum OS {
        LINUX,
        MAC,
        WINDOWS;


        public static OS get() {
            return IS_LINUX ? LINUX : (IS_MAC ? MAC : WINDOWS);
        }
    }
}

