/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;

class LiveUpdater {
    private final AbstractDragSource dragSource;
    private final EditorController editorController;
    private AbstractDropTarget dropTarget;
    private Job dropTargetMoveJob;

    public LiveUpdater(AbstractDragSource dragSource, EditorController editorController) {
        assert (dragSource != null);
        assert (editorController != null);
        this.dragSource = dragSource;
        this.editorController = editorController;
    }

    public void setDropTarget(AbstractDropTarget newDropTarget) {
        assert (newDropTarget == null || this.dropTarget != newDropTarget);
        if (this.dropTarget != null) {
            assert (this.dropTargetMoveJob != null);
            this.dropTargetMoveJob.undo();
        }
        this.dropTarget = newDropTarget;
        this.dropTargetMoveJob = null;
        if (this.dropTarget != null) {
            this.dropTargetMoveJob = this.dropTarget.makeDropJob(this.dragSource, this.editorController);
            this.dropTargetMoveJob.execute();
        }
    }

    public AbstractDropTarget getDropTarget() {
        return this.dropTarget;
    }
}

