/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.source;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.DragSourceShadow;
import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardEncoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.Chart;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.stage.Window;

public class DocumentDragSource
extends AbstractDragSource {
    private final List<FXOMObject> draggedObjects = new ArrayList<FXOMObject>();
    private final FXOMObject hitObject;
    private final double hitX;
    private final double hitY;
    private final boolean nodeOnly;
    private final boolean singleImageViewOnly;
    private final boolean singleTooltipOnly;
    private final boolean singleContextMenuOnly;

    public DocumentDragSource(List<FXOMObject> draggedObjects, FXOMObject hitObject, double hitX, double hitY, Window ownerWindow) {
        super(ownerWindow);
        assert (draggedObjects != null);
        assert (hitObject != null);
        assert (draggedObjects.contains(hitObject));
        this.draggedObjects.addAll(draggedObjects);
        this.hitObject = hitObject;
        this.hitX = hitX;
        this.hitY = hitY;
        this.nodeOnly = this.checkForNodeOnly();
        if (draggedObjects.size() != 1) {
            this.singleImageViewOnly = false;
            this.singleTooltipOnly = false;
            this.singleContextMenuOnly = false;
        } else {
            FXOMObject draggedObject = draggedObjects.get(0);
            if (draggedObject instanceof FXOMInstance) {
                Object sceneGraphObject = draggedObject.getSceneGraphObject();
                this.singleImageViewOnly = sceneGraphObject instanceof ImageView;
                this.singleTooltipOnly = sceneGraphObject instanceof Tooltip;
                this.singleContextMenuOnly = sceneGraphObject instanceof ContextMenu;
            } else {
                this.singleImageViewOnly = false;
                this.singleTooltipOnly = false;
                this.singleContextMenuOnly = false;
            }
        }
    }

    public DocumentDragSource(List<FXOMObject> draggedObjects, FXOMObject hitObject, Window ownerWindow) {
        super(ownerWindow);
        assert (draggedObjects != null);
        assert (hitObject != null);
        assert (draggedObjects.contains(hitObject));
        this.draggedObjects.addAll(draggedObjects);
        this.hitObject = hitObject;
        Point2D hitPoint = DocumentDragSource.computeDefaultHit(hitObject);
        this.hitX = hitPoint.getX();
        this.hitY = hitPoint.getY();
        this.nodeOnly = this.checkForNodeOnly();
        if (draggedObjects.size() != 1) {
            this.singleImageViewOnly = false;
            this.singleTooltipOnly = false;
            this.singleContextMenuOnly = false;
        } else {
            FXOMObject draggedObject = draggedObjects.get(0);
            if (draggedObject instanceof FXOMInstance) {
                Object sceneGraphObject = draggedObject.getSceneGraphObject();
                this.singleImageViewOnly = sceneGraphObject instanceof ImageView;
                this.singleTooltipOnly = sceneGraphObject instanceof Tooltip;
                this.singleContextMenuOnly = sceneGraphObject instanceof ContextMenu;
            } else {
                this.singleImageViewOnly = false;
                this.singleTooltipOnly = false;
                this.singleContextMenuOnly = false;
            }
        }
    }

    private static Point2D computeDefaultHit(FXOMObject fxomObject) {
        double hitY;
        double hitX;
        if (fxomObject.getSceneGraphObject() instanceof Node) {
            Node sceneGraphNode = (Node)fxomObject.getSceneGraphObject();
            Bounds lb = sceneGraphNode.getLayoutBounds();
            hitX = (lb.getMinX() + lb.getMaxX()) / 2.0;
            hitY = (lb.getMinY() + lb.getMaxY()) / 2.0;
        } else {
            hitX = 0.0;
            hitY = 0.0;
        }
        return new Point2D(hitX, hitY);
    }

    @Override
    public boolean isAcceptable() {
        boolean result = true;
        for (FXOMObject draggedObject : this.draggedObjects) {
            FXOMObject parentObject;
            if (!(draggedObject.getSceneGraphObject() instanceof Axis) || (parentObject = draggedObject.getParentObject()) == null || !(parentObject.getSceneGraphObject() instanceof Chart)) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public List<FXOMObject> getDraggedObjects() {
        return this.draggedObjects;
    }

    @Override
    public FXOMObject getHitObject() {
        return this.hitObject;
    }

    @Override
    public double getHitX() {
        return this.hitX;
    }

    @Override
    public double getHitY() {
        return this.hitY;
    }

    @Override
    public ClipboardContent makeClipboardContent() {
        ClipboardEncoder encoder = new ClipboardEncoder(this.draggedObjects);
        assert (encoder.isEncodable());
        ClipboardContent result = encoder.makeEncoding();
        return result;
    }

    @Override
    public Image makeDragView() {
        DesignHierarchyMask mask = new DesignHierarchyMask(this.hitObject);
        URL resource = mask.getClassNameIconURL();
        Image image = resource == null ? ImageUtils.getNodeIcon("MissingIcon.png") : new Image(resource.toExternalForm());
        Label visualNode = new Label();
        visualNode.setGraphic((Node)new ImageView(image));
        visualNode.getStylesheets().add((Object)EditorController.getStylesheet().toString());
        visualNode.getStyleClass().add((Object)"drag-preview");
        return ImageUtils.getImageFromNode((Node)visualNode);
    }

    @Override
    public Node makeShadow() {
        Point2D hitPoint;
        Group result = new Group();
        result.getStylesheets().add((Object)EditorController.getStylesheet().toString());
        for (FXOMObject draggedObject : this.draggedObjects) {
            if (!(draggedObject.getSceneGraphObject() instanceof Node)) continue;
            Node sceneGraphNode = (Node)draggedObject.getSceneGraphObject();
            DragSourceShadow shadowNode = new DragSourceShadow();
            shadowNode.setupForNode(sceneGraphNode);
            shadowNode.getTransforms().add((Object)sceneGraphNode.getLocalToParentTransform());
            result.getChildren().add((Object)shadowNode);
        }
        if (this.hitObject.getSceneGraphObject() instanceof Node) {
            Node hitNode = (Node)this.hitObject.getSceneGraphObject();
            hitPoint = hitNode.localToParent(this.hitX, this.hitY);
        } else {
            hitPoint = Point2D.ZERO;
        }
        result.setTranslateX(-hitPoint.getX());
        result.setTranslateY(-hitPoint.getY());
        return result;
    }

    @Override
    public String makeDropJobDescription() {
        String result;
        if (this.draggedObjects.size() == 1) {
            FXOMObject draggedObject = this.draggedObjects.get(0);
            Object sceneGraphObject = draggedObject.getSceneGraphObject();
            result = sceneGraphObject == null ? I18N.getString("drop.job.move.single.unresolved") : I18N.getString("drop.job.move.single.resolved", sceneGraphObject.getClass().getSimpleName());
        } else {
            boolean homogeneous;
            HashSet classes = new HashSet();
            int unresolvedCount = 0;
            for (FXOMObject o : this.draggedObjects) {
                if (o.getSceneGraphObject() != null) {
                    classes.add(o.getSceneGraphObject().getClass());
                    continue;
                }
                ++unresolvedCount;
            }
            boolean bl = homogeneous = classes.size() == 1 && unresolvedCount == 0;
            if (homogeneous) {
                Class singleClass = (Class)classes.iterator().next();
                result = I18N.getString("drop.job.move.multiple.homogeneous", this.draggedObjects.size(), singleClass.getSimpleName());
            } else {
                result = I18N.getString("drop.job.move.multiple.heterogeneous", this.draggedObjects.size());
            }
        }
        return result;
    }

    @Override
    public boolean isNodeOnly() {
        return this.nodeOnly;
    }

    @Override
    public boolean isSingleImageViewOnly() {
        return this.singleImageViewOnly;
    }

    @Override
    public boolean isSingleTooltipOnly() {
        return this.singleTooltipOnly;
    }

    @Override
    public boolean isSingleContextMenuOnly() {
        return this.singleContextMenuOnly;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": hitObject=(" + String.valueOf(this.hitObject) + ")";
    }

    private boolean checkForNodeOnly() {
        int nonNodeCount = 0;
        for (FXOMObject draggedObject : this.draggedObjects) {
            if (draggedObject.isNode()) continue;
            ++nonNodeCount;
        }
        return nonNodeCount == 0;
    }
}

