/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.target;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.drag.source.AbstractDragSource;
import com.oracle.javafx.scenebuilder.kit.editor.drag.target.AbstractDropTarget;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.Objects;

public class CollectionDropTarget
extends AbstractDropTarget {
    private final FXOMCollection targetCollection;
    private final int targetIndex;

    public CollectionDropTarget(FXOMCollection targetCollection, int targetIndex) {
        this.targetCollection = targetCollection;
        this.targetIndex = targetIndex;
    }

    public FXOMCollection getTargetCollection() {
        return this.targetCollection;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    @Override
    public FXOMObject getTargetObject() {
        return this.targetCollection;
    }

    @Override
    public boolean acceptDragSource(AbstractDragSource dragSource) {
        assert (dragSource != null);
        return !dragSource.getDraggedObjects().isEmpty();
    }

    @Override
    public Job makeDropJob(AbstractDragSource dragSource, EditorController editorController) {
        throw new UnsupportedOperationException("To be implemented");
    }

    @Override
    public boolean isSelectRequiredAfterDrop() {
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.targetCollection);
        hash = 37 * hash + this.targetIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionDropTarget other = (CollectionDropTarget)obj;
        if (!Objects.equals(this.targetCollection, other.targetCollection)) {
            return false;
        }
        return this.targetIndex == other.targetIndex;
    }

    public String toString() {
        return "CollectionDropTarget{targetCollection=" + String.valueOf(this.targetCollection) + ", targetIndex=" + this.targetIndex + "}";
    }
}

