/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsAccessoryJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AddContextMenuToSelectionJob
extends BatchSelectionJob {
    private Map<FXOMObject, FXOMObject> contextMenuMap;

    public AddContextMenuToSelectionJob(EditorController editorController) {
        super(editorController);
    }

    public Collection<FXOMObject> getContextMenus() {
        this.constructContextMenuMap();
        return this.contextMenuMap.values();
    }

    @Override
    protected List<Job> makeSubJobs() {
        this.constructContextMenuMap();
        LinkedList<Job> result = new LinkedList<Job>();
        for (Map.Entry<FXOMObject, FXOMObject> e : this.contextMenuMap.entrySet()) {
            FXOMObject fxomObject = e.getKey();
            FXOMObject contextMenuObject = e.getValue();
            InsertAsAccessoryJob insertJob = new InsertAsAccessoryJob(contextMenuObject, fxomObject, DesignHierarchyMask.Accessory.CONTEXT_MENU, this.getEditorController());
            result.add(insertJob);
        }
        return result;
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        Collection<FXOMObject> contextMenus = this.contextMenuMap.values();
        assert (!contextMenus.isEmpty());
        FXOMObject hitMenu = contextMenus.iterator().next();
        return new ObjectSelectionGroup(contextMenus, hitMenu, null);
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("label.action.edit.add.context.menu");
    }

    private void constructContextMenuMap() {
        if (this.contextMenuMap == null) {
            this.contextMenuMap = new LinkedHashMap<FXOMObject, FXOMObject>();
            String contextMenuFxmlPath = "builtin/ContextMenu.fxml";
            URL contextMenuFxmlURL = BuiltinLibrary.class.getResource("builtin/ContextMenu.fxml");
            assert (contextMenuFxmlURL != null);
            AbstractSelectionGroup asg = this.getEditorController().getSelection().getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            try {
                String contextMenuFxmlText = FXOMDocument.readContentFromURL(contextMenuFxmlURL);
                FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
                Library library = this.getEditorController().getLibrary();
                for (FXOMObject fxomObject : osg.getItems()) {
                    FXOMDocument contextMenuDocument = new FXOMDocument(contextMenuFxmlText, contextMenuFxmlURL, library.getClassLoader(), null, FXOMDocument.FXOMDocumentSwitch.NORMALIZED);
                    assert (contextMenuDocument != null);
                    FXOMObject contextMenuObject = contextMenuDocument.getFxomRoot();
                    assert (contextMenuObject != null);
                    contextMenuObject.moveToFxomDocument(fxomDocument);
                    assert (contextMenuDocument.getFxomRoot() == null);
                    this.contextMenuMap.put(fxomObject, contextMenuObject);
                }
            }
            catch (IOException x) {
                throw new IllegalStateException("Bug in " + this.getClass().getSimpleName(), x);
            }
        }
    }
}

