/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsAccessoryJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.library.BuiltinLibrary;
import com.oracle.javafx.scenebuilder.kit.library.Library;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AddTooltipToSelectionJob
extends BatchSelectionJob {
    private Map<FXOMObject, FXOMObject> tooltipMap;

    public AddTooltipToSelectionJob(EditorController editorController) {
        super(editorController);
    }

    public Collection<FXOMObject> getTooltips() {
        this.constructTooltipMap();
        return this.tooltipMap.values();
    }

    @Override
    protected List<Job> makeSubJobs() {
        this.constructTooltipMap();
        LinkedList<Job> result = new LinkedList<Job>();
        for (Map.Entry<FXOMObject, FXOMObject> e : this.tooltipMap.entrySet()) {
            FXOMObject fxomObject = e.getKey();
            FXOMObject tooltipObject = e.getValue();
            InsertAsAccessoryJob insertJob = new InsertAsAccessoryJob(tooltipObject, fxomObject, DesignHierarchyMask.Accessory.TOOLTIP, this.getEditorController());
            result.add(insertJob);
        }
        return result;
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        Collection<FXOMObject> contextMenus = this.tooltipMap.values();
        assert (!contextMenus.isEmpty());
        FXOMObject hitMenu = contextMenus.iterator().next();
        return new ObjectSelectionGroup(contextMenus, hitMenu, null);
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("label.action.edit.add.tooltip");
    }

    private void constructTooltipMap() {
        if (this.tooltipMap == null) {
            this.tooltipMap = new LinkedHashMap<FXOMObject, FXOMObject>();
            String tooltipFxmlPath = "builtin/Tooltip.fxml";
            URL tooltipFxmlURL = BuiltinLibrary.class.getResource("builtin/Tooltip.fxml");
            assert (tooltipFxmlURL != null);
            AbstractSelectionGroup asg = this.getEditorController().getSelection().getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            try {
                String contextMenuFxmlText = FXOMDocument.readContentFromURL(tooltipFxmlURL);
                FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
                Library library = this.getEditorController().getLibrary();
                for (FXOMObject fxomObject : osg.getItems()) {
                    FXOMDocument contextMenuDocument = new FXOMDocument(contextMenuFxmlText, tooltipFxmlURL, library.getClassLoader(), null, FXOMDocument.FXOMDocumentSwitch.NORMALIZED);
                    assert (contextMenuDocument != null);
                    FXOMObject contextMenuObject = contextMenuDocument.getFxomRoot();
                    assert (contextMenuObject != null);
                    contextMenuObject.moveToFxomDocument(fxomDocument);
                    assert (contextMenuDocument.getFxomRoot() == null);
                    this.tooltipMap.put(fxomObject, contextMenuObject);
                }
            }
            catch (IOException x) {
                throw new IllegalStateException("Bug in " + this.getClass().getSimpleName(), x);
            }
        }
    }
}

