/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.reference.ObjectDeleter;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;

public class DeleteObjectJob
extends InlineDocumentJob {
    private final FXOMObject targetFxomObject;

    public DeleteObjectJob(FXOMObject fxomObject, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        this.targetFxomObject = fxomObject;
    }

    @Override
    public boolean isExecutable() {
        boolean result = this.targetFxomObject == this.targetFxomObject.getFxomDocument().getFxomRoot() ? true : (this.targetFxomObject.getSceneGraphObject() instanceof Axis ? false : (this.targetFxomObject.getParentObject() != null && this.targetFxomObject.getParentObject().getSceneGraphObject() instanceof Scene ? false : this.targetFxomObject.getParentProperty() != null));
        return result;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.targetFxomObject.getParentProperty() == null && this.targetFxomObject.getParentCollection() == null) {
            SetDocumentRootJob setRootJob = new SetDocumentRootJob(null, this.getEditorController());
            ((Job)setRootJob).execute();
            result.add(setRootJob);
        } else {
            ObjectDeleter deleter = new ObjectDeleter(this.getEditorController());
            deleter.delete(this.targetFxomObject);
            result.addAll(deleter.getExecutedJobs());
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delete ");
        if (this.targetFxomObject instanceof FXOMInstance) {
            Object sceneGraphObject = this.targetFxomObject.getSceneGraphObject();
            if (sceneGraphObject != null) {
                sb.append(sceneGraphObject.getClass().getSimpleName());
            } else {
                sb.append("Unresolved Object");
            }
        } else if (this.targetFxomObject instanceof FXOMCollection) {
            sb.append("Collection");
        } else if (this.targetFxomObject instanceof FXOMIntrinsic) {
            sb.append(this.targetFxomObject.getGlueElement().getTagName());
        } else {
            assert (false);
            sb.append(this.targetFxomObject.getClass().getSimpleName());
        }
        return sb.toString();
    }

    FXOMObject getTargetFxomObject() {
        return this.targetFxomObject;
    }
}

