/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectSelectionJob
extends BatchSelectionJob {
    public DeleteObjectSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        ArrayList<Job> result = new ArrayList<Job>();
        int cannotDeleteCount = 0;
        for (FXOMObject candidate : osg.getFlattenItems()) {
            DeleteObjectJob subJob = new DeleteObjectJob(candidate, this.getEditorController());
            if (subJob.isExecutable()) {
                result.add(subJob);
                continue;
            }
            ++cannotDeleteCount;
        }
        if (cannotDeleteCount >= 1) {
            result.clear();
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        int subJobCount = this.getSubJobs().size();
        return switch (subJobCount) {
            case 0 -> "Unexecutable Delete";
            case 1 -> this.getSubJobs().get(0).getDescription();
            default -> I18N.getString("label.action.edit.delete.n", subJobCount);
        };
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        return null;
    }
}

