/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RelocateNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;

public class DuplicateSelectionJob
extends BatchSelectionJob {
    private static final double offset = 10.0;
    final Map<FXOMObject, FXOMObject> newFxomObjects = new LinkedHashMap<FXOMObject, FXOMObject>();

    public DuplicateSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        LinkedList<Job> result = new LinkedList<Job>();
        if (this.canDuplicate()) {
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            assert (osg.hasSingleParent());
            FXOMObject targetObject = osg.getAncestor();
            assert (targetObject != null);
            FXOMDocument targetDocument = this.getEditorController().getFxomDocument();
            for (FXOMObject selectedObject : osg.getSortedItems()) {
                FXOMDocument newDocument = FXOMNodes.newDocument(selectedObject);
                FXOMObject newObject = newDocument.getFxomRoot();
                newObject.moveToFxomDocument(targetDocument);
                assert (newDocument.getFxomRoot() == null);
                this.newFxomObjects.put(selectedObject, newObject);
            }
            assert (!this.newFxomObjects.isEmpty());
            DesignHierarchyMask targetMask = new DesignHierarchyMask(targetObject);
            if (targetMask.isAcceptingSubComponent(this.newFxomObjects.keySet())) {
                int index = 0;
                for (Map.Entry<FXOMObject, FXOMObject> entry : this.newFxomObjects.entrySet()) {
                    FXOMObject selectedFxomObject = entry.getKey();
                    FXOMObject newFxomObject = entry.getValue();
                    InsertAsSubComponentJob insertSubJob = new InsertAsSubComponentJob(newFxomObject, targetObject, targetMask.getSubComponentCount() + index++, this.getEditorController());
                    result.add(insertSubJob);
                    Object selectedSceneGraphObject = selectedFxomObject.getSceneGraphObject();
                    if (!(selectedSceneGraphObject instanceof Node)) continue;
                    Node selectedNode = (Node)selectedSceneGraphObject;
                    double newLayoutX = Math.round(selectedNode.getLayoutX() + 10.0);
                    double newLayoutY = Math.round(selectedNode.getLayoutY() + 10.0);
                    assert (newFxomObject instanceof FXOMInstance);
                    RelocateNodeJob relocateSubJob = new RelocateNodeJob((FXOMInstance)newFxomObject, newLayoutX, newLayoutY, this.getEditorController());
                    result.add(relocateSubJob);
                }
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        assert (!this.newFxomObjects.values().isEmpty());
        String result = this.newFxomObjects.values().size() == 1 ? this.makeSingleSelectionDescription() : this.makeMultipleSelectionDescription();
        return result;
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        assert (this.newFxomObjects != null);
        if (this.newFxomObjects.isEmpty()) {
            return null;
        }
        return new ObjectSelectionGroup(this.newFxomObjects.values(), this.newFxomObjects.values().iterator().next(), null);
    }

    private boolean canDuplicate() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (fxomDocument == null) {
            return false;
        }
        Selection selection = this.getEditorController().getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        FXOMObject rootObject = fxomDocument.getFxomRoot();
        if (selection.isSelected(rootObject)) {
            return false;
        }
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        for (FXOMObject fxomObject : osg.getItems()) {
            if (fxomObject.getSceneGraphObject() != null) continue;
            return false;
        }
        return osg.hasSingleParent();
    }

    private String makeSingleSelectionDescription() {
        String result;
        FXOMObject newObject = this.newFxomObjects.values().iterator().next();
        if (newObject instanceof FXOMInstance) {
            Object sceneGraphObject = newObject.getSceneGraphObject();
            result = sceneGraphObject != null ? I18N.getString("label.action.edit.duplicate.1", sceneGraphObject.getClass().getSimpleName()) : I18N.getString("label.action.edit.duplicate.unresolved");
        } else if (newObject instanceof FXOMCollection) {
            result = I18N.getString("label.action.edit.duplicate.collection");
        } else {
            assert (false);
            result = I18N.getString("label.action.edit.duplicate.1", newObject.getClass().getSimpleName());
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        return I18N.getString("label.action.edit.duplicate.n", this.newFxomObjects.values().size());
    }
}

