/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.layout.AnchorPane;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

public class FitToParentObjectJob
extends BatchDocumentJob {
    private final FXOMInstance fxomInstance;
    private final FXOMPropertyC parentProperty;
    private final FXOMInstance parentInstance;

    public FitToParentObjectJob(FXOMInstance fxomInstance, EditorController editorController) {
        super(editorController);
        assert (fxomInstance != null);
        this.fxomInstance = fxomInstance;
        this.parentProperty = fxomInstance.getParentProperty();
        this.parentInstance = this.parentProperty == null ? null : this.parentProperty.getParentInstance();
    }

    @Override
    protected List<Job> makeSubJobs() {
        Job bottomAnchorJob;
        Job rightAnchorJob;
        Job topAnchorJob;
        Job leftAnchorJob;
        Job prefHeightJob;
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.parentProperty == null) {
            return result;
        }
        Object childObject = this.fxomInstance.getSceneGraphObject();
        if (!(childObject instanceof Node)) {
            return result;
        }
        Node childNode = (Node)childObject;
        if (!childNode.isResizable()) {
            return result;
        }
        Object parentObject = this.parentInstance.getSceneGraphObject();
        if (!(parentObject instanceof AnchorPane)) {
            return result;
        }
        AnchorPane parentNode = (AnchorPane)parentObject;
        Bounds childBounds = childNode.getLayoutBounds();
        Bounds parentBounds = parentNode.getLayoutBounds();
        Scale scale = null;
        for (Transform transform : childNode.getTransforms()) {
            if (!(transform instanceof Scale)) continue;
            scale = (Scale)transform;
        }
        double scaleX = scale == null ? 1.0 : scale.getX();
        double scaleY = scale == null ? 1.0 : scale.getY();
        Set<Sizing> sizing = this.getSizingMask(childNode);
        boolean isResizableX = sizing.contains((Object)Sizing.HORIZONTAL);
        boolean isResizableY = sizing.contains((Object)Sizing.VERTICAL);
        double leftAnchorValue = isResizableX ? 0.0 : (parentBounds.getWidth() - childBounds.getWidth() * scaleX) / 2.0;
        double topAnchorValue = isResizableY ? 0.0 : (parentBounds.getHeight() - childBounds.getHeight() * scaleY) / 2.0;
        double prefWidthValue = isResizableX ? parentBounds.getWidth() / scaleY : childBounds.getWidth();
        double prefHeightValue = isResizableY ? parentBounds.getHeight() / scaleY : childBounds.getHeight();
        Job prefWidthJob = this.modifyJob("prefWidth", prefWidthValue);
        if (prefWidthJob.isExecutable()) {
            result.add(prefWidthJob);
        }
        if ((prefHeightJob = this.modifyJob("prefHeight", prefHeightValue)).isExecutable()) {
            result.add(prefHeightJob);
        }
        if ((leftAnchorJob = this.modifyAnchorJob(Anchor.LEFT, leftAnchorValue)).isExecutable()) {
            result.add(leftAnchorJob);
        }
        if ((topAnchorJob = this.modifyAnchorJob(Anchor.TOP, topAnchorValue)).isExecutable()) {
            result.add(topAnchorJob);
        }
        if (isResizableX && (rightAnchorJob = this.modifyAnchorJob(Anchor.RIGHT, 0.0)).isExecutable()) {
            result.add(rightAnchorJob);
        }
        if (isResizableY && (bottomAnchorJob = this.modifyAnchorJob(Anchor.BOTTOM, 0.0)).isExecutable()) {
            result.add(bottomAnchorJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fit to Parent ");
        Object sceneGraphObject = this.fxomInstance.getSceneGraphObject();
        assert (sceneGraphObject != null);
        sb.append(sceneGraphObject.getClass().getSimpleName());
        return sb.toString();
    }

    private Job modifyJob(Class<?> clazz, String name, double value) {
        PropertyName pn = new PropertyName(name, clazz);
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(this.fxomInstance, pn);
        ModifyObjectJob subJob = new ModifyObjectJob(this.fxomInstance, vpm, value, this.getEditorController());
        return subJob;
    }

    private Job modifyJob(String name, double value) {
        return this.modifyJob(null, name, value);
    }

    private Job modifyAnchorJob(Anchor anchor, double value) {
        String name = anchor.name().toLowerCase(Locale.ROOT) + "Anchor";
        return this.modifyJob(AnchorPane.class, name, value);
    }

    private Set<Sizing> getSizingMask(Node node) {
        Set<Sizing> result;
        if (node instanceof ScrollBar) {
            ScrollBar scrollBar = (ScrollBar)node;
            result = this.getSizingMask(scrollBar.getOrientation());
        } else if (node instanceof Separator) {
            Separator separator = (Separator)node;
            result = this.getSizingMask(separator.getOrientation());
        } else if (node instanceof Slider) {
            Slider slider = (Slider)node;
            result = this.getSizingMask(slider.getOrientation());
        } else {
            result = EnumSet.of(Sizing.HORIZONTAL, Sizing.VERTICAL);
        }
        return result;
    }

    private Set<Sizing> getSizingMask(Orientation orientation) {
        assert (orientation != null);
        return switch (orientation) {
            case Orientation.HORIZONTAL -> EnumSet.of(Sizing.HORIZONTAL);
            case Orientation.VERTICAL -> EnumSet.of(Sizing.VERTICAL);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("unexpected orientation: " + String.valueOf(orientation)));
                }
                yield null;
            }
        };
    }

    private static enum Sizing {
        HORIZONTAL,
        VERTICAL;

    }

    private static enum Anchor {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

