/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.FitToParentObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FitToParentSelectionJob
extends BatchDocumentJob {
    public FitToParentSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        HashSet<FXOMInstance> candidates = new HashSet<FXOMInstance>();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject fxomObject : osg.getItems()) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                candidates.add((FXOMInstance)fxomObject);
            }
        } else if (!(selection.getGroup() instanceof GridSelectionGroup)) assert (selection.getGroup() == null) : "Add implementation for " + String.valueOf(selection.getGroup());
        for (FXOMInstance candidate : candidates) {
            FitToParentObjectJob subJob = new FitToParentObjectJob(candidate, this.getEditorController());
            if (subJob.isExecutable()) {
                result.add(subJob);
                continue;
            }
            result.clear();
            break;
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return switch (this.getSubJobs().size()) {
            case 0 -> "Unexecutable Fit To Parent";
            case 1 -> this.getSubJobs().get(0).getDescription();
            default -> this.makeMultipleSelectionDescription();
        };
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Fit To Parent ");
        result.append(this.getSubJobs().size());
        result.append(" Objects");
        return result.toString();
    }
}

