/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModifySelectionJob
extends BatchDocumentJob {
    protected final ValuePropertyMetadata propertyMetadata;
    protected final Object newValue;

    public ModifySelectionJob(ValuePropertyMetadata propertyMetadata, Object newValue, EditorController editorController) {
        super(editorController);
        this.propertyMetadata = propertyMetadata;
        this.newValue = newValue;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        HashSet<FXOMInstance> candidates = new HashSet<FXOMInstance>();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            this.handleObjectSelectionGroup(selection.getGroup(), candidates);
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            this.handleGridSelectionGroup(selection.getGroup(), candidates);
        } else assert (selection.getGroup() == null) : "Add implementation for " + String.valueOf(selection.getGroup());
        for (FXOMInstance fxomInstance : candidates) {
            ModifyObjectJob subJob = new ModifyObjectJob(fxomInstance, this.propertyMetadata, this.newValue, this.getEditorController());
            if (!subJob.isExecutable()) continue;
            result.add(subJob);
        }
        return result;
    }

    private void handleObjectSelectionGroup(AbstractSelectionGroup group, Set<FXOMInstance> candidates) {
        ObjectSelectionGroup osg = (ObjectSelectionGroup)group;
        for (FXOMObject fxomObject : osg.getItems()) {
            this.handleFxomInstance(fxomObject, candidates);
            this.handleFxomIntrinsic(fxomObject, candidates);
        }
    }

    private void handleFxomInstance(FXOMObject fxomObject, Set<FXOMInstance> candidates) {
        if (fxomObject instanceof FXOMInstance) {
            candidates.add((FXOMInstance)fxomObject);
        }
    }

    private void handleFxomIntrinsic(FXOMObject fxomObject, Set<FXOMInstance> candidates) {
        if (fxomObject instanceof FXOMIntrinsic) {
            FXOMIntrinsic intrinsic = (FXOMIntrinsic)fxomObject;
            FXOMInstance fxomInstance = intrinsic.createFxomInstanceFromIntrinsic();
            candidates.add(fxomInstance);
        }
    }

    private void handleGridSelectionGroup(AbstractSelectionGroup group, Set<FXOMInstance> candidates) {
        GridSelectionGroup gsg = (GridSelectionGroup)group;
        DesignHierarchyMask mask = new DesignHierarchyMask(gsg.getAncestor());
        for (int index : gsg.getIndexes()) {
            FXOMObject constraints = null;
            switch (gsg.getType()) {
                case COLUMN: {
                    constraints = mask.getColumnConstraintsAtIndex(index);
                    break;
                }
                case ROW: {
                    constraints = mask.getRowConstraintsAtIndex(index);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (constraints instanceof FXOMInstance);
            candidates.add((FXOMInstance)constraints);
        }
    }

    @Override
    protected String makeDescription() {
        List<Job> subJobs = this.getSubJobs();
        int subJobCount = subJobs.size();
        return switch (subJobCount) {
            case 0 -> "Unexecutable Set";
            case 1 -> subJobs.get(0).getDescription();
            default -> I18N.getString("label.action.edit.set.n", this.propertyMetadata.getName().toString(), subJobCount);
        };
    }
}

