/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsAccessoryJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardDecoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.input.Clipboard;

public class PasteIntoJob
extends BatchSelectionJob {
    private List<FXOMObject> newObjects;

    public PasteIntoJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result;
        block7: {
            ObjectSelectionGroup osg;
            result = new ArrayList<Job>();
            FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
            if (fxomDocument == null) break block7;
            ClipboardDecoder clipboardDecoder = new ClipboardDecoder(Clipboard.getSystemClipboard());
            this.newObjects = clipboardDecoder.decode(fxomDocument);
            assert (this.newObjects != null);
            Selection selection = this.getEditorController().getSelection();
            if (selection.getGroup() instanceof ObjectSelectionGroup && (osg = (ObjectSelectionGroup)selection.getGroup()).getItems().size() == 1) {
                FXOMObject targetObject = osg.getItems().iterator().next();
                DesignHierarchyMask targetMask = new DesignHierarchyMask(targetObject);
                if (targetMask.isAcceptingSubComponent(this.newObjects)) {
                    for (FXOMObject newObject : this.newObjects) {
                        InsertAsSubComponentJob subJob = new InsertAsSubComponentJob(newObject, targetObject, targetMask.getSubComponentCount(), this.getEditorController());
                        result.add(0, subJob);
                    }
                } else if (this.newObjects.size() == 1) {
                    DesignHierarchyMask.Accessory[] accessories;
                    FXOMObject newObject = this.newObjects.get(0);
                    for (DesignHierarchyMask.Accessory a : accessories = new DesignHierarchyMask.Accessory[]{DesignHierarchyMask.Accessory.CONTENT, DesignHierarchyMask.Accessory.CONTEXT_MENU, DesignHierarchyMask.Accessory.GRAPHIC, DesignHierarchyMask.Accessory.TOOLTIP}) {
                        if (!targetMask.isAcceptingAccessory(a, newObject) || targetMask.getAccessory(a) != null) continue;
                        InsertAsAccessoryJob subJob = new InsertAsAccessoryJob(newObject, targetObject, a, this.getEditorController());
                        result.add(subJob);
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result = this.newObjects.size() == 1 ? this.makeSingleSelectionDescription() : this.makeMultipleSelectionDescription();
        return result;
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        assert (this.newObjects != null);
        if (this.newObjects.isEmpty()) {
            return null;
        }
        return new ObjectSelectionGroup(this.newObjects, this.newObjects.iterator().next(), null);
    }

    private String makeSingleSelectionDescription() {
        String result;
        assert (this.newObjects.size() == 1);
        FXOMObject newObject = this.newObjects.get(0);
        if (newObject instanceof FXOMInstance) {
            Object sceneGraphObject = newObject.getSceneGraphObject();
            result = sceneGraphObject != null ? I18N.getString("label.action.edit.paste.into.1", sceneGraphObject.getClass().getSimpleName()) : I18N.getString("label.action.edit.paste.into.unresolved");
        } else if (newObject instanceof FXOMCollection) {
            result = I18N.getString("label.action.edit.paste.into.collection");
        } else {
            assert (false);
            result = I18N.getString("label.action.edit.paste.into.1", newObject.getClass().getSimpleName());
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        int objectCount = this.newObjects.size();
        return I18N.getString("label.action.edit.paste.into.n", objectCount);
    }
}

