/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ReIndexObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;

public class SendBackwardJob
extends InlineDocumentJob {
    public SendBackwardJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public boolean isExecutable() {
        Selection selection = this.getEditorController().getSelection();
        if (!(selection.getGroup() instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        for (FXOMObject item : osg.getSortedItems()) {
            FXOMObject previousSlibing = item.getPreviousSlibing();
            if (previousSlibing != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        assert (this.isExecutable());
        ArrayList<Job> result = new ArrayList<Job>();
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        List<FXOMObject> candidates = osg.getSortedItems();
        for (FXOMObject candidate : candidates) {
            ReIndexObjectJob subJob;
            FXOMObject previousSlibing = candidate.getPreviousSlibing();
            if (previousSlibing == null || !(subJob = new ReIndexObjectJob(candidate, previousSlibing, this.getEditorController())).isExecutable()) continue;
            subJob.execute();
            result.add(subJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return switch (this.getSubJobs().size()) {
            case 0 -> "Unexecutable Send Backward";
            case 1 -> this.getSubJobs().get(0).getDescription();
            default -> this.makeMultipleSelectionDescription();
        };
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Send Backward ");
        result.append(this.getSubJobs().size());
        result.append(" Objects");
        return result.toString();
    }
}

