/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.web.WebView;

public class UsePredefinedSizeJob
extends Job {
    private final List<ModifyObjectJob> subJobs = new ArrayList<ModifyObjectJob>();
    private String description;
    private final EditorController.Size size;
    private final EditorController editorController;
    private final FXOMObject fxomObject;

    public UsePredefinedSizeJob(EditorController editorController, EditorController.Size size, FXOMObject fxomObject) {
        super(editorController);
        this.editorController = editorController;
        this.size = size;
        this.fxomObject = fxomObject;
        this.buildSubJobs();
    }

    public UsePredefinedSizeJob(EditorController editorController, EditorController.Size size) {
        super(editorController);
        this.editorController = editorController;
        this.size = size;
        if (editorController.getFxomDocument() == null) {
            this.fxomObject = null;
        } else {
            FXOMObject fxomObject = editorController.getFxomDocument().getFxomRoot();
            if (fxomObject != null && fxomObject.getSceneGraphObject() instanceof Scene) {
                DesignHierarchyMask mask = new DesignHierarchyMask(fxomObject);
                fxomObject = mask.getAccessory(DesignHierarchyMask.Accessory.ROOT);
                assert (fxomObject != null);
            }
            this.fxomObject = fxomObject;
        }
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return !this.subJobs.isEmpty();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        fxomDocument.beginUpdate();
        for (ModifyObjectJob subJob : this.subJobs) {
            subJob.execute();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        fxomDocument.beginUpdate();
        for (int i = this.subJobs.size() - 1; i >= 0; --i) {
            this.subJobs.get(i).undo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        fxomDocument.beginUpdate();
        for (ModifyObjectJob subJob : this.subJobs) {
            subJob.redo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = I18N.getString("job.set.size", JobUtils.getStringFromDouble(this.getWidthFromSize(this.size)), JobUtils.getStringFromDouble(this.getHeightFromSize(this.size)));
        }
        return this.description;
    }

    private void buildSubJobs() {
        FXOMInstance fxomInstance;
        Object sceneGraphObject;
        if (this.editorController.getFxomDocument() != null && this.fxomObject instanceof FXOMInstance && ((sceneGraphObject = (fxomInstance = (FXOMInstance)this.fxomObject).getSceneGraphObject()) instanceof WebView || sceneGraphObject instanceof Region)) {
            this.subJobs.addAll(this.modifyHeightJobs(fxomInstance));
            this.subJobs.addAll(this.modifyWidthJobs(fxomInstance));
        }
    }

    private List<ModifyObjectJob> modifyHeightJobs(FXOMInstance candidate) {
        ArrayList<ModifyObjectJob> result = new ArrayList<ModifyObjectJob>();
        PropertyName maxHeight = new PropertyName("maxHeight");
        PropertyName minHeight = new PropertyName("minHeight");
        PropertyName prefHeight = new PropertyName("prefHeight");
        ValuePropertyMetadata maxHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, maxHeight);
        ValuePropertyMetadata minHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, minHeight);
        ValuePropertyMetadata prefHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, prefHeight);
        ModifyObjectJob maxHeightJob = new ModifyObjectJob(candidate, maxHeightVPM, Double.NEGATIVE_INFINITY, this.editorController);
        ModifyObjectJob minHeightJob = new ModifyObjectJob(candidate, minHeightVPM, Double.NEGATIVE_INFINITY, this.editorController);
        ModifyObjectJob prefHeightJob = new ModifyObjectJob(candidate, prefHeightVPM, this.getHeightFromSize(this.size), this.editorController);
        if (maxHeightJob.isExecutable()) {
            result.add(maxHeightJob);
        }
        if (minHeightJob.isExecutable()) {
            result.add(minHeightJob);
        }
        if (prefHeightJob.isExecutable()) {
            result.add(prefHeightJob);
        }
        return result;
    }

    private List<ModifyObjectJob> modifyWidthJobs(FXOMInstance candidate) {
        ArrayList<ModifyObjectJob> result = new ArrayList<ModifyObjectJob>();
        PropertyName maxWidth = new PropertyName("maxWidth");
        PropertyName minWidth = new PropertyName("minWidth");
        PropertyName prefWidth = new PropertyName("prefWidth");
        ValuePropertyMetadata maxWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, maxWidth);
        ValuePropertyMetadata minWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, minWidth);
        ValuePropertyMetadata prefWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, prefWidth);
        ModifyObjectJob maxWidthJob = new ModifyObjectJob(candidate, maxWidthVPM, Double.NEGATIVE_INFINITY, this.editorController);
        ModifyObjectJob minWidthJob = new ModifyObjectJob(candidate, minWidthVPM, Double.NEGATIVE_INFINITY, this.editorController);
        ModifyObjectJob prefWidthJob = new ModifyObjectJob(candidate, prefWidthVPM, this.getWidthFromSize(this.size), this.editorController);
        if (maxWidthJob.isExecutable()) {
            result.add(maxWidthJob);
        }
        if (minWidthJob.isExecutable()) {
            result.add(minWidthJob);
        }
        if (prefWidthJob.isExecutable()) {
            result.add(prefWidthJob);
        }
        return result;
    }

    private double getWidthFromSize(EditorController.Size size) {
        assert (size != EditorController.Size.SIZE_PREFERRED);
        if (size == EditorController.Size.SIZE_DEFAULT) {
            return this.editorController.getDefaultRootContainerWidth();
        }
        String sizeString = size.toString();
        return Double.parseDouble(sizeString.substring(5, sizeString.indexOf(120)));
    }

    private double getHeightFromSize(EditorController.Size size) {
        assert (size != EditorController.Size.SIZE_PREFERRED);
        if (size == EditorController.Size.SIZE_DEFAULT) {
            return this.editorController.getDefaultRootContainerHeight();
        }
        String sizeString = size.toString();
        return Double.parseDouble(sizeString.substring(sizeString.indexOf(120) + 1, sizeString.length()));
    }
}

