/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;

public class ReplaceObjectJob
extends Job {
    private final FXOMObject original;
    private final FXOMObject replacement;
    private FXOMPropertyC parentProperty;
    private FXOMCollection parentCollection;
    private int indexInParentProperty;
    private int indexInParentCollection;

    public ReplaceObjectJob(FXOMObject original, FXOMObject replacement, EditorController editorController) {
        super(editorController);
        this.original = original;
        this.replacement = replacement;
    }

    @Override
    public boolean isExecutable() {
        return (this.original.getParentCollection() != null || this.original.getParentProperty() != null) && this.replacement.getParentCollection() == null && this.replacement.getParentProperty() == null;
    }

    @Override
    public void execute() {
        this.parentProperty = this.original.getParentProperty();
        this.parentCollection = this.original.getParentCollection();
        this.indexInParentProperty = this.original.getIndexInParentProperty();
        this.indexInParentCollection = this.original.getIndexInParentCollection();
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.original.getParentProperty() == null);
        assert (this.original.getParentCollection() == null);
        assert (this.replacement.getParentProperty() == this.parentProperty);
        assert (this.replacement.getParentCollection() == this.parentCollection);
        assert (this.replacement.getIndexInParentProperty() == this.indexInParentProperty);
        assert (this.replacement.getIndexInParentCollection() == this.indexInParentCollection);
        if (this.parentProperty != null) {
            this.original.addToParentProperty(this.indexInParentProperty, this.parentProperty);
            this.replacement.removeFromParentProperty();
        } else {
            assert (this.parentCollection != null);
            this.original.addToParentCollection(this.indexInParentCollection, this.parentCollection);
            this.replacement.removeFromParentCollection();
        }
    }

    @Override
    public void redo() {
        assert (this.original.getParentProperty() == this.parentProperty);
        assert (this.original.getParentCollection() == this.parentCollection);
        assert (this.original.getIndexInParentProperty() == this.indexInParentProperty);
        assert (this.original.getIndexInParentCollection() == this.indexInParentCollection);
        assert (this.replacement.getParentProperty() == null);
        assert (this.replacement.getParentCollection() == null);
        if (this.parentProperty != null) {
            this.replacement.addToParentProperty(this.indexInParentProperty, this.parentProperty);
            this.original.removeFromParentProperty();
        } else {
            assert (this.parentCollection != null);
            this.replacement.addToParentCollection(this.indexInParentCollection, this.parentCollection);
            this.original.removeFromParentCollection();
        }
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

