/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class SetFxomRootJob
extends Job {
    private final FXOMObject newRoot;
    private FXOMObject oldRoot;

    public SetFxomRootJob(FXOMObject newRoot, EditorController editorController) {
        super(editorController);
        assert (editorController.getFxomDocument() != null);
        assert (newRoot == null || newRoot.getFxomDocument() == editorController.getFxomDocument());
        this.newRoot = newRoot;
    }

    @Override
    public boolean isExecutable() {
        return this.newRoot != this.getEditorController().getFxomDocument().getFxomRoot();
    }

    @Override
    public void execute() {
        assert (this.oldRoot == null);
        EditorController editorController = this.getEditorController();
        FXOMDocument fxomDocument = editorController.getFxomDocument();
        this.oldRoot = fxomDocument.getFxomRoot();
        fxomDocument.beginUpdate();
        fxomDocument.setFxomRoot(this.newRoot);
        fxomDocument.endUpdate();
        if (this.newRoot != null && this.newRoot.isClassFromExternalPlugin()) {
            EditorPlatform.showThemeAlert(editorController.getOwnerWindow(), editorController.getTheme(), editorController::setTheme);
        }
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        assert (fxomDocument.getFxomRoot() == this.newRoot);
        fxomDocument.beginUpdate();
        fxomDocument.setFxomRoot(this.oldRoot);
        fxomDocument.endUpdate();
        assert (fxomDocument.getFxomRoot() == this.oldRoot);
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        assert (fxomDocument.getFxomRoot() == this.oldRoot);
        fxomDocument.beginUpdate();
        fxomDocument.setFxomRoot(this.newRoot);
        fxomDocument.endUpdate();
        assert (fxomDocument.getFxomRoot() == this.newRoot);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

