/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.layout.RowConstraints;

public class AddRowConstraintsJob
extends BatchDocumentJob {
    private final Map<FXOMObject, Set<Integer>> targetGridPanes;
    private final GridPaneJobUtils.Position position;
    private static final double defaultMinHeight = 10.0;
    private static final double defaultPrefHeight = 30.0;

    public AddRowConstraintsJob(EditorController editorController, GridPaneJobUtils.Position position, Map<FXOMObject, Set<Integer>> targetGridPanes) {
        super(editorController);
        this.position = position;
        this.targetGridPanes = targetGridPanes;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        assert (!this.targetGridPanes.isEmpty());
        for (FXOMObject targetGridPane : this.targetGridPanes.keySet()) {
            assert (targetGridPane instanceof FXOMInstance);
            Set<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            result.addAll(this.addRowConstraints((FXOMInstance)targetGridPane, targetIndexes));
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Add Row Constraints";
    }

    private Set<Job> addRowConstraints(FXOMInstance targetGridPane, Set<Integer> targetIndexes) {
        LinkedHashSet<Job> result = new LinkedHashSet<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        PropertyName propertyName = new PropertyName("rowConstraints");
        FXOMProperty constraintsProperty = targetGridPane.getProperties().get(propertyName);
        if (constraintsProperty == null) {
            constraintsProperty = new FXOMPropertyC(fxomDocument, propertyName);
        }
        assert (constraintsProperty instanceof FXOMPropertyC);
        DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
        int shiftIndex = 0;
        int constraintsSize = mask.getRowsConstraintsSize();
        for (int targetIndex : targetIndexes) {
            FXOMObject targetConstraints;
            int addedIndex = targetIndex + shiftIndex;
            if (this.position == GridPaneJobUtils.Position.BELOW) {
                ++addedIndex;
            }
            if ((targetConstraints = mask.getRowConstraintsAtIndex(targetIndex)) != null) {
                assert (targetConstraints instanceof FXOMInstance);
                addedConstraints = this.makeRowConstraintsInstance((FXOMInstance)targetConstraints);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                result.add(addValueJob);
            } else {
                for (int index = constraintsSize; index < addedIndex; ++index) {
                    FXOMInstance addedConstraints = this.makeRowConstraintsInstance();
                    AddPropertyValueJob addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, index, this.getEditorController());
                    result.add(addValueJob);
                }
                addedConstraints = this.makeRowConstraintsInstance();
                JobUtils.setMinHeight(addedConstraints, RowConstraints.class, 10.0);
                JobUtils.setPrefHeight(addedConstraints, RowConstraints.class, 30.0);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                result.add(addValueJob);
                constraintsSize = addedIndex + 1;
            }
            ++shiftIndex;
        }
        if (constraintsProperty.getParentInstance() == null) {
            AddPropertyJob addPropertyJob = new AddPropertyJob(constraintsProperty, targetGridPane, -1, this.getEditorController());
            result.add(addPropertyJob);
        }
        return result;
    }

    private FXOMInstance makeRowConstraintsInstance() {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, RowConstraints.class);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }

    private FXOMInstance makeRowConstraintsInstance(FXOMInstance constraints) {
        assert (constraints != null);
        assert (constraints.getDeclaredClass() == RowConstraints.class);
        FXOMInstance result = this.makeRowConstraintsInstance();
        boolean fillHeight = JobUtils.getFillHeight(constraints, RowConstraints.class);
        double maxHeight = JobUtils.getMaxHeight(constraints, RowConstraints.class);
        double minHeight = JobUtils.getMinHeight(constraints, RowConstraints.class);
        double percentHeight = JobUtils.getPercentHeight(constraints, RowConstraints.class);
        double prefHeight = JobUtils.getPrefHeight(constraints, RowConstraints.class);
        String valignment = JobUtils.getVAlignment(constraints, RowConstraints.class);
        String vgrow = JobUtils.getVGrow(constraints, RowConstraints.class);
        JobUtils.setFillHeight(result, RowConstraints.class, fillHeight);
        JobUtils.setMaxHeight(result, RowConstraints.class, maxHeight);
        JobUtils.setMinHeight(result, RowConstraints.class, Math.max(minHeight, 10.0));
        JobUtils.setPercentHeight(result, RowConstraints.class, percentHeight);
        JobUtils.setPrefHeight(result, RowConstraints.class, Math.max(prefHeight, 30.0));
        JobUtils.setVAlignment(result, RowConstraints.class, valignment);
        JobUtils.setVGrow(result, RowConstraints.class, vgrow);
        return result;
    }
}

