/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.ReIndexColumnContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.RemoveColumnConstraintsJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.RemoveColumnContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteColumnJob
extends BatchSelectionJob {
    private FXOMObject targetGridPane;
    private final List<Integer> targetIndexes = new ArrayList<Integer>();

    public DeleteColumnJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (GridPaneJobUtils.canPerformRemove(this.getEditorController())) {
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            this.targetGridPane = gsg.getParentObject();
            this.targetIndexes.addAll(gsg.getIndexes());
            RemoveColumnConstraintsJob removeConstraints = new RemoveColumnConstraintsJob(this.getEditorController(), this.targetGridPane, this.targetIndexes);
            result.add(removeConstraints);
            RemoveColumnContentJob removeContent = new RemoveColumnContentJob(this.getEditorController(), this.targetGridPane, this.targetIndexes);
            result.add(removeContent);
            result.addAll(this.moveColumnContent());
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return switch (this.targetIndexes.size()) {
            case 0 -> "Unexecutable Delete";
            case 1 -> "Delete Column";
            default -> this.makeMultipleSelectionDescription();
        };
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        return null;
    }

    private List<Job> moveColumnContent() {
        ArrayList<Job> result = new ArrayList<Job>();
        DesignHierarchyMask targetGridPaneMask = new DesignHierarchyMask(this.targetGridPane);
        int columnsSize = targetGridPaneMask.getColumnsSize();
        Iterator<Integer> iterator = this.targetIndexes.iterator();
        int shiftIndex = 0;
        int targetIndex = iterator.next();
        while (targetIndex != -1) {
            int toIndex;
            int nextTargetIndex;
            int fromIndex = targetIndex + 1;
            if (iterator.hasNext()) {
                nextTargetIndex = iterator.next();
                toIndex = nextTargetIndex - 1;
            } else {
                nextTargetIndex = -1;
                toIndex = columnsSize - 1;
            }
            if (nextTargetIndex != targetIndex + 1 && fromIndex < columnsSize) {
                int offset = -1 + shiftIndex;
                List<Integer> indexes = GridPaneJobUtils.getIndexes(fromIndex, toIndex);
                ReIndexColumnContentJob reIndexJob = new ReIndexColumnContentJob(this.getEditorController(), offset, this.targetGridPane, indexes);
                result.add(reIndexJob);
            }
            targetIndex = nextTargetIndex;
            --shiftIndex;
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Delete ");
        result.append(this.targetIndexes.size());
        result.append(" Columns");
        return result.toString();
    }
}

