/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.List;

public class RemoveRowConstraintsJob
extends BatchDocumentJob {
    private final FXOMObject targetGridPane;
    private final List<Integer> targetIndexes;

    public RemoveRowConstraintsJob(EditorController editorController, FXOMObject targetGridPane, List<Integer> targetIndexes) {
        super(editorController);
        assert (targetGridPane != null);
        assert (targetIndexes != null);
        this.targetGridPane = targetGridPane;
        this.targetIndexes = targetIndexes;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        assert (this.targetGridPane instanceof FXOMInstance);
        assert (!this.targetIndexes.isEmpty());
        DesignHierarchyMask mask = new DesignHierarchyMask(this.targetGridPane);
        for (int targetIndex : this.targetIndexes) {
            FXOMObject targetConstraints = mask.getRowConstraintsAtIndex(targetIndex);
            if (targetConstraints == null) continue;
            DeleteObjectJob removeValueJob = new DeleteObjectJob(targetConstraints, this.getEditorController());
            result.add(removeValueJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Remove Row Constraints";
    }
}

