/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.GridBounds;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class GridSnapshotItem {
    private final Integer columnIndex;
    private final Integer rowIndex;
    private final Integer columnSpan;
    private final Integer rowSpan;
    private final Priority vgrow;
    private final Priority hgrow;
    private final VPos valignment;
    private final HPos halignment;

    public GridSnapshotItem(FXOMObject fxomObject) {
        assert (fxomObject != null);
        assert (fxomObject.getSceneGraphObject() instanceof Node);
        Node node = (Node)fxomObject.getSceneGraphObject();
        this.columnIndex = GridPane.getColumnIndex((Node)node);
        this.rowIndex = GridPane.getRowIndex((Node)node);
        this.columnSpan = GridPane.getColumnSpan((Node)node);
        this.rowSpan = GridPane.getRowSpan((Node)node);
        this.vgrow = GridPane.getVgrow((Node)node);
        this.hgrow = GridPane.getHgrow((Node)node);
        this.valignment = GridPane.getValignment((Node)node);
        this.halignment = GridPane.getHalignment((Node)node);
    }

    public GridSnapshotItem(FXOMObject fxomObject, int columnIndex, int rowIndex) {
        assert (fxomObject != null);
        assert (fxomObject.getSceneGraphObject() instanceof Node);
        assert (columnIndex >= 0);
        assert (rowIndex >= 0);
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.columnSpan = null;
        this.rowSpan = null;
        this.vgrow = null;
        this.hgrow = null;
        this.valignment = null;
        this.halignment = null;
    }

    public int getColumnIndex() {
        return this.columnIndex == null ? 0 : this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex == null ? 0 : this.rowIndex;
    }

    public int getColumnSpan() {
        return this.columnSpan == null ? 1 : this.columnSpan;
    }

    public int getRowSpan() {
        return this.rowSpan == null ? 1 : this.rowSpan;
    }

    public Priority getVgrow() {
        return this.vgrow;
    }

    public Priority getHgrow() {
        return this.hgrow;
    }

    public VPos getValignment() {
        return this.valignment;
    }

    public HPos getHalignment() {
        return this.halignment;
    }

    public GridBounds getBounds() {
        int actualColumnIndex = this.columnIndex == null ? 0 : this.columnIndex;
        int actualRowIndex = this.rowIndex == null ? 0 : this.rowIndex;
        int actualColumnSpan = this.columnSpan == null || this.columnSpan == Integer.MAX_VALUE ? 1 : this.columnSpan;
        int actualRowSpan = this.rowSpan == null || this.rowSpan == Integer.MAX_VALUE ? 1 : this.rowSpan;
        return new GridBounds(actualColumnIndex, actualRowIndex, actualColumnSpan, actualRowSpan);
    }
}

