/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ToggleFxRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInAnchorPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInBorderPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInButtonBarJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInDialogPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInFlowPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInGridPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInHBoxJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInSceneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInScrollPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInSplitPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInStackPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInStageJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInTabPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInTextFlowJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInTilePaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInTitledPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInToolBarJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInVBoxJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;

public abstract class AbstractWrapInJob
extends BatchSelectionJob {
    protected Class<?> newContainerClass;
    protected FXOMInstance oldContainer;
    protected FXOMInstance newContainer;

    public AbstractWrapInJob(EditorController editorController) {
        super(editorController);
    }

    public static AbstractWrapInJob getWrapInJob(EditorController editorController, Class<?> wrappingClass) {
        AbstractWrapInJob job;
        assert (EditorController.getClassesSupportingWrapping().contains(wrappingClass));
        if (wrappingClass == AnchorPane.class) {
            job = new WrapInAnchorPaneJob(editorController);
        } else if (wrappingClass == BorderPane.class) {
            job = new WrapInBorderPaneJob(editorController);
        } else if (wrappingClass == ButtonBar.class) {
            job = new WrapInButtonBarJob(editorController);
        } else if (wrappingClass == DialogPane.class) {
            job = new WrapInDialogPaneJob(editorController);
        } else if (wrappingClass == FlowPane.class) {
            job = new WrapInFlowPaneJob(editorController);
        } else if (wrappingClass == GridPane.class) {
            job = new WrapInGridPaneJob(editorController);
        } else if (wrappingClass == Group.class) {
            job = new WrapInGroupJob(editorController);
        } else if (wrappingClass == HBox.class) {
            job = new WrapInHBoxJob(editorController);
        } else if (wrappingClass == Pane.class) {
            job = new WrapInPaneJob(editorController);
        } else if (wrappingClass == ScrollPane.class) {
            job = new WrapInScrollPaneJob(editorController);
        } else if (wrappingClass == SplitPane.class) {
            job = new WrapInSplitPaneJob(editorController);
        } else if (wrappingClass == StackPane.class) {
            job = new WrapInStackPaneJob(editorController);
        } else if (wrappingClass == TabPane.class) {
            job = new WrapInTabPaneJob(editorController);
        } else if (wrappingClass == TextFlow.class) {
            job = new WrapInTextFlowJob(editorController);
        } else if (wrappingClass == TilePane.class) {
            job = new WrapInTilePaneJob(editorController);
        } else if (wrappingClass == TitledPane.class) {
            job = new WrapInTitledPaneJob(editorController);
        } else if (wrappingClass == ToolBar.class) {
            job = new WrapInToolBarJob(editorController);
        } else if (wrappingClass == Scene.class) {
            job = new WrapInSceneJob(editorController);
        } else if (wrappingClass == Stage.class) {
            job = new WrapInStageJob(editorController);
        } else {
            assert (wrappingClass == VBox.class);
            job = new WrapInVBoxJob(editorController);
        }
        return job;
    }

    protected boolean canWrapIn() {
        Selection selection = this.getEditorController().getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        if (!osg.hasSingleParent()) {
            return false;
        }
        if (!this.getEditorController().isSelectionNode()) {
            return false;
        }
        for (FXOMObject fxomObject : osg.getItems()) {
            if (!(fxomObject.getSceneGraphObject() instanceof Axis)) continue;
            return false;
        }
        FXOMObject parent = osg.getAncestor();
        if (parent == null) {
            return true;
        }
        Object parentSceneGraphObject = parent.getSceneGraphObject();
        if (parentSceneGraphObject instanceof BorderPane || parentSceneGraphObject instanceof DialogPane) {
            return osg.getItems().size() == 1;
        }
        return !(parentSceneGraphObject instanceof Accordion) && !(parentSceneGraphObject instanceof TabPane);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.canWrapIn()) {
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            this.oldContainer = (FXOMInstance)osg.getAncestor();
            List<FXOMObject> children = osg.getSortedItems();
            this.newContainer = this.makeNewContainerInstance();
            this.modifyNewContainer(children);
            if (this.oldContainer != null) {
                PropertyName oldContainerPropertyName = WrapJobUtils.getContainerPropertyName(this.oldContainer, children);
                FXOMPropertyC oldContainerProperty = (FXOMPropertyC)this.oldContainer.getProperties().get(oldContainerPropertyName);
                assert (oldContainerProperty != null && oldContainerProperty.getParentInstance() != null);
                int newContainerIndex = this.getIndex(this.oldContainer, children);
                AddPropertyValueJob newContainerAddValueJob = new AddPropertyValueJob(this.newContainer, oldContainerProperty, newContainerIndex, this.getEditorController());
                result.add(newContainerAddValueJob);
                List<Job> removeChildrenJobs = this.removeChildrenJobs(oldContainerProperty, children);
                result.addAll(removeChildrenJobs);
            } else {
                assert (children.size() == 1);
                FXOMObject rootObject = children.iterator().next();
                assert (rootObject instanceof FXOMInstance);
                boolean isFxRoot = ((FXOMInstance)rootObject).isFxRoot();
                String fxController = rootObject.getFxController();
                if (isFxRoot) {
                    ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                    result.add(fxRootJob);
                }
                if (fxController != null) {
                    ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(rootObject, null, this.getEditorController());
                    result.add(fxControllerJob);
                }
                SetDocumentRootJob setDocumentRoot = new SetDocumentRootJob(this.newContainer, this.getEditorController());
                result.add(setDocumentRoot);
                if (isFxRoot) {
                    ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                    result.add(fxRootJob);
                }
                if (fxController != null) {
                    ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(this.newContainer, fxController, this.getEditorController());
                    result.add(fxControllerJob);
                }
            }
            result.addAll(this.wrapChildrenJobs(children));
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Wrap in " + this.newContainerClass.getSimpleName();
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        ArrayList<FXOMObject> newObjects = new ArrayList<FXOMObject>();
        newObjects.add(this.newContainer);
        return new ObjectSelectionGroup(newObjects, (FXOMObject)newObjects.iterator().next(), null);
    }

    protected abstract List<Job> wrapChildrenJobs(List<FXOMObject> var1);

    protected List<Job> addChildrenJobs(FXOMPropertyC containerProperty, Collection<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        int index = 0;
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(child, containerProperty, index++, this.getEditorController());
            jobs.add(addValueJob);
        }
        return jobs;
    }

    protected List<Job> removeChildrenJobs(FXOMPropertyC containerProperty, List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            RemovePropertyValueJob removeValueJob = new RemovePropertyValueJob(child, this.getEditorController());
            jobs.add(removeValueJob);
        }
        return jobs;
    }

    protected List<Job> modifyChildrenJobs(List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        Bounds unionOfBounds = WrapJobUtils.getUnionOfBounds(children);
        for (FXOMObject child : children) {
            if (newContainerMask.isFreeChildPositioning()) {
                assert (child.getSceneGraphObject() instanceof Node);
                Node childNode = (Node)child.getSceneGraphObject();
                Bounds childBounds = childNode.getLayoutBounds();
                Point2D point = childNode.localToParent(childBounds.getMinX(), childBounds.getMinY());
                double layoutX = point.getX() - unionOfBounds.getMinX();
                double layoutY = point.getY() - unionOfBounds.getMinY();
                ModifyObjectJob modifyLayoutX = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutX", layoutX, this.getEditorController());
                jobs.add(modifyLayoutX);
                ModifyObjectJob modifyLayoutY = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutY", layoutY, this.getEditorController());
                jobs.add(modifyLayoutY);
            } else {
                assert (child.getSceneGraphObject() instanceof Node);
                ModifyObjectJob modifyLayoutX = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutX", 0.0, this.getEditorController());
                jobs.add(modifyLayoutX);
                ModifyObjectJob modifyLayoutY = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutY", 0.0, this.getEditorController());
                jobs.add(modifyLayoutY);
            }
            if (!(child instanceof FXOMInstance)) continue;
            FXOMInstance fxomInstance = (FXOMInstance)child;
            for (FXOMProperty p : fxomInstance.getProperties().values()) {
                Class<?> residentClass = p.getName().getResidenceClass();
                if (residentClass == null) continue;
                jobs.add(new RemovePropertyJob(p, this.getEditorController()));
            }
        }
        return jobs;
    }

    protected void modifyNewContainer(List<FXOMObject> children) {
        DesignHierarchyMask oldContainerMask;
        if (this.oldContainer != null && (oldContainerMask = new DesignHierarchyMask(this.oldContainer)).isFreeChildPositioning()) {
            Bounds unionOfBounds = WrapJobUtils.getUnionOfBounds(children);
            JobUtils.setLayoutX(this.newContainer, Node.class, unionOfBounds.getMinX());
            JobUtils.setLayoutY(this.newContainer, Node.class, unionOfBounds.getMinY());
        }
        if (children.size() == 1) {
            Metadata metadata = Metadata.getMetadata();
            FXOMObject child = children.get(0);
            if (child instanceof FXOMInstance) {
                FXOMInstance fxomInstance = (FXOMInstance)child;
                for (FXOMProperty p : fxomInstance.getProperties().values()) {
                    Class<?> residentClass = p.getName().getResidenceClass();
                    if (residentClass == null) continue;
                    ValuePropertyMetadata vpm = metadata.queryValueProperty(fxomInstance, p.getName());
                    Object value = vpm.getValueObject(fxomInstance);
                    vpm.setValueObject(this.newContainer, value);
                }
            }
        }
    }

    protected FXOMInstance makeNewContainerInstance(Class<?> containerClass) {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, containerClass);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }

    private FXOMInstance makeNewContainerInstance() {
        return this.makeNewContainerInstance(this.newContainerClass);
    }

    private int getIndex(FXOMInstance container, List<FXOMObject> fxomObjects) {
        DesignHierarchyMask mask = new DesignHierarchyMask(container);
        if (!mask.isAcceptingSubComponent()) {
            return -1;
        }
        Iterator<FXOMObject> iterator = fxomObjects.iterator();
        assert (iterator.hasNext());
        int result = iterator.next().getIndexInParentProperty();
        while (iterator.hasNext()) {
            int index = iterator.next().getIndexInParentProperty();
            if (index >= result) continue;
            result = index;
        }
        return result;
    }
}

