/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Scene;

public class AbstractWrapInWindowJob
extends AbstractWrapInJob {
    public AbstractWrapInWindowJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected boolean canWrapIn() {
        Selection selection = this.getEditorController().getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        if (!osg.hasSingleParent()) {
            return false;
        }
        if (osg.getItems().size() != 1) {
            return false;
        }
        for (FXOMObject fxomObject : osg.getItems()) {
            if (fxomObject.getSceneGraphObject() instanceof Scene) continue;
            return false;
        }
        FXOMObject parent = osg.getAncestor();
        return parent == null;
    }

    @Override
    protected List<Job> wrapChildrenJobs(List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        assert (newContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.SCENE));
        PropertyName newContainerPropertyName = new PropertyName("scene");
        FXOMPropertyC newContainerProperty = new FXOMPropertyC(this.newContainer.getFxomDocument(), newContainerPropertyName);
        assert (children.size() == 1);
        jobs.addAll(this.addChildrenJobs(newContainerProperty, children));
        assert (newContainerProperty.getParentInstance() == null);
        AddPropertyJob addPropertyJob = new AddPropertyJob(newContainerProperty, this.newContainer, -1, this.getEditorController());
        jobs.add(addPropertyJob);
        return jobs;
    }
}

