/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.Comparator;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;

public class FXOMObjectCourseComparator {
    private static final int B1GREATER = 1;
    private static final int B2GREATER = -1;
    public static final double OVERLAP_FUZZ = 1.0;

    FXOMObjectCourseComparator() {
    }

    static class UnidimensionalComparator
    implements Comparator<FXOMObject> {
        private final GridCourse course;
        private static final long serialVersionUID = 0L;

        public UnidimensionalComparator(GridCourse course) {
            this.course = course;
        }

        public static UnidimensionalComparator of(Orientation orientation) {
            switch (orientation) {
                case HORIZONTAL: {
                    return new UnidimensionalComparator(GridCourse.ROW_BY_ROW);
                }
                case VERTICAL: {
                    return new UnidimensionalComparator(GridCourse.COL_BY_COL);
                }
            }
            throw new IllegalArgumentException(String.valueOf(orientation));
        }

        @Override
        public int compare(FXOMObject o1, FXOMObject o2) {
            assert (o1.getSceneGraphObject() != null && o1.getSceneGraphObject() instanceof Node);
            assert (o2.getSceneGraphObject() != null && o2.getSceneGraphObject() instanceof Node);
            Node n1 = (Node)o1.getSceneGraphObject();
            Node n2 = (Node)o2.getSceneGraphObject();
            Bounds b1 = n1.getBoundsInParent();
            Bounds b2 = n2.getBoundsInParent();
            return this.compareBounds(b1, b2);
        }

        private int compareBounds(Bounds b1, Bounds b2) {
            if (this.course.getMinX(b2) < this.course.getMinX(b1)) {
                return 1;
            }
            if (this.course.getMinX(b2) > this.course.getMinX(b1)) {
                return -1;
            }
            return 0;
        }
    }

    static class BidimensionalComparator
    implements Comparator<FXOMObject> {
        private final GridCourse course;
        private static final long serialVersionUID = 0L;

        public BidimensionalComparator(GridCourse course) {
            this.course = course;
        }

        @Override
        public int compare(FXOMObject o1, FXOMObject o2) {
            Bounds b2;
            assert (o1.getSceneGraphObject() != null && o1.getSceneGraphObject() instanceof Node);
            assert (o2.getSceneGraphObject() != null && o2.getSceneGraphObject() instanceof Node);
            Node n1 = (Node)o1.getSceneGraphObject();
            Node n2 = (Node)o2.getSceneGraphObject();
            Bounds b1 = n1.getBoundsInParent();
            int test1 = this.compareBounds(b1, b2 = n2.getBoundsInParent());
            if (test1 != 0) {
                return test1;
            }
            int test2 = this.compareBounds(b2, b1);
            if (test2 != 0) {
                return -test2;
            }
            return 0;
        }

        private int compareBounds(Bounds b1, Bounds b2) {
            if (this.course.getMaxY(b2) - 1.0 <= this.course.getMinY(b1)) {
                return 1;
            }
            if (this.course.getMinY(b2) + 1.0 >= this.course.getMaxY(b1)) {
                return -1;
            }
            if (this.course.getMaxX(b2) - 1.0 <= this.course.getMinX(b1)) {
                return 1;
            }
            if (this.course.getMinX(b2) + 1.0 >= this.course.getMaxX(b1)) {
                return -1;
            }
            return 0;
        }
    }

    static enum GridCourse {
        ROW_BY_ROW,
        COL_BY_COL;


        public double getMinX(Bounds b) {
            switch (this.ordinal()) {
                case 0: {
                    return b.getMinX();
                }
                case 1: {
                    return b.getMinY();
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)this));
        }

        public double getMaxX(Bounds b) {
            switch (this.ordinal()) {
                case 0: {
                    return b.getMaxX();
                }
                case 1: {
                    return b.getMaxY();
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)this));
        }

        public double getMinY(Bounds b) {
            switch (this.ordinal()) {
                case 0: {
                    return b.getMinY();
                }
                case 1: {
                    return b.getMinX();
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)this));
        }

        public double getMaxY(Bounds b) {
            switch (this.ordinal()) {
                case 0: {
                    return b.getMaxY();
                }
                case 1: {
                    return b.getMaxX();
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)this));
        }

        public int index() {
            switch (this.ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)this));
        }
    }
}

