/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ReplaceObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;

public class WrapInSceneJob
extends AbstractWrapInJob {
    public WrapInSceneJob(EditorController editorController) {
        super(editorController);
        this.newContainerClass = Scene.class;
    }

    @Override
    protected boolean canWrapIn() {
        if (!super.canWrapIn()) {
            return false;
        }
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        if (osg.getItems().size() != 1) {
            return false;
        }
        FXOMObject parent = osg.getAncestor();
        return parent == null;
    }

    @Override
    protected List<Job> wrapChildrenJobs(List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        assert (newContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.ROOT));
        FXOMObject dummyPane = newContainerMask.getAccessory(DesignHierarchyMask.Accessory.ROOT);
        assert (dummyPane != null);
        jobs.addAll(this.modifyChildrenJobs(children));
        assert (children.size() == 1);
        FXOMObject child = children.iterator().next();
        jobs.add(new ReplaceObjectJob(dummyPane, child, this.getEditorController()));
        return jobs;
    }

    @Override
    protected FXOMInstance makeNewContainerInstance(Class<?> containerClass) {
        assert (containerClass == Scene.class);
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, containerClass);
        FXOMInstance dummyPane = new FXOMInstance(newDocument, Pane.class);
        PropertyName newContainerPropertyName = new PropertyName("root");
        FXOMPropertyC newContainerProperty = new FXOMPropertyC(newDocument, newContainerPropertyName);
        dummyPane.addToParentProperty(0, newContainerProperty);
        newContainerProperty.addToParentInstance(0, result);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }
}

